/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.testng;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.surefire.NonAbstractClassFilter;
import org.apache.maven.surefire.report.ReportEntry;
import org.apache.maven.surefire.report.ReporterException;
import org.apache.maven.surefire.report.ReporterFactory;
import org.apache.maven.surefire.report.ReporterManagerFactory;
import org.apache.maven.surefire.report.RunListener;
import org.apache.maven.surefire.report.SimpleReportEntry;
import org.apache.maven.surefire.testng.SynchronizedReporterManager;
import org.apache.maven.surefire.testng.TestNGExecutor;
import org.apache.maven.surefire.testng.TestNGTestSet;
import org.apache.maven.surefire.testng.TestNGXmlTestSuite;
import org.apache.maven.surefire.testng.TestNgTestSuite;
import org.apache.maven.surefire.testset.TestSetFailedException;
import org.apache.maven.surefire.util.DefaultDirectoryScanner;
import org.apache.maven.surefire.util.DirectoryScanner;
import org.apache.maven.surefire.util.ScannerFilter;
import org.apache.maven.surefire.util.TestsToRun;

public class TestNGDirectoryTestSuite
implements TestNgTestSuite {
    private final ArtifactVersion version;
    private final Map options;
    private final String testSourceDirectory;
    private final File reportsDirectory;
    private SortedMap testSets;
    private final DirectoryScanner surefireDirectoryScanner;
    private String testMethodPattern;

    public TestNGDirectoryTestSuite(File basedir, ArrayList includes, ArrayList excludes, String testSourceDirectory, String artifactVersion, Properties confOptions, File reportsDirectory, String testMethodPattern) {
        this.surefireDirectoryScanner = new DefaultDirectoryScanner(basedir, (List)includes, (List)excludes, "filesystem");
        this.options = confOptions;
        this.testSourceDirectory = testSourceDirectory;
        this.reportsDirectory = reportsDirectory;
        this.version = new DefaultArtifactVersion(artifactVersion);
        this.testMethodPattern = testMethodPattern;
    }

    public void execute(TestsToRun testsToRun, ReporterFactory reporterManagerFactory) throws ReporterException, TestSetFailedException {
        if (testsToRun.size() == 0) {
            return;
        }
        if (testsToRun.size() > 1) {
            this.executeMulti(testsToRun, reporterManagerFactory);
            return;
        }
        RunListener reporter = reporterManagerFactory.createReporter();
        TestNGDirectoryTestSuite.startTestSuite(reporter, this);
        TestNGExecutor.run(new Class[]{(Class)testsToRun.iterator().next()}, this.testSourceDirectory, this.options, this.version, reporter, this, this.reportsDirectory, this.testMethodPattern);
        TestNGDirectoryTestSuite.finishTestSuite(reporter, this);
    }

    public void executeMulti(TestsToRun testsToRun, ReporterFactory reporterFactory) throws ReporterException, TestSetFailedException {
        Class<?> junitTest;
        try {
            junitTest = Class.forName("junit.framework.Test");
        }
        catch (ClassNotFoundException e) {
            junitTest = null;
        }
        ArrayList<Class> testNgTestClasses = new ArrayList<Class>();
        ArrayList<Class> junitTestClasses = new ArrayList<Class>();
        Iterator it = testsToRun.iterator();
        while (it.hasNext()) {
            Class c = (Class)it.next();
            if (junitTest != null && junitTest.isAssignableFrom(c)) {
                junitTestClasses.add(c);
                continue;
            }
            testNgTestClasses.add(c);
        }
        File testNgReportsDirectory = this.reportsDirectory;
        File junitReportsDirectory = this.reportsDirectory;
        if (junitTestClasses.size() > 0 && testNgTestClasses.size() > 0) {
            testNgReportsDirectory = new File(this.reportsDirectory, "testng-native-results");
            junitReportsDirectory = new File(this.reportsDirectory, "testng-junit-results");
        }
        SynchronizedReporterManager reporterManager = new SynchronizedReporterManager(reporterFactory.createReporter());
        TestNGDirectoryTestSuite.startTestSuite(reporterManager, this);
        Class[] testClasses = testNgTestClasses.toArray(new Class[testNgTestClasses.size()]);
        TestNGExecutor.run(testClasses, this.testSourceDirectory, this.options, this.version, reporterManager, this, testNgReportsDirectory, this.testMethodPattern);
        if (junitTestClasses.size() > 0) {
            testClasses = junitTestClasses.toArray(new Class[junitTestClasses.size()]);
            HashMap junitOptions = new HashMap();
            Iterator it2 = this.options.keySet().iterator();
            while (it2.hasNext()) {
                Object key = it2.next();
                junitOptions.put(key, this.options.get(key));
            }
            junitOptions.put("junit", Boolean.TRUE);
            TestNGExecutor.run(testClasses, this.testSourceDirectory, junitOptions, this.version, reporterManager, this, junitReportsDirectory, this.testMethodPattern);
        }
        TestNGDirectoryTestSuite.finishTestSuite(reporterManager, this);
    }

    public void execute(String testSetName, ReporterManagerFactory reporterManagerFactory, ClassLoader classLoader) throws ReporterException, TestSetFailedException {
        if (this.testSets == null) {
            throw new IllegalStateException("You must call locateTestSets before calling execute");
        }
        TestNGTestSet testSet = (TestNGTestSet)this.testSets.get(testSetName);
        if (testSet == null) {
            throw new TestSetFailedException("Unable to find test set '" + testSetName + "' in suite");
        }
        RunListener reporter = reporterManagerFactory.createReporter();
        TestNGDirectoryTestSuite.startTestSuite(reporter, this);
        TestNGExecutor.run(new Class[]{testSet.getTestClass()}, this.testSourceDirectory, this.options, this.version, reporter, this, this.reportsDirectory, this.testMethodPattern);
        TestNGDirectoryTestSuite.finishTestSuite(reporter, this);
    }

    public static void startTestSuite(RunListener reporter, Object suite) {
        SimpleReportEntry report = new SimpleReportEntry(suite.getClass().getName(), TestNGDirectoryTestSuite.getSuiteName(suite));
        try {
            reporter.testSetStarting((ReportEntry)report);
        }
        catch (ReporterException reporterException) {
            // empty catch block
        }
    }

    public static void finishTestSuite(RunListener reporterManager, Object suite) throws ReporterException {
        SimpleReportEntry report = new SimpleReportEntry(suite.getClass().getName(), TestNGDirectoryTestSuite.getSuiteName(suite));
        reporterManager.testSetCompleted((ReportEntry)report);
    }

    public String getSuiteName() {
        String result = (String)this.options.get("suitename");
        if (result == null) {
            result = "TestSuite";
        }
        return result;
    }

    private static String getSuiteName(Object suite) {
        if (suite instanceof TestNGDirectoryTestSuite) {
            return ((TestNGDirectoryTestSuite)suite).getSuiteName();
        }
        if (suite instanceof TestNGXmlTestSuite) {
            return ((TestNGXmlTestSuite)suite).getSuiteName();
        }
        String result = "TestSuite";
        return result;
    }

    public Map locateTestSets(ClassLoader classLoader) throws TestSetFailedException {
        if (this.testSets != null) {
            throw new IllegalStateException("You can't call locateTestSets twice");
        }
        this.testSets = new TreeMap();
        TestsToRun testsToRun = this.surefireDirectoryScanner.locateTestClasses(classLoader, (ScannerFilter)new NonAbstractClassFilter());
        Class[] locatedClasses = testsToRun.getLocatedClasses();
        for (int i = 0; i < locatedClasses.length; ++i) {
            Class testClass = locatedClasses[i];
            TestNGTestSet testSet = new TestNGTestSet(testClass);
            if (this.testSets.containsKey(testSet.getName())) {
                throw new TestSetFailedException("Duplicate test set '" + testSet.getName() + "'");
            }
            this.testSets.put(testSet.getName(), testSet);
        }
        return Collections.unmodifiableSortedMap(this.testSets);
    }
}

