/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.invoker;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.apache.maven.shared.invoker.InvokerLogger;

public class SystemOutLogger
implements InvokerLogger {
    private int threshold = 3;

    public void debug(String message) {
        this.log(4, message, null);
    }

    private void log(int level, String message, Throwable error) {
        if (level > this.threshold) {
            return;
        }
        if (message == null && error == null) {
            return;
        }
        StringBuffer buffer = new StringBuffer();
        switch (level) {
            case 4: {
                buffer.append("[DEBUG]");
                break;
            }
            case 3: {
                buffer.append("[INFO]");
                break;
            }
            case 2: {
                buffer.append("[WARN]");
                break;
            }
            case 1: {
                buffer.append("[ERROR]");
                break;
            }
            case 0: {
                buffer.append("[FATAL]");
            }
        }
        buffer.append(' ');
        if (message != null) {
            buffer.append(message);
        }
        if (error != null) {
            StringWriter writer = new StringWriter();
            PrintWriter pWriter = new PrintWriter(writer);
            error.printStackTrace(pWriter);
            if (message != null) {
                buffer.append('\n');
            }
            buffer.append("Error:\n");
            buffer.append(writer.toString());
        }
        System.out.println(buffer.toString());
    }

    public void debug(String message, Throwable throwable) {
        this.log(4, message, throwable);
    }

    public void error(String message) {
        this.log(1, message, null);
    }

    public void error(String message, Throwable throwable) {
        this.log(1, message, throwable);
    }

    public void fatalError(String message) {
        this.log(0, message, null);
    }

    public void fatalError(String message, Throwable throwable) {
        this.log(0, message, throwable);
    }

    public int getThreshold() {
        return this.threshold;
    }

    public void info(String message) {
        this.log(3, message, null);
    }

    public void info(String message, Throwable throwable) {
        this.log(3, message, throwable);
    }

    public boolean isDebugEnabled() {
        return this.threshold >= 4;
    }

    public boolean isErrorEnabled() {
        return this.threshold >= 1;
    }

    public boolean isFatalErrorEnabled() {
        return this.threshold >= 0;
    }

    public boolean isInfoEnabled() {
        return this.threshold >= 3;
    }

    public boolean isWarnEnabled() {
        return this.threshold >= 2;
    }

    public void warn(String message) {
        this.log(2, message, null);
    }

    public void warn(String message, Throwable throwable) {
        this.log(2, message, throwable);
    }

    public void setThreshold(int threshold) {
        this.threshold = threshold;
    }
}

