/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.plugin;

import java.io.File;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.command.status.StatusScmResult;
import org.apache.maven.scm.plugin.AbstractScmMojo;
import org.apache.maven.scm.repository.ScmRepository;

@Mojo(name="check-local-modification")
public class CheckLocalModificationsMojo
extends AbstractScmMojo {
    @Parameter(property="scm.checkLocalModification.errorMessage", defaultValue="The build will stop as there is local modifications")
    private String errorMessage;
    @Parameter(property="scm.checkLocalModification.skip", defaultValue="false")
    private boolean skip;
    @Parameter(defaultValue="${basedir}", readonly=true)
    private File baseDirectory;

    public void execute() throws MojoExecutionException {
        if (this.skip) {
            this.getLog().info((CharSequence)"check-local-modification execution has been skipped");
            return;
        }
        super.execute();
        StatusScmResult result = null;
        try {
            ScmRepository repository = this.getScmRepository();
            result = this.getScmManager().status(repository, new ScmFileSet(this.baseDirectory));
        }
        catch (ScmException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
        if (!result.isSuccess()) {
            throw new MojoExecutionException("Unable to check for local modifications :" + result.getProviderMessage());
        }
        if (!result.getChangedFiles().isEmpty()) {
            this.getLog().error((CharSequence)this.errorMessage);
            throw new MojoExecutionException(this.errorMessage);
        }
    }
}

