/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.assembly.archive.archiver;

import java.io.File;
import org.apache.maven.plugin.assembly.archive.archiver.PrefixedFileSet;
import org.codehaus.plexus.archiver.ArchivedFileSet;
import org.codehaus.plexus.components.io.fileselectors.FileSelector;
import org.codehaus.plexus.components.io.functions.InputStreamTransformer;

class PrefixedArchivedFileSet
implements ArchivedFileSet {
    private final String rootPrefix;
    private final ArchivedFileSet fileSet;
    private final FileSelector[] selectors;

    public PrefixedArchivedFileSet(ArchivedFileSet fileSet, String rootPrefix, FileSelector[] selectors) {
        this.fileSet = fileSet;
        this.selectors = selectors;
        this.rootPrefix = rootPrefix.length() > 0 && !rootPrefix.endsWith("/") ? rootPrefix + "/" : rootPrefix;
    }

    public File getArchive() {
        return this.fileSet.getArchive();
    }

    public String[] getExcludes() {
        return this.fileSet.getExcludes();
    }

    public FileSelector[] getFileSelectors() {
        return PrefixedFileSet.combineSelectors(this.fileSet.getFileSelectors(), this.selectors);
    }

    public String[] getIncludes() {
        return this.fileSet.getIncludes();
    }

    public String getPrefix() {
        String prefix = this.fileSet.getPrefix();
        if (prefix.startsWith("/")) {
            prefix = prefix.length() > 1 ? prefix.substring(1) : "";
        }
        return this.rootPrefix + prefix;
    }

    public boolean isCaseSensitive() {
        return this.fileSet.isCaseSensitive();
    }

    public boolean isIncludingEmptyDirectories() {
        return this.fileSet.isIncludingEmptyDirectories();
    }

    public boolean isUsingDefaultExcludes() {
        return this.fileSet.isUsingDefaultExcludes();
    }

    public InputStreamTransformer getStreamTransformer() {
        return this.fileSet.getStreamTransformer();
    }
}

