/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.util;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import org.apache.lucene.facet.taxonomy.CategoryPath;
import org.apache.lucene.facet.taxonomy.TaxonomyReader;
import org.apache.lucene.facet.taxonomy.directory.DirectoryTaxonomyReader;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;

public class PrintTaxonomyStats {
    public static void main(String[] args) throws IOException {
        boolean printTree = false;
        String path = null;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-printTree")) {
                printTree = true;
                continue;
            }
            path = args[i];
        }
        if (args.length != (printTree ? 2 : 1)) {
            System.out.println("\nUsage: java -classpath ... org.apache.lucene.facet.util.PrintTaxonomyStats [-printTree] /path/to/taxononmy/index\n");
            System.exit(1);
        }
        FSDirectory dir = FSDirectory.open((File)new File(path));
        DirectoryTaxonomyReader r = new DirectoryTaxonomyReader((Directory)dir);
        PrintTaxonomyStats.printStats(r, System.out, printTree);
        r.close();
        dir.close();
    }

    public static void printStats(TaxonomyReader r, PrintStream out, boolean printTree) throws IOException {
        int child;
        out.println(r.getSize() + " total categories.");
        TaxonomyReader.ChildrenIterator it = r.getChildren(0);
        while ((child = it.next()) != -1) {
            TaxonomyReader.ChildrenIterator chilrenIt = r.getChildren(child);
            int numImmediateChildren = 0;
            while (chilrenIt.next() != -1) {
                ++numImmediateChildren;
            }
            CategoryPath cp = r.getPath(child);
            out.println("/" + cp + ": " + numImmediateChildren + " immediate children; " + (1 + PrintTaxonomyStats.countAllChildren(r, child)) + " total categories");
            if (!printTree) continue;
            PrintTaxonomyStats.printAllChildren(out, r, child, "  ", 1);
        }
    }

    private static int countAllChildren(TaxonomyReader r, int ord) throws IOException {
        int child;
        int count = 0;
        TaxonomyReader.ChildrenIterator it = r.getChildren(ord);
        while ((child = it.next()) != -1) {
            count += 1 + PrintTaxonomyStats.countAllChildren(r, child);
        }
        return count;
    }

    private static void printAllChildren(PrintStream out, TaxonomyReader r, int ord, String indent, int depth) throws IOException {
        int child;
        TaxonomyReader.ChildrenIterator it = r.getChildren(ord);
        while ((child = it.next()) != -1) {
            out.println(indent + "/" + r.getPath((int)child).components[depth]);
            PrintTaxonomyStats.printAllChildren(out, r, child, indent + "  ", depth + 1);
        }
    }
}

