/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.protocol;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public enum SecurityProtocol {
    PLAINTEXT(0, "PLAINTEXT"),
    SSL(1, "SSL"),
    SASL_PLAINTEXT(2, "SASL_PLAINTEXT"),
    SASL_SSL(3, "SASL_SSL"),
    TRACE(Short.MAX_VALUE, "TRACE");

    private static final Map<Short, SecurityProtocol> CODE_TO_SECURITY_PROTOCOL;
    private static final List<String> NAMES;
    public final short id;
    public final String name;

    private SecurityProtocol(int id, String name) {
        this.id = (short)id;
        this.name = name;
    }

    public static String getName(int id) {
        return SecurityProtocol.CODE_TO_SECURITY_PROTOCOL.get((Object)Short.valueOf((short)((short)id))).name;
    }

    public static List<String> getNames() {
        return NAMES;
    }

    public static SecurityProtocol forId(Short id) {
        return CODE_TO_SECURITY_PROTOCOL.get(id);
    }

    static {
        CODE_TO_SECURITY_PROTOCOL = new HashMap<Short, SecurityProtocol>();
        NAMES = new ArrayList<String>();
        for (SecurityProtocol proto : SecurityProtocol.values()) {
            CODE_TO_SECURITY_PROTOCOL.put(proto.id, proto);
            NAMES.add(proto.name);
        }
    }
}

