/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.compactions;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.regionserver.StoreConfigInformation;
import org.apache.hadoop.hbase.regionserver.StoreFile;
import org.apache.hadoop.hbase.regionserver.StoreUtils;
import org.apache.hadoop.hbase.regionserver.StripeStoreConfig;
import org.apache.hadoop.hbase.regionserver.StripeStoreFileManager;
import org.apache.hadoop.hbase.regionserver.StripeStoreFlusher;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionPolicy;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionRequest;
import org.apache.hadoop.hbase.regionserver.compactions.ExploringCompactionPolicy;
import org.apache.hadoop.hbase.regionserver.compactions.StripeCompactor;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.ConcatenatedLists;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.Pair;

@InterfaceAudience.Private
public class StripeCompactionPolicy
extends CompactionPolicy {
    private static final Log LOG = LogFactory.getLog(StripeCompactionPolicy.class);
    private ExploringCompactionPolicy stripePolicy = null;
    private StripeStoreConfig config;

    public StripeCompactionPolicy(Configuration conf, StoreConfigInformation storeConfigInfo, StripeStoreConfig config) {
        super(conf, storeConfigInfo);
        this.config = config;
        this.stripePolicy = new ExploringCompactionPolicy(conf, storeConfigInfo);
    }

    public List<StoreFile> preSelectFilesForCoprocessor(StripeInformationProvider si, List<StoreFile> filesCompacting) {
        ArrayList<StoreFile> candidateFiles = new ArrayList<StoreFile>(si.getStorefiles());
        candidateFiles.removeAll(filesCompacting);
        return candidateFiles;
    }

    public StripeCompactionRequest createEmptyRequest(StripeInformationProvider si, CompactionRequest request) {
        if (si.getStripeCount() > 0) {
            return new BoundaryStripeCompactionRequest(request, si.getStripeBoundaries());
        }
        Pair<Long, Integer> targetKvsAndCount = this.estimateTargetKvs(request.getFiles(), this.config.getInitialCount());
        return new SplitStripeCompactionRequest(request, StripeStoreFileManager.OPEN_KEY, StripeStoreFileManager.OPEN_KEY, (int)((Integer)targetKvsAndCount.getSecond()), (long)((Long)targetKvsAndCount.getFirst()));
    }

    public StripeStoreFlusher.StripeFlushRequest selectFlush(StripeInformationProvider si, int kvCount) {
        if (this.config.isUsingL0Flush()) {
            return new StripeStoreFlusher.StripeFlushRequest();
        }
        if (si.getStripeCount() == 0) {
            int initialCount = this.config.getInitialCount();
            return new StripeStoreFlusher.SizeStripeFlushRequest(initialCount, kvCount / initialCount);
        }
        return new StripeStoreFlusher.BoundaryStripeFlushRequest(si.getStripeBoundaries());
    }

    public StripeCompactionRequest selectCompaction(StripeInformationProvider si, List<StoreFile> filesCompacting, boolean isOffpeak) throws IOException {
        boolean canDropDeletesNoL0;
        boolean shouldCompactL0;
        if (!filesCompacting.isEmpty()) {
            LOG.debug((Object)("Not selecting compaction: " + filesCompacting.size() + " files compacting"));
            return null;
        }
        Collection<StoreFile> allFiles = si.getStorefiles();
        if (StoreUtils.hasReferences(allFiles)) {
            LOG.debug((Object)"There are references in the store; compacting all files");
            long targetKvs = (Long)this.estimateTargetKvs(allFiles, this.config.getInitialCount()).getFirst();
            SplitStripeCompactionRequest request = new SplitStripeCompactionRequest(allFiles, StripeStoreFileManager.OPEN_KEY, StripeStoreFileManager.OPEN_KEY, targetKvs);
            request.setMajorRangeFull();
            return request;
        }
        int stripeCount = si.getStripeCount();
        List<StoreFile> l0Files = si.getLevel0Files();
        boolean bl = shouldCompactL0 = this.config.getLevel0MinFiles() <= l0Files.size();
        if (stripeCount == 0) {
            if (!shouldCompactL0) {
                return null;
            }
            return this.selectNewStripesCompaction(si);
        }
        boolean bl2 = canDropDeletesNoL0 = l0Files.size() == 0;
        if (shouldCompactL0) {
            StripeCompactionRequest result;
            if (!canDropDeletesNoL0 && (result = this.selectSingleStripeCompaction(si, true, canDropDeletesNoL0, isOffpeak)) != null) {
                return result;
            }
            LOG.debug((Object)("Selecting L0 compaction with " + l0Files.size() + " files"));
            return new BoundaryStripeCompactionRequest(l0Files, si.getStripeBoundaries());
        }
        StripeCompactionRequest result = this.selectExpiredMergeCompaction(si, canDropDeletesNoL0);
        if (result != null) {
            return result;
        }
        return this.selectSingleStripeCompaction(si, false, canDropDeletesNoL0, isOffpeak);
    }

    public boolean needsCompactions(StripeInformationProvider si, List<StoreFile> filesCompacting) {
        return filesCompacting.isEmpty() && (StoreUtils.hasReferences(si.getStorefiles()) || si.getLevel0Files().size() >= this.config.getLevel0MinFiles() || this.needsSingleStripeCompaction(si));
    }

    @Override
    public boolean isMajorCompaction(Collection<StoreFile> filesToCompact) throws IOException {
        return false;
    }

    @Override
    public boolean throttleCompaction(long compactionSize) {
        return compactionSize > this.comConf.getThrottlePoint();
    }

    protected boolean needsSingleStripeCompaction(StripeInformationProvider si) {
        int minFiles = this.config.getStripeCompactMinFiles();
        for (List list : si.getStripes()) {
            if (list.size() < minFiles) continue;
            return true;
        }
        return false;
    }

    protected StripeCompactionRequest selectSingleStripeCompaction(StripeInformationProvider si, boolean includeL0, boolean canDropDeletesWithoutL0, boolean isOffpeak) throws IOException {
        StripeCompactionRequest req;
        ArrayList<ImmutableList<StoreFile>> stripes = si.getStripes();
        int bqIndex = -1;
        List<StoreFile> bqSelection = null;
        int stripeCount = stripes.size();
        long bqTotalSize = -1L;
        for (int i = 0; i < stripeCount; ++i) {
            List<StoreFile> selection = this.selectSimpleCompaction((List)stripes.get(i), !canDropDeletesWithoutL0 && includeL0, isOffpeak);
            if (selection.isEmpty()) continue;
            long size = 0L;
            for (StoreFile sf : selection) {
                size += sf.getReader().length();
            }
            if (bqSelection != null && selection.size() <= bqSelection.size() && (selection.size() != bqSelection.size() || size >= bqTotalSize)) continue;
            bqSelection = selection;
            bqIndex = i;
            bqTotalSize = size;
        }
        if (bqSelection == null) {
            LOG.debug((Object)"No good compaction is possible in any stripe");
            return null;
        }
        ArrayList<StoreFile> filesToCompact = new ArrayList<StoreFile>(bqSelection);
        int targetCount = 1;
        long targetKvs = Long.MAX_VALUE;
        boolean hasAllFiles = filesToCompact.size() == stripes.get(bqIndex).size();
        String splitString = "";
        if (hasAllFiles && bqTotalSize >= this.config.getSplitSize()) {
            if (includeL0) {
                return null;
            }
            Pair<Long, Integer> kvsAndCount = this.estimateTargetKvs(filesToCompact, this.config.getSplitCount());
            targetKvs = (Long)kvsAndCount.getFirst();
            targetCount = (Integer)kvsAndCount.getSecond();
            splitString = "; the stripe will be split into at most " + targetCount + " stripes with " + targetKvs + " target KVs";
        }
        LOG.debug((Object)("Found compaction in a stripe with end key [" + Bytes.toString((byte[])si.getEndRow(bqIndex)) + "], with " + filesToCompact.size() + " files of total size " + bqTotalSize + splitString));
        if (includeL0) {
            assert (hasAllFiles);
            List<StoreFile> l0Files = si.getLevel0Files();
            LOG.debug((Object)("Adding " + l0Files.size() + " files to compaction to be able to drop deletes"));
            ConcatenatedLists sfs = new ConcatenatedLists();
            sfs.addSublist(filesToCompact);
            sfs.addSublist(l0Files);
            req = new BoundaryStripeCompactionRequest((Collection<StoreFile>)sfs, si.getStripeBoundaries());
        } else {
            req = new SplitStripeCompactionRequest(filesToCompact, si.getStartRow(bqIndex), si.getEndRow(bqIndex), targetCount, targetKvs);
        }
        if (canDropDeletesWithoutL0 || includeL0) {
            req.setMajorRange(si.getStartRow(bqIndex), si.getEndRow(bqIndex));
        }
        req.getRequest().setOffPeak(isOffpeak);
        return req;
    }

    private List<StoreFile> selectSimpleCompaction(List<StoreFile> sfs, boolean allFilesOnly, boolean isOffpeak) {
        int minFilesLocal = Math.max(allFilesOnly ? sfs.size() : 0, this.config.getStripeCompactMinFiles());
        int maxFilesLocal = Math.max(this.config.getStripeCompactMaxFiles(), minFilesLocal);
        return this.stripePolicy.applyCompactionPolicy(sfs, false, isOffpeak, minFilesLocal, maxFilesLocal);
    }

    private StripeCompactionRequest selectCompactionOfAllFiles(StripeInformationProvider si, int targetStripeCount, long targetSize) {
        Collection<StoreFile> allFiles = si.getStorefiles();
        SplitStripeCompactionRequest request = new SplitStripeCompactionRequest(allFiles, StripeStoreFileManager.OPEN_KEY, StripeStoreFileManager.OPEN_KEY, targetStripeCount, targetSize);
        request.setMajorRangeFull();
        LOG.debug((Object)("Selecting a compaction that includes all " + allFiles.size() + " files"));
        return request;
    }

    private StripeCompactionRequest selectNewStripesCompaction(StripeInformationProvider si) {
        List<StoreFile> l0Files = si.getLevel0Files();
        Pair<Long, Integer> kvsAndCount = this.estimateTargetKvs(l0Files, this.config.getInitialCount());
        LOG.debug((Object)("Creating " + kvsAndCount.getSecond() + " initial stripes with " + kvsAndCount.getFirst() + " kvs each via L0 compaction of " + l0Files.size() + " files"));
        SplitStripeCompactionRequest request = new SplitStripeCompactionRequest(si.getLevel0Files(), StripeStoreFileManager.OPEN_KEY, StripeStoreFileManager.OPEN_KEY, (int)((Integer)kvsAndCount.getSecond()), (long)((Long)kvsAndCount.getFirst()));
        request.setMajorRangeFull();
        return request;
    }

    private StripeCompactionRequest selectExpiredMergeCompaction(StripeInformationProvider si, boolean canDropDeletesNoL0) {
        long cfTtl = this.storeConfigInfo.getStoreFileTtl();
        if (cfTtl == Long.MAX_VALUE) {
            return null;
        }
        long timestampCutoff = EnvironmentEdgeManager.currentTimeMillis() - cfTtl;
        int start = -1;
        int bestStart = -1;
        int length = 0;
        int bestLength = 0;
        ArrayList<ImmutableList<StoreFile>> stripes = si.getStripes();
        block0: for (int i = 0; i < stripes.size(); ++i) {
            for (StoreFile storeFile : stripes.get(i)) {
                if (storeFile.getReader().getMaxTimestamp() < timestampCutoff) continue;
                if (length > bestLength) {
                    bestStart = start;
                    bestLength = length;
                }
                start = -1;
                length = 0;
                continue block0;
            }
            if (start == -1) {
                start = i;
            }
            ++length;
        }
        if (length > bestLength) {
            bestStart = start;
            bestLength = length;
        }
        if (bestLength == 0) {
            return null;
        }
        if (bestLength == 1) {
            if (bestStart == stripes.size() - 1) {
                return null;
            }
            ++bestLength;
        }
        LOG.debug((Object)("Merging " + bestLength + " stripes to delete expired store files"));
        int endIndex = bestStart + bestLength - 1;
        ConcatenatedLists sfs = new ConcatenatedLists();
        sfs.addAllSublists(stripes.subList(bestStart, endIndex + 1));
        SplitStripeCompactionRequest result = new SplitStripeCompactionRequest((Collection<StoreFile>)sfs, si.getStartRow(bestStart), si.getEndRow(endIndex), 1, Long.MAX_VALUE);
        if (canDropDeletesNoL0) {
            result.setMajorRangeFull();
        }
        return result;
    }

    private static long getTotalKvCount(Collection<StoreFile> candidates) {
        long totalSize = 0L;
        for (StoreFile storeFile : candidates) {
            totalSize += storeFile.getReader().getEntries();
        }
        return totalSize;
    }

    public static long getTotalFileSize(Collection<StoreFile> candidates) {
        long totalSize = 0L;
        for (StoreFile storeFile : candidates) {
            totalSize += storeFile.getReader().length();
        }
        return totalSize;
    }

    private Pair<Long, Integer> estimateTargetKvs(Collection<StoreFile> files, double splitCount) {
        double newRatio;
        long totalSize = StripeCompactionPolicy.getTotalFileSize(files);
        long targetPartSize = this.config.getSplitPartSize();
        assert (targetPartSize > 0L && splitCount > 0.0);
        double ratio = (double)totalSize / (splitCount * (double)targetPartSize);
        while (ratio > 1.0 && !(1.0 / (newRatio = (double)totalSize / ((splitCount + 1.0) * (double)targetPartSize)) >= ratio)) {
            ratio = newRatio;
            splitCount += 1.0;
        }
        long kvCount = (long)((double)StripeCompactionPolicy.getTotalKvCount(files) / splitCount);
        return new Pair((Object)kvCount, (Object)((int)Math.ceil(splitCount)));
    }

    public static interface StripeInformationProvider {
        public Collection<StoreFile> getStorefiles();

        public byte[] getStartRow(int var1);

        public byte[] getEndRow(int var1);

        public List<StoreFile> getLevel0Files();

        public List<byte[]> getStripeBoundaries();

        public ArrayList<ImmutableList<StoreFile>> getStripes();

        public int getStripeCount();
    }

    private static class SplitStripeCompactionRequest
    extends StripeCompactionRequest {
        private final byte[] startRow;
        private final byte[] endRow;
        private final int targetCount;
        private final long targetKvs;

        public SplitStripeCompactionRequest(CompactionRequest request, byte[] startRow, byte[] endRow, int targetCount, long targetKvs) {
            super(request);
            this.startRow = startRow;
            this.endRow = endRow;
            this.targetCount = targetCount;
            this.targetKvs = targetKvs;
        }

        public SplitStripeCompactionRequest(CompactionRequest request, byte[] startRow, byte[] endRow, long targetKvs) {
            this(request, startRow, endRow, Integer.MAX_VALUE, targetKvs);
        }

        public SplitStripeCompactionRequest(Collection<StoreFile> files, byte[] startRow, byte[] endRow, long targetKvs) {
            this(files, startRow, endRow, Integer.MAX_VALUE, targetKvs);
        }

        public SplitStripeCompactionRequest(Collection<StoreFile> files, byte[] startRow, byte[] endRow, int targetCount, long targetKvs) {
            this(new CompactionRequest(files), startRow, endRow, targetCount, targetKvs);
        }

        @Override
        public List<Path> execute(StripeCompactor compactor) throws IOException {
            return compactor.compact(this.request, this.targetCount, this.targetKvs, this.startRow, this.endRow, this.majorRangeFromRow, this.majorRangeToRow);
        }

        public void setMajorRangeFull() {
            this.setMajorRange(this.startRow, this.endRow);
        }
    }

    private static class BoundaryStripeCompactionRequest
    extends StripeCompactionRequest {
        private final List<byte[]> targetBoundaries;

        public BoundaryStripeCompactionRequest(CompactionRequest request, List<byte[]> targetBoundaries) {
            super(request);
            this.targetBoundaries = targetBoundaries;
        }

        public BoundaryStripeCompactionRequest(Collection<StoreFile> files, List<byte[]> targetBoundaries) {
            this(new CompactionRequest(files), targetBoundaries);
        }

        @Override
        public List<Path> execute(StripeCompactor compactor) throws IOException {
            return compactor.compact(this.request, this.targetBoundaries, this.majorRangeFromRow, this.majorRangeToRow);
        }
    }

    public static abstract class StripeCompactionRequest {
        protected CompactionRequest request;
        protected byte[] majorRangeFromRow = null;
        protected byte[] majorRangeToRow = null;

        public abstract List<Path> execute(StripeCompactor var1) throws IOException;

        public StripeCompactionRequest(CompactionRequest request) {
            this.request = request;
        }

        public void setMajorRange(byte[] startRow, byte[] endRow) {
            this.majorRangeFromRow = startRow;
            this.majorRangeToRow = endRow;
        }

        public CompactionRequest getRequest() {
            return this.request;
        }

        public void setRequest(CompactionRequest request) {
            assert (request != null);
            this.request = request;
            this.majorRangeToRow = null;
            this.majorRangeFromRow = null;
        }
    }
}

