/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security.token;

import com.google.protobuf.RpcCallback;
import com.google.protobuf.RpcController;
import com.google.protobuf.Service;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.Coprocessor;
import org.apache.hadoop.hbase.CoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.CoprocessorService;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.ipc.RequestContext;
import org.apache.hadoop.hbase.ipc.RpcServer;
import org.apache.hadoop.hbase.ipc.RpcServerInterface;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.ResponseConverter;
import org.apache.hadoop.hbase.protobuf.generated.AuthenticationProtos;
import org.apache.hadoop.hbase.security.AccessDeniedException;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.security.token.AuthenticationTokenIdentifier;
import org.apache.hadoop.hbase.security.token.AuthenticationTokenSecretManager;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;

public class TokenProvider
implements AuthenticationProtos.AuthenticationService.Interface,
Coprocessor,
CoprocessorService {
    private static Log LOG = LogFactory.getLog(TokenProvider.class);
    private AuthenticationTokenSecretManager secretManager;

    public void start(CoprocessorEnvironment env) {
        RegionCoprocessorEnvironment regionEnv;
        RpcServerInterface server;
        SecretManager<? extends TokenIdentifier> mgr;
        if (env instanceof RegionCoprocessorEnvironment && (mgr = ((RpcServer)(server = (regionEnv = (RegionCoprocessorEnvironment)env).getRegionServerServices().getRpcServer())).getSecretManager()) instanceof AuthenticationTokenSecretManager) {
            this.secretManager = (AuthenticationTokenSecretManager)mgr;
        }
    }

    public void stop(CoprocessorEnvironment env) throws IOException {
    }

    private boolean isAllowedDelegationTokenOp(UserGroupInformation ugi) throws IOException {
        UserGroupInformation.AuthenticationMethod authMethod = ugi.getAuthenticationMethod();
        if (authMethod == UserGroupInformation.AuthenticationMethod.PROXY) {
            authMethod = ugi.getRealUser().getAuthenticationMethod();
        }
        return authMethod == UserGroupInformation.AuthenticationMethod.KERBEROS || authMethod == UserGroupInformation.AuthenticationMethod.KERBEROS_SSL || authMethod == UserGroupInformation.AuthenticationMethod.CERTIFICATE;
    }

    @Override
    public Service getService() {
        return AuthenticationProtos.AuthenticationService.newReflectiveService((AuthenticationProtos.AuthenticationService.Interface)this);
    }

    public void getAuthenticationToken(RpcController controller, AuthenticationProtos.GetAuthenticationTokenRequest request, RpcCallback<AuthenticationProtos.GetAuthenticationTokenResponse> done) {
        AuthenticationProtos.GetAuthenticationTokenResponse.Builder response = AuthenticationProtos.GetAuthenticationTokenResponse.newBuilder();
        try {
            if (this.secretManager == null) {
                throw new IOException("No secret manager configured for token authentication");
            }
            User currentUser = RequestContext.getRequestUser();
            UserGroupInformation ugi = null;
            if (currentUser != null) {
                ugi = currentUser.getUGI();
            }
            if (currentUser == null) {
                throw new AccessDeniedException("No authenticated user for request!");
            }
            if (!this.isAllowedDelegationTokenOp(ugi)) {
                LOG.warn((Object)("Token generation denied for user=" + currentUser.getName() + ", authMethod=" + ugi.getAuthenticationMethod()));
                throw new AccessDeniedException("Token generation only allowed for Kerberos authenticated clients");
            }
            Token<AuthenticationTokenIdentifier> token = this.secretManager.generateToken(currentUser.getName());
            response.setToken(ProtobufUtil.toToken(token)).build();
        }
        catch (IOException ioe) {
            ResponseConverter.setControllerException((RpcController)controller, (IOException)ioe);
        }
        done.run((Object)response.build());
    }

    public void whoAmI(RpcController controller, AuthenticationProtos.WhoAmIRequest request, RpcCallback<AuthenticationProtos.WhoAmIResponse> done) {
        User requestUser = RequestContext.getRequestUser();
        AuthenticationProtos.WhoAmIResponse.Builder response = AuthenticationProtos.WhoAmIResponse.newBuilder();
        if (requestUser != null) {
            response.setUsername(requestUser.getShortName());
            UserGroupInformation.AuthenticationMethod method = requestUser.getUGI().getAuthenticationMethod();
            if (method != null) {
                response.setAuthMethod(method.name());
            }
        }
        done.run((Object)response.build());
    }
}

