/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.wal;

import java.io.IOException;
import java.io.InputStream;
import java.security.Key;
import java.security.KeyException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.hbase.io.crypto.Cipher;
import org.apache.hadoop.hbase.io.crypto.Decryptor;
import org.apache.hadoop.hbase.io.crypto.Encryption;
import org.apache.hadoop.hbase.protobuf.generated.WALProtos;
import org.apache.hadoop.hbase.regionserver.wal.ProtobufLogReader;
import org.apache.hadoop.hbase.regionserver.wal.SecureWALCellCodec;
import org.apache.hadoop.hbase.regionserver.wal.WALCellCodec;
import org.apache.hadoop.hbase.security.EncryptionUtil;
import org.apache.hadoop.hbase.security.User;

public class SecureProtobufLogReader
extends ProtobufLogReader {
    private static final Log LOG = LogFactory.getLog(SecureProtobufLogReader.class);
    private Decryptor decryptor = null;

    @Override
    protected boolean readHeader(WALProtos.WALHeader.Builder builder, FSDataInputStream stream) throws IOException {
        boolean result = super.readHeader(builder, stream);
        if (result && builder.hasEncryptionKey()) {
            Cipher cipher;
            byte[] keyBytes = builder.getEncryptionKey().toByteArray();
            Key key = null;
            String walKeyName = this.conf.get("hbase.crypto.wal.key.name");
            if (walKeyName != null) {
                try {
                    key = EncryptionUtil.unwrapKey((Configuration)this.conf, (String)walKeyName, (byte[])keyBytes);
                }
                catch (KeyException e) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Unable to unwrap key with WAL key '" + walKeyName + "'"));
                    }
                    key = null;
                }
            }
            if (key == null) {
                String masterKeyName = this.conf.get("hbase.crypto.master.key.name", User.getCurrent().getShortName());
                try {
                    key = EncryptionUtil.unwrapKey((Configuration)this.conf, (String)masterKeyName, (byte[])keyBytes);
                }
                catch (KeyException e) {
                    String alternateKeyName;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Unable to unwrap key with current master key '" + masterKeyName + "'"));
                    }
                    if ((alternateKeyName = this.conf.get("hbase.crypto.master.alternate.key.name")) != null) {
                        try {
                            key = EncryptionUtil.unwrapKey((Configuration)this.conf, (String)alternateKeyName, (byte[])keyBytes);
                        }
                        catch (KeyException ex) {
                            throw new IOException(ex);
                        }
                    }
                    throw new IOException(e);
                }
            }
            if ((cipher = Encryption.getCipher((Configuration)this.conf, (String)key.getAlgorithm())) == null) {
                throw new IOException("Cipher '" + key.getAlgorithm() + "' is not available");
            }
            this.decryptor = cipher.getDecryptor();
            this.decryptor.setKey(key);
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Initialized secure protobuf WAL: cipher=" + cipher.getName()));
            }
        }
        return result;
    }

    @Override
    protected void initAfterCompression() throws IOException {
        if (this.decryptor != null) {
            WALCellCodec codec = SecureWALCellCodec.getCodec(this.conf, this.decryptor);
            this.cellDecoder = codec.getDecoder((InputStream)this.inputStream);
            this.compressionContext = null;
            this.hasCompression = false;
        } else {
            super.initAfterCompression();
        }
    }
}

