/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.hfile;

import java.io.IOException;
import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.io.HeapSize;
import org.apache.hadoop.hbase.io.hfile.BlockCache;
import org.apache.hadoop.hbase.io.hfile.BlockCacheColumnFamilySummary;
import org.apache.hadoop.hbase.io.hfile.BlockCacheKey;
import org.apache.hadoop.hbase.io.hfile.BlockType;
import org.apache.hadoop.hbase.io.hfile.CacheStats;
import org.apache.hadoop.hbase.io.hfile.Cacheable;
import org.apache.hadoop.hbase.io.hfile.LruBlockCache;
import org.apache.hadoop.hbase.io.hfile.bucket.BucketCache;

@InterfaceAudience.Private
public class CombinedBlockCache
implements BlockCache,
HeapSize {
    private final LruBlockCache lruCache;
    private final BucketCache bucketCache;
    private final CombinedCacheStats combinedCacheStats;

    public CombinedBlockCache(LruBlockCache lruCache, BucketCache bucketCache) {
        this.lruCache = lruCache;
        this.bucketCache = bucketCache;
        this.combinedCacheStats = new CombinedCacheStats(lruCache.getStats(), bucketCache.getStats());
    }

    public long heapSize() {
        return this.lruCache.heapSize() + this.bucketCache.heapSize();
    }

    @Override
    public void cacheBlock(BlockCacheKey cacheKey, Cacheable buf, boolean inMemory) {
        boolean isMetaBlock;
        boolean bl = isMetaBlock = buf.getBlockType().getCategory() != BlockType.BlockCategory.DATA;
        if (isMetaBlock) {
            this.lruCache.cacheBlock(cacheKey, buf, inMemory);
        } else {
            this.bucketCache.cacheBlock(cacheKey, buf, inMemory);
        }
    }

    @Override
    public void cacheBlock(BlockCacheKey cacheKey, Cacheable buf) {
        this.cacheBlock(cacheKey, buf, false);
    }

    @Override
    public Cacheable getBlock(BlockCacheKey cacheKey, boolean caching, boolean repeat, boolean updateCacheMetrics) {
        if (this.lruCache.containsBlock(cacheKey)) {
            return this.lruCache.getBlock(cacheKey, caching, repeat, updateCacheMetrics);
        }
        return this.bucketCache.getBlock(cacheKey, caching, repeat, updateCacheMetrics);
    }

    @Override
    public boolean evictBlock(BlockCacheKey cacheKey) {
        return this.lruCache.evictBlock(cacheKey) || this.bucketCache.evictBlock(cacheKey);
    }

    @Override
    public int evictBlocksByHfileName(String hfileName) {
        return this.lruCache.evictBlocksByHfileName(hfileName) + this.bucketCache.evictBlocksByHfileName(hfileName);
    }

    @Override
    public CacheStats getStats() {
        return this.combinedCacheStats;
    }

    @Override
    public void shutdown() {
        this.lruCache.shutdown();
        this.bucketCache.shutdown();
    }

    @Override
    public long size() {
        return this.lruCache.size() + this.bucketCache.size();
    }

    @Override
    public long getFreeSize() {
        return this.lruCache.getFreeSize() + this.bucketCache.getFreeSize();
    }

    @Override
    public long getCurrentSize() {
        return this.lruCache.getCurrentSize() + this.bucketCache.getCurrentSize();
    }

    @Override
    public long getEvictedCount() {
        return this.lruCache.getEvictedCount() + this.bucketCache.getEvictedCount();
    }

    @Override
    public long getBlockCount() {
        return this.lruCache.getBlockCount() + this.bucketCache.getBlockCount();
    }

    @Override
    public List<BlockCacheColumnFamilySummary> getBlockCacheColumnFamilySummaries(Configuration conf) throws IOException {
        throw new UnsupportedOperationException();
    }

    private static class CombinedCacheStats
    extends CacheStats {
        private final CacheStats lruCacheStats;
        private final CacheStats bucketCacheStats;

        CombinedCacheStats(CacheStats lbcStats, CacheStats fcStats) {
            this.lruCacheStats = lbcStats;
            this.bucketCacheStats = fcStats;
        }

        @Override
        public long getRequestCount() {
            return this.lruCacheStats.getRequestCount() + this.bucketCacheStats.getRequestCount();
        }

        @Override
        public long getRequestCachingCount() {
            return this.lruCacheStats.getRequestCachingCount() + this.bucketCacheStats.getRequestCachingCount();
        }

        @Override
        public long getMissCount() {
            return this.lruCacheStats.getMissCount() + this.bucketCacheStats.getMissCount();
        }

        @Override
        public long getMissCachingCount() {
            return this.lruCacheStats.getMissCachingCount() + this.bucketCacheStats.getMissCachingCount();
        }

        @Override
        public long getHitCount() {
            return this.lruCacheStats.getHitCount() + this.bucketCacheStats.getHitCount();
        }

        @Override
        public long getHitCachingCount() {
            return this.lruCacheStats.getHitCachingCount() + this.bucketCacheStats.getHitCachingCount();
        }

        @Override
        public long getEvictionCount() {
            return this.lruCacheStats.getEvictionCount() + this.bucketCacheStats.getEvictionCount();
        }

        @Override
        public long getEvictedCount() {
            return this.lruCacheStats.getEvictedCount() + this.bucketCacheStats.getEvictedCount();
        }

        @Override
        public double getHitRatioPastNPeriods() {
            double ratio = (double)(this.lruCacheStats.getSumHitCountsPastNPeriods() + this.bucketCacheStats.getSumHitCountsPastNPeriods()) / (double)(this.lruCacheStats.getSumRequestCountsPastNPeriods() + this.bucketCacheStats.getSumRequestCountsPastNPeriods());
            return Double.isNaN(ratio) ? 0.0 : ratio;
        }

        @Override
        public double getHitCachingRatioPastNPeriods() {
            double ratio = (double)(this.lruCacheStats.getSumHitCachingCountsPastNPeriods() + this.bucketCacheStats.getSumHitCachingCountsPastNPeriods()) / (double)(this.lruCacheStats.getSumRequestCachingCountsPastNPeriods() + this.bucketCacheStats.getSumRequestCachingCountsPastNPeriods());
            return Double.isNaN(ratio) ? 0.0 : ratio;
        }
    }
}

