/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.ClusterId;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.MediumTests;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.catalog.CatalogTracker;
import org.apache.hadoop.hbase.replication.ReplicationFactory;
import org.apache.hadoop.hbase.replication.ReplicationQueuesZKImpl;
import org.apache.hadoop.hbase.replication.TestReplicationStateBasic;
import org.apache.hadoop.hbase.zookeeper.ZKClusterId;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.zookeeper.KeeperException;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestReplicationStateZKImpl
extends TestReplicationStateBasic {
    private static final Log LOG = LogFactory.getLog(TestReplicationStateZKImpl.class);
    private static Configuration conf;
    private static HBaseTestingUtility utility;
    private static ZooKeeperWatcher zkw;
    private static String replicationZNode;
    private ReplicationQueuesZKImpl rqZK;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        utility = new HBaseTestingUtility();
        utility.startMiniZKCluster();
        conf = utility.getConfiguration();
        zkw = HBaseTestingUtility.getZooKeeperWatcher(utility);
        String replicationZNodeName = conf.get("zookeeper.znode.replication", "replication");
        replicationZNode = ZKUtil.joinZNode((String)TestReplicationStateZKImpl.zkw.baseZNode, (String)replicationZNodeName);
        KEY_ONE = TestReplicationStateZKImpl.initPeerClusterState("/hbase1");
        KEY_TWO = TestReplicationStateZKImpl.initPeerClusterState("/hbase2");
    }

    private static String initPeerClusterState(String baseZKNode) throws IOException, KeeperException {
        Configuration testConf = new Configuration(conf);
        testConf.set("zookeeper.znode.parent", baseZKNode);
        ZooKeeperWatcher zkw1 = new ZooKeeperWatcher(testConf, "test1", null);
        String fakeRs = ZKUtil.joinZNode((String)zkw1.rsZNode, (String)"hostname1.example.org:1234");
        ZKUtil.createWithParents((ZooKeeperWatcher)zkw1, (String)fakeRs);
        ZKClusterId.setClusterId((ZooKeeperWatcher)zkw1, (ClusterId)new ClusterId());
        return ZKUtil.getZooKeeperClusterKey((Configuration)testConf);
    }

    @Override
    @Before
    public void setUp() {
        super.setUp();
        DummyServer ds1 = new DummyServer(this.server1);
        DummyServer ds2 = new DummyServer(this.server2);
        DummyServer ds3 = new DummyServer(this.server3);
        this.rq1 = ReplicationFactory.getReplicationQueues((ZooKeeperWatcher)zkw, (Configuration)conf, (Abortable)ds1);
        this.rq2 = ReplicationFactory.getReplicationQueues((ZooKeeperWatcher)zkw, (Configuration)conf, (Abortable)ds2);
        this.rq3 = ReplicationFactory.getReplicationQueues((ZooKeeperWatcher)zkw, (Configuration)conf, (Abortable)ds3);
        this.rqc = ReplicationFactory.getReplicationQueuesClient((ZooKeeperWatcher)zkw, (Configuration)conf, (Abortable)ds1);
        this.rp = ReplicationFactory.getReplicationPeers((ZooKeeperWatcher)zkw, (Configuration)conf, (Abortable)zkw);
        this.OUR_KEY = ZKUtil.getZooKeeperClusterKey((Configuration)conf);
        this.rqZK = new ReplicationQueuesZKImpl(zkw, conf, (Abortable)ds1);
    }

    @After
    public void tearDown() throws KeeperException, IOException {
        ZKUtil.deleteNodeRecursively((ZooKeeperWatcher)zkw, (String)replicationZNode);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        utility.shutdownMiniZKCluster();
    }

    @Test
    public void testIsPeerPath_PathToParentOfPeerNode() {
        Assert.assertFalse((boolean)this.rqZK.isPeerPath(this.rqZK.peersZNode));
    }

    @Test
    public void testIsPeerPath_PathToChildOfPeerNode() {
        String peerChild = ZKUtil.joinZNode((String)ZKUtil.joinZNode((String)this.rqZK.peersZNode, (String)"1"), (String)"child");
        Assert.assertFalse((boolean)this.rqZK.isPeerPath(peerChild));
    }

    @Test
    public void testIsPeerPath_ActualPeerPath() {
        String peerPath = ZKUtil.joinZNode((String)this.rqZK.peersZNode, (String)"1");
        Assert.assertTrue((boolean)this.rqZK.isPeerPath(peerPath));
    }

    static class DummyServer
    implements Server {
        private String serverName;
        private boolean isAborted = false;
        private boolean isStopped = false;

        public DummyServer(String serverName) {
            this.serverName = serverName;
        }

        public Configuration getConfiguration() {
            return conf;
        }

        public ZooKeeperWatcher getZooKeeper() {
            return zkw;
        }

        public CatalogTracker getCatalogTracker() {
            return null;
        }

        public ServerName getServerName() {
            return ServerName.valueOf((String)this.serverName);
        }

        public void abort(String why, Throwable e) {
            LOG.info((Object)("Aborting " + this.serverName));
            this.isAborted = true;
        }

        public boolean isAborted() {
            return this.isAborted;
        }

        public void stop(String why) {
            this.isStopped = true;
        }

        public boolean isStopped() {
            return this.isStopped;
        }
    }
}

