/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellScanner;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.MediumTests;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.Tag;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.coprocessor.BaseRegionObserver;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.io.encoding.DataBlockEncoding;
import org.apache.hadoop.hbase.protobuf.generated.AdminProtos;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.InternalScanner;
import org.apache.hadoop.hbase.regionserver.Store;
import org.apache.hadoop.hbase.regionserver.wal.WALEdit;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;

@Category(value={MediumTests.class})
public class TestTags {
    static boolean useFilter = false;
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    @Rule
    public final TestName TEST_NAME = new TestName();

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        Configuration conf = TEST_UTIL.getConfiguration();
        conf.setInt("hfile.format.version", 3);
        conf.setStrings("hbase.coprocessor.user.region.classes", new String[]{TestCoprocessorForTags.class.getName()});
        TEST_UTIL.startMiniCluster(1, 2);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @After
    public void tearDown() {
        useFilter = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTags() throws Exception {
        HTable table = null;
        try {
            TableName tableName = TableName.valueOf((String)this.TEST_NAME.getMethodName());
            byte[] fam = Bytes.toBytes((String)"info");
            byte[] row = Bytes.toBytes((String)"rowa");
            byte[] qual = Bytes.toBytes((String)"qual");
            byte[] row1 = Bytes.toBytes((String)"rowb");
            byte[] row2 = Bytes.toBytes((String)"rowc");
            HTableDescriptor desc = new HTableDescriptor(tableName);
            HColumnDescriptor colDesc = new HColumnDescriptor(fam);
            colDesc.setBlockCacheEnabled(true);
            colDesc.setDataBlockEncoding(DataBlockEncoding.PREFIX_TREE);
            desc.addFamily(colDesc);
            HBaseAdmin admin = TEST_UTIL.getHBaseAdmin();
            admin.createTable(desc);
            byte[] value = Bytes.toBytes((String)"value");
            table = new HTable(TEST_UTIL.getConfiguration(), tableName);
            Put put = new Put(row);
            put.add(fam, qual, Long.MAX_VALUE, value);
            put.setAttribute("visibility", Bytes.toBytes((String)"myTag"));
            table.put(put);
            admin.flush(tableName.getName());
            List<HRegion> regions = TEST_UTIL.getHBaseCluster().getRegions(tableName.getName());
            for (HRegion region : regions) {
                Store store = region.getStore(fam);
                while (store.getStorefilesCount() <= 0) {
                    Thread.sleep(10L);
                }
            }
            Put put1 = new Put(row1);
            byte[] value1 = Bytes.toBytes((String)"1000dfsdf");
            put1.add(fam, qual, Long.MAX_VALUE, value1);
            table.put(put1);
            admin.flush(tableName.getName());
            regions = TEST_UTIL.getHBaseCluster().getRegions(tableName.getName());
            for (HRegion region : regions) {
                Store store = region.getStore(fam);
                while (store.getStorefilesCount() <= 1) {
                    Thread.sleep(10L);
                }
            }
            Put put2 = new Put(row2);
            byte[] value2 = Bytes.toBytes((String)"1000dfsdf");
            put2.add(fam, qual, Long.MAX_VALUE, value2);
            put2.setAttribute("visibility", Bytes.toBytes((String)"myTag3"));
            table.put(put2);
            admin.flush(tableName.getName());
            regions = TEST_UTIL.getHBaseCluster().getRegions(tableName.getName());
            for (HRegion region : regions) {
                Store store = region.getStore(fam);
                while (store.getStorefilesCount() <= 2) {
                    Thread.sleep(10L);
                }
            }
            this.result(fam, row, qual, row2, table, value, value2, row1, value1);
            admin.compact(tableName.getName());
            while (admin.getCompactionState(tableName.getName()) != AdminProtos.GetRegionInfoResponse.CompactionState.NONE) {
                Thread.sleep(10L);
            }
            this.result(fam, row, qual, row2, table, value, value2, row1, value1);
        }
        finally {
            if (table != null) {
                table.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFlushAndCompactionWithoutTags() throws Exception {
        HTable table = null;
        try {
            KeyValue current;
            boolean advance;
            CellScanner cellScanner;
            Result[] next;
            TableName tableName = TableName.valueOf((String)this.TEST_NAME.getMethodName());
            byte[] fam = Bytes.toBytes((String)"info");
            byte[] row = Bytes.toBytes((String)"rowa");
            byte[] qual = Bytes.toBytes((String)"qual");
            byte[] row1 = Bytes.toBytes((String)"rowb");
            byte[] row2 = Bytes.toBytes((String)"rowc");
            HTableDescriptor desc = new HTableDescriptor(tableName);
            HColumnDescriptor colDesc = new HColumnDescriptor(fam);
            colDesc.setBlockCacheEnabled(true);
            colDesc.setDataBlockEncoding(DataBlockEncoding.PREFIX_TREE);
            desc.addFamily(colDesc);
            HBaseAdmin admin = TEST_UTIL.getHBaseAdmin();
            admin.createTable(desc);
            table = new HTable(TEST_UTIL.getConfiguration(), tableName);
            Put put = new Put(row);
            byte[] value = Bytes.toBytes((String)"value");
            put.add(fam, qual, Long.MAX_VALUE, value);
            table.put(put);
            admin.flush(tableName.getName());
            List<HRegion> regions = TEST_UTIL.getHBaseCluster().getRegions(tableName.getName());
            for (HRegion region : regions) {
                Store store = region.getStore(fam);
                while (store.getStorefilesCount() <= 0) {
                    Thread.sleep(10L);
                }
            }
            Put put1 = new Put(row1);
            byte[] value1 = Bytes.toBytes((String)"1000dfsdf");
            put1.add(fam, qual, Long.MAX_VALUE, value1);
            table.put(put1);
            admin.flush(tableName.getName());
            regions = TEST_UTIL.getHBaseCluster().getRegions(tableName.getName());
            for (HRegion region : regions) {
                Store store = region.getStore(fam);
                while (store.getStorefilesCount() <= 1) {
                    Thread.sleep(10L);
                }
            }
            Put put2 = new Put(row2);
            byte[] value2 = Bytes.toBytes((String)"1000dfsdf");
            put2.add(fam, qual, Long.MAX_VALUE, value2);
            table.put(put2);
            admin.flush(tableName.getName());
            regions = TEST_UTIL.getHBaseCluster().getRegions(tableName.getName());
            for (HRegion region : regions) {
                Store store = region.getStore(fam);
                while (store.getStorefilesCount() <= 2) {
                    Thread.sleep(10L);
                }
            }
            Scan s = new Scan(row);
            ResultScanner scanner = table.getScanner(s);
            try {
                for (Result result : next = scanner.next(3)) {
                    cellScanner = result.cellScanner();
                    advance = cellScanner.advance();
                    current = (KeyValue)cellScanner.current();
                    Assert.assertTrue((current.getValueOffset() + current.getValueLength() == current.getLength() ? 1 : 0) != 0);
                }
            }
            finally {
                if (scanner != null) {
                    scanner.close();
                }
            }
            admin.compact(tableName.getName());
            while (admin.getCompactionState(tableName.getName()) != AdminProtos.GetRegionInfoResponse.CompactionState.NONE) {
                Thread.sleep(10L);
            }
            s = new Scan(row);
            scanner = table.getScanner(s);
            try {
                for (Result result : next = scanner.next(3)) {
                    cellScanner = result.cellScanner();
                    advance = cellScanner.advance();
                    current = (KeyValue)cellScanner.current();
                    Assert.assertTrue((current.getValueOffset() + current.getValueLength() == current.getLength() ? 1 : 0) != 0);
                }
            }
            finally {
                if (scanner != null) {
                    scanner.close();
                }
            }
        }
        finally {
            if (table != null) {
                table.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFlushAndCompactionwithCombinations() throws Exception {
        HTable table = null;
        try {
            KeyValue current;
            boolean advance;
            CellScanner cellScanner;
            Result[] next;
            Store store;
            TableName tableName = TableName.valueOf((String)this.TEST_NAME.getMethodName());
            byte[] fam = Bytes.toBytes((String)"info");
            byte[] row = Bytes.toBytes((String)"rowa");
            byte[] qual = Bytes.toBytes((String)"qual");
            byte[] row1 = Bytes.toBytes((String)"rowb");
            byte[] row2 = Bytes.toBytes((String)"rowc");
            byte[] rowd = Bytes.toBytes((String)"rowd");
            byte[] rowe = Bytes.toBytes((String)"rowe");
            HTableDescriptor desc = new HTableDescriptor(tableName);
            HColumnDescriptor colDesc = new HColumnDescriptor(fam);
            colDesc.setBlockCacheEnabled(true);
            colDesc.setDataBlockEncoding(DataBlockEncoding.PREFIX_TREE);
            desc.addFamily(colDesc);
            HBaseAdmin admin = TEST_UTIL.getHBaseAdmin();
            admin.createTable(desc);
            table = new HTable(TEST_UTIL.getConfiguration(), tableName);
            Put put = new Put(row);
            byte[] value = Bytes.toBytes((String)"value");
            put.add(fam, qual, Long.MAX_VALUE, value);
            put.setAttribute("visibility", Bytes.toBytes((String)"ram"));
            table.put(put);
            Put put1 = new Put(row1);
            byte[] value1 = Bytes.toBytes((String)"1000dfsdf");
            put1.add(fam, qual, Long.MAX_VALUE, value1);
            table.put(put1);
            admin.flush(tableName.getName());
            List<HRegion> regions = TEST_UTIL.getHBaseCluster().getRegions(tableName.getName());
            for (HRegion region : regions) {
                store = region.getStore(fam);
                while (store.getStorefilesCount() <= 0) {
                    Thread.sleep(10L);
                }
            }
            put1 = new Put(row2);
            value1 = Bytes.toBytes((String)"1000dfsdf");
            put1.add(fam, qual, Long.MAX_VALUE, value1);
            table.put(put1);
            admin.flush(tableName.getName());
            regions = TEST_UTIL.getHBaseCluster().getRegions(tableName.getName());
            for (HRegion region : regions) {
                store = region.getStore(fam);
                while (store.getStorefilesCount() <= 1) {
                    Thread.sleep(10L);
                }
            }
            Put put2 = new Put(rowd);
            byte[] value2 = Bytes.toBytes((String)"1000dfsdf");
            put2.add(fam, qual, Long.MAX_VALUE, value2);
            table.put(put2);
            put2 = new Put(rowe);
            value2 = Bytes.toBytes((String)"1000dfsddfdf");
            put2.add(fam, qual, Long.MAX_VALUE, value2);
            put.setAttribute("visibility", Bytes.toBytes((String)"ram"));
            table.put(put2);
            admin.flush(tableName.getName());
            regions = TEST_UTIL.getHBaseCluster().getRegions(tableName.getName());
            for (HRegion region : regions) {
                Store store2 = region.getStore(fam);
                while (store2.getStorefilesCount() <= 2) {
                    Thread.sleep(10L);
                }
            }
            Scan s = new Scan(row);
            ResultScanner scanner = table.getScanner(s);
            try {
                for (Result result : next = scanner.next(5)) {
                    cellScanner = result.cellScanner();
                    advance = cellScanner.advance();
                    current = (KeyValue)cellScanner.current();
                    short tagsLength = current.getTagsLength();
                    if (tagsLength == 0) {
                        Assert.assertTrue((current.getValueOffset() + current.getValueLength() == current.getLength() ? 1 : 0) != 0);
                        continue;
                    }
                    Assert.assertTrue((current.getValueOffset() + current.getValueLength() != current.getLength() ? 1 : 0) != 0);
                }
            }
            finally {
                if (scanner != null) {
                    scanner.close();
                }
            }
            while (admin.getCompactionState(tableName.getName()) != AdminProtos.GetRegionInfoResponse.CompactionState.NONE) {
                Thread.sleep(10L);
            }
            s = new Scan(row);
            scanner = table.getScanner(s);
            try {
                for (Result result : next = scanner.next(5)) {
                    cellScanner = result.cellScanner();
                    advance = cellScanner.advance();
                    current = (KeyValue)cellScanner.current();
                    if (current.getTagsLength() == 0) {
                        Assert.assertTrue((current.getValueOffset() + current.getValueLength() == current.getLength() ? 1 : 0) != 0);
                        continue;
                    }
                    Assert.assertTrue((current.getValueOffset() + current.getValueLength() != current.getLength() ? 1 : 0) != 0);
                }
            }
            finally {
                if (scanner != null) {
                    scanner.close();
                }
            }
        }
        finally {
            if (table != null) {
                table.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTagsWithAppendAndIncrement() throws Exception {
        TableName tableName = TableName.valueOf((String)this.TEST_NAME.getMethodName());
        byte[] f = Bytes.toBytes((String)"f");
        byte[] q = Bytes.toBytes((String)"q");
        byte[] row1 = Bytes.toBytes((String)"r1");
        byte[] row2 = Bytes.toBytes((String)"r2");
        HTableDescriptor desc = new HTableDescriptor(tableName);
        HColumnDescriptor colDesc = new HColumnDescriptor(f);
        desc.addFamily(colDesc);
        TEST_UTIL.getHBaseAdmin().createTable(desc);
        HTable table = null;
        try {
            table = new HTable(TEST_UTIL.getConfiguration(), tableName);
            Put put = new Put(row1);
            byte[] v = Bytes.toBytes((long)2L);
            put.add(f, q, v);
            put.setAttribute("visibility", Bytes.toBytes((String)"tag1"));
            table.put(put);
            Increment increment = new Increment(row1);
            increment.addColumn(f, q, 1L);
            table.increment(increment);
            TestCoprocessorForTags.checkTagPresence = true;
            ResultScanner scanner = table.getScanner(new Scan());
            Result result = scanner.next();
            KeyValue kv = KeyValueUtil.ensureKeyValue((Cell)result.getColumnLatestCell(f, q));
            List<Tag> tags = TestCoprocessorForTags.tags;
            Assert.assertEquals((long)3L, (long)Bytes.toLong((byte[])kv.getValueArray(), (int)kv.getValueOffset(), (int)kv.getValueLength()));
            Assert.assertEquals((long)1L, (long)tags.size());
            Assert.assertEquals((Object)"tag1", (Object)Bytes.toString((byte[])tags.get(0).getValue()));
            TestCoprocessorForTags.checkTagPresence = false;
            TestCoprocessorForTags.tags = null;
            increment = new Increment(row1);
            increment.add((Cell)new KeyValue(row1, f, q, 1234L, v));
            increment.setAttribute("visibility", Bytes.toBytes((String)"tag2"));
            table.increment(increment);
            TestCoprocessorForTags.checkTagPresence = true;
            scanner = table.getScanner(new Scan());
            result = scanner.next();
            kv = KeyValueUtil.ensureKeyValue((Cell)result.getColumnLatestCell(f, q));
            tags = TestCoprocessorForTags.tags;
            Assert.assertEquals((long)5L, (long)Bytes.toLong((byte[])kv.getValueArray(), (int)kv.getValueOffset(), (int)kv.getValueLength()));
            Assert.assertEquals((long)2L, (long)tags.size());
            Assert.assertEquals((Object)"tag1", (Object)Bytes.toString((byte[])tags.get(0).getValue()));
            Assert.assertEquals((Object)"tag2", (Object)Bytes.toString((byte[])tags.get(1).getValue()));
            TestCoprocessorForTags.checkTagPresence = false;
            TestCoprocessorForTags.tags = null;
            put = new Put(row2);
            v = Bytes.toBytes((long)2L);
            put.add(f, q, v);
            table.put(put);
            increment = new Increment(row2);
            increment.add((Cell)new KeyValue(row2, f, q, 1234L, v));
            increment.setAttribute("visibility", Bytes.toBytes((String)"tag2"));
            table.increment(increment);
            Scan scan = new Scan();
            scan.setStartRow(row2);
            TestCoprocessorForTags.checkTagPresence = true;
            scanner = table.getScanner(scan);
            result = scanner.next();
            kv = KeyValueUtil.ensureKeyValue((Cell)result.getColumnLatestCell(f, q));
            tags = TestCoprocessorForTags.tags;
            Assert.assertEquals((long)4L, (long)Bytes.toLong((byte[])kv.getValueArray(), (int)kv.getValueOffset(), (int)kv.getValueLength()));
            Assert.assertEquals((long)1L, (long)tags.size());
            Assert.assertEquals((Object)"tag2", (Object)Bytes.toString((byte[])tags.get(0).getValue()));
            TestCoprocessorForTags.checkTagPresence = false;
            TestCoprocessorForTags.tags = null;
            byte[] row3 = Bytes.toBytes((String)"r3");
            put = new Put(row3);
            put.add(f, q, Bytes.toBytes((String)"a"));
            put.setAttribute("visibility", Bytes.toBytes((String)"tag1"));
            table.put(put);
            Append append = new Append(row3);
            append.add(f, q, Bytes.toBytes((String)"b"));
            table.append(append);
            scan = new Scan();
            scan.setStartRow(row3);
            TestCoprocessorForTags.checkTagPresence = true;
            scanner = table.getScanner(scan);
            result = scanner.next();
            kv = KeyValueUtil.ensureKeyValue((Cell)result.getColumnLatestCell(f, q));
            tags = TestCoprocessorForTags.tags;
            Assert.assertEquals((long)1L, (long)tags.size());
            Assert.assertEquals((Object)"tag1", (Object)Bytes.toString((byte[])tags.get(0).getValue()));
            TestCoprocessorForTags.checkTagPresence = false;
            TestCoprocessorForTags.tags = null;
            append = new Append(row3);
            append.add((Cell)new KeyValue(row3, f, q, 1234L, v));
            append.setAttribute("visibility", Bytes.toBytes((String)"tag2"));
            table.append(append);
            TestCoprocessorForTags.checkTagPresence = true;
            scanner = table.getScanner(scan);
            result = scanner.next();
            kv = KeyValueUtil.ensureKeyValue((Cell)result.getColumnLatestCell(f, q));
            tags = TestCoprocessorForTags.tags;
            Assert.assertEquals((long)2L, (long)tags.size());
            Assert.assertEquals((Object)"tag1", (Object)Bytes.toString((byte[])tags.get(0).getValue()));
            Assert.assertEquals((Object)"tag2", (Object)Bytes.toString((byte[])tags.get(1).getValue()));
            TestCoprocessorForTags.checkTagPresence = false;
            TestCoprocessorForTags.tags = null;
            byte[] row4 = Bytes.toBytes((String)"r4");
            put = new Put(row4);
            put.add(f, q, Bytes.toBytes((String)"a"));
            table.put(put);
            append = new Append(row4);
            append.add((Cell)new KeyValue(row4, f, q, 1234L, v));
            append.setAttribute("visibility", Bytes.toBytes((String)"tag2"));
            table.append(append);
            scan = new Scan();
            scan.setStartRow(row4);
            TestCoprocessorForTags.checkTagPresence = true;
            scanner = table.getScanner(scan);
            result = scanner.next();
            kv = KeyValueUtil.ensureKeyValue((Cell)result.getColumnLatestCell(f, q));
            tags = TestCoprocessorForTags.tags;
            Assert.assertEquals((long)1L, (long)tags.size());
            Assert.assertEquals((Object)"tag2", (Object)Bytes.toString((byte[])tags.get(0).getValue()));
        }
        finally {
            TestCoprocessorForTags.checkTagPresence = false;
            TestCoprocessorForTags.tags = null;
            if (table != null) {
                table.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void result(byte[] fam, byte[] row, byte[] qual, byte[] row2, HTable table, byte[] value, byte[] value2, byte[] row1, byte[] value1) throws IOException {
        Scan s = new Scan(row);
        s.setAttribute("visibility", Bytes.toBytes((String)"myTag"));
        ResultScanner scanner = null;
        try {
            scanner = table.getScanner(s);
            Result next = scanner.next();
            CellScanner cellScanner = next.cellScanner();
            boolean advance = cellScanner.advance();
            KeyValue current = (KeyValue)cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])next.getRow(), (byte[])row));
            Assert.assertTrue((boolean)Bytes.equals((byte[])next.getValue(fam, qual), (byte[])value));
            Result next2 = scanner.next();
            Assert.assertTrue((next2 != null ? 1 : 0) != 0);
            Assert.assertTrue((boolean)Bytes.equals((byte[])next2.getRow(), (byte[])row1));
            Assert.assertTrue((boolean)Bytes.equals((byte[])next2.getValue(fam, qual), (byte[])value1));
            next2 = scanner.next();
            Assert.assertTrue((next2 != null ? 1 : 0) != 0);
            Assert.assertTrue((boolean)Bytes.equals((byte[])next2.getRow(), (byte[])row2));
            Assert.assertTrue((boolean)Bytes.equals((byte[])next2.getValue(fam, qual), (byte[])value2));
        }
        finally {
            if (scanner != null) {
                scanner.close();
            }
        }
    }

    public static class TestCoprocessorForTags
    extends BaseRegionObserver {
        public static boolean checkTagPresence = false;
        public static List<Tag> tags = null;

        public void prePut(ObserverContext<RegionCoprocessorEnvironment> e, Put put, WALEdit edit, Durability durability) throws IOException {
            this.updateMutationAddingTags((Mutation)put);
        }

        private void updateMutationAddingTags(Mutation m) {
            byte[] attribute = m.getAttribute("visibility");
            byte[] cf = null;
            ArrayList<KeyValue> updatedCells = new ArrayList<KeyValue>();
            if (attribute != null) {
                for (List edits : m.getFamilyCellMap().values()) {
                    for (Cell cell : edits) {
                        KeyValue kv = KeyValueUtil.ensureKeyValue((Cell)cell);
                        if (cf == null) {
                            cf = kv.getFamily();
                        }
                        Tag tag = new Tag(1, attribute);
                        ArrayList<Tag> tagList = new ArrayList<Tag>();
                        tagList.add(tag);
                        KeyValue newKV = new KeyValue(kv.getRow(), 0, (int)kv.getRowLength(), kv.getFamily(), 0, (int)kv.getFamilyLength(), kv.getQualifier(), 0, kv.getQualifierLength(), kv.getTimestamp(), KeyValue.Type.codeToType((byte)kv.getType()), kv.getValue(), 0, kv.getValueLength(), tagList);
                        updatedCells.add(newKV);
                    }
                }
                m.getFamilyCellMap().remove(cf);
                m.getFamilyCellMap().put(cf, updatedCells);
            }
        }

        public Result preIncrement(ObserverContext<RegionCoprocessorEnvironment> e, Increment increment) throws IOException {
            this.updateMutationAddingTags((Mutation)increment);
            return super.preIncrement(e, increment);
        }

        public Result preAppend(ObserverContext<RegionCoprocessorEnvironment> e, Append append) throws IOException {
            this.updateMutationAddingTags((Mutation)append);
            return super.preAppend(e, append);
        }

        public boolean postScannerNext(ObserverContext<RegionCoprocessorEnvironment> e, InternalScanner s, List<Result> results, int limit, boolean hasMore) throws IOException {
            Result result;
            CellScanner cellScanner;
            if (checkTagPresence && results.size() > 0 && (cellScanner = (result = results.get(0)).cellScanner()).advance()) {
                Cell cell = cellScanner.current();
                tags = Tag.asList((byte[])cell.getTagsArray(), (int)cell.getTagsOffset(), (int)cell.getTagsLength());
            }
            return hasMore;
        }
    }
}

