/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.compactions;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.io.compress.Compression;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.io.hfile.HFileWriterV2;
import org.apache.hadoop.hbase.regionserver.HStore;
import org.apache.hadoop.hbase.regionserver.InternalScanner;
import org.apache.hadoop.hbase.regionserver.ScanType;
import org.apache.hadoop.hbase.regionserver.Store;
import org.apache.hadoop.hbase.regionserver.StoreFile;
import org.apache.hadoop.hbase.regionserver.StoreFileScanner;
import org.apache.hadoop.hbase.regionserver.StoreScanner;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionProgress;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionRequest;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.util.StringUtils;

@InterfaceAudience.Private
public abstract class Compactor {
    private static final Log LOG = LogFactory.getLog(Compactor.class);
    protected CompactionProgress progress;
    protected Configuration conf;
    protected Store store;
    private int compactionKVMax;
    protected Compression.Algorithm compactionCompression;

    Compactor(Configuration conf, Store store) {
        this.conf = conf;
        this.store = store;
        this.compactionKVMax = this.conf.getInt("hbase.hstore.compaction.kv.max", 10);
        this.compactionCompression = this.store.getFamily() == null ? Compression.Algorithm.NONE : this.store.getFamily().getCompactionCompression();
    }

    public CompactionProgress getProgress() {
        return this.progress;
    }

    protected FileDetails getFileDetails(Collection<StoreFile> filesToCompact, boolean calculatePutTs) throws IOException {
        FileDetails fd = new FileDetails();
        for (StoreFile file : filesToCompact) {
            long seqNum = file.getMaxSequenceId();
            fd.maxSeqId = Math.max(fd.maxSeqId, seqNum);
            StoreFile.Reader r = file.getReader();
            if (r == null) {
                LOG.warn((Object)("Null reader for " + file.getPath()));
                continue;
            }
            long keyCount = r.getBloomFilterType() == this.store.getFamily().getBloomFilterType() ? r.getFilterEntries() : r.getEntries();
            fd.maxKeyCount += keyCount;
            Map<byte[], byte[]> fileInfo = r.loadFileInfo();
            byte[] tmp = fileInfo.get(HFileWriterV2.MAX_MEMSTORE_TS_KEY);
            if (tmp != null) {
                fd.maxMVCCReadpoint = Math.max(fd.maxMVCCReadpoint, Bytes.toLong((byte[])tmp));
            }
            if ((tmp = fileInfo.get(HFile.FileInfo.MAX_TAGS_LEN)) != null) {
                fd.maxTagsLength = Math.max(fd.maxTagsLength, Bytes.toInt((byte[])tmp));
            }
            long earliestPutTs = 0L;
            if (calculatePutTs) {
                tmp = fileInfo.get(StoreFile.EARLIEST_PUT_TS);
                if (tmp == null) {
                    earliestPutTs = Long.MIN_VALUE;
                    fd.earliestPutTs = Long.MIN_VALUE;
                } else {
                    earliestPutTs = Bytes.toLong((byte[])tmp);
                    fd.earliestPutTs = Math.min(fd.earliestPutTs, earliestPutTs);
                }
            }
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug((Object)("Compacting " + file + ", keycount=" + keyCount + ", bloomtype=" + r.getBloomFilterType().toString() + ", size=" + StringUtils.humanReadableInt((long)r.length()) + ", encoding=" + r.getHFileReader().getDataBlockEncoding() + ", seqNum=" + seqNum + (calculatePutTs ? ", earliestPutTs=" + earliestPutTs : "")));
        }
        return fd;
    }

    protected List<StoreFileScanner> createFileScanners(Collection<StoreFile> filesToCompact, long smallestReadPoint) throws IOException {
        return StoreFileScanner.getScannersForStoreFiles(filesToCompact, false, false, true, smallestReadPoint);
    }

    protected long getSmallestReadPoint() {
        return this.store.getSmallestReadPoint();
    }

    protected InternalScanner preCreateCoprocScanner(CompactionRequest request, ScanType scanType, long earliestPutTs, List<StoreFileScanner> scanners) throws IOException {
        if (this.store.getCoprocessorHost() == null) {
            return null;
        }
        return this.store.getCoprocessorHost().preCompactScannerOpen(this.store, scanners, scanType, earliestPutTs, request);
    }

    protected InternalScanner postCreateCoprocScanner(CompactionRequest request, ScanType scanType, InternalScanner scanner) throws IOException {
        if (this.store.getCoprocessorHost() == null) {
            return scanner;
        }
        return this.store.getCoprocessorHost().preCompact(this.store, scanner, scanType, request);
    }

    protected boolean performCompaction(InternalScanner scanner, CellSink writer, long smallestReadPoint) throws IOException {
        boolean hasMore;
        int bytesWritten = 0;
        ArrayList<Cell> kvs = new ArrayList<Cell>();
        int closeCheckInterval = HStore.getCloseCheckInterval();
        do {
            hasMore = scanner.next(kvs, this.compactionKVMax);
            for (Cell c : kvs) {
                KeyValue kv = KeyValueUtil.ensureKeyValue((Cell)c);
                if (kv.getMvccVersion() <= smallestReadPoint) {
                    kv.setMvccVersion(0L);
                }
                writer.append(kv);
                ++this.progress.currentCompactedKVs;
                if (closeCheckInterval <= 0 || (bytesWritten += kv.getLength()) <= closeCheckInterval) continue;
                bytesWritten = 0;
                if (this.store.areWritesEnabled()) continue;
                this.progress.cancel();
                return false;
            }
            kvs.clear();
        } while (hasMore);
        this.progress.complete();
        return true;
    }

    protected InternalScanner createScanner(Store store, List<StoreFileScanner> scanners, ScanType scanType, long smallestReadPoint, long earliestPutTs) throws IOException {
        Scan scan = new Scan();
        scan.setMaxVersions(store.getFamily().getMaxVersions());
        return new StoreScanner(store, store.getScanInfo(), scan, scanners, scanType, smallestReadPoint, earliestPutTs);
    }

    protected InternalScanner createScanner(Store store, List<StoreFileScanner> scanners, long smallestReadPoint, long earliestPutTs, byte[] dropDeletesFromRow, byte[] dropDeletesToRow) throws IOException {
        Scan scan = new Scan();
        scan.setMaxVersions(store.getFamily().getMaxVersions());
        return new StoreScanner(store, store.getScanInfo(), scan, scanners, smallestReadPoint, earliestPutTs, dropDeletesFromRow, dropDeletesToRow);
    }

    protected static class FileDetails {
        public long maxKeyCount = 0L;
        public long earliestPutTs = Long.MAX_VALUE;
        public long maxSeqId = 0L;
        public long maxMVCCReadpoint = 0L;
        public int maxTagsLength = 0;

        protected FileDetails() {
        }
    }

    public static interface CellSink {
        public void append(KeyValue var1) throws IOException;
    }
}

