/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.util.LinkedList;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hbase.util.ClassSize;

@InterfaceAudience.Private
public class MultiVersionConsistencyControl {
    private volatile long memstoreRead = 0L;
    private volatile long memstoreWrite = 0L;
    private final Object readWaiters = new Object();
    private final LinkedList<WriteEntry> writeQueue = new LinkedList();
    public static final long FIXED_SIZE = ClassSize.align((int)(ClassSize.OBJECT + 16 + 2 * ClassSize.REFERENCE));

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize(long startPoint) {
        LinkedList<WriteEntry> linkedList = this.writeQueue;
        synchronized (linkedList) {
            if (this.memstoreWrite != this.memstoreRead) {
                throw new RuntimeException("Already used this mvcc. Too late to initialize");
            }
            this.memstoreRead = this.memstoreWrite = startPoint;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WriteEntry beginMemstoreInsert() {
        LinkedList<WriteEntry> linkedList = this.writeQueue;
        synchronized (linkedList) {
            long nextWriteNumber = ++this.memstoreWrite;
            WriteEntry e = new WriteEntry(nextWriteNumber);
            this.writeQueue.add(e);
            return e;
        }
    }

    public void completeMemstoreInsert(WriteEntry e) {
        this.advanceMemstore(e);
        this.waitForRead(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean advanceMemstore(WriteEntry e) {
        LinkedList<WriteEntry> linkedList = this.writeQueue;
        synchronized (linkedList) {
            e.markCompleted();
            long nextReadValue = -1L;
            boolean ranOnce = false;
            while (!this.writeQueue.isEmpty()) {
                ranOnce = true;
                WriteEntry queueFirst = this.writeQueue.getFirst();
                if (nextReadValue > 0L && nextReadValue + 1L != queueFirst.getWriteNumber()) {
                    throw new RuntimeException("invariant in completeMemstoreInsert violated, prev: " + nextReadValue + " next: " + queueFirst.getWriteNumber());
                }
                if (!queueFirst.isCompleted()) break;
                nextReadValue = queueFirst.getWriteNumber();
                this.writeQueue.removeFirst();
            }
            if (!ranOnce) {
                throw new RuntimeException("never was a first");
            }
            if (nextReadValue > 0L) {
                Object object = this.readWaiters;
                synchronized (object) {
                    this.memstoreRead = nextReadValue;
                    this.readWaiters.notifyAll();
                }
            }
            return this.memstoreRead >= e.getWriteNumber();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForRead(WriteEntry e) {
        boolean interrupted = false;
        Object object = this.readWaiters;
        synchronized (object) {
            while (this.memstoreRead < e.getWriteNumber()) {
                try {
                    this.readWaiters.wait(0L);
                }
                catch (InterruptedException ie) {
                    interrupted = true;
                }
            }
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
    }

    public long memstoreReadPoint() {
        return this.memstoreRead;
    }

    public static class WriteEntry {
        private long writeNumber;
        private boolean completed = false;

        WriteEntry(long writeNumber) {
            this.writeNumber = writeNumber;
        }

        void markCompleted() {
            this.completed = true;
        }

        boolean isCompleted() {
            return this.completed;
        }

        long getWriteNumber() {
            return this.writeNumber;
        }
    }
}

