/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapreduce;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.mapreduce.TableMapReduceUtil;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableUtils;
import org.apache.hadoop.mapreduce.InputSplit;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class TableSplit
extends InputSplit
implements Writable,
Comparable<TableSplit> {
    public static final Log LOG = LogFactory.getLog(TableSplit.class);
    private static final Version VERSION = Version.INITIAL;
    private TableName tableName;
    private byte[] startRow;
    private byte[] endRow;
    private String regionLocation;
    private String scan = "";
    private long length;

    public TableSplit() {
        this((TableName)null, null, HConstants.EMPTY_BYTE_ARRAY, HConstants.EMPTY_BYTE_ARRAY, "");
    }

    @Deprecated
    public TableSplit(byte[] tableName, Scan scan, byte[] startRow, byte[] endRow, String location) {
        this(TableName.valueOf((byte[])tableName), scan, startRow, endRow, location);
    }

    public TableSplit(TableName tableName, Scan scan, byte[] startRow, byte[] endRow, String location) {
        this(tableName, scan, startRow, endRow, location, 0L);
    }

    public TableSplit(TableName tableName, Scan scan, byte[] startRow, byte[] endRow, String location, long length) {
        this.tableName = tableName;
        try {
            this.scan = null == scan ? "" : TableMapReduceUtil.convertScanToString(scan);
        }
        catch (IOException e) {
            LOG.warn((Object)"Failed to convert Scan to String", (Throwable)e);
        }
        this.startRow = startRow;
        this.endRow = endRow;
        this.regionLocation = location;
        this.length = length;
    }

    @Deprecated
    public TableSplit(byte[] tableName, byte[] startRow, byte[] endRow, String location) {
        this(TableName.valueOf((byte[])tableName), startRow, endRow, location);
    }

    public TableSplit(TableName tableName, byte[] startRow, byte[] endRow, String location) {
        this(tableName, null, startRow, endRow, location);
    }

    public TableSplit(TableName tableName, byte[] startRow, byte[] endRow, String location, long length) {
        this(tableName, null, startRow, endRow, location, length);
    }

    public Scan getScan() throws IOException {
        return TableMapReduceUtil.convertStringToScan(this.scan);
    }

    public byte[] getTableName() {
        return this.tableName.getName();
    }

    public TableName getTable() {
        return this.tableName;
    }

    public byte[] getStartRow() {
        return this.startRow;
    }

    public byte[] getEndRow() {
        return this.endRow;
    }

    public String getRegionLocation() {
        return this.regionLocation;
    }

    public String[] getLocations() {
        return new String[]{this.regionLocation};
    }

    public long getLength() {
        return this.length;
    }

    public void readFields(DataInput in) throws IOException {
        Version version = Version.UNVERSIONED;
        int len = WritableUtils.readVInt((DataInput)in);
        if (len < 0) {
            version = Version.fromCode(len);
            len = WritableUtils.readVInt((DataInput)in);
        }
        byte[] tableNameBytes = new byte[len];
        in.readFully(tableNameBytes);
        this.tableName = TableName.valueOf((byte[])tableNameBytes);
        this.startRow = Bytes.readByteArray((DataInput)in);
        this.endRow = Bytes.readByteArray((DataInput)in);
        this.regionLocation = Bytes.toString((byte[])Bytes.readByteArray((DataInput)in));
        if (version.atLeast(Version.INITIAL)) {
            this.scan = Bytes.toString((byte[])Bytes.readByteArray((DataInput)in));
        }
        this.length = WritableUtils.readVLong((DataInput)in);
    }

    public void write(DataOutput out) throws IOException {
        WritableUtils.writeVInt((DataOutput)out, (int)TableSplit.VERSION.code);
        Bytes.writeByteArray((DataOutput)out, (byte[])this.tableName.getName());
        Bytes.writeByteArray((DataOutput)out, (byte[])this.startRow);
        Bytes.writeByteArray((DataOutput)out, (byte[])this.endRow);
        Bytes.writeByteArray((DataOutput)out, (byte[])Bytes.toBytes((String)this.regionLocation));
        Bytes.writeByteArray((DataOutput)out, (byte[])Bytes.toBytes((String)this.scan));
        WritableUtils.writeVLong((DataOutput)out, (long)this.length);
    }

    public String toString() {
        return this.regionLocation + ":" + Bytes.toStringBinary((byte[])this.startRow) + "," + Bytes.toStringBinary((byte[])this.endRow);
    }

    @Override
    public int compareTo(TableSplit split) {
        int tableNameComparison = this.getTable().compareTo(split.getTable());
        return tableNameComparison != 0 ? tableNameComparison : Bytes.compareTo((byte[])this.getStartRow(), (byte[])split.getStartRow());
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof TableSplit)) {
            return false;
        }
        return this.tableName.equals((Object)((TableSplit)o).tableName) && Bytes.equals((byte[])this.startRow, (byte[])((TableSplit)o).startRow) && Bytes.equals((byte[])this.endRow, (byte[])((TableSplit)o).endRow) && this.regionLocation.equals(((TableSplit)o).regionLocation);
    }

    public int hashCode() {
        int result = this.tableName != null ? this.tableName.hashCode() : 0;
        result = 31 * result + (this.scan != null ? this.scan.hashCode() : 0);
        result = 31 * result + (this.startRow != null ? Arrays.hashCode(this.startRow) : 0);
        result = 31 * result + (this.endRow != null ? Arrays.hashCode(this.endRow) : 0);
        result = 31 * result + (this.regionLocation != null ? this.regionLocation.hashCode() : 0);
        return result;
    }

    static enum Version {
        UNVERSIONED(0),
        INITIAL(-1);

        final int code;
        static final Version[] byCode;

        private Version(int code) {
            this.code = code;
        }

        boolean atLeast(Version other) {
            return this.code <= other.code;
        }

        static Version fromCode(int code) {
            return byCode[code * -1];
        }

        static {
            byCode = Version.values();
            for (int i = 0; i < byCode.length; ++i) {
                if (Version.byCode[i].code != -1 * i) {
                    throw new AssertionError((Object)"Values in this enum should be descending by one");
                }
            }
        }
    }
}

