/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security.visibility;

import java.io.IOException;
import java.security.PrivilegedExceptionAction;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.MediumTests;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.protobuf.generated.VisibilityLabelsProtos;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.security.visibility.Authorizations;
import org.apache.hadoop.hbase.security.visibility.CellVisibility;
import org.apache.hadoop.hbase.security.visibility.LabelFilteringScanLabelGenerator;
import org.apache.hadoop.hbase.security.visibility.SimpleScanLabelGenerator;
import org.apache.hadoop.hbase.security.visibility.VisibilityClient;
import org.apache.hadoop.hbase.security.visibility.VisibilityConstants;
import org.apache.hadoop.hbase.security.visibility.VisibilityController;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;

@Category(value={MediumTests.class})
public class TestVisibilityLabelsWithSLGStack {
    public static final String CONFIDENTIAL = "confidential";
    private static final String SECRET = "secret";
    public static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final byte[] ROW_1 = Bytes.toBytes((String)"row1");
    private static final byte[] CF = Bytes.toBytes((String)"f");
    private static final byte[] Q1 = Bytes.toBytes((String)"q1");
    private static final byte[] Q2 = Bytes.toBytes((String)"q2");
    private static final byte[] value = Bytes.toBytes((String)"value");
    public static Configuration conf;
    @Rule
    public final TestName TEST_NAME = new TestName();
    public static User SUPERUSER;

    @BeforeClass
    public static void setupBeforeClass() throws Exception {
        conf = TEST_UTIL.getConfiguration();
        conf.setInt("hfile.format.version", 3);
        conf.set("hbase.coprocessor.master.classes", VisibilityController.class.getName());
        conf.set("hbase.coprocessor.region.classes", VisibilityController.class.getName());
        String classes = SimpleScanLabelGenerator.class.getCanonicalName() + " , " + LabelFilteringScanLabelGenerator.class.getCanonicalName();
        conf.setStrings("hbase.regionserver.scan.visibility.label.generator.class", new String[]{classes});
        conf.set("hbase.superuser", "admin");
        TEST_UTIL.startMiniCluster(1);
        SUPERUSER = User.createUserForTesting((Configuration)conf, (String)"admin", (String[])new String[]{"supergroup"});
        TEST_UTIL.waitTableEnabled(VisibilityConstants.LABELS_TABLE_NAME.getName(), 50000L);
        TestVisibilityLabelsWithSLGStack.addLabels();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWithSAGStack() throws Exception {
        TableName tableName = TableName.valueOf((String)this.TEST_NAME.getMethodName());
        HTable table = null;
        try {
            table = TEST_UTIL.createTable(tableName, CF);
            Put put = new Put(ROW_1);
            put.add(CF, Q1, Long.MAX_VALUE, value);
            put.setCellVisibility(new CellVisibility(SECRET));
            table.put(put);
            put = new Put(ROW_1);
            put.add(CF, Q2, Long.MAX_VALUE, value);
            put.setCellVisibility(new CellVisibility(CONFIDENTIAL));
            table.put(put);
            LabelFilteringScanLabelGenerator.labelToFilter = CONFIDENTIAL;
            Scan s = new Scan();
            s.setAuthorizations(new Authorizations(new String[]{SECRET, CONFIDENTIAL}));
            ResultScanner scanner = table.getScanner(s);
            Result next = scanner.next();
            Assert.assertNotNull((Object)next.getColumnLatestCell(CF, Q1));
            Assert.assertNull((Object)next.getColumnLatestCell(CF, Q2));
        }
        finally {
            if (table != null) {
                table.close();
            }
        }
    }

    private static void addLabels() throws Exception {
        PrivilegedExceptionAction<VisibilityLabelsProtos.VisibilityLabelsResponse> action = new PrivilegedExceptionAction<VisibilityLabelsProtos.VisibilityLabelsResponse>(){

            @Override
            public VisibilityLabelsProtos.VisibilityLabelsResponse run() throws Exception {
                String[] labels = new String[]{TestVisibilityLabelsWithSLGStack.SECRET, TestVisibilityLabelsWithSLGStack.CONFIDENTIAL};
                try {
                    VisibilityClient.addLabels((Configuration)conf, (String[])labels);
                }
                catch (Throwable t) {
                    throw new IOException(t);
                }
                return null;
            }
        };
        SUPERUSER.runAs((PrivilegedExceptionAction)action);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }
}

