/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.balancer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Random;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.master.RegionPlan;
import org.apache.hadoop.hbase.master.balancer.BaseLoadBalancer;
import org.apache.hadoop.hbase.master.balancer.ServerAndLoad;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;

public class BalancerTestBase {
    protected static Random rand = new Random();
    static int regionId = 0;
    private Queue<HRegionInfo> regionQueue = new LinkedList<HRegionInfo>();
    private Queue<ServerName> serverQueue = new LinkedList<ServerName>();

    public void assertClusterAsBalanced(List<ServerAndLoad> servers) {
        int numServers = servers.size();
        int numRegions = 0;
        int maxRegions = 0;
        int minRegions = Integer.MAX_VALUE;
        for (ServerAndLoad server : servers) {
            int nr = server.getLoad();
            if (nr > maxRegions) {
                maxRegions = nr;
            }
            if (nr < minRegions) {
                minRegions = nr;
            }
            numRegions += nr;
        }
        if (maxRegions - minRegions < 2) {
            return;
        }
        int min = numRegions / numServers;
        int max = numRegions % numServers == 0 ? min : min + 1;
        for (ServerAndLoad server : servers) {
            Assert.assertTrue((server.getLoad() >= 0 ? 1 : 0) != 0);
            Assert.assertTrue((server.getLoad() <= max ? 1 : 0) != 0);
            Assert.assertTrue((server.getLoad() >= min ? 1 : 0) != 0);
        }
    }

    protected String printStats(List<ServerAndLoad> servers) {
        int numServers = servers.size();
        int totalRegions = 0;
        for (ServerAndLoad server : servers) {
            totalRegions += server.getLoad();
        }
        float average = (float)totalRegions / (float)numServers;
        int max = (int)Math.ceil(average);
        int min = (int)Math.floor(average);
        return "[srvr=" + numServers + " rgns=" + totalRegions + " avg=" + average + " max=" + max + " min=" + min + "]";
    }

    protected List<ServerAndLoad> convertToList(Map<ServerName, List<HRegionInfo>> servers) {
        ArrayList<ServerAndLoad> list = new ArrayList<ServerAndLoad>(servers.size());
        for (Map.Entry<ServerName, List<HRegionInfo>> e : servers.entrySet()) {
            list.add(new ServerAndLoad(e.getKey(), e.getValue().size()));
        }
        return list;
    }

    protected String printMock(List<ServerAndLoad> balancedCluster) {
        TreeSet<ServerAndLoad> sorted = new TreeSet<ServerAndLoad>(balancedCluster);
        ServerAndLoad[] arr = sorted.toArray(new ServerAndLoad[sorted.size()]);
        StringBuilder sb = new StringBuilder(sorted.size() * 4 + 4);
        sb.append("{ ");
        for (int i = 0; i < arr.length; ++i) {
            if (i != 0) {
                sb.append(" , ");
            }
            sb.append(arr[i].getServerName().getHostname());
            sb.append(":");
            sb.append(arr[i].getLoad());
        }
        sb.append(" }");
        return sb.toString();
    }

    protected List<ServerAndLoad> reconcile(List<ServerAndLoad> list, List<RegionPlan> plans, Map<ServerName, List<HRegionInfo>> servers) {
        ArrayList<ServerAndLoad> result = new ArrayList<ServerAndLoad>(list.size());
        if (plans == null) {
            return result;
        }
        HashMap<ServerName, ServerAndLoad> map = new HashMap<ServerName, ServerAndLoad>(list.size());
        for (ServerAndLoad sl : list) {
            map.put(sl.getServerName(), sl);
        }
        for (RegionPlan plan : plans) {
            ServerName source = plan.getSource();
            this.updateLoad(map, source, -1);
            ServerName destination = plan.getDestination();
            this.updateLoad(map, destination, 1);
            servers.get(source).remove(plan.getRegionInfo());
            servers.get(destination).add(plan.getRegionInfo());
        }
        result.clear();
        result.addAll(map.values());
        return result;
    }

    protected void updateLoad(Map<ServerName, ServerAndLoad> map, ServerName sn, int diff) {
        ServerAndLoad sal = map.get(sn);
        if (sal == null) {
            sal = new ServerAndLoad(sn, 0);
        }
        sal = new ServerAndLoad(sn, sal.getLoad() + diff);
        map.put(sn, sal);
    }

    protected Map<ServerName, List<HRegionInfo>> mockClusterServers(int[] mockCluster) {
        return this.mockClusterServers(mockCluster, -1);
    }

    protected BaseLoadBalancer.Cluster mockCluster(int[] mockCluster) {
        return new BaseLoadBalancer.Cluster(this.mockClusterServers(mockCluster, -1), null, null);
    }

    protected Map<ServerName, List<HRegionInfo>> mockClusterServers(int[] mockCluster, int numTables) {
        int numServers = mockCluster.length;
        TreeMap<ServerName, List<HRegionInfo>> servers = new TreeMap<ServerName, List<HRegionInfo>>();
        for (int i = 0; i < numServers; ++i) {
            int numRegions = mockCluster[i];
            ServerAndLoad sal = this.randomServer(0);
            List<HRegionInfo> regions = this.randomRegions(numRegions, numTables);
            servers.put(sal.getServerName(), regions);
        }
        return servers;
    }

    protected List<HRegionInfo> randomRegions(int numRegions) {
        return this.randomRegions(numRegions, -1);
    }

    protected List<HRegionInfo> randomRegions(int numRegions, int numTables) {
        ArrayList<HRegionInfo> regions = new ArrayList<HRegionInfo>(numRegions);
        byte[] start = new byte[16];
        byte[] end = new byte[16];
        rand.nextBytes(start);
        rand.nextBytes(end);
        for (int i = 0; i < numRegions; ++i) {
            if (!this.regionQueue.isEmpty()) {
                regions.add(this.regionQueue.poll());
                continue;
            }
            Bytes.putInt((byte[])start, (int)0, (int)(numRegions << 1));
            Bytes.putInt((byte[])end, (int)0, (int)((numRegions << 1) + 1));
            TableName tableName = TableName.valueOf((String)("table" + (numTables > 0 ? rand.nextInt(numTables) : i)));
            HRegionInfo hri = new HRegionInfo(tableName, start, end, false, (long)regionId++);
            regions.add(hri);
        }
        return regions;
    }

    protected void returnRegions(List<HRegionInfo> regions) {
        this.regionQueue.addAll(regions);
    }

    protected ServerAndLoad randomServer(int numRegionsPerServer) {
        if (!this.serverQueue.isEmpty()) {
            ServerName sn = this.serverQueue.poll();
            return new ServerAndLoad(sn, numRegionsPerServer);
        }
        String host = "srv" + rand.nextInt(100000);
        int port = rand.nextInt(60000);
        long startCode = rand.nextLong();
        ServerName sn = ServerName.valueOf((String)host, (int)port, (long)startCode);
        return new ServerAndLoad(sn, numRegionsPerServer);
    }

    protected List<ServerAndLoad> randomServers(int numServers, int numRegionsPerServer) {
        ArrayList<ServerAndLoad> servers = new ArrayList<ServerAndLoad>(numServers);
        for (int i = 0; i < numServers; ++i) {
            servers.add(this.randomServer(numRegionsPerServer));
        }
        return servers;
    }

    protected void returnServer(ServerName server) {
        this.serverQueue.add(server);
    }

    protected void returnServers(List<ServerName> servers) {
        this.serverQueue.addAll(servers);
    }
}

