/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security.access;

import com.google.protobuf.BlockingRpcChannel;
import java.io.IOException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.LargeTests;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.ipc.CoprocessorRpcChannel;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.AccessControlProtos;
import org.apache.hadoop.hbase.security.AccessDeniedException;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.security.access.AccessControlLists;
import org.apache.hadoop.hbase.security.access.Permission;
import org.apache.hadoop.hbase.security.access.SecureTestUtil;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;

@Category(value={LargeTests.class})
public class TestAccessControlFilter {
    @Rule
    public TestName name = new TestName();
    private static Log LOG = LogFactory.getLog(TestAccessControlFilter.class);
    private static HBaseTestingUtility TEST_UTIL;
    private static User ADMIN;
    private static User READER;
    private static User LIMITED;
    private static User DENIED;
    private static TableName TABLE;
    private static byte[] FAMILY;
    private static byte[] PRIVATE_COL;
    private static byte[] PUBLIC_COL;

    @Before
    public void setup() {
        TABLE = TableName.valueOf((String)this.name.getMethodName());
    }

    @BeforeClass
    public static void setupBeforeClass() throws Exception {
        TEST_UTIL = new HBaseTestingUtility();
        Configuration conf = TEST_UTIL.getConfiguration();
        SecureTestUtil.enableSecurity(conf);
        String baseuser = User.getCurrent().getShortName();
        conf.set("hbase.superuser", conf.get("hbase.superuser", "") + String.format(",%s.hfs.0,%s.hfs.1,%s.hfs.2", baseuser, baseuser, baseuser));
        TEST_UTIL.startMiniCluster();
        TEST_UTIL.waitTableEnabled(AccessControlLists.ACL_TABLE_NAME.getName());
        ADMIN = User.createUserForTesting((Configuration)conf, (String)"admin", (String[])new String[]{"supergroup"});
        READER = User.createUserForTesting((Configuration)conf, (String)"reader", (String[])new String[0]);
        LIMITED = User.createUserForTesting((Configuration)conf, (String)"limited", (String[])new String[0]);
        DENIED = User.createUserForTesting((Configuration)conf, (String)"denied", (String[])new String[0]);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testQualifierAccess() throws Exception {
        HTable table = TEST_UTIL.createTable(TABLE, FAMILY);
        try {
            this.doQualifierAccess(table);
        }
        finally {
            table.close();
        }
    }

    private void doQualifierAccess(HTable table) throws IOException, InterruptedException {
        ADMIN.runAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

            @Override
            public Object run() throws Exception {
                HTable aclmeta = new HTable(TEST_UTIL.getConfiguration(), AccessControlLists.ACL_TABLE_NAME);
                byte[] table = Bytes.toBytes((String)TestAccessControlFilter.this.name.getMethodName());
                CoprocessorRpcChannel service = aclmeta.coprocessorService(table);
                AccessControlProtos.AccessControlService.BlockingInterface protocol = AccessControlProtos.AccessControlService.newBlockingStub((BlockingRpcChannel)service);
                ProtobufUtil.grant((AccessControlProtos.AccessControlService.BlockingInterface)protocol, (String)READER.getShortName(), (TableName)TABLE, null, null, (Permission.Action[])new Permission.Action[]{Permission.Action.READ});
                ProtobufUtil.grant((AccessControlProtos.AccessControlService.BlockingInterface)protocol, (String)LIMITED.getShortName(), (TableName)TABLE, (byte[])FAMILY, (byte[])PUBLIC_COL, (Permission.Action[])new Permission.Action[]{Permission.Action.READ});
                return null;
            }
        });
        ArrayList<Put> puts = new ArrayList<Put>(100);
        for (int i = 0; i < 100; ++i) {
            Put p = new Put(Bytes.toBytes((int)i));
            p.add(FAMILY, PRIVATE_COL, Bytes.toBytes((String)("secret " + i)));
            p.add(FAMILY, PUBLIC_COL, Bytes.toBytes((String)("info " + i)));
            puts.add(p);
        }
        table.put(puts);
        READER.runAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

            @Override
            public Object run() throws Exception {
                Configuration conf = new Configuration(TEST_UTIL.getConfiguration());
                conf.set("testkey", UUID.randomUUID().toString());
                HTable t = new HTable(conf, TABLE);
                ResultScanner rs = t.getScanner(new Scan());
                int rowcnt = 0;
                for (Result r : rs) {
                    ++rowcnt;
                    int rownum = Bytes.toInt((byte[])r.getRow());
                    Assert.assertTrue((boolean)r.containsColumn(FAMILY, PRIVATE_COL));
                    Assert.assertEquals((Object)("secret " + rownum), (Object)Bytes.toString((byte[])r.getValue(FAMILY, PRIVATE_COL)));
                    Assert.assertTrue((boolean)r.containsColumn(FAMILY, PUBLIC_COL));
                    Assert.assertEquals((Object)("info " + rownum), (Object)Bytes.toString((byte[])r.getValue(FAMILY, PUBLIC_COL)));
                }
                Assert.assertEquals((String)"Expected 100 rows returned", (long)100L, (long)rowcnt);
                return null;
            }
        });
        LIMITED.runAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

            @Override
            public Object run() throws Exception {
                Configuration conf = new Configuration(TEST_UTIL.getConfiguration());
                conf.set("testkey", UUID.randomUUID().toString());
                HTable t = new HTable(conf, TABLE);
                ResultScanner rs = t.getScanner(new Scan());
                int rowcnt = 0;
                for (Result r : rs) {
                    ++rowcnt;
                    int rownum = Bytes.toInt((byte[])r.getRow());
                    Assert.assertFalse((boolean)r.containsColumn(FAMILY, PRIVATE_COL));
                    Assert.assertTrue((boolean)r.containsColumn(FAMILY, PUBLIC_COL));
                    Assert.assertEquals((Object)("info " + rownum), (Object)Bytes.toString((byte[])r.getValue(FAMILY, PUBLIC_COL)));
                }
                Assert.assertEquals((String)"Expected 100 rows returned", (long)100L, (long)rowcnt);
                return null;
            }
        });
        DENIED.runAs(new PrivilegedExceptionAction(){

            public Object run() throws Exception {
                try {
                    Configuration conf = new Configuration(TEST_UTIL.getConfiguration());
                    conf.set("testkey", UUID.randomUUID().toString());
                    HTable t = new HTable(conf, TABLE);
                    ResultScanner rs = t.getScanner(new Scan());
                    Assert.fail((String)"Attempt to open scanner should have been denied");
                }
                catch (AccessDeniedException accessDeniedException) {
                    // empty catch block
                }
                return null;
            }
        });
    }

    static {
        FAMILY = Bytes.toBytes((String)"f1");
        PRIVATE_COL = Bytes.toBytes((String)"private");
        PUBLIC_COL = Bytes.toBytes((String)"public");
    }
}

