/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import com.google.protobuf.ServiceException;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.HBaseIOException;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.LargeTests;
import org.apache.hadoop.hbase.MasterNotRunningException;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.RegionTransition;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.ZooKeeperConnectionException;
import org.apache.hadoop.hbase.catalog.CatalogTracker;
import org.apache.hadoop.hbase.catalog.MetaReader;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.executor.EventType;
import org.apache.hadoop.hbase.master.AssignmentManager;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.RegionState;
import org.apache.hadoop.hbase.master.RegionStates;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.AdminProtos;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.RegionServerServices;
import org.apache.hadoop.hbase.regionserver.SplitTransaction;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.JVMClusterUtil;
import org.apache.hadoop.hbase.util.PairOfSameType;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hadoop.hbase.zookeeper.ZKAssign;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.data.Stat;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={LargeTests.class})
public class TestSplitTransactionOnCluster {
    private static final Log LOG = LogFactory.getLog(TestSplitTransactionOnCluster.class);
    private HBaseAdmin admin = null;
    private MiniHBaseCluster cluster = null;
    private static final int NB_SERVERS = 3;
    private static CountDownLatch latch = new CountDownLatch(1);
    private static volatile boolean secondSplit = false;
    private static volatile boolean callRollBack = false;
    private static volatile boolean firstSplitCompleted = false;
    private static byte[] CF = Bytes.toBytes((String)"cf");
    private static final HBaseTestingUtility TESTING_UTIL = new HBaseTestingUtility();

    @BeforeClass
    public static void before() throws Exception {
        TESTING_UTIL.getConfiguration().setInt("hbase.balancer.period", 60000);
        TESTING_UTIL.getConfiguration().setInt("hbase.master.assignment.timeoutmonitor.timeout", 4000);
        TESTING_UTIL.startMiniCluster(3);
    }

    @AfterClass
    public static void after() throws Exception {
        TESTING_UTIL.shutdownMiniCluster();
    }

    @Before
    public void setup() throws IOException {
        TESTING_UTIL.ensureSomeNonStoppedRegionServersAvailable(3);
        this.admin = new HBaseAdmin(TESTING_UTIL.getConfiguration());
        this.cluster = TESTING_UTIL.getMiniHBaseCluster();
    }

    @After
    public void tearDown() throws Exception {
        this.admin.close();
    }

    private HRegionInfo getAndCheckSingleTableRegion(List<HRegion> regions) {
        Assert.assertEquals((long)1L, (long)regions.size());
        HRegionInfo hri = regions.get(0).getRegionInfo();
        return this.waitOnRIT(hri);
    }

    private HRegionInfo waitOnRIT(HRegionInfo hri) {
        while (TESTING_UTIL.getHBaseCluster().getMaster().getAssignmentManager().getRegionStates().isRegionInTransition(hri)) {
            LOG.info((Object)("Waiting on region in transition: " + TESTING_UTIL.getHBaseCluster().getMaster().getAssignmentManager().getRegionStates().getRegionTransitionState(hri)));
            Threads.sleep((long)10L);
        }
        return hri;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testShouldFailSplitIfZNodeDoesNotExistDueToPrevRollBack() throws Exception {
        TableName tableName = TableName.valueOf((String)"testShouldFailSplitIfZNodeDoesNotExistDueToPrevRollBack");
        try {
            HTable t = this.createTableAndWait(tableName.getName(), CF);
            List<HRegion> regions = this.cluster.getRegions(tableName);
            HRegionInfo hri = this.getAndCheckSingleTableRegion(regions);
            int regionServerIndex = this.cluster.getServerWith(regions.get(0).getRegionName());
            final HRegionServer regionServer = this.cluster.getRegionServer(regionServerIndex);
            this.insertData(tableName.getName(), this.admin, t);
            t.close();
            this.admin.setBalancerRunning(false, true);
            this.cluster.getMaster().setCatalogJanitorEnabled(false);
            final HRegion region = this.findSplittableRegion(regions);
            Assert.assertTrue((String)"not able to find a splittable region", (region != null ? 1 : 0) != 0);
            new Thread(){

                @Override
                public void run() {
                    MockedSplitTransaction st = null;
                    st = new MockedSplitTransaction(region, Bytes.toBytes((String)"row2"));
                    try {
                        st.prepare();
                        st.execute((Server)regionServer, (RegionServerServices)regionServer);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }.start();
            for (int i = 0; !callRollBack && i < 100; ++i) {
                Thread.sleep(100L);
            }
            Assert.assertTrue((String)"Waited too long for rollback", (boolean)callRollBack);
            MockedSplitTransaction st = new MockedSplitTransaction(region, Bytes.toBytes((String)"row3"));
            try {
                secondSplit = true;
                region.initialize();
                st.prepare();
                st.execute((Server)regionServer, (RegionServerServices)regionServer);
            }
            catch (IOException e) {
                LOG.debug((Object)("Rollback started :" + e.getMessage()));
                st.rollback((Server)regionServer, (RegionServerServices)regionServer);
            }
            for (int i = 0; !firstSplitCompleted && i < 100; ++i) {
                Thread.sleep(100L);
            }
            Assert.assertTrue((String)"fist split did not complete", (boolean)firstSplitCompleted);
            RegionStates regionStates = this.cluster.getMaster().getAssignmentManager().getRegionStates();
            Map rit = regionStates.getRegionsInTransition();
            for (int i = 0; rit.containsKey(hri.getTable()) && i < 100; ++i) {
                Thread.sleep(100L);
            }
            Assert.assertFalse((String)"region still in transition", (boolean)rit.containsKey(rit.containsKey(hri.getTable())));
            List onlineRegions = regionServer.getOnlineRegions(tableName);
            Assert.assertEquals((String)"The parent region should be splitted", (long)2L, (long)onlineRegions.size());
            List regionsOfTable = this.cluster.getMaster().getAssignmentManager().getRegionStates().getRegionsOfTable(tableName);
            Assert.assertEquals((String)"No of regions in master", (long)2L, (long)regionsOfTable.size());
        }
        finally {
            this.admin.setBalancerRunning(true, false);
            secondSplit = false;
            firstSplitCompleted = false;
            callRollBack = false;
            this.cluster.getMaster().setCatalogJanitorEnabled(true);
            TESTING_UTIL.deleteTable(tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=300000L)
    public void testRSSplitEphemeralsDisappearButDaughtersAreOnlinedAfterShutdownHandling() throws IOException, InterruptedException, KeeperException.NodeExistsException, KeeperException, DeserializationException, ServiceException {
        byte[] tableName = Bytes.toBytes((String)"testRSSplitEphemeralsDisappearButDaughtersAreOnlinedAfterShutdownHandling");
        HTable t = this.createTableAndWait(tableName, HConstants.CATALOG_FAMILY);
        List<HRegion> regions = this.cluster.getRegions(tableName);
        HRegionInfo hri = this.getAndCheckSingleTableRegion(regions);
        int tableRegionIndex = this.ensureTableRegionNotOnSameServerAsMeta(this.admin, hri);
        this.admin.setBalancerRunning(false, true);
        this.cluster.getMaster().setCatalogJanitorEnabled(false);
        try {
            TESTING_UTIL.loadTable(t, HConstants.CATALOG_FAMILY);
            HRegionServer server = this.cluster.getRegionServer(tableRegionIndex);
            this.printOutRegions(server, "Initial regions: ");
            int regionCount = ProtobufUtil.getOnlineRegions((AdminProtos.AdminService.BlockingInterface)server).size();
            AssignmentManager.TEST_SKIP_SPLIT_HANDLING = true;
            this.split(hri, server, regionCount);
            List<HRegion> daughters = this.checkAndGetDaughters(tableName);
            String path = ZKAssign.getNodeName((ZooKeeperWatcher)TESTING_UTIL.getZooKeeperWatcher(), (String)hri.getEncodedName());
            RegionTransition rt = null;
            Stat stats = null;
            for (int i = 0; i < 100; ++i) {
                stats = TESTING_UTIL.getZooKeeperWatcher().getRecoverableZooKeeper().exists(path, false);
                rt = RegionTransition.parseFrom((byte[])ZKAssign.getData((ZooKeeperWatcher)TESTING_UTIL.getZooKeeperWatcher(), (String)hri.getEncodedName()));
                if (rt.getEventType().equals((Object)EventType.RS_ZK_REGION_SPLIT)) break;
                Thread.sleep(100L);
            }
            LOG.info((Object)("EPHEMERAL NODE BEFORE SERVER ABORT, path=" + path + ", stats=" + stats));
            Assert.assertTrue((rt != null && rt.getEventType().equals((Object)EventType.RS_ZK_REGION_SPLIT) ? 1 : 0) != 0);
            this.cluster.abortRegionServer(tableRegionIndex);
            this.waitUntilRegionServerDead();
            this.awaitDaughters(tableName, daughters.size());
            regions = this.cluster.getRegions(tableName);
            for (HRegion r : regions) {
                Assert.assertTrue((boolean)daughters.contains(r));
            }
            for (int i = 0; i < 100 && (stats = TESTING_UTIL.getZooKeeperWatcher().getRecoverableZooKeeper().exists(path, false)) != null; ++i) {
                Thread.sleep(100L);
            }
            LOG.info((Object)("EPHEMERAL NODE AFTER SERVER ABORT, path=" + path + ", stats=" + stats));
            Assert.assertTrue((stats == null ? 1 : 0) != 0);
        }
        finally {
            AssignmentManager.TEST_SKIP_SPLIT_HANDLING = false;
            this.admin.setBalancerRunning(true, false);
            this.cluster.getMaster().setCatalogJanitorEnabled(true);
            t.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=300000L)
    public void testExistingZnodeBlocksSplitAndWeRollback() throws IOException, InterruptedException, KeeperException.NodeExistsException, KeeperException, ServiceException {
        byte[] tableName = Bytes.toBytes((String)"testExistingZnodeBlocksSplitAndWeRollback");
        HTable t = this.createTableAndWait(tableName, HConstants.CATALOG_FAMILY);
        List<HRegion> regions = this.cluster.getRegions(tableName);
        HRegionInfo hri = this.getAndCheckSingleTableRegion(regions);
        int tableRegionIndex = this.ensureTableRegionNotOnSameServerAsMeta(this.admin, hri);
        this.admin.setBalancerRunning(false, true);
        this.cluster.getMaster().setCatalogJanitorEnabled(false);
        try {
            TESTING_UTIL.loadTable(t, HConstants.CATALOG_FAMILY);
            HRegionServer server = this.cluster.getRegionServer(tableRegionIndex);
            this.printOutRegions(server, "Initial regions: ");
            int regionCount = ProtobufUtil.getOnlineRegions((AdminProtos.AdminService.BlockingInterface)server).size();
            ZKAssign.createNodeClosing((ZooKeeperWatcher)TESTING_UTIL.getZooKeeperWatcher(), (HRegionInfo)hri, (ServerName)new ServerName("any.old.server", 1234, -1L));
            this.admin.split(hri.getRegionNameAsString());
            this.admin.split(hri.getRegionNameAsString());
            this.admin.split(hri.getRegionNameAsString());
            for (int i = 0; i < 10; ++i) {
                Thread.sleep(100L);
                Assert.assertEquals((long)regionCount, (long)ProtobufUtil.getOnlineRegions((AdminProtos.AdminService.BlockingInterface)server).size());
            }
            ZKAssign.deleteClosingNode((ZooKeeperWatcher)TESTING_UTIL.getZooKeeperWatcher(), (HRegionInfo)hri);
            this.split(hri, server, regionCount);
            this.checkAndGetDaughters(tableName);
        }
        finally {
            this.admin.setBalancerRunning(true, false);
            this.cluster.getMaster().setCatalogJanitorEnabled(true);
            t.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=300000L)
    public void testShutdownFixupWhenDaughterHasSplit() throws IOException, InterruptedException, ServiceException {
        byte[] tableName = Bytes.toBytes((String)"testShutdownFixupWhenDaughterHasSplit");
        HTable t = this.createTableAndWait(tableName, HConstants.CATALOG_FAMILY);
        List<HRegion> regions = this.cluster.getRegions(tableName);
        HRegionInfo hri = this.getAndCheckSingleTableRegion(regions);
        int tableRegionIndex = this.ensureTableRegionNotOnSameServerAsMeta(this.admin, hri);
        this.admin.setBalancerRunning(false, true);
        this.cluster.getMaster().setCatalogJanitorEnabled(false);
        try {
            TESTING_UTIL.loadTable(t, HConstants.CATALOG_FAMILY);
            HRegionServer server = this.cluster.getRegionServer(tableRegionIndex);
            this.printOutRegions(server, "Initial regions: ");
            int regionCount = ProtobufUtil.getOnlineRegions((AdminProtos.AdminService.BlockingInterface)server).size();
            this.split(hri, server, regionCount);
            List<HRegion> daughters = this.checkAndGetDaughters(tableName);
            regionCount = ProtobufUtil.getOnlineRegions((AdminProtos.AdminService.BlockingInterface)server).size();
            HRegionInfo daughter = daughters.get(0).getRegionInfo();
            LOG.info((Object)("Daughter we are going to split: " + daughter));
            this.admin.compact(daughter.getRegionName());
            daughters = this.cluster.getRegions(tableName);
            HRegion daughterRegion = null;
            for (HRegion r : daughters) {
                if (!r.getRegionInfo().equals((Object)daughter)) continue;
                daughterRegion = r;
                LOG.info((Object)("Found matching HRI: " + daughterRegion));
                break;
            }
            Assert.assertTrue((daughterRegion != null ? 1 : 0) != 0);
            for (int i = 0; i < 100 && daughterRegion.hasReferences(); ++i) {
                Threads.sleep((long)100L);
            }
            Assert.assertFalse((String)"Waiting for reference to be compacted", (boolean)daughterRegion.hasReferences());
            LOG.info((Object)("Daughter hri before split (has been compacted): " + daughter));
            this.split(daughter, server, regionCount);
            daughters = this.cluster.getRegions(tableName);
            for (HRegion d : daughters) {
                LOG.info((Object)("Regions before crash: " + d));
            }
            this.cluster.abortRegionServer(tableRegionIndex);
            this.waitUntilRegionServerDead();
            this.awaitDaughters(tableName, daughters.size());
            regions = this.cluster.getRegions(tableName);
            for (HRegion d : daughters) {
                LOG.info((Object)("Regions after crash: " + d));
            }
            Assert.assertEquals((long)daughters.size(), (long)regions.size());
            for (HRegion r : regions) {
                LOG.info((Object)("Regions post crash " + r));
                Assert.assertTrue((String)("Missing region post crash " + r), (boolean)daughters.contains(r));
            }
        }
        finally {
            this.admin.setBalancerRunning(true, false);
            this.cluster.getMaster().setCatalogJanitorEnabled(true);
            t.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=180000L)
    public void testSplitShouldNotThrowNPEEvenARegionHasEmptySplitFiles() throws Exception {
        Configuration conf = TESTING_UTIL.getConfiguration();
        ZooKeeperWatcher zkw = HBaseTestingUtility.getZooKeeperWatcher(TESTING_UTIL);
        TableName userTableName = TableName.valueOf((String)"testSplitShouldNotThrowNPEEvenARegionHasEmptySplitFiles");
        HTableDescriptor htd = new HTableDescriptor(userTableName);
        HColumnDescriptor hcd = new HColumnDescriptor("col");
        htd.addFamily(hcd);
        this.admin.createTable(htd);
        ZKAssign.blockUntilNoRIT((ZooKeeperWatcher)zkw);
        HTable table = new HTable(conf, userTableName);
        try {
            Put p;
            for (int i = 0; i <= 5; ++i) {
                String row = "row" + i;
                p = new Put(row.getBytes());
                String val = "Val" + i;
                p.add("col".getBytes(), "ql".getBytes(), val.getBytes());
                table.put(p);
                this.admin.flush(userTableName.getName());
                Delete d = new Delete(row.getBytes());
                table.delete(d);
                this.admin.flush(userTableName.getName());
            }
            this.admin.majorCompact(userTableName.getName());
            List regionsOfTable = TESTING_UTIL.getMiniHBaseCluster().getMaster().getAssignmentManager().getRegionStates().getRegionsOfTable(userTableName);
            HRegionInfo hRegionInfo = (HRegionInfo)regionsOfTable.get(0);
            p = new Put("row6".getBytes());
            p.add("col".getBytes(), "ql".getBytes(), "val".getBytes());
            table.put(p);
            p = new Put("row7".getBytes());
            p.add("col".getBytes(), "ql".getBytes(), "val".getBytes());
            table.put(p);
            p = new Put("row8".getBytes());
            p.add("col".getBytes(), "ql".getBytes(), "val".getBytes());
            table.put(p);
            this.admin.flush(userTableName.getName());
            this.admin.split(hRegionInfo.getRegionName(), "row7".getBytes());
            regionsOfTable = TESTING_UTIL.getMiniHBaseCluster().getMaster().getAssignmentManager().getRegionStates().getRegionsOfTable(userTableName);
            while (regionsOfTable.size() != 2) {
                Thread.sleep(2000L);
                regionsOfTable = TESTING_UTIL.getMiniHBaseCluster().getMaster().getAssignmentManager().getRegionStates().getRegionsOfTable(userTableName);
            }
            Assert.assertEquals((long)2L, (long)regionsOfTable.size());
            Scan s = new Scan();
            ResultScanner scanner = table.getScanner(s);
            int mainTableCount = 0;
            Result rr = scanner.next();
            while (rr != null) {
                ++mainTableCount;
                rr = scanner.next();
            }
            Assert.assertEquals((long)3L, (long)mainTableCount);
        }
        finally {
            table.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=400000L)
    public void testMasterRestartWhenSplittingIsPartial() throws IOException, InterruptedException, KeeperException.NodeExistsException, KeeperException, DeserializationException, ServiceException {
        byte[] tableName = Bytes.toBytes((String)"testMasterRestartWhenSplittingIsPartial");
        HTable t = this.createTableAndWait(tableName, HConstants.CATALOG_FAMILY);
        List<HRegion> regions = this.cluster.getRegions(tableName);
        HRegionInfo hri = this.getAndCheckSingleTableRegion(regions);
        int tableRegionIndex = this.ensureTableRegionNotOnSameServerAsMeta(this.admin, hri);
        this.admin.setBalancerRunning(false, true);
        this.cluster.getMaster().setCatalogJanitorEnabled(false);
        ZooKeeperWatcher zkw = new ZooKeeperWatcher(t.getConfiguration(), "testMasterRestartWhenSplittingIsPartial", (Abortable)new UselessTestAbortable());
        try {
            TESTING_UTIL.loadTable(t, HConstants.CATALOG_FAMILY);
            HRegionServer server = this.cluster.getRegionServer(tableRegionIndex);
            this.printOutRegions(server, "Initial regions: ");
            AssignmentManager.TEST_SKIP_SPLIT_HANDLING = true;
            this.admin.split(hri.getRegionNameAsString());
            this.checkAndGetDaughters(tableName);
            String path = ZKAssign.getNodeName((ZooKeeperWatcher)zkw, (String)hri.getEncodedName());
            Stat stats = zkw.getRecoverableZooKeeper().exists(path, false);
            LOG.info((Object)("EPHEMERAL NODE BEFORE SERVER ABORT, path=" + path + ", stats=" + stats));
            byte[] bytes = ZKAssign.getData((ZooKeeperWatcher)zkw, (String)hri.getEncodedName());
            RegionTransition rtd = RegionTransition.parseFrom((byte[])bytes);
            Assert.assertTrue((rtd.getEventType().equals((Object)EventType.RS_ZK_REGION_SPLIT) || rtd.getEventType().equals((Object)EventType.RS_ZK_REGION_SPLITTING) ? 1 : 0) != 0);
            MockMasterWithoutCatalogJanitor master = this.abortAndWaitForMaster();
            this.admin = new HBaseAdmin(TESTING_UTIL.getConfiguration());
            hri.setOffline(true);
            hri.setSplit(true);
            ServerName regionServerOfRegion = master.getAssignmentManager().getRegionStates().getRegionServerOfRegion(hri);
            Assert.assertTrue((regionServerOfRegion != null ? 1 : 0) != 0);
            AssignmentManager.TEST_SKIP_SPLIT_HANDLING = false;
            String node = ZKAssign.getNodeName((ZooKeeperWatcher)zkw, (String)hri.getEncodedName());
            Stat stat = new Stat();
            byte[] data = ZKUtil.getDataNoWatch((ZooKeeperWatcher)zkw, (String)node, (Stat)stat);
            for (int i = 0; data != null && i < 60; ++i) {
                Thread.sleep(1000L);
                data = ZKUtil.getDataNoWatch((ZooKeeperWatcher)zkw, (String)node, (Stat)stat);
            }
            Assert.assertNull((String)("Waited too long for ZK node to be removed: " + node), (Object)data);
            RegionStates regionStates = master.getAssignmentManager().getRegionStates();
            Assert.assertTrue((String)"Split parent should be in SPLIT state", (boolean)regionStates.isRegionInState(hri, new RegionState.State[]{RegionState.State.SPLIT}));
            regionServerOfRegion = regionStates.getRegionServerOfRegion(hri);
            Assert.assertTrue((regionServerOfRegion == null ? 1 : 0) != 0);
        }
        finally {
            AssignmentManager.TEST_SKIP_SPLIT_HANDLING = false;
            this.admin.setBalancerRunning(true, false);
            this.cluster.getMaster().setCatalogJanitorEnabled(true);
            t.close();
            zkw.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=300000L)
    public void testMasterRestartAtRegionSplitPendingCatalogJanitor() throws IOException, InterruptedException, KeeperException.NodeExistsException, KeeperException, ServiceException {
        byte[] tableName = Bytes.toBytes((String)"testMasterRestartAtRegionSplitPendingCatalogJanitor");
        HTable t = this.createTableAndWait(tableName, HConstants.CATALOG_FAMILY);
        List<HRegion> regions = this.cluster.getRegions(tableName);
        HRegionInfo hri = this.getAndCheckSingleTableRegion(regions);
        int tableRegionIndex = this.ensureTableRegionNotOnSameServerAsMeta(this.admin, hri);
        this.admin.setBalancerRunning(false, true);
        this.cluster.getMaster().setCatalogJanitorEnabled(false);
        ZooKeeperWatcher zkw = new ZooKeeperWatcher(t.getConfiguration(), "testMasterRestartAtRegionSplitPendingCatalogJanitor", (Abortable)new UselessTestAbortable());
        try {
            TESTING_UTIL.loadTable(t, HConstants.CATALOG_FAMILY);
            HRegionServer server = this.cluster.getRegionServer(tableRegionIndex);
            this.printOutRegions(server, "Initial regions: ");
            this.admin.split(hri.getRegionNameAsString());
            this.checkAndGetDaughters(tableName);
            String path = ZKAssign.getNodeName((ZooKeeperWatcher)zkw, (String)hri.getEncodedName());
            Stat stats = zkw.getRecoverableZooKeeper().exists(path, false);
            LOG.info((Object)("EPHEMERAL NODE BEFORE SERVER ABORT, path=" + path + ", stats=" + stats));
            String node = ZKAssign.getNodeName((ZooKeeperWatcher)zkw, (String)hri.getEncodedName());
            Stat stat = new Stat();
            byte[] data = ZKUtil.getDataNoWatch((ZooKeeperWatcher)zkw, (String)node, (Stat)stat);
            for (int i = 0; data != null && i < 60; ++i) {
                Thread.sleep(1000L);
                data = ZKUtil.getDataNoWatch((ZooKeeperWatcher)zkw, (String)node, (Stat)stat);
            }
            Assert.assertNull((String)("Waited too long for ZK node to be removed: " + node), (Object)data);
            MockMasterWithoutCatalogJanitor master = this.abortAndWaitForMaster();
            this.admin = new HBaseAdmin(TESTING_UTIL.getConfiguration());
            hri.setOffline(true);
            hri.setSplit(true);
            RegionStates regionStates = master.getAssignmentManager().getRegionStates();
            Assert.assertTrue((String)"Split parent should be in SPLIT state", (boolean)regionStates.isRegionInState(hri, new RegionState.State[]{RegionState.State.SPLIT}));
            ServerName regionServerOfRegion = regionStates.getRegionServerOfRegion(hri);
            Assert.assertTrue((regionServerOfRegion == null ? 1 : 0) != 0);
        }
        finally {
            this.admin.setBalancerRunning(true, false);
            this.cluster.getMaster().setCatalogJanitorEnabled(true);
            t.close();
            zkw.close();
        }
    }

    @Test
    public void testSplitBeforeSettingSplittingInZK() throws Exception, InterruptedException, KeeperException {
        this.testSplitBeforeSettingSplittingInZKInternals();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testTableExistsIfTheSpecifiedTableRegionIsSplitParent() throws Exception {
        TableName tableName = TableName.valueOf((String)"testTableExistsIfTheSpecifiedTableRegionIsSplitParent");
        HTable t = this.createTableAndWait(tableName.getName(), CF);
        try {
            List<HRegion> regions = this.cluster.getRegions(tableName);
            int regionServerIndex = this.cluster.getServerWith(regions.get(0).getRegionName());
            HRegionServer regionServer = this.cluster.getRegionServer(regionServerIndex);
            this.insertData(tableName.getName(), this.admin, t);
            this.admin.setBalancerRunning(false, true);
            this.cluster.getMaster().setCatalogJanitorEnabled(false);
            boolean tableExists = MetaReader.tableExists((CatalogTracker)regionServer.getCatalogTracker(), (TableName)tableName);
            Assert.assertEquals((String)"The specified table should present.", (Object)true, (Object)tableExists);
            HRegion region = this.findSplittableRegion(regions);
            Assert.assertTrue((String)"not able to find a splittable region", (region != null ? 1 : 0) != 0);
            SplitTransaction st = new SplitTransaction(region, Bytes.toBytes((String)"row2"));
            try {
                st.prepare();
                st.createDaughters((Server)regionServer, (RegionServerServices)regionServer);
            }
            catch (IOException e) {
                // empty catch block
            }
            tableExists = MetaReader.tableExists((CatalogTracker)regionServer.getCatalogTracker(), (TableName)tableName);
            Assert.assertEquals((String)"The specified table should present.", (Object)true, (Object)tableExists);
        }
        finally {
            this.admin.setBalancerRunning(true, false);
            this.cluster.getMaster().setCatalogJanitorEnabled(true);
            t.close();
        }
    }

    private void insertData(byte[] tableName, HBaseAdmin admin, HTable t) throws IOException, InterruptedException {
        Put p = new Put(Bytes.toBytes((String)"row1"));
        p.add(CF, Bytes.toBytes((String)"q1"), Bytes.toBytes((String)"1"));
        t.put(p);
        p = new Put(Bytes.toBytes((String)"row2"));
        p.add(CF, Bytes.toBytes((String)"q1"), Bytes.toBytes((String)"2"));
        t.put(p);
        p = new Put(Bytes.toBytes((String)"row3"));
        p.add(CF, Bytes.toBytes((String)"q1"), Bytes.toBytes((String)"3"));
        t.put(p);
        p = new Put(Bytes.toBytes((String)"row4"));
        p.add(CF, Bytes.toBytes((String)"q1"), Bytes.toBytes((String)"4"));
        t.put(p);
        admin.flush(tableName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSplitRegionNotAssignable() throws Exception {
        TableName tableName = TableName.valueOf((String)"testSplitRegionWithNoStoreFiles");
        HTable t = this.createTableAndWait(tableName.getName(), CF);
        try {
            List<HRegion> regions = this.cluster.getRegions(tableName);
            int regionServerIndex = this.cluster.getServerWith(regions.get(0).getRegionName());
            HRegionServer regionServer = this.cluster.getRegionServer(regionServerIndex);
            this.insertData(tableName.getName(), this.admin, t);
            this.admin.setBalancerRunning(false, true);
            this.cluster.getMaster().setCatalogJanitorEnabled(false);
            HRegion region = this.findSplittableRegion(regions);
            Assert.assertTrue((String)"not able to find a splittable region", (region != null ? 1 : 0) != 0);
            MockedSplitTransaction st = new MockedSplitTransaction(region, Bytes.toBytes((String)"row2"));
            try {
                st.prepare();
                st.execute((Server)regionServer, (RegionServerServices)regionServer);
            }
            catch (IOException e) {
                Assert.fail((String)"Split execution should have succeeded with no exceptions thrown");
            }
            List<HRegion> daughters = this.cluster.getRegions(tableName);
            Assert.assertTrue((daughters.size() == regions.size() + 1 ? 1 : 0) != 0);
            HRegionInfo hri = region.getRegionInfo();
            AssignmentManager am = this.cluster.getMaster().getAssignmentManager();
            RegionStates regionStates = am.getRegionStates();
            long start = EnvironmentEdgeManager.currentTimeMillis();
            while (!regionStates.isRegionInState(hri, new RegionState.State[]{RegionState.State.SPLIT})) {
                Assert.assertFalse((String)"Timed out in waiting split parent to be in state SPLIT", (EnvironmentEdgeManager.currentTimeMillis() - start > 60000L ? 1 : 0) != 0);
                Thread.sleep(500L);
            }
            am.assign(hri, true, true);
            Assert.assertFalse((String)"Split region can't be assigned", (boolean)regionStates.isRegionInTransition(hri));
            Assert.assertTrue((boolean)regionStates.isRegionInState(hri, new RegionState.State[]{RegionState.State.SPLIT}));
            am.unassign(hri, true, null);
            Assert.assertFalse((String)"Split region can't be unassigned", (boolean)regionStates.isRegionInTransition(hri));
            Assert.assertTrue((boolean)regionStates.isRegionInState(hri, new RegionState.State[]{RegionState.State.SPLIT}));
        }
        finally {
            this.admin.setBalancerRunning(true, false);
            this.cluster.getMaster().setCatalogJanitorEnabled(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testSplitBeforeSettingSplittingInZKInternals() throws Exception {
        byte[] tableName = Bytes.toBytes((String)"testSplitBeforeSettingSplittingInZK");
        try {
            this.createTableAndWait(tableName, CF);
            List<HRegion> regions = this.awaitTableRegions(tableName);
            Assert.assertTrue((String)"Table not online", (this.cluster.getRegions(tableName).size() != 0 ? 1 : 0) != 0);
            int regionServerIndex = this.cluster.getServerWith(regions.get(0).getRegionName());
            HRegionServer regionServer = this.cluster.getRegionServer(regionServerIndex);
            HRegion region = this.findSplittableRegion(regions);
            Assert.assertTrue((String)"not able to find a splittable region", (region != null ? 1 : 0) != 0);
            MockedSplitTransaction st = new MockedSplitTransaction(region, Bytes.toBytes((String)"row2")){

                PairOfSameType<HRegion> createDaughters(Server server, RegionServerServices services) throws IOException {
                    throw new SplittingNodeCreationFailedException();
                }
            };
            String node = ZKAssign.getNodeName((ZooKeeperWatcher)regionServer.getZooKeeper(), (String)region.getRegionInfo().getEncodedName());
            regionServer.getZooKeeper().sync(node);
            for (int i = 0; i < 100; ++i) {
                if (ZKUtil.checkExists((ZooKeeperWatcher)regionServer.getZooKeeper(), (String)node) == -1) continue;
                Thread.sleep(100L);
            }
            try {
                st.prepare();
                st.execute((Server)regionServer, (RegionServerServices)regionServer);
            }
            catch (IOException e) {
                Assert.assertTrue((String)"Should be instance of CreateSplittingNodeFailedException", (boolean)(e instanceof SplittingNodeCreationFailedException));
                node = ZKAssign.getNodeName((ZooKeeperWatcher)regionServer.getZooKeeper(), (String)region.getRegionInfo().getEncodedName());
                Assert.assertTrue((ZKUtil.checkExists((ZooKeeperWatcher)regionServer.getZooKeeper(), (String)node) == -1 ? 1 : 0) != 0);
                Assert.assertTrue((boolean)st.rollback((Server)regionServer, (RegionServerServices)regionServer));
                Assert.assertTrue((ZKUtil.checkExists((ZooKeeperWatcher)regionServer.getZooKeeper(), (String)node) == -1 ? 1 : 0) != 0);
            }
        }
        finally {
            TESTING_UTIL.deleteTable(tableName);
        }
    }

    private HRegion findSplittableRegion(List<HRegion> regions) throws InterruptedException {
        for (int i = 0; i < 5; ++i) {
            for (HRegion r : regions) {
                if (!r.isSplittable()) continue;
                return r;
            }
            Thread.sleep(100L);
        }
        return null;
    }

    private List<HRegion> checkAndGetDaughters(byte[] tableName) throws InterruptedException {
        List<HRegion> daughters = null;
        for (int i = 0; i < 100 && (daughters = this.cluster.getRegions(tableName)).size() < 2; ++i) {
            Thread.sleep(100L);
        }
        Assert.assertTrue((daughters.size() >= 2 ? 1 : 0) != 0);
        return daughters;
    }

    private MockMasterWithoutCatalogJanitor abortAndWaitForMaster() throws IOException, InterruptedException {
        this.cluster.abortMaster(0);
        this.cluster.waitOnMaster(0);
        this.cluster.getConfiguration().setClass("hbase.master.impl", MockMasterWithoutCatalogJanitor.class, HMaster.class);
        MockMasterWithoutCatalogJanitor master = null;
        master = (MockMasterWithoutCatalogJanitor)this.cluster.startMaster().getMaster();
        this.cluster.waitForActiveAndReadyMaster();
        return master;
    }

    private void split(HRegionInfo hri, HRegionServer server, int regionCount) throws IOException, InterruptedException {
        this.admin.split(hri.getRegionNameAsString());
        for (int i = 0; ProtobufUtil.getOnlineRegions((AdminProtos.AdminService.BlockingInterface)server).size() <= regionCount && i < 100; ++i) {
            LOG.debug((Object)"Waiting on region to split");
            Thread.sleep(100L);
        }
        Assert.assertFalse((String)"Waited too long for split", (ProtobufUtil.getOnlineRegions((AdminProtos.AdminService.BlockingInterface)server).size() <= regionCount ? 1 : 0) != 0);
    }

    private int ensureTableRegionNotOnSameServerAsMeta(HBaseAdmin admin, HRegionInfo hri) throws HBaseIOException, MasterNotRunningException, ZooKeeperConnectionException, InterruptedException {
        int metaServerIndex = this.cluster.getServerWithMeta();
        Assert.assertTrue((metaServerIndex != -1 ? 1 : 0) != 0);
        HRegionServer metaRegionServer = this.cluster.getRegionServer(metaServerIndex);
        int tableRegionIndex = this.cluster.getServerWith(hri.getRegionName());
        Assert.assertTrue((tableRegionIndex != -1 ? 1 : 0) != 0);
        HRegionServer tableRegionServer = this.cluster.getRegionServer(tableRegionIndex);
        if (metaRegionServer.getServerName().equals((Object)tableRegionServer.getServerName())) {
            HRegionServer hrs = this.getOtherRegionServer(this.cluster, metaRegionServer);
            Assert.assertNotNull((Object)hrs);
            Assert.assertNotNull((Object)hri);
            LOG.info((Object)("Moving " + hri.getRegionNameAsString() + " from " + metaRegionServer.getServerName() + " to " + hrs.getServerName() + "; metaServerIndex=" + metaServerIndex));
            admin.move(hri.getEncodedNameAsBytes(), Bytes.toBytes((String)hrs.getServerName().toString()));
        }
        for (int i = 0; i < 100 && ((tableRegionIndex = this.cluster.getServerWith(hri.getRegionName())) == -1 || tableRegionIndex == metaServerIndex); ++i) {
            LOG.debug((Object)("Waiting on region move off the hbase:meta server; current index " + tableRegionIndex + " and metaServerIndex=" + metaServerIndex));
            Thread.sleep(100L);
        }
        Assert.assertTrue((String)"Region not moved off hbase:meta server", (tableRegionIndex != -1 && tableRegionIndex != metaServerIndex ? 1 : 0) != 0);
        tableRegionIndex = this.cluster.getServerWith(hri.getRegionName());
        Assert.assertTrue((tableRegionIndex != -1 ? 1 : 0) != 0);
        Assert.assertNotSame((Object)metaServerIndex, (Object)tableRegionIndex);
        return tableRegionIndex;
    }

    private HRegionServer getOtherRegionServer(MiniHBaseCluster cluster, HRegionServer notThisOne) {
        for (JVMClusterUtil.RegionServerThread rst : cluster.getRegionServerThreads()) {
            HRegionServer hrs = rst.getRegionServer();
            if (hrs.getServerName().equals((Object)notThisOne.getServerName()) || hrs.isStopping() || hrs.isStopped()) continue;
            return hrs;
        }
        return null;
    }

    private void printOutRegions(HRegionServer hrs, String prefix) throws IOException {
        List regions = ProtobufUtil.getOnlineRegions((AdminProtos.AdminService.BlockingInterface)hrs);
        for (HRegionInfo region : regions) {
            LOG.info((Object)(prefix + region.getRegionNameAsString()));
        }
    }

    private void waitUntilRegionServerDead() throws InterruptedException {
        for (int i = 0; this.cluster.getMaster().getClusterStatus().getServers().size() == 3 && i < 100; ++i) {
            LOG.info((Object)"Waiting on server to go down");
            Thread.sleep(100L);
        }
        Assert.assertFalse((String)"Waited too long for RS to die", (this.cluster.getMaster().getClusterStatus().getServers().size() == 3 ? 1 : 0) != 0);
    }

    private void awaitDaughters(byte[] tableName, int numDaughters) throws InterruptedException {
        for (int i = 0; this.cluster.getRegions(tableName).size() < numDaughters && i < 60; ++i) {
            LOG.info((Object)"Waiting for repair to happen");
            Thread.sleep(1000L);
        }
        if (this.cluster.getRegions(tableName).size() < numDaughters) {
            Assert.fail((String)"Waiting too long for daughter regions");
        }
    }

    private List<HRegion> awaitTableRegions(byte[] tableName) throws InterruptedException {
        List<HRegion> regions = null;
        for (int i = 0; i < 100 && (regions = this.cluster.getRegions(tableName)).size() <= 0; ++i) {
            Thread.sleep(100L);
        }
        return regions;
    }

    private HTable createTableAndWait(byte[] tableName, byte[] cf) throws IOException, InterruptedException {
        HTable t = TESTING_UTIL.createTable(tableName, cf);
        this.awaitTableRegions(tableName);
        Assert.assertTrue((String)("Table not online: " + Bytes.toString((byte[])tableName)), (this.cluster.getRegions(tableName).size() != 0 ? 1 : 0) != 0);
        return t;
    }

    private static class SplittingNodeCreationFailedException
    extends IOException {
        private static final long serialVersionUID = 1652404976265623004L;
    }

    public static class MockMasterWithoutCatalogJanitor
    extends HMaster {
        public MockMasterWithoutCatalogJanitor(Configuration conf) throws IOException, KeeperException, InterruptedException {
            super(conf);
        }

        protected void startCatalogJanitorChore() {
            LOG.debug((Object)"Customised master executed.");
        }
    }

    public static class MockedSplitTransaction
    extends SplitTransaction {
        private HRegion currentRegion;

        public MockedSplitTransaction(HRegion r, byte[] splitrow) {
            super(r, splitrow);
            this.currentRegion = r;
        }

        void transitionZKNode(Server server, RegionServerServices services, HRegion a, HRegion b) throws IOException {
            if (this.currentRegion.getRegionInfo().getTable().getNameAsString().equals("testShouldFailSplitIfZNodeDoesNotExistDueToPrevRollBack")) {
                try {
                    if (!secondSplit) {
                        callRollBack = true;
                        latch.await();
                    }
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
            super.transitionZKNode(server, services, a, b);
            if (this.currentRegion.getRegionInfo().getTable().getNameAsString().equals("testShouldFailSplitIfZNodeDoesNotExistDueToPrevRollBack")) {
                firstSplitCompleted = true;
            }
        }

        public boolean rollback(Server server, RegionServerServices services) throws IOException {
            if (this.currentRegion.getRegionInfo().getTable().getNameAsString().equals("testShouldFailSplitIfZNodeDoesNotExistDueToPrevRollBack") && secondSplit) {
                super.rollback(server, services);
                latch.countDown();
                return true;
            }
            return super.rollback(server, services);
        }
    }

    static class UselessTestAbortable
    implements Abortable {
        boolean aborted = false;

        UselessTestAbortable() {
        }

        public void abort(String why, Throwable e) {
            LOG.warn((Object)("ABORTED (But nothing to abort): why=" + why), e);
            this.aborted = true;
        }

        public boolean isAborted() {
            return this.aborted;
        }
    }
}

