/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellComparator;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.CompatibilitySingletonFactory;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.HBaseTestCase;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HDFSBlocksDistribution;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.MediumTests;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.MultithreadedTestUtil;
import org.apache.hadoop.hbase.NotServingRegionException;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.Waiter;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.exceptions.FailedSanityCheckException;
import org.apache.hadoop.hbase.filter.BinaryComparator;
import org.apache.hadoop.hbase.filter.ByteArrayComparable;
import org.apache.hadoop.hbase.filter.ColumnCountGetFilter;
import org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterBase;
import org.apache.hadoop.hbase.filter.FilterList;
import org.apache.hadoop.hbase.filter.NullComparator;
import org.apache.hadoop.hbase.filter.PrefixFilter;
import org.apache.hadoop.hbase.filter.SingleColumnValueExcludeFilter;
import org.apache.hadoop.hbase.filter.SingleColumnValueFilter;
import org.apache.hadoop.hbase.metrics.BaseSource;
import org.apache.hadoop.hbase.monitoring.MonitoredRPCHandler;
import org.apache.hadoop.hbase.monitoring.MonitoredTask;
import org.apache.hadoop.hbase.monitoring.TaskMonitor;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.WALProtos;
import org.apache.hadoop.hbase.regionserver.BloomType;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HStore;
import org.apache.hadoop.hbase.regionserver.InternalScanner;
import org.apache.hadoop.hbase.regionserver.MultiVersionConsistencyControl;
import org.apache.hadoop.hbase.regionserver.NoSuchColumnFamilyException;
import org.apache.hadoop.hbase.regionserver.OperationStatus;
import org.apache.hadoop.hbase.regionserver.RegionScanner;
import org.apache.hadoop.hbase.regionserver.SplitTransaction;
import org.apache.hadoop.hbase.regionserver.Store;
import org.apache.hadoop.hbase.regionserver.StoreFile;
import org.apache.hadoop.hbase.regionserver.WrongRegionException;
import org.apache.hadoop.hbase.regionserver.wal.HLog;
import org.apache.hadoop.hbase.regionserver.wal.HLogFactory;
import org.apache.hadoop.hbase.regionserver.wal.HLogKey;
import org.apache.hadoop.hbase.regionserver.wal.HLogUtil;
import org.apache.hadoop.hbase.regionserver.wal.MetricsWALSource;
import org.apache.hadoop.hbase.regionserver.wal.WALEdit;
import org.apache.hadoop.hbase.test.MetricsAssertHelper;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdge;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManagerTestHelper;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.util.IncrementingEnvironmentEdge;
import org.apache.hadoop.hbase.util.PairOfSameType;
import org.apache.hadoop.hbase.util.Threads;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@Category(value={MediumTests.class})
public class TestHRegion {
    static final Log LOG = LogFactory.getLog(TestHRegion.class);
    @Rule
    public TestName name = new TestName();
    private static final String COLUMN_FAMILY = "MyCF";
    HRegion region = null;
    private static HBaseTestingUtility TEST_UTIL;
    public static Configuration conf;
    private String DIR;
    private static FileSystem fs;
    private final int MAX_VERSIONS = 2;
    protected byte[] tableName;
    protected String method;
    protected final byte[] qual1 = Bytes.toBytes((String)"qual1");
    protected final byte[] qual2 = Bytes.toBytes((String)"qual2");
    protected final byte[] qual3 = Bytes.toBytes((String)"qual3");
    protected final byte[] value1 = Bytes.toBytes((String)"value1");
    protected final byte[] value2 = Bytes.toBytes((String)"value2");
    protected final byte[] row = Bytes.toBytes((String)"rowA");
    protected final byte[] row2 = Bytes.toBytes((String)"rowB");
    protected final MetricsAssertHelper metricsAssertHelper = (MetricsAssertHelper)CompatibilitySingletonFactory.getInstance(MetricsAssertHelper.class);

    @Before
    public void setup() throws IOException {
        TEST_UTIL = HBaseTestingUtility.createLocalHTU();
        fs = TEST_UTIL.getTestFileSystem();
        conf = TEST_UTIL.getConfiguration();
        this.DIR = TEST_UTIL.getDataTestDir("TestHRegion").toString();
        this.method = this.name.getMethodName();
        this.tableName = Bytes.toBytes((String)this.name.getMethodName());
    }

    @After
    public void tearDown() throws Exception {
        EnvironmentEdgeManagerTestHelper.reset();
    }

    String getName() {
        return this.name.getMethodName();
    }

    @Test
    public void testCompactionAffectedByScanners() throws Exception {
        byte[] family = Bytes.toBytes((String)"family");
        this.region = TestHRegion.initHRegion(this.tableName, this.method, conf, (byte[][])new byte[][]{family});
        Put put = new Put(Bytes.toBytes((String)"r1"));
        put.add(family, Bytes.toBytes((String)"q1"), Bytes.toBytes((String)"v1"));
        this.region.put(put);
        this.region.flushcache();
        Scan scan = new Scan();
        scan.setMaxVersions(3);
        RegionScanner scanner1 = this.region.getScanner(scan);
        Delete delete = new Delete(Bytes.toBytes((String)"r1"));
        this.region.delete(delete);
        this.region.flushcache();
        RegionScanner scanner2 = this.region.getScanner(scan);
        ArrayList results = new ArrayList();
        System.out.println("Smallest read point:" + this.region.getSmallestReadPoint());
        this.region.compactStores(true);
        RegionScanner scanner3 = this.region.getScanner(scan);
        scanner1.next(results);
        System.out.println(results);
        Assert.assertEquals((long)1L, (long)results.size());
        results.clear();
        scanner2.next(results);
        System.out.println(results);
        Assert.assertEquals((long)0L, (long)results.size());
        results.clear();
        scanner3.next(results);
        System.out.println(results);
        Assert.assertEquals((long)0L, (long)results.size());
    }

    @Test
    public void testToShowNPEOnRegionScannerReseek() throws Exception {
        byte[] family = Bytes.toBytes((String)"family");
        this.region = TestHRegion.initHRegion(this.tableName, this.method, conf, (byte[][])new byte[][]{family});
        Put put = new Put(Bytes.toBytes((String)"r1"));
        put.add(family, Bytes.toBytes((String)"q1"), Bytes.toBytes((String)"v1"));
        this.region.put(put);
        put = new Put(Bytes.toBytes((String)"r2"));
        put.add(family, Bytes.toBytes((String)"q1"), Bytes.toBytes((String)"v1"));
        this.region.put(put);
        this.region.flushcache();
        Scan scan = new Scan();
        scan.setMaxVersions(3);
        RegionScanner scanner1 = this.region.getScanner(scan);
        System.out.println("Smallest read point:" + this.region.getSmallestReadPoint());
        this.region.compactStores(true);
        scanner1.reseek(Bytes.toBytes((String)"r2"));
        ArrayList results = new ArrayList();
        scanner1.next(results);
        Cell keyValue = (Cell)results.get(0);
        Assert.assertTrue((Bytes.compareTo((byte[])CellUtil.cloneRow((Cell)keyValue), (byte[])Bytes.toBytes((String)"r2")) == 0 ? 1 : 0) != 0);
        scanner1.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSkipRecoveredEditsReplay() throws Exception {
        String method = "testSkipRecoveredEditsReplay";
        TableName tableName = TableName.valueOf((String)method);
        byte[] family = Bytes.toBytes((String)"family");
        this.region = TestHRegion.initHRegion(tableName, method, conf, (byte[][])new byte[][]{family});
        try {
            long minSeqId;
            Path regiondir = this.region.getRegionFileSystem().getRegionDir();
            FileSystem fs = this.region.getRegionFileSystem().getFileSystem();
            byte[] regionName = this.region.getRegionInfo().getEncodedNameAsBytes();
            Path recoveredEditsDir = HLogUtil.getRegionDirRecoveredEditsDir((Path)regiondir);
            long maxSeqId = 1050L;
            for (long i = minSeqId = 1000L; i <= maxSeqId; i += 10L) {
                Path recoveredEdits = new Path(recoveredEditsDir, String.format("%019d", i));
                fs.create(recoveredEdits);
                HLog.Writer writer = HLogFactory.createWriter((FileSystem)fs, (Path)recoveredEdits, (Configuration)conf);
                long time = System.nanoTime();
                WALEdit edit = new WALEdit();
                edit.add(new KeyValue(this.row, family, Bytes.toBytes((long)i), time, KeyValue.Type.Put, Bytes.toBytes((long)i)));
                writer.append(new HLog.Entry(new HLogKey(regionName, tableName, i, time, HConstants.DEFAULT_CLUSTER_ID), edit));
                writer.close();
            }
            MonitoredTask status = TaskMonitor.get().createStatus(method);
            TreeMap<byte[], Long> maxSeqIdInStores = new TreeMap<byte[], Long>(Bytes.BYTES_COMPARATOR);
            for (Store store : this.region.getStores().values()) {
                maxSeqIdInStores.put(store.getColumnFamilyName().getBytes(), minSeqId - 1L);
            }
            long seqId = this.region.replayRecoveredEditsIfAny(regiondir, maxSeqIdInStores, null, status);
            Assert.assertEquals((long)maxSeqId, (long)seqId);
            Get get = new Get(this.row);
            Result result = this.region.get(get);
            for (long i = minSeqId; i <= maxSeqId; i += 10L) {
                List kvs = result.getColumnCells(family, Bytes.toBytes((long)i));
                Assert.assertEquals((long)1L, (long)kvs.size());
                Assert.assertArrayEquals((byte[])Bytes.toBytes((long)i), (byte[])CellUtil.cloneValue((Cell)((Cell)kvs.get(0))));
            }
        }
        finally {
            HRegion.closeHRegion((HRegion)this.region);
            this.region = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSkipRecoveredEditsReplaySomeIgnored() throws Exception {
        String method = "testSkipRecoveredEditsReplaySomeIgnored";
        TableName tableName = TableName.valueOf((String)method);
        byte[] family = Bytes.toBytes((String)"family");
        this.region = TestHRegion.initHRegion(tableName, method, conf, (byte[][])new byte[][]{family});
        try {
            long minSeqId;
            Path regiondir = this.region.getRegionFileSystem().getRegionDir();
            FileSystem fs = this.region.getRegionFileSystem().getFileSystem();
            byte[] regionName = this.region.getRegionInfo().getEncodedNameAsBytes();
            Path recoveredEditsDir = HLogUtil.getRegionDirRecoveredEditsDir((Path)regiondir);
            long maxSeqId = 1050L;
            for (long i = minSeqId = 1000L; i <= maxSeqId; i += 10L) {
                Path recoveredEdits = new Path(recoveredEditsDir, String.format("%019d", i));
                fs.create(recoveredEdits);
                HLog.Writer writer = HLogFactory.createWriter((FileSystem)fs, (Path)recoveredEdits, (Configuration)conf);
                long time = System.nanoTime();
                WALEdit edit = new WALEdit();
                edit.add(new KeyValue(this.row, family, Bytes.toBytes((long)i), time, KeyValue.Type.Put, Bytes.toBytes((long)i)));
                writer.append(new HLog.Entry(new HLogKey(regionName, tableName, i, time, HConstants.DEFAULT_CLUSTER_ID), edit));
                writer.close();
            }
            long recoverSeqId = 1030L;
            MonitoredTask status = TaskMonitor.get().createStatus(method);
            TreeMap<byte[], Long> maxSeqIdInStores = new TreeMap<byte[], Long>(Bytes.BYTES_COMPARATOR);
            for (Store store : this.region.getStores().values()) {
                maxSeqIdInStores.put(store.getColumnFamilyName().getBytes(), recoverSeqId - 1L);
            }
            long seqId = this.region.replayRecoveredEditsIfAny(regiondir, maxSeqIdInStores, null, status);
            Assert.assertEquals((long)maxSeqId, (long)seqId);
            Get get = new Get(this.row);
            Result result = this.region.get(get);
            for (long i = minSeqId; i <= maxSeqId; i += 10L) {
                List kvs = result.getColumnCells(family, Bytes.toBytes((long)i));
                if (i < recoverSeqId) {
                    Assert.assertEquals((long)0L, (long)kvs.size());
                    continue;
                }
                Assert.assertEquals((long)1L, (long)kvs.size());
                Assert.assertArrayEquals((byte[])Bytes.toBytes((long)i), (byte[])CellUtil.cloneValue((Cell)((Cell)kvs.get(0))));
            }
        }
        finally {
            HRegion.closeHRegion((HRegion)this.region);
            this.region = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSkipRecoveredEditsReplayAllIgnored() throws Exception {
        byte[] family = Bytes.toBytes((String)"family");
        this.region = TestHRegion.initHRegion(this.tableName, this.method, conf, (byte[][])new byte[][]{family});
        try {
            Path regiondir = this.region.getRegionFileSystem().getRegionDir();
            FileSystem fs = this.region.getRegionFileSystem().getFileSystem();
            Path recoveredEditsDir = HLogUtil.getRegionDirRecoveredEditsDir((Path)regiondir);
            for (int i = 1000; i < 1050; i += 10) {
                Path recoveredEdits = new Path(recoveredEditsDir, String.format("%019d", i));
                FSDataOutputStream dos = fs.create(recoveredEdits);
                dos.writeInt(i);
                dos.close();
            }
            long minSeqId = 2000L;
            Path recoveredEdits = new Path(recoveredEditsDir, String.format("%019d", minSeqId - 1L));
            FSDataOutputStream dos = fs.create(recoveredEdits);
            dos.close();
            TreeMap<byte[], Long> maxSeqIdInStores = new TreeMap<byte[], Long>(Bytes.BYTES_COMPARATOR);
            for (Store store : this.region.getStores().values()) {
                maxSeqIdInStores.put(store.getColumnFamilyName().getBytes(), minSeqId);
            }
            long seqId = this.region.replayRecoveredEditsIfAny(regiondir, maxSeqIdInStores, null, null);
            Assert.assertEquals((long)minSeqId, (long)seqId);
        }
        finally {
            HRegion.closeHRegion((HRegion)this.region);
            this.region = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRecoveredEditsReplayCompaction() throws Exception {
        String method = this.name.getMethodName();
        TableName tableName = TableName.valueOf((String)method);
        byte[] family = Bytes.toBytes((String)"family");
        this.region = TestHRegion.initHRegion(tableName, method, conf, (byte[][])new byte[][]{family});
        try {
            long minSeqId;
            Path regiondir = this.region.getRegionFileSystem().getRegionDir();
            FileSystem fs = this.region.getRegionFileSystem().getFileSystem();
            byte[] regionName = this.region.getRegionInfo().getEncodedNameAsBytes();
            long maxSeqId = 3L;
            for (long i = minSeqId = 0L; i < maxSeqId; ++i) {
                Put put = new Put(Bytes.toBytes((long)i));
                put.add(family, Bytes.toBytes((long)i), Bytes.toBytes((long)i));
                this.region.put(put);
                this.region.flushcache();
            }
            Assert.assertEquals((long)3L, (long)this.region.getStore(family).getStorefilesCount());
            ArrayList<Path> storeFiles = new ArrayList<Path>(3);
            for (StoreFile sf : this.region.getStore(family).getStorefiles()) {
                storeFiles.add(sf.getPath());
            }
            conf.setBoolean("hbase.hstore.compaction.complete", false);
            this.region.compactStores();
            Assert.assertEquals((long)3L, (long)this.region.getStore(family).getStorefilesCount());
            Path tmpDir = this.region.getRegionFileSystem().getTempDir();
            FileStatus[] files = FSUtils.listStatus((FileSystem)fs, (Path)tmpDir);
            String errorMsg = "Expected to find 1 file in the region temp directory from the compaction, could not find any";
            Assert.assertNotNull((String)errorMsg, (Object)files);
            Assert.assertEquals((String)errorMsg, (long)1L, (long)files.length);
            Path newFile = this.region.getRegionFileSystem().commitStoreFile(Bytes.toString((byte[])family), files[0].getPath());
            WALProtos.CompactionDescriptor compactionDescriptor = ProtobufUtil.toCompactionDescriptor((HRegionInfo)this.region.getRegionInfo(), (byte[])family, storeFiles, (List)Lists.newArrayList((Object[])new Path[]{newFile}), (Path)this.region.getRegionFileSystem().getStoreDir(Bytes.toString((byte[])family)));
            HLogUtil.writeCompactionMarker((HLog)this.region.getLog(), (HTableDescriptor)this.region.getTableDesc(), (HRegionInfo)this.region.getRegionInfo(), (WALProtos.CompactionDescriptor)compactionDescriptor);
            Path recoveredEditsDir = HLogUtil.getRegionDirRecoveredEditsDir((Path)regiondir);
            Path recoveredEdits = new Path(recoveredEditsDir, String.format("%019d", 1000));
            fs.create(recoveredEdits);
            HLog.Writer writer = HLogFactory.createWriter((FileSystem)fs, (Path)recoveredEdits, (Configuration)conf);
            long time = System.nanoTime();
            writer.append(new HLog.Entry(new HLogKey(regionName, tableName, 10L, time, HConstants.DEFAULT_CLUSTER_ID), WALEdit.createCompaction((WALProtos.CompactionDescriptor)compactionDescriptor)));
            writer.close();
            HTableDescriptor htd = this.region.getTableDesc();
            HRegionInfo info = this.region.getRegionInfo();
            this.region.close();
            this.region = HRegion.openHRegion((HRegion)this.region, null);
            Collection sfs = this.region.getStore(family).getStorefiles();
            for (StoreFile sf : sfs) {
                LOG.info((Object)sf.getPath());
            }
            Assert.assertEquals((long)1L, (long)this.region.getStore(family).getStorefilesCount());
            files = FSUtils.listStatus((FileSystem)fs, (Path)tmpDir);
            Assert.assertTrue((String)("Expected to find 0 files inside " + tmpDir), (files == null || files.length == 0 ? 1 : 0) != 0);
            for (long i = minSeqId; i < maxSeqId; ++i) {
                Get get = new Get(Bytes.toBytes((long)i));
                Result result = this.region.get(get);
                byte[] value = result.getValue(family, Bytes.toBytes((long)i));
                Assert.assertArrayEquals((byte[])Bytes.toBytes((long)i), (byte[])value);
            }
        }
        finally {
            HRegion.closeHRegion((HRegion)this.region);
            this.region = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetWhileRegionClose() throws IOException {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        Configuration hc = this.initSplit();
        int numRows = 100;
        byte[][] families = new byte[][]{HBaseTestingUtility.fam1, HBaseTestingUtility.fam2, HBaseTestingUtility.fam3};
        String method = this.name.getMethodName();
        this.region = TestHRegion.initHRegion(tableName, method, hc, (byte[][])families);
        try {
            int startRow = 100;
            this.putData(100, numRows, this.qual1, families);
            this.putData(100, numRows, this.qual2, families);
            this.putData(100, numRows, this.qual3, families);
            AtomicBoolean done = new AtomicBoolean(false);
            AtomicInteger gets = new AtomicInteger(0);
            GetTillDoneOrException[] threads = new GetTillDoneOrException[10];
            try {
                int i;
                for (i = 0; i < threads.length / 2; ++i) {
                    threads[i] = new GetTillDoneOrException(i, Bytes.toBytes((String)"100"), done, gets);
                    threads[i].setDaemon(true);
                    threads[i].start();
                }
                this.region.closing.set(true);
                for (i = threads.length / 2; i < threads.length; ++i) {
                    threads[i] = new GetTillDoneOrException(i, Bytes.toBytes((String)"100"), done, gets);
                    threads[i].setDaemon(true);
                    threads[i].start();
                }
            }
            finally {
                if (this.region != null) {
                    HRegion.closeHRegion((HRegion)this.region);
                }
            }
            done.set(true);
            for (GetTillDoneOrException t : threads) {
                try {
                    t.join();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                if (t.e == null) continue;
                LOG.info((Object)("Exception=" + t.e));
                Assert.assertFalse((String)("Found a NPE in " + t.getName()), (boolean)(t.e instanceof NullPointerException));
            }
        }
        finally {
            HRegion.closeHRegion((HRegion)this.region);
            this.region = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWeirdCacheBehaviour() throws Exception {
        byte[] TABLE = Bytes.toBytes((String)"testWeirdCacheBehaviour");
        byte[][] FAMILIES = new byte[][]{Bytes.toBytes((String)"trans-blob"), Bytes.toBytes((String)"trans-type"), Bytes.toBytes((String)"trans-date"), Bytes.toBytes((String)"trans-tags"), Bytes.toBytes((String)"trans-group")};
        this.region = TestHRegion.initHRegion(TABLE, this.getName(), conf, (byte[][])FAMILIES);
        try {
            String value = "this is the value";
            String value2 = "this is some other value";
            String keyPrefix1 = "prefix1";
            String keyPrefix2 = "prefix2";
            String keyPrefix3 = "prefix3";
            this.putRows(this.region, 3, value, keyPrefix1);
            this.putRows(this.region, 3, value, keyPrefix2);
            this.putRows(this.region, 3, value, keyPrefix3);
            this.putRows(this.region, 3, value2, keyPrefix1);
            this.putRows(this.region, 3, value2, keyPrefix2);
            this.putRows(this.region, 3, value2, keyPrefix3);
            System.out.println("Checking values for key: " + keyPrefix1);
            Assert.assertEquals((String)"Got back incorrect number of rows from scan", (long)3L, (long)this.getNumberOfRows(keyPrefix1, value2, this.region));
            System.out.println("Checking values for key: " + keyPrefix2);
            Assert.assertEquals((String)"Got back incorrect number of rows from scan", (long)3L, (long)this.getNumberOfRows(keyPrefix2, value2, this.region));
            System.out.println("Checking values for key: " + keyPrefix3);
            Assert.assertEquals((String)"Got back incorrect number of rows from scan", (long)3L, (long)this.getNumberOfRows(keyPrefix3, value2, this.region));
            this.deleteColumns(this.region, value2, keyPrefix1);
            this.deleteColumns(this.region, value2, keyPrefix2);
            this.deleteColumns(this.region, value2, keyPrefix3);
            System.out.println("Starting important checks.....");
            Assert.assertEquals((String)("Got back incorrect number of rows from scan: " + keyPrefix1), (long)0L, (long)this.getNumberOfRows(keyPrefix1, value2, this.region));
            Assert.assertEquals((String)("Got back incorrect number of rows from scan: " + keyPrefix2), (long)0L, (long)this.getNumberOfRows(keyPrefix2, value2, this.region));
            Assert.assertEquals((String)("Got back incorrect number of rows from scan: " + keyPrefix3), (long)0L, (long)this.getNumberOfRows(keyPrefix3, value2, this.region));
        }
        finally {
            HRegion.closeHRegion((HRegion)this.region);
            this.region = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAppendWithReadOnlyTable() throws Exception {
        byte[] TABLE = Bytes.toBytes((String)"readOnlyTable");
        this.region = TestHRegion.initHRegion(TABLE, this.getName(), conf, true, (byte[][])new byte[][]{Bytes.toBytes((String)"somefamily")});
        boolean exceptionCaught = false;
        Append append = new Append(Bytes.toBytes((String)"somerow"));
        append.setDurability(Durability.SKIP_WAL);
        append.add(Bytes.toBytes((String)"somefamily"), Bytes.toBytes((String)"somequalifier"), Bytes.toBytes((String)"somevalue"));
        try {
            this.region.append(append);
        }
        catch (IOException e) {
            exceptionCaught = true;
        }
        finally {
            HRegion.closeHRegion((HRegion)this.region);
            this.region = null;
        }
        Assert.assertTrue((exceptionCaught ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testIncrWithReadOnlyTable() throws Exception {
        byte[] TABLE = Bytes.toBytes((String)"readOnlyTable");
        this.region = TestHRegion.initHRegion(TABLE, this.getName(), conf, true, (byte[][])new byte[][]{Bytes.toBytes((String)"somefamily")});
        boolean exceptionCaught = false;
        Increment inc = new Increment(Bytes.toBytes((String)"somerow"));
        inc.setDurability(Durability.SKIP_WAL);
        inc.addColumn(Bytes.toBytes((String)"somefamily"), Bytes.toBytes((String)"somequalifier"), 1L);
        try {
            this.region.increment(inc);
        }
        catch (IOException e) {
            exceptionCaught = true;
        }
        finally {
            HRegion.closeHRegion((HRegion)this.region);
            this.region = null;
        }
        Assert.assertTrue((exceptionCaught ? 1 : 0) != 0);
    }

    private void deleteColumns(HRegion r, String value, String keyPrefix) throws IOException {
        InternalScanner scanner = this.buildScanner(keyPrefix, value, r);
        int count = 0;
        boolean more = false;
        ArrayList results = new ArrayList();
        do {
            more = scanner.next(results);
            if (results == null || results.isEmpty()) break;
            ++count;
            Delete delete = new Delete(CellUtil.cloneRow((Cell)((Cell)results.get(0))));
            delete.deleteColumn(Bytes.toBytes((String)"trans-tags"), Bytes.toBytes((String)"qual2"));
            r.delete(delete);
            results.clear();
        } while (more);
        Assert.assertEquals((String)"Did not perform correct number of deletes", (long)3L, (long)count);
    }

    private int getNumberOfRows(String keyPrefix, String value, HRegion r) throws Exception {
        InternalScanner resultScanner = this.buildScanner(keyPrefix, value, r);
        int numberOfResults = 0;
        ArrayList results = new ArrayList();
        boolean more = false;
        do {
            more = resultScanner.next(results);
            if (results == null || results.isEmpty()) break;
            ++numberOfResults;
            for (Cell kv : results) {
                System.out.println("kv=" + kv.toString() + ", " + Bytes.toString((byte[])CellUtil.cloneValue((Cell)kv)));
            }
            results.clear();
        } while (more);
        return numberOfResults;
    }

    private InternalScanner buildScanner(String keyPrefix, String value, HRegion r) throws IOException {
        FilterList allFilters = new FilterList(new Filter[0]);
        allFilters.addFilter((Filter)new PrefixFilter(Bytes.toBytes((String)keyPrefix)));
        SingleColumnValueFilter filter = new SingleColumnValueFilter(Bytes.toBytes((String)"trans-tags"), Bytes.toBytes((String)"qual2"), CompareFilter.CompareOp.EQUAL, Bytes.toBytes((String)value));
        filter.setFilterIfMissing(true);
        allFilters.addFilter((Filter)filter);
        Scan scan = new Scan();
        scan.addFamily(Bytes.toBytes((String)"trans-blob"));
        scan.addFamily(Bytes.toBytes((String)"trans-type"));
        scan.addFamily(Bytes.toBytes((String)"trans-date"));
        scan.addFamily(Bytes.toBytes((String)"trans-tags"));
        scan.addFamily(Bytes.toBytes((String)"trans-group"));
        scan.setFilter((Filter)allFilters);
        return r.getScanner(scan);
    }

    private void putRows(HRegion r, int numRows, String value, String key) throws IOException {
        for (int i = 0; i < numRows; ++i) {
            String row = key + "_" + i;
            System.out.println(String.format("Saving row: %s, with value %s", row, value));
            Put put = new Put(Bytes.toBytes((String)row));
            put.setDurability(Durability.SKIP_WAL);
            put.add(Bytes.toBytes((String)"trans-blob"), null, Bytes.toBytes((String)"value for blob"));
            put.add(Bytes.toBytes((String)"trans-type"), null, Bytes.toBytes((String)"statement"));
            put.add(Bytes.toBytes((String)"trans-date"), null, Bytes.toBytes((String)"20090921010101999"));
            put.add(Bytes.toBytes((String)"trans-tags"), Bytes.toBytes((String)"qual2"), Bytes.toBytes((String)value));
            put.add(Bytes.toBytes((String)"trans-group"), null, Bytes.toBytes((String)"adhocTransactionGroupId"));
            r.put(put);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFamilyWithAndWithoutColon() throws Exception {
        byte[] b = Bytes.toBytes((String)this.getName());
        byte[] cf = Bytes.toBytes((String)COLUMN_FAMILY);
        this.region = TestHRegion.initHRegion(b, this.getName(), conf, (byte[][])new byte[][]{cf});
        try {
            Put p = new Put(b);
            byte[] cfwithcolon = Bytes.toBytes((String)"MyCF:");
            p.add(cfwithcolon, cfwithcolon, cfwithcolon);
            boolean exception = false;
            try {
                this.region.put(p);
            }
            catch (NoSuchColumnFamilyException e) {
                exception = true;
            }
            Assert.assertTrue((boolean)exception);
        }
        finally {
            HRegion.closeHRegion((HRegion)this.region);
            this.region = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBatchPut() throws Exception {
        byte[] b = Bytes.toBytes((String)this.getName());
        byte[] cf = Bytes.toBytes((String)COLUMN_FAMILY);
        byte[] qual = Bytes.toBytes((String)"qual");
        byte[] val = Bytes.toBytes((String)"val");
        this.region = TestHRegion.initHRegion(b, this.getName(), conf, (byte[][])new byte[][]{cf});
        MetricsWALSource source = (MetricsWALSource)CompatibilitySingletonFactory.getInstance(MetricsWALSource.class);
        try {
            int i;
            long syncs = this.metricsAssertHelper.getCounter("syncTimeNumOps", (BaseSource)source);
            this.metricsAssertHelper.assertCounter("syncTimeNumOps", syncs, (BaseSource)source);
            LOG.info((Object)"First a batch put with all valid puts");
            final Put[] puts = new Put[10];
            for (int i2 = 0; i2 < 10; ++i2) {
                puts[i2] = new Put(Bytes.toBytes((String)("row_" + i2)));
                puts[i2].add(cf, qual, val);
            }
            OperationStatus[] codes = this.region.batchMutate((Mutation[])puts);
            Assert.assertEquals((long)10L, (long)codes.length);
            for (i = 0; i < 10; ++i) {
                Assert.assertEquals((Object)HConstants.OperationStatusCode.SUCCESS, (Object)codes[i].getOperationStatusCode());
            }
            this.metricsAssertHelper.assertCounter("syncTimeNumOps", syncs + 1L, (BaseSource)source);
            LOG.info((Object)"Next a batch put with one invalid family");
            puts[5].add(Bytes.toBytes((String)"BAD_CF"), qual, val);
            codes = this.region.batchMutate((Mutation[])puts);
            Assert.assertEquals((long)10L, (long)codes.length);
            for (i = 0; i < 10; ++i) {
                Assert.assertEquals((Object)(i == 5 ? HConstants.OperationStatusCode.BAD_FAMILY : HConstants.OperationStatusCode.SUCCESS), (Object)codes[i].getOperationStatusCode());
            }
            this.metricsAssertHelper.assertCounter("syncTimeNumOps", syncs + 2L, (BaseSource)source);
            LOG.info((Object)"Next a batch put that has to break into two batches to avoid a lock");
            HRegion.RowLock rowLock = this.region.getRowLock(Bytes.toBytes((String)"row_2"));
            MultithreadedTestUtil.TestContext ctx = new MultithreadedTestUtil.TestContext(conf);
            final AtomicReference retFromThread = new AtomicReference();
            MultithreadedTestUtil.TestThread putter = new MultithreadedTestUtil.TestThread(ctx){

                @Override
                public void doWork() throws IOException {
                    retFromThread.set(TestHRegion.this.region.batchMutate((Mutation[])puts));
                }
            };
            LOG.info((Object)"...starting put thread while holding lock");
            ctx.addThread(putter);
            ctx.startThreads();
            LOG.info((Object)"...waiting for put thread to sync first time");
            long startWait = System.currentTimeMillis();
            while (this.metricsAssertHelper.getCounter("syncTimeNumOps", (BaseSource)source) == syncs + 2L) {
                Thread.sleep(100L);
                if (System.currentTimeMillis() - startWait <= 10000L) continue;
                Assert.fail((String)"Timed out waiting for thread to sync first minibatch");
            }
            LOG.info((Object)"...releasing row lock, which should let put thread continue");
            rowLock.release();
            LOG.info((Object)"...joining on thread");
            ctx.stop();
            LOG.info((Object)"...checking that next batch was synced");
            this.metricsAssertHelper.assertCounter("syncTimeNumOps", syncs + 4L, (BaseSource)source);
            codes = (OperationStatus[])retFromThread.get();
            for (int i3 = 0; i3 < 10; ++i3) {
                Assert.assertEquals((Object)(i3 == 5 ? HConstants.OperationStatusCode.BAD_FAMILY : HConstants.OperationStatusCode.SUCCESS), (Object)codes[i3].getOperationStatusCode());
            }
        }
        finally {
            HRegion.closeHRegion((HRegion)this.region);
            this.region = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBatchPutWithTsSlop() throws Exception {
        byte[] b = Bytes.toBytes((String)this.getName());
        byte[] cf = Bytes.toBytes((String)COLUMN_FAMILY);
        byte[] qual = Bytes.toBytes((String)"qual");
        byte[] val = Bytes.toBytes((String)"val");
        conf.setInt("hbase.hregion.keyvalue.timestamp.slop.millisecs", 1000);
        this.region = TestHRegion.initHRegion(b, this.getName(), conf, (byte[][])new byte[][]{cf});
        try {
            MetricsWALSource source = (MetricsWALSource)CompatibilitySingletonFactory.getInstance(MetricsWALSource.class);
            long syncs = this.metricsAssertHelper.getCounter("syncTimeNumOps", (BaseSource)source);
            this.metricsAssertHelper.assertCounter("syncTimeNumOps", syncs, (BaseSource)source);
            Put[] puts = new Put[10];
            for (int i = 0; i < 10; ++i) {
                puts[i] = new Put(Bytes.toBytes((String)("row_" + i)), 9223372036854775707L);
                puts[i].add(cf, qual, val);
            }
            OperationStatus[] codes = this.region.batchMutate((Mutation[])puts);
            Assert.assertEquals((long)10L, (long)codes.length);
            for (int i = 0; i < 10; ++i) {
                Assert.assertEquals((Object)HConstants.OperationStatusCode.SANITY_CHECK_FAILURE, (Object)codes[i].getOperationStatusCode());
            }
            this.metricsAssertHelper.assertCounter("syncTimeNumOps", syncs, (BaseSource)source);
        }
        finally {
            HRegion.closeHRegion((HRegion)this.region);
            this.region = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCheckAndMutate_WithEmptyRowValue() throws IOException {
        byte[] row1 = Bytes.toBytes((String)"row1");
        byte[] fam1 = Bytes.toBytes((String)"fam1");
        byte[] qf1 = Bytes.toBytes((String)"qualifier");
        byte[] emptyVal = new byte[]{};
        byte[] val1 = Bytes.toBytes((String)"value1");
        byte[] val2 = Bytes.toBytes((String)"value2");
        String method = this.getName();
        this.region = TestHRegion.initHRegion(this.tableName, method, conf, (byte[][])new byte[][]{fam1});
        try {
            Put put = new Put(row1);
            put.add(fam1, qf1, emptyVal);
            boolean res = this.region.checkAndMutate(row1, fam1, qf1, CompareFilter.CompareOp.EQUAL, (ByteArrayComparable)new BinaryComparator(emptyVal), (Mutation)put, true);
            Assert.assertTrue((boolean)res);
            put = new Put(row1);
            put.add(fam1, qf1, val1);
            res = this.region.checkAndMutate(row1, fam1, qf1, CompareFilter.CompareOp.EQUAL, (ByteArrayComparable)new BinaryComparator(emptyVal), (Mutation)put, true);
            Assert.assertTrue((boolean)res);
            res = this.region.checkAndMutate(row1, fam1, qf1, CompareFilter.CompareOp.EQUAL, (ByteArrayComparable)new BinaryComparator(emptyVal), (Mutation)put, true);
            Assert.assertFalse((boolean)res);
            Delete delete = new Delete(row1);
            delete.deleteColumn(fam1, qf1);
            res = this.region.checkAndMutate(row1, fam1, qf1, CompareFilter.CompareOp.EQUAL, (ByteArrayComparable)new BinaryComparator(emptyVal), (Mutation)delete, true);
            Assert.assertFalse((boolean)res);
            put = new Put(row1);
            put.add(fam1, qf1, val2);
            res = this.region.checkAndMutate(row1, fam1, qf1, CompareFilter.CompareOp.EQUAL, (ByteArrayComparable)new BinaryComparator(val1), (Mutation)put, true);
            Assert.assertTrue((boolean)res);
            delete = new Delete(row1);
            delete.deleteColumn(fam1, qf1);
            delete.deleteColumn(fam1, qf1);
            res = this.region.checkAndMutate(row1, fam1, qf1, CompareFilter.CompareOp.EQUAL, (ByteArrayComparable)new BinaryComparator(val2), (Mutation)delete, true);
            Assert.assertTrue((boolean)res);
            delete = new Delete(row1);
            res = this.region.checkAndMutate(row1, fam1, qf1, CompareFilter.CompareOp.EQUAL, (ByteArrayComparable)new BinaryComparator(emptyVal), (Mutation)delete, true);
            Assert.assertTrue((boolean)res);
            put = new Put(row1);
            put.add(fam1, qf1, val1);
            res = this.region.checkAndMutate(row1, fam1, qf1, CompareFilter.CompareOp.EQUAL, (ByteArrayComparable)new NullComparator(), (Mutation)put, true);
            Assert.assertTrue((boolean)res);
        }
        finally {
            HRegion.closeHRegion((HRegion)this.region);
            this.region = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCheckAndMutate_WithWrongValue() throws IOException {
        byte[] row1 = Bytes.toBytes((String)"row1");
        byte[] fam1 = Bytes.toBytes((String)"fam1");
        byte[] qf1 = Bytes.toBytes((String)"qualifier");
        byte[] val1 = Bytes.toBytes((String)"value1");
        byte[] val2 = Bytes.toBytes((String)"value2");
        String method = this.getName();
        this.region = TestHRegion.initHRegion(this.tableName, method, conf, (byte[][])new byte[][]{fam1});
        try {
            Put put = new Put(row1);
            put.add(fam1, qf1, val1);
            this.region.put(put);
            boolean res = this.region.checkAndMutate(row1, fam1, qf1, CompareFilter.CompareOp.EQUAL, (ByteArrayComparable)new BinaryComparator(val2), (Mutation)put, true);
            Assert.assertEquals((Object)false, (Object)res);
            Delete delete = new Delete(row1);
            delete.deleteFamily(fam1);
            res = this.region.checkAndMutate(row1, fam1, qf1, CompareFilter.CompareOp.EQUAL, (ByteArrayComparable)new BinaryComparator(val2), (Mutation)delete, true);
            Assert.assertEquals((Object)false, (Object)res);
        }
        finally {
            HRegion.closeHRegion((HRegion)this.region);
            this.region = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCheckAndMutate_WithCorrectValue() throws IOException {
        byte[] row1 = Bytes.toBytes((String)"row1");
        byte[] fam1 = Bytes.toBytes((String)"fam1");
        byte[] qf1 = Bytes.toBytes((String)"qualifier");
        byte[] val1 = Bytes.toBytes((String)"value1");
        String method = this.getName();
        this.region = TestHRegion.initHRegion(this.tableName, method, conf, (byte[][])new byte[][]{fam1});
        try {
            Put put = new Put(row1);
            put.add(fam1, qf1, val1);
            this.region.put(put);
            boolean res = this.region.checkAndMutate(row1, fam1, qf1, CompareFilter.CompareOp.EQUAL, (ByteArrayComparable)new BinaryComparator(val1), (Mutation)put, true);
            Assert.assertEquals((Object)true, (Object)res);
            Delete delete = new Delete(row1);
            delete.deleteColumn(fam1, qf1);
            res = this.region.checkAndMutate(row1, fam1, qf1, CompareFilter.CompareOp.EQUAL, (ByteArrayComparable)new BinaryComparator(val1), (Mutation)put, true);
            Assert.assertEquals((Object)true, (Object)res);
        }
        finally {
            HRegion.closeHRegion((HRegion)this.region);
            this.region = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCheckAndPut_ThatPutWasWritten() throws IOException {
        byte[] row1 = Bytes.toBytes((String)"row1");
        byte[] fam1 = Bytes.toBytes((String)"fam1");
        byte[] fam2 = Bytes.toBytes((String)"fam2");
        byte[] qf1 = Bytes.toBytes((String)"qualifier");
        byte[] val1 = Bytes.toBytes((String)"value1");
        byte[] val2 = Bytes.toBytes((String)"value2");
        byte[][] families = new byte[][]{fam1, fam2};
        String method = this.getName();
        this.region = TestHRegion.initHRegion(this.tableName, method, conf, (byte[][])families);
        try {
            Put put = new Put(row1);
            put.add(fam1, qf1, val1);
            this.region.put(put);
            long ts = System.currentTimeMillis();
            KeyValue kv = new KeyValue(row1, fam2, qf1, ts, KeyValue.Type.Put, val2);
            put = new Put(row1);
            put.add((Cell)kv);
            HStore store = (HStore)this.region.getStore(fam1);
            store.memstore.kvset.size();
            boolean res = this.region.checkAndMutate(row1, fam1, qf1, CompareFilter.CompareOp.EQUAL, (ByteArrayComparable)new BinaryComparator(val1), (Mutation)put, true);
            Assert.assertEquals((Object)true, (Object)res);
            store.memstore.kvset.size();
            Get get = new Get(row1);
            get.addColumn(fam2, qf1);
            Cell[] actual = this.region.get(get).rawCells();
            Cell[] expected = new Cell[]{kv};
            Assert.assertEquals((long)expected.length, (long)actual.length);
            for (int i = 0; i < actual.length; ++i) {
                Assert.assertEquals((Object)expected[i], (Object)actual[i]);
            }
        }
        finally {
            HRegion.closeHRegion((HRegion)this.region);
            this.region = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCheckAndPut_wrongRowInPut() throws IOException {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        this.region = TestHRegion.initHRegion(tableName, this.getName(), conf, HBaseTestingUtility.COLUMNS);
        try {
            Put put = new Put(this.row2);
            put.add(HBaseTestingUtility.fam1, this.qual1, this.value1);
            try {
                boolean res = this.region.checkAndMutate(this.row, HBaseTestingUtility.fam1, this.qual1, CompareFilter.CompareOp.EQUAL, (ByteArrayComparable)new BinaryComparator(this.value2), (Mutation)put, false);
                Assert.fail();
            }
            catch (DoNotRetryIOException doNotRetryIOException) {
                // empty catch block
            }
        }
        finally {
            HRegion.closeHRegion((HRegion)this.region);
            this.region = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCheckAndDelete_ThatDeleteWasWritten() throws IOException {
        byte[] row1 = Bytes.toBytes((String)"row1");
        byte[] fam1 = Bytes.toBytes((String)"fam1");
        byte[] fam2 = Bytes.toBytes((String)"fam2");
        byte[] qf1 = Bytes.toBytes((String)"qualifier1");
        byte[] qf2 = Bytes.toBytes((String)"qualifier2");
        byte[] qf3 = Bytes.toBytes((String)"qualifier3");
        byte[] val1 = Bytes.toBytes((String)"value1");
        byte[] val2 = Bytes.toBytes((String)"value2");
        byte[] val3 = Bytes.toBytes((String)"value3");
        byte[] emptyVal = new byte[]{};
        byte[][] families = new byte[][]{fam1, fam2};
        String method = this.getName();
        this.region = TestHRegion.initHRegion(this.tableName, method, conf, (byte[][])families);
        try {
            Put put = new Put(row1);
            put.add(fam1, qf1, val1);
            this.region.put(put);
            Threads.sleep((long)2L);
            put = new Put(row1);
            put.add(fam1, qf1, val2);
            put.add(fam2, qf1, val3);
            put.add(fam2, qf2, val2);
            put.add(fam2, qf3, val1);
            put.add(fam1, qf3, val1);
            this.region.put(put);
            Delete delete = new Delete(row1);
            delete.deleteColumn(fam1, qf1);
            delete.deleteColumn(fam2, qf1);
            delete.deleteColumn(fam1, qf3);
            boolean res = this.region.checkAndMutate(row1, fam1, qf1, CompareFilter.CompareOp.EQUAL, (ByteArrayComparable)new BinaryComparator(val2), (Mutation)delete, true);
            Assert.assertEquals((Object)true, (Object)res);
            Get get = new Get(row1);
            get.addColumn(fam1, qf1);
            get.addColumn(fam1, qf3);
            get.addColumn(fam2, qf2);
            Result r = this.region.get(get);
            Assert.assertEquals((long)2L, (long)r.size());
            Assert.assertArrayEquals((byte[])val1, (byte[])r.getValue(fam1, qf1));
            Assert.assertArrayEquals((byte[])val2, (byte[])r.getValue(fam2, qf2));
            delete = new Delete(row1);
            delete.deleteFamily(fam2);
            res = this.region.checkAndMutate(row1, fam2, qf1, CompareFilter.CompareOp.EQUAL, (ByteArrayComparable)new BinaryComparator(emptyVal), (Mutation)delete, true);
            Assert.assertEquals((Object)true, (Object)res);
            get = new Get(row1);
            r = this.region.get(get);
            Assert.assertEquals((long)1L, (long)r.size());
            Assert.assertArrayEquals((byte[])val1, (byte[])r.getValue(fam1, qf1));
            delete = new Delete(row1);
            res = this.region.checkAndMutate(row1, fam1, qf1, CompareFilter.CompareOp.EQUAL, (ByteArrayComparable)new BinaryComparator(val1), (Mutation)delete, true);
            Assert.assertEquals((Object)true, (Object)res);
            get = new Get(row1);
            r = this.region.get(get);
            Assert.assertEquals((long)0L, (long)r.size());
        }
        finally {
            HRegion.closeHRegion((HRegion)this.region);
            this.region = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDelete_multiDeleteColumn() throws IOException {
        byte[] row1 = Bytes.toBytes((String)"row1");
        byte[] fam1 = Bytes.toBytes((String)"fam1");
        byte[] qual = Bytes.toBytes((String)"qualifier");
        byte[] value = Bytes.toBytes((String)"value");
        Put put = new Put(row1);
        put.add(fam1, qual, 1L, value);
        put.add(fam1, qual, 2L, value);
        String method = this.getName();
        this.region = TestHRegion.initHRegion(this.tableName, method, conf, (byte[][])new byte[][]{fam1});
        try {
            this.region.put(put);
            Delete delete = new Delete(row1);
            delete.deleteColumn(fam1, qual);
            delete.deleteColumn(fam1, qual);
            this.region.delete(delete);
            Get get = new Get(row1);
            get.addFamily(fam1);
            Result r = this.region.get(get);
            Assert.assertEquals((long)0L, (long)r.size());
        }
        finally {
            HRegion.closeHRegion((HRegion)this.region);
            this.region = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDelete_CheckFamily() throws IOException {
        byte[] row1 = Bytes.toBytes((String)"row1");
        byte[] fam1 = Bytes.toBytes((String)"fam1");
        byte[] fam2 = Bytes.toBytes((String)"fam2");
        byte[] fam3 = Bytes.toBytes((String)"fam3");
        byte[] fam4 = Bytes.toBytes((String)"fam4");
        String method = this.getName();
        this.region = TestHRegion.initHRegion(this.tableName, method, conf, (byte[][])new byte[][]{fam1, fam2, fam3});
        try {
            ArrayList<KeyValue> kvs = new ArrayList<KeyValue>();
            kvs.add(new KeyValue(row1, fam4, null, null));
            byte[] family = fam2;
            try {
                TreeMap<byte[], ArrayList<KeyValue>> deleteMap = new TreeMap<byte[], ArrayList<KeyValue>>(Bytes.BYTES_COMPARATOR);
                deleteMap.put(family, kvs);
                this.region.delete(deleteMap, Durability.SYNC_WAL);
            }
            catch (Exception e) {
                Assert.assertTrue((String)("Family " + new String(family) + " does not exist"), (boolean)false);
            }
            boolean ok = false;
            family = fam4;
            try {
                TreeMap<byte[], ArrayList<KeyValue>> deleteMap = new TreeMap<byte[], ArrayList<KeyValue>>(Bytes.BYTES_COMPARATOR);
                deleteMap.put(family, kvs);
                this.region.delete(deleteMap, Durability.SYNC_WAL);
            }
            catch (Exception e) {
                ok = true;
            }
            Assert.assertEquals((String)("Family " + new String(family) + " does exist"), (Object)true, (Object)ok);
        }
        finally {
            HRegion.closeHRegion((HRegion)this.region);
            this.region = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDelete_mixed() throws IOException, InterruptedException {
        byte[] fam = Bytes.toBytes((String)"info");
        byte[][] families = new byte[][]{fam};
        String method = this.getName();
        this.region = TestHRegion.initHRegion(this.tableName, method, conf, (byte[][])families);
        try {
            EnvironmentEdgeManagerTestHelper.injectEdge((EnvironmentEdge)new IncrementingEnvironmentEdge());
            byte[] row = Bytes.toBytes((String)"table_name");
            byte[] serverinfo = Bytes.toBytes((String)"serverinfo");
            byte[] splitA = Bytes.toBytes((String)"splitA");
            byte[] splitB = Bytes.toBytes((String)"splitB");
            Put put = new Put(row);
            put.add(fam, splitA, Bytes.toBytes((String)"reference_A"));
            this.region.put(put);
            put = new Put(row);
            put.add(fam, splitB, Bytes.toBytes((String)"reference_B"));
            this.region.put(put);
            put = new Put(row);
            put.add(fam, serverinfo, Bytes.toBytes((String)"ip_address"));
            this.region.put(put);
            Delete delete = new Delete(row);
            delete.deleteColumns(fam, splitA);
            this.region.delete(delete);
            Get get = new Get(row).addColumn(fam, serverinfo);
            Result result = this.region.get(get);
            Assert.assertEquals((long)1L, (long)result.size());
            get = new Get(row).addColumn(fam, splitA);
            result = this.region.get(get);
            Assert.assertEquals((long)0L, (long)result.size());
            get = new Get(row).addColumn(fam, splitB);
            result = this.region.get(get);
            Assert.assertEquals((long)1L, (long)result.size());
            put = new Put(row);
            put.add(fam, splitA, Bytes.toBytes((String)"reference_A"));
            this.region.put(put);
            get = new Get(row);
            result = this.region.get(get);
            Assert.assertEquals((long)3L, (long)result.size());
            delete = new Delete(row);
            this.region.delete(delete);
            Assert.assertEquals((long)0L, (long)this.region.get(get).size());
            this.region.put(new Put(row).add(fam, splitA, Bytes.toBytes((String)"reference_A")));
            result = this.region.get(get);
            Assert.assertEquals((long)1L, (long)result.size());
        }
        finally {
            HRegion.closeHRegion((HRegion)this.region);
            this.region = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDeleteRowWithFutureTs() throws IOException {
        byte[] fam = Bytes.toBytes((String)"info");
        byte[][] families = new byte[][]{fam};
        String method = this.getName();
        this.region = TestHRegion.initHRegion(this.tableName, method, conf, (byte[][])families);
        try {
            byte[] row = Bytes.toBytes((String)"table_name");
            byte[] serverinfo = Bytes.toBytes((String)"serverinfo");
            Put put = new Put(row);
            put.add(fam, serverinfo, 0x7FFFFFFFFFFFFFFAL, Bytes.toBytes((String)"value"));
            this.region.put(put);
            Delete delete = new Delete(row);
            this.region.delete(delete);
            Get get = new Get(row).addColumn(fam, serverinfo);
            Result result = this.region.get(get);
            Assert.assertEquals((long)1L, (long)result.size());
            delete = new Delete(row, 0x7FFFFFFFFFFFFFFCL);
            this.region.delete(delete);
            get = new Get(row).addColumn(fam, serverinfo);
            result = this.region.get(get);
            Assert.assertEquals((long)0L, (long)result.size());
        }
        finally {
            HRegion.closeHRegion((HRegion)this.region);
            this.region = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPutWithLatestTS() throws IOException {
        byte[] fam = Bytes.toBytes((String)"info");
        byte[][] families = new byte[][]{fam};
        String method = this.getName();
        this.region = TestHRegion.initHRegion(this.tableName, method, conf, (byte[][])families);
        try {
            byte[] row = Bytes.toBytes((String)"row1");
            byte[] qual = Bytes.toBytes((String)"qual");
            Put put = new Put(row);
            put.add(fam, qual, Long.MAX_VALUE, Bytes.toBytes((String)"value"));
            this.region.put(put);
            Get get = new Get(row).addColumn(fam, qual);
            Result result = this.region.get(get);
            Assert.assertEquals((long)1L, (long)result.size());
            Cell kv = result.rawCells()[0];
            LOG.info((Object)("Got: " + kv));
            Assert.assertTrue((String)"LATEST_TIMESTAMP was not replaced with real timestamp", (kv.getTimestamp() != Long.MAX_VALUE ? 1 : 0) != 0);
            row = Bytes.toBytes((String)"row2");
            put = new Put(row);
            put.add(fam, qual, Long.MAX_VALUE, Bytes.toBytes((String)"value"));
            this.region.put(put);
            get = new Get(row).addColumn(fam, qual);
            result = this.region.get(get);
            Assert.assertEquals((long)1L, (long)result.size());
            kv = result.rawCells()[0];
            LOG.info((Object)("Got: " + kv));
            Assert.assertTrue((String)"LATEST_TIMESTAMP was not replaced with real timestamp", (kv.getTimestamp() != Long.MAX_VALUE ? 1 : 0) != 0);
        }
        finally {
            HRegion.closeHRegion((HRegion)this.region);
            this.region = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPutWithTsSlop() throws IOException {
        byte[] fam = Bytes.toBytes((String)"info");
        byte[][] families = new byte[][]{fam};
        String method = this.getName();
        conf.setInt("hbase.hregion.keyvalue.timestamp.slop.millisecs", 1000);
        this.region = TestHRegion.initHRegion(this.tableName, method, conf, (byte[][])families);
        boolean caughtExcep = false;
        try {
            try {
                this.region.put(new Put(this.row).add(fam, Bytes.toBytes((String)"qual"), Bytes.toBytes((String)"value")));
                this.region.put(new Put(this.row).add(fam, Bytes.toBytes((String)"qual"), System.currentTimeMillis() + 2000L, Bytes.toBytes((String)"value")));
                Assert.fail((String)"Expected IOE for TS out of configured timerange");
            }
            catch (FailedSanityCheckException ioe) {
                LOG.debug((Object)"Received expected exception", (Throwable)ioe);
                caughtExcep = true;
            }
            Assert.assertTrue((String)"Should catch FailedSanityCheckException", (boolean)caughtExcep);
        }
        finally {
            HRegion.closeHRegion((HRegion)this.region);
            this.region = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testScanner_DeleteOneFamilyNotAnother() throws IOException {
        byte[] fam1 = Bytes.toBytes((String)"columnA");
        byte[] fam2 = Bytes.toBytes((String)"columnB");
        this.region = TestHRegion.initHRegion(this.tableName, this.getName(), conf, (byte[][])new byte[][]{fam1, fam2});
        try {
            byte[] rowA = Bytes.toBytes((String)"rowA");
            byte[] rowB = Bytes.toBytes((String)"rowB");
            byte[] value = Bytes.toBytes((String)"value");
            Delete delete = new Delete(rowA);
            delete.deleteFamily(fam1);
            this.region.delete(delete);
            Put put = new Put(rowA);
            put.add(fam2, null, value);
            this.region.put(put);
            put = new Put(rowB);
            put.add(fam1, null, value);
            put.add(fam2, null, value);
            this.region.put(put);
            Scan scan = new Scan();
            scan.addFamily(fam1).addFamily(fam2);
            RegionScanner s = this.region.getScanner(scan);
            ArrayList results = new ArrayList();
            s.next(results);
            Assert.assertTrue((boolean)CellUtil.matchingRow((Cell)((Cell)results.get(0)), (byte[])rowA));
            results.clear();
            s.next(results);
            Assert.assertTrue((boolean)CellUtil.matchingRow((Cell)((Cell)results.get(0)), (byte[])rowB));
        }
        finally {
            HRegion.closeHRegion((HRegion)this.region);
            this.region = null;
        }
    }

    @Test
    public void testDeleteColumns_PostInsert() throws IOException, InterruptedException {
        Delete delete = new Delete(this.row);
        delete.deleteColumns(HBaseTestingUtility.fam1, this.qual1);
        this.doTestDelete_AndPostInsert(delete);
    }

    @Test
    public void testDeleteFamily_PostInsert() throws IOException, InterruptedException {
        Delete delete = new Delete(this.row);
        delete.deleteFamily(HBaseTestingUtility.fam1);
        this.doTestDelete_AndPostInsert(delete);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doTestDelete_AndPostInsert(Delete delete) throws IOException, InterruptedException {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        this.region = TestHRegion.initHRegion(tableName, this.getName(), conf, (byte[][])new byte[][]{HBaseTestingUtility.fam1});
        try {
            EnvironmentEdgeManagerTestHelper.injectEdge((EnvironmentEdge)new IncrementingEnvironmentEdge());
            Put put = new Put(this.row);
            put.add(HBaseTestingUtility.fam1, this.qual1, this.value1);
            this.region.put(put);
            this.region.delete(delete);
            put = new Put(this.row);
            put.add(HBaseTestingUtility.fam1, this.qual1, this.value2);
            this.region.put(put);
            Get get = new Get(this.row);
            get.addColumn(HBaseTestingUtility.fam1, this.qual1);
            Result r = this.region.get(get);
            Assert.assertEquals((long)1L, (long)r.size());
            Assert.assertArrayEquals((byte[])this.value2, (byte[])r.getValue(HBaseTestingUtility.fam1, this.qual1));
            Scan scan = new Scan(this.row);
            scan.addColumn(HBaseTestingUtility.fam1, this.qual1);
            RegionScanner s = this.region.getScanner(scan);
            ArrayList results = new ArrayList();
            Assert.assertEquals((Object)false, (Object)s.next(results));
            Assert.assertEquals((long)1L, (long)results.size());
            Cell kv = (Cell)results.get(0);
            Assert.assertArrayEquals((byte[])this.value2, (byte[])CellUtil.cloneValue((Cell)kv));
            Assert.assertArrayEquals((byte[])HBaseTestingUtility.fam1, (byte[])CellUtil.cloneFamily((Cell)kv));
            Assert.assertArrayEquals((byte[])this.qual1, (byte[])CellUtil.cloneQualifier((Cell)kv));
            Assert.assertArrayEquals((byte[])this.row, (byte[])CellUtil.cloneRow((Cell)kv));
        }
        finally {
            HRegion.closeHRegion((HRegion)this.region);
            this.region = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDelete_CheckTimestampUpdated() throws IOException {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        byte[] row1 = Bytes.toBytes((String)"row1");
        byte[] col1 = Bytes.toBytes((String)"col1");
        byte[] col2 = Bytes.toBytes((String)"col2");
        byte[] col3 = Bytes.toBytes((String)"col3");
        String method = this.getName();
        this.region = TestHRegion.initHRegion(tableName, method, conf, (byte[][])new byte[][]{HBaseTestingUtility.fam1});
        try {
            ArrayList<KeyValue> kvs = new ArrayList<KeyValue>();
            kvs.add(new KeyValue(row1, HBaseTestingUtility.fam1, col1, null));
            kvs.add(new KeyValue(row1, HBaseTestingUtility.fam1, col2, null));
            kvs.add(new KeyValue(row1, HBaseTestingUtility.fam1, col3, null));
            TreeMap<byte[], ArrayList<KeyValue>> deleteMap = new TreeMap<byte[], ArrayList<KeyValue>>(Bytes.BYTES_COMPARATOR);
            deleteMap.put(HBaseTestingUtility.fam1, kvs);
            this.region.delete(deleteMap, Durability.SYNC_WAL);
            long now = System.currentTimeMillis();
            KeyValue firstKv = ((HStore)this.region.getStore((byte[])HBaseTestingUtility.fam1)).memstore.kvset.first();
            Assert.assertTrue((firstKv.getTimestamp() <= now ? 1 : 0) != 0);
            now = firstKv.getTimestamp();
            for (KeyValue kv : ((HStore)this.region.getStore((byte[])HBaseTestingUtility.fam1)).memstore.kvset) {
                Assert.assertTrue((kv.getTimestamp() <= now ? 1 : 0) != 0);
                now = kv.getTimestamp();
            }
        }
        finally {
            HRegion.closeHRegion((HRegion)this.region);
            this.region = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGet_FamilyChecker() throws IOException {
        byte[] row1 = Bytes.toBytes((String)"row1");
        byte[] fam1 = Bytes.toBytes((String)"fam1");
        byte[] fam2 = Bytes.toBytes((String)"False");
        byte[] col1 = Bytes.toBytes((String)"col1");
        String method = this.getName();
        this.region = TestHRegion.initHRegion(this.tableName, method, conf, (byte[][])new byte[][]{fam1});
        try {
            Get get = new Get(row1);
            get.addColumn(fam2, col1);
            try {
                this.region.get(get);
            }
            catch (DoNotRetryIOException e) {
                Assert.assertFalse((boolean)false);
                HRegion.closeHRegion((HRegion)this.region);
                this.region = null;
                return;
            }
            Assert.assertFalse((boolean)true);
        }
        finally {
            HRegion.closeHRegion((HRegion)this.region);
            this.region = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGet_Basic() throws IOException {
        byte[] row1 = Bytes.toBytes((String)"row1");
        byte[] fam1 = Bytes.toBytes((String)"fam1");
        byte[] col1 = Bytes.toBytes((String)"col1");
        byte[] col2 = Bytes.toBytes((String)"col2");
        byte[] col3 = Bytes.toBytes((String)"col3");
        byte[] col4 = Bytes.toBytes((String)"col4");
        byte[] col5 = Bytes.toBytes((String)"col5");
        String method = this.getName();
        this.region = TestHRegion.initHRegion(this.tableName, method, conf, (byte[][])new byte[][]{fam1});
        try {
            Put put = new Put(row1);
            put.add(fam1, col1, null);
            put.add(fam1, col2, null);
            put.add(fam1, col3, null);
            put.add(fam1, col4, null);
            put.add(fam1, col5, null);
            this.region.put(put);
            Get get = new Get(row1);
            get.addColumn(fam1, col2);
            get.addColumn(fam1, col4);
            KeyValue kv1 = new KeyValue(row1, fam1, col2);
            KeyValue kv2 = new KeyValue(row1, fam1, col4);
            KeyValue[] expected = new KeyValue[]{kv1, kv2};
            Result res = this.region.get(get);
            Assert.assertEquals((long)expected.length, (long)res.size());
            for (int i = 0; i < res.size(); ++i) {
                Assert.assertTrue((boolean)CellUtil.matchingRow((Cell)expected[i], (Cell)res.rawCells()[i]));
                Assert.assertTrue((boolean)CellUtil.matchingFamily((Cell)expected[i], (Cell)res.rawCells()[i]));
                Assert.assertTrue((boolean)CellUtil.matchingQualifier((Cell)expected[i], (Cell)res.rawCells()[i]));
            }
            Get g = new Get(row1);
            int count = 2;
            g.setFilter((Filter)new ColumnCountGetFilter(2));
            res = this.region.get(g);
            Assert.assertEquals((long)2L, (long)res.size());
        }
        finally {
            HRegion.closeHRegion((HRegion)this.region);
            this.region = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGet_Empty() throws IOException {
        byte[] row = Bytes.toBytes((String)"row");
        byte[] fam = Bytes.toBytes((String)"fam");
        String method = this.getName();
        this.region = TestHRegion.initHRegion(this.tableName, method, conf, (byte[][])new byte[][]{fam});
        try {
            Get get = new Get(row);
            get.addFamily(fam);
            Result r = this.region.get(get);
            Assert.assertTrue((boolean)r.isEmpty());
        }
        finally {
            HRegion.closeHRegion((HRegion)this.region);
            this.region = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMerge() throws IOException {
        byte[][] families = new byte[][]{HBaseTestingUtility.fam1, HBaseTestingUtility.fam2, HBaseTestingUtility.fam3};
        Configuration hc = this.initSplit();
        String method = this.getName();
        this.region = TestHRegion.initHRegion(this.tableName, method, hc, (byte[][])families);
        try {
            LOG.info((Object)("" + HBaseTestCase.addContent(this.region, HBaseTestingUtility.fam3)));
            this.region.flushcache();
            this.region.compactStores();
            byte[] splitRow = this.region.checkSplit();
            Assert.assertNotNull((Object)splitRow);
            LOG.info((Object)("SplitRow: " + Bytes.toString((byte[])splitRow)));
            HRegion[] subregions = this.splitRegion(this.region, splitRow);
            try {
                for (int i = 0; i < subregions.length; ++i) {
                    HRegion.openHRegion((HRegion)subregions[i], null);
                    subregions[i].compactStores();
                }
                Path oldRegionPath = this.region.getRegionFileSystem().getRegionDir();
                Path oldRegion1 = subregions[0].getRegionFileSystem().getRegionDir();
                Path oldRegion2 = subregions[1].getRegionFileSystem().getRegionDir();
                long startTime = System.currentTimeMillis();
                this.region = HRegion.mergeAdjacent((HRegion)subregions[0], (HRegion)subregions[1]);
                LOG.info((Object)("Merge regions elapsed time: " + (double)(System.currentTimeMillis() - startTime) / 1000.0));
                fs.delete(oldRegion1, true);
                fs.delete(oldRegion2, true);
                fs.delete(oldRegionPath, true);
                LOG.info((Object)"splitAndMerge completed.");
            }
            finally {
                for (int i = 0; i < subregions.length; ++i) {
                    try {
                        HRegion.closeHRegion((HRegion)subregions[i]);
                        continue;
                    }
                    catch (IOException e) {}
                }
            }
        }
        finally {
            HRegion.closeHRegion((HRegion)this.region);
            this.region = null;
        }
    }

    HRegion[] splitRegion(HRegion parent, byte[] midkey) throws IOException {
        PairOfSameType result = null;
        SplitTransaction st = new SplitTransaction(parent, midkey);
        if (!st.prepare()) {
            return null;
        }
        try {
            result = st.execute(null, null);
        }
        catch (IOException ioe) {
            try {
                LOG.info((Object)("Running rollback of failed split of " + parent.getRegionNameAsString() + "; " + ioe.getMessage()));
                st.rollback(null, null);
                LOG.info((Object)("Successful rollback of failed split of " + parent.getRegionNameAsString()));
                return null;
            }
            catch (RuntimeException e) {
                LOG.info((Object)("Failed rollback of failed split of " + parent.getRegionNameAsString() + " -- aborting server"), (Throwable)e);
            }
        }
        return new HRegion[]{(HRegion)result.getFirst(), (HRegion)result.getSecond()};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetScanner_WithOkFamilies() throws IOException {
        byte[] fam1 = Bytes.toBytes((String)"fam1");
        byte[] fam2 = Bytes.toBytes((String)"fam2");
        byte[][] families = new byte[][]{fam1, fam2};
        String method = this.getName();
        this.region = TestHRegion.initHRegion(this.tableName, method, conf, (byte[][])families);
        try {
            Scan scan = new Scan();
            scan.addFamily(fam1);
            scan.addFamily(fam2);
            try {
                this.region.getScanner(scan);
            }
            catch (Exception e) {
                Assert.assertTrue((String)"Families could not be found in Region", (boolean)false);
            }
        }
        finally {
            HRegion.closeHRegion((HRegion)this.region);
            this.region = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetScanner_WithNotOkFamilies() throws IOException {
        byte[] fam1 = Bytes.toBytes((String)"fam1");
        byte[] fam2 = Bytes.toBytes((String)"fam2");
        byte[][] families = new byte[][]{fam1};
        String method = this.getName();
        this.region = TestHRegion.initHRegion(this.tableName, method, conf, (byte[][])families);
        try {
            Scan scan = new Scan();
            scan.addFamily(fam2);
            boolean ok = false;
            try {
                this.region.getScanner(scan);
            }
            catch (Exception e) {
                ok = true;
            }
            Assert.assertTrue((String)"Families could not be found in Region", (boolean)ok);
        }
        finally {
            HRegion.closeHRegion((HRegion)this.region);
            this.region = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetScanner_WithNoFamilies() throws IOException {
        byte[] row1 = Bytes.toBytes((String)"row1");
        byte[] fam1 = Bytes.toBytes((String)"fam1");
        byte[] fam2 = Bytes.toBytes((String)"fam2");
        byte[] fam3 = Bytes.toBytes((String)"fam3");
        byte[] fam4 = Bytes.toBytes((String)"fam4");
        byte[][] families = new byte[][]{fam1, fam2, fam3, fam4};
        String method = this.getName();
        this.region = TestHRegion.initHRegion(this.tableName, method, conf, (byte[][])families);
        try {
            Put put = new Put(row1);
            put.add(fam1, null, null);
            put.add(fam2, null, null);
            put.add(fam3, null, null);
            put.add(fam4, null, null);
            this.region.put(put);
            Scan scan = null;
            HRegion.RegionScannerImpl is = null;
            scan = new Scan();
            scan.addFamily(fam2);
            scan.addFamily(fam4);
            is = (HRegion.RegionScannerImpl)this.region.getScanner(scan);
            MultiVersionConsistencyControl.resetThreadReadPoint((MultiVersionConsistencyControl)this.region.getMVCC());
            Assert.assertEquals((long)1L, (long)is.storeHeap.getHeap().size());
            scan = new Scan();
            is = (HRegion.RegionScannerImpl)this.region.getScanner(scan);
            MultiVersionConsistencyControl.resetThreadReadPoint((MultiVersionConsistencyControl)this.region.getMVCC());
            Assert.assertEquals((long)(families.length - 1), (long)is.storeHeap.getHeap().size());
        }
        finally {
            HRegion.closeHRegion((HRegion)this.region);
            this.region = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetScanner_WithRegionClosed() throws IOException {
        byte[] fam1 = Bytes.toBytes((String)"fam1");
        byte[] fam2 = Bytes.toBytes((String)"fam2");
        byte[][] families = new byte[][]{fam1, fam2};
        String method = this.getName();
        try {
            this.region = TestHRegion.initHRegion(this.tableName, method, conf, (byte[][])families);
        }
        catch (IOException e) {
            e.printStackTrace();
            Assert.fail((String)("Got IOException during initHRegion, " + e.getMessage()));
        }
        try {
            this.region.closed.set(true);
            try {
                this.region.getScanner(null);
                Assert.fail((String)"Expected to get an exception during getScanner on a region that is closed");
            }
            catch (NotServingRegionException e) {
            }
            catch (IOException e) {
                Assert.fail((String)("Got wrong type of exception - should be a NotServingRegionException, but was an IOException: " + e.getMessage()));
            }
        }
        finally {
            HRegion.closeHRegion((HRegion)this.region);
            this.region = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRegionScanner_Next() throws IOException {
        byte[] row1 = Bytes.toBytes((String)"row1");
        byte[] row2 = Bytes.toBytes((String)"row2");
        byte[] fam1 = Bytes.toBytes((String)"fam1");
        byte[] fam2 = Bytes.toBytes((String)"fam2");
        byte[] fam3 = Bytes.toBytes((String)"fam3");
        byte[] fam4 = Bytes.toBytes((String)"fam4");
        byte[][] families = new byte[][]{fam1, fam2, fam3, fam4};
        long ts = System.currentTimeMillis();
        String method = this.getName();
        this.region = TestHRegion.initHRegion(this.tableName, method, conf, (byte[][])families);
        try {
            Put put = null;
            put = new Put(row1);
            put.add(fam1, null, ts, null);
            put.add(fam2, null, ts, null);
            put.add(fam3, null, ts, null);
            put.add(fam4, null, ts, null);
            this.region.put(put);
            put = new Put(row2);
            put.add(fam1, null, ts, null);
            put.add(fam2, null, ts, null);
            put.add(fam3, null, ts, null);
            put.add(fam4, null, ts, null);
            this.region.put(put);
            Scan scan = new Scan();
            scan.addFamily(fam2);
            scan.addFamily(fam4);
            RegionScanner is = this.region.getScanner(scan);
            ArrayList res = null;
            ArrayList<KeyValue> expected1 = new ArrayList<KeyValue>();
            expected1.add(new KeyValue(row1, fam2, null, ts, KeyValue.Type.Put, null));
            expected1.add(new KeyValue(row1, fam4, null, ts, KeyValue.Type.Put, null));
            res = new ArrayList();
            is.next(res);
            for (int i = 0; i < res.size(); ++i) {
                Assert.assertTrue((boolean)CellComparator.equalsIgnoreMvccVersion((Cell)((Cell)expected1.get(i)), (Cell)((Cell)res.get(i))));
            }
            ArrayList<KeyValue> expected2 = new ArrayList<KeyValue>();
            expected2.add(new KeyValue(row2, fam2, null, ts, KeyValue.Type.Put, null));
            expected2.add(new KeyValue(row2, fam4, null, ts, KeyValue.Type.Put, null));
            res = new ArrayList();
            is.next(res);
            for (int i = 0; i < res.size(); ++i) {
                Assert.assertTrue((boolean)CellComparator.equalsIgnoreMvccVersion((Cell)((Cell)expected2.get(i)), (Cell)((Cell)res.get(i))));
            }
        }
        finally {
            HRegion.closeHRegion((HRegion)this.region);
            this.region = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testScanner_ExplicitColumns_FromMemStore_EnforceVersions() throws IOException {
        byte[] row1 = Bytes.toBytes((String)"row1");
        byte[] qf1 = Bytes.toBytes((String)"qualifier1");
        byte[] qf2 = Bytes.toBytes((String)"qualifier2");
        byte[] fam1 = Bytes.toBytes((String)"fam1");
        byte[][] families = new byte[][]{fam1};
        long ts1 = System.currentTimeMillis();
        long ts2 = ts1 + 1L;
        long ts3 = ts1 + 2L;
        String method = this.getName();
        this.region = TestHRegion.initHRegion(this.tableName, method, conf, (byte[][])families);
        try {
            Put put = null;
            KeyValue kv13 = new KeyValue(row1, fam1, qf1, ts3, KeyValue.Type.Put, null);
            KeyValue kv12 = new KeyValue(row1, fam1, qf1, ts2, KeyValue.Type.Put, null);
            KeyValue kv11 = new KeyValue(row1, fam1, qf1, ts1, KeyValue.Type.Put, null);
            KeyValue kv23 = new KeyValue(row1, fam1, qf2, ts3, KeyValue.Type.Put, null);
            KeyValue kv22 = new KeyValue(row1, fam1, qf2, ts2, KeyValue.Type.Put, null);
            KeyValue kv21 = new KeyValue(row1, fam1, qf2, ts1, KeyValue.Type.Put, null);
            put = new Put(row1);
            put.add((Cell)kv13);
            put.add((Cell)kv12);
            put.add((Cell)kv11);
            put.add((Cell)kv23);
            put.add((Cell)kv22);
            put.add((Cell)kv21);
            this.region.put(put);
            ArrayList<KeyValue> expected = new ArrayList<KeyValue>();
            expected.add(kv13);
            expected.add(kv12);
            Scan scan = new Scan(row1);
            scan.addColumn(fam1, qf1);
            scan.setMaxVersions(2);
            ArrayList actual = new ArrayList();
            RegionScanner scanner = this.region.getScanner(scan);
            boolean hasNext = scanner.next(actual);
            Assert.assertEquals((Object)false, (Object)hasNext);
            for (int i = 0; i < expected.size(); ++i) {
                Assert.assertEquals(expected.get(i), actual.get(i));
            }
        }
        finally {
            HRegion.closeHRegion((HRegion)this.region);
            this.region = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testScanner_ExplicitColumns_FromFilesOnly_EnforceVersions() throws IOException {
        byte[] row1 = Bytes.toBytes((String)"row1");
        byte[] qf1 = Bytes.toBytes((String)"qualifier1");
        byte[] qf2 = Bytes.toBytes((String)"qualifier2");
        byte[] fam1 = Bytes.toBytes((String)"fam1");
        byte[][] families = new byte[][]{fam1};
        long ts1 = 1L;
        long ts2 = ts1 + 1L;
        long ts3 = ts1 + 2L;
        String method = this.getName();
        this.region = TestHRegion.initHRegion(this.tableName, method, conf, (byte[][])families);
        try {
            Put put = null;
            KeyValue kv13 = new KeyValue(row1, fam1, qf1, ts3, KeyValue.Type.Put, null);
            KeyValue kv12 = new KeyValue(row1, fam1, qf1, ts2, KeyValue.Type.Put, null);
            KeyValue kv11 = new KeyValue(row1, fam1, qf1, ts1, KeyValue.Type.Put, null);
            KeyValue kv23 = new KeyValue(row1, fam1, qf2, ts3, KeyValue.Type.Put, null);
            KeyValue kv22 = new KeyValue(row1, fam1, qf2, ts2, KeyValue.Type.Put, null);
            KeyValue kv21 = new KeyValue(row1, fam1, qf2, ts1, KeyValue.Type.Put, null);
            put = new Put(row1);
            put.add((Cell)kv13);
            put.add((Cell)kv12);
            put.add((Cell)kv11);
            put.add((Cell)kv23);
            put.add((Cell)kv22);
            put.add((Cell)kv21);
            this.region.put(put);
            this.region.flushcache();
            ArrayList<KeyValue> expected = new ArrayList<KeyValue>();
            expected.add(kv13);
            expected.add(kv12);
            expected.add(kv23);
            expected.add(kv22);
            Scan scan = new Scan(row1);
            scan.addColumn(fam1, qf1);
            scan.addColumn(fam1, qf2);
            scan.setMaxVersions(2);
            ArrayList actual = new ArrayList();
            RegionScanner scanner = this.region.getScanner(scan);
            boolean hasNext = scanner.next(actual);
            Assert.assertEquals((Object)false, (Object)hasNext);
            for (int i = 0; i < expected.size(); ++i) {
                Assert.assertTrue((boolean)CellComparator.equalsIgnoreMvccVersion((Cell)((Cell)expected.get(i)), (Cell)((Cell)actual.get(i))));
            }
        }
        finally {
            HRegion.closeHRegion((HRegion)this.region);
            this.region = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testScanner_ExplicitColumns_FromMemStoreAndFiles_EnforceVersions() throws IOException {
        byte[] row1 = Bytes.toBytes((String)"row1");
        byte[] fam1 = Bytes.toBytes((String)"fam1");
        byte[][] families = new byte[][]{fam1};
        byte[] qf1 = Bytes.toBytes((String)"qualifier1");
        byte[] qf2 = Bytes.toBytes((String)"qualifier2");
        long ts1 = 1L;
        long ts2 = ts1 + 1L;
        long ts3 = ts1 + 2L;
        long ts4 = ts1 + 3L;
        String method = this.getName();
        this.region = TestHRegion.initHRegion(this.tableName, method, conf, (byte[][])families);
        try {
            KeyValue kv14 = new KeyValue(row1, fam1, qf1, ts4, KeyValue.Type.Put, null);
            KeyValue kv13 = new KeyValue(row1, fam1, qf1, ts3, KeyValue.Type.Put, null);
            KeyValue kv12 = new KeyValue(row1, fam1, qf1, ts2, KeyValue.Type.Put, null);
            KeyValue kv11 = new KeyValue(row1, fam1, qf1, ts1, KeyValue.Type.Put, null);
            KeyValue kv24 = new KeyValue(row1, fam1, qf2, ts4, KeyValue.Type.Put, null);
            KeyValue kv23 = new KeyValue(row1, fam1, qf2, ts3, KeyValue.Type.Put, null);
            KeyValue kv22 = new KeyValue(row1, fam1, qf2, ts2, KeyValue.Type.Put, null);
            KeyValue kv21 = new KeyValue(row1, fam1, qf2, ts1, KeyValue.Type.Put, null);
            Put put = null;
            put = new Put(row1);
            put.add((Cell)kv14);
            put.add((Cell)kv24);
            this.region.put(put);
            this.region.flushcache();
            put = new Put(row1);
            put.add((Cell)kv23);
            put.add((Cell)kv13);
            this.region.put(put);
            this.region.flushcache();
            put = new Put(row1);
            put.add((Cell)kv22);
            put.add((Cell)kv12);
            this.region.put(put);
            this.region.flushcache();
            put = new Put(row1);
            put.add((Cell)kv21);
            put.add((Cell)kv11);
            this.region.put(put);
            ArrayList<KeyValue> expected = new ArrayList<KeyValue>();
            expected.add(kv14);
            expected.add(kv13);
            expected.add(kv12);
            expected.add(kv24);
            expected.add(kv23);
            expected.add(kv22);
            Scan scan = new Scan(row1);
            scan.addColumn(fam1, qf1);
            scan.addColumn(fam1, qf2);
            int versions = 3;
            scan.setMaxVersions(versions);
            ArrayList actual = new ArrayList();
            RegionScanner scanner = this.region.getScanner(scan);
            boolean hasNext = scanner.next(actual);
            Assert.assertEquals((Object)false, (Object)hasNext);
            for (int i = 0; i < expected.size(); ++i) {
                Assert.assertTrue((boolean)CellComparator.equalsIgnoreMvccVersion((Cell)((Cell)expected.get(i)), (Cell)((Cell)actual.get(i))));
            }
        }
        finally {
            HRegion.closeHRegion((HRegion)this.region);
            this.region = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testScanner_Wildcard_FromMemStore_EnforceVersions() throws IOException {
        byte[] row1 = Bytes.toBytes((String)"row1");
        byte[] qf1 = Bytes.toBytes((String)"qualifier1");
        byte[] qf2 = Bytes.toBytes((String)"qualifier2");
        byte[] fam1 = Bytes.toBytes((String)"fam1");
        byte[][] families = new byte[][]{fam1};
        long ts1 = System.currentTimeMillis();
        long ts2 = ts1 + 1L;
        long ts3 = ts1 + 2L;
        String method = this.getName();
        this.region = TestHRegion.initHRegion(this.tableName, method, conf, (byte[][])families);
        try {
            Put put = null;
            KeyValue kv13 = new KeyValue(row1, fam1, qf1, ts3, KeyValue.Type.Put, null);
            KeyValue kv12 = new KeyValue(row1, fam1, qf1, ts2, KeyValue.Type.Put, null);
            KeyValue kv11 = new KeyValue(row1, fam1, qf1, ts1, KeyValue.Type.Put, null);
            KeyValue kv23 = new KeyValue(row1, fam1, qf2, ts3, KeyValue.Type.Put, null);
            KeyValue kv22 = new KeyValue(row1, fam1, qf2, ts2, KeyValue.Type.Put, null);
            KeyValue kv21 = new KeyValue(row1, fam1, qf2, ts1, KeyValue.Type.Put, null);
            put = new Put(row1);
            put.add((Cell)kv13);
            put.add((Cell)kv12);
            put.add((Cell)kv11);
            put.add((Cell)kv23);
            put.add((Cell)kv22);
            put.add((Cell)kv21);
            this.region.put(put);
            ArrayList<KeyValue> expected = new ArrayList<KeyValue>();
            expected.add(kv13);
            expected.add(kv12);
            expected.add(kv23);
            expected.add(kv22);
            Scan scan = new Scan(row1);
            scan.addFamily(fam1);
            scan.setMaxVersions(2);
            ArrayList actual = new ArrayList();
            RegionScanner scanner = this.region.getScanner(scan);
            boolean hasNext = scanner.next(actual);
            Assert.assertEquals((Object)false, (Object)hasNext);
            for (int i = 0; i < expected.size(); ++i) {
                Assert.assertEquals(expected.get(i), actual.get(i));
            }
        }
        finally {
            HRegion.closeHRegion((HRegion)this.region);
            this.region = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testScanner_Wildcard_FromFilesOnly_EnforceVersions() throws IOException {
        byte[] row1 = Bytes.toBytes((String)"row1");
        byte[] qf1 = Bytes.toBytes((String)"qualifier1");
        byte[] qf2 = Bytes.toBytes((String)"qualifier2");
        byte[] fam1 = Bytes.toBytes((String)"fam1");
        long ts1 = 1L;
        long ts2 = ts1 + 1L;
        long ts3 = ts1 + 2L;
        String method = this.getName();
        this.region = TestHRegion.initHRegion(this.tableName, method, conf, (byte[][])new byte[][]{fam1});
        try {
            Put put = null;
            KeyValue kv13 = new KeyValue(row1, fam1, qf1, ts3, KeyValue.Type.Put, null);
            KeyValue kv12 = new KeyValue(row1, fam1, qf1, ts2, KeyValue.Type.Put, null);
            KeyValue kv11 = new KeyValue(row1, fam1, qf1, ts1, KeyValue.Type.Put, null);
            KeyValue kv23 = new KeyValue(row1, fam1, qf2, ts3, KeyValue.Type.Put, null);
            KeyValue kv22 = new KeyValue(row1, fam1, qf2, ts2, KeyValue.Type.Put, null);
            KeyValue kv21 = new KeyValue(row1, fam1, qf2, ts1, KeyValue.Type.Put, null);
            put = new Put(row1);
            put.add((Cell)kv13);
            put.add((Cell)kv12);
            put.add((Cell)kv11);
            put.add((Cell)kv23);
            put.add((Cell)kv22);
            put.add((Cell)kv21);
            this.region.put(put);
            this.region.flushcache();
            ArrayList<KeyValue> expected = new ArrayList<KeyValue>();
            expected.add(kv13);
            expected.add(kv12);
            expected.add(kv23);
            expected.add(kv22);
            Scan scan = new Scan(row1);
            scan.addFamily(fam1);
            scan.setMaxVersions(2);
            ArrayList actual = new ArrayList();
            RegionScanner scanner = this.region.getScanner(scan);
            boolean hasNext = scanner.next(actual);
            Assert.assertEquals((Object)false, (Object)hasNext);
            for (int i = 0; i < expected.size(); ++i) {
                Assert.assertTrue((boolean)CellComparator.equalsIgnoreMvccVersion((Cell)((Cell)expected.get(i)), (Cell)((Cell)actual.get(i))));
            }
        }
        finally {
            HRegion.closeHRegion((HRegion)this.region);
            this.region = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testScanner_StopRow1542() throws IOException {
        byte[] family = Bytes.toBytes((String)"testFamily");
        this.region = TestHRegion.initHRegion(this.tableName, this.getName(), conf, (byte[][])new byte[][]{family});
        try {
            byte[] row1 = Bytes.toBytes((String)"row111");
            byte[] row2 = Bytes.toBytes((String)"row222");
            byte[] row3 = Bytes.toBytes((String)"row333");
            byte[] row4 = Bytes.toBytes((String)"row444");
            byte[] row5 = Bytes.toBytes((String)"row555");
            byte[] col1 = Bytes.toBytes((String)"Pub111");
            byte[] col2 = Bytes.toBytes((String)"Pub222");
            Put put = new Put(row1);
            put.add(family, col1, Bytes.toBytes((long)10L));
            this.region.put(put);
            put = new Put(row2);
            put.add(family, col1, Bytes.toBytes((long)15L));
            this.region.put(put);
            put = new Put(row3);
            put.add(family, col2, Bytes.toBytes((long)20L));
            this.region.put(put);
            put = new Put(row4);
            put.add(family, col2, Bytes.toBytes((long)30L));
            this.region.put(put);
            put = new Put(row5);
            put.add(family, col1, Bytes.toBytes((long)40L));
            this.region.put(put);
            Scan scan = new Scan(row3, row4);
            scan.setMaxVersions();
            scan.addColumn(family, col1);
            RegionScanner s = this.region.getScanner(scan);
            ArrayList results = new ArrayList();
            Assert.assertEquals((Object)false, (Object)s.next(results));
            Assert.assertEquals((long)0L, (long)results.size());
        }
        finally {
            HRegion.closeHRegion((HRegion)this.region);
            this.region = null;
        }
    }

    private void assertICV(byte[] row, byte[] familiy, byte[] qualifier, long amount) throws IOException {
        Get get = new Get(row);
        get.addColumn(familiy, qualifier);
        Result result = this.region.get(get);
        Assert.assertEquals((long)1L, (long)result.size());
        Cell kv = result.rawCells()[0];
        long r = Bytes.toLong((byte[])CellUtil.cloneValue((Cell)kv));
        Assert.assertEquals((long)amount, (long)r);
    }

    private void assertICV(byte[] row, byte[] familiy, byte[] qualifier, int amount) throws IOException {
        Get get = new Get(row);
        get.addColumn(familiy, qualifier);
        Result result = this.region.get(get);
        Assert.assertEquals((long)1L, (long)result.size());
        Cell kv = result.rawCells()[0];
        int r = Bytes.toInt((byte[])CellUtil.cloneValue((Cell)kv));
        Assert.assertEquals((long)amount, (long)r);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testScanner_Wildcard_FromMemStoreAndFiles_EnforceVersions() throws IOException {
        byte[] row1 = Bytes.toBytes((String)"row1");
        byte[] fam1 = Bytes.toBytes((String)"fam1");
        byte[] qf1 = Bytes.toBytes((String)"qualifier1");
        byte[] qf2 = Bytes.toBytes((String)"quateslifier2");
        long ts1 = 1L;
        long ts2 = ts1 + 1L;
        long ts3 = ts1 + 2L;
        long ts4 = ts1 + 3L;
        String method = this.getName();
        this.region = TestHRegion.initHRegion(this.tableName, method, conf, (byte[][])new byte[][]{fam1});
        try {
            KeyValue kv14 = new KeyValue(row1, fam1, qf1, ts4, KeyValue.Type.Put, null);
            KeyValue kv13 = new KeyValue(row1, fam1, qf1, ts3, KeyValue.Type.Put, null);
            KeyValue kv12 = new KeyValue(row1, fam1, qf1, ts2, KeyValue.Type.Put, null);
            KeyValue kv11 = new KeyValue(row1, fam1, qf1, ts1, KeyValue.Type.Put, null);
            KeyValue kv24 = new KeyValue(row1, fam1, qf2, ts4, KeyValue.Type.Put, null);
            KeyValue kv23 = new KeyValue(row1, fam1, qf2, ts3, KeyValue.Type.Put, null);
            KeyValue kv22 = new KeyValue(row1, fam1, qf2, ts2, KeyValue.Type.Put, null);
            KeyValue kv21 = new KeyValue(row1, fam1, qf2, ts1, KeyValue.Type.Put, null);
            Put put = null;
            put = new Put(row1);
            put.add((Cell)kv14);
            put.add((Cell)kv24);
            this.region.put(put);
            this.region.flushcache();
            put = new Put(row1);
            put.add((Cell)kv23);
            put.add((Cell)kv13);
            this.region.put(put);
            this.region.flushcache();
            put = new Put(row1);
            put.add((Cell)kv22);
            put.add((Cell)kv12);
            this.region.put(put);
            this.region.flushcache();
            put = new Put(row1);
            put.add((Cell)kv21);
            put.add((Cell)kv11);
            this.region.put(put);
            ArrayList<KeyValue> expected = new ArrayList<KeyValue>();
            expected.add(kv14);
            expected.add(kv13);
            expected.add(kv12);
            expected.add(kv24);
            expected.add(kv23);
            expected.add(kv22);
            Scan scan = new Scan(row1);
            int versions = 3;
            scan.setMaxVersions(versions);
            ArrayList actual = new ArrayList();
            RegionScanner scanner = this.region.getScanner(scan);
            boolean hasNext = scanner.next(actual);
            Assert.assertEquals((Object)false, (Object)hasNext);
            for (int i = 0; i < expected.size(); ++i) {
                Assert.assertTrue((boolean)CellComparator.equalsIgnoreMvccVersion((Cell)((Cell)expected.get(i)), (Cell)((Cell)actual.get(i))));
            }
        }
        finally {
            HRegion.closeHRegion((HRegion)this.region);
            this.region = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testScanner_JoinedScanners() throws IOException {
        byte[] cf_essential = Bytes.toBytes((String)"essential");
        byte[] cf_joined = Bytes.toBytes((String)"joined");
        byte[] cf_alpha = Bytes.toBytes((String)"alpha");
        this.region = TestHRegion.initHRegion(this.tableName, this.getName(), conf, (byte[][])new byte[][]{cf_essential, cf_joined, cf_alpha});
        try {
            byte[] row1 = Bytes.toBytes((String)"row1");
            byte[] row2 = Bytes.toBytes((String)"row2");
            byte[] row3 = Bytes.toBytes((String)"row3");
            byte[] col_normal = Bytes.toBytes((String)"d");
            byte[] col_alpha = Bytes.toBytes((String)"a");
            byte[] filtered_val = Bytes.toBytes((int)3);
            Put put = new Put(row1);
            put.add(cf_essential, col_normal, Bytes.toBytes((int)1));
            put.add(cf_joined, col_alpha, Bytes.toBytes((int)1));
            this.region.put(put);
            put = new Put(row2);
            put.add(cf_essential, col_alpha, Bytes.toBytes((int)2));
            put.add(cf_joined, col_normal, Bytes.toBytes((int)2));
            put.add(cf_alpha, col_alpha, Bytes.toBytes((int)2));
            this.region.put(put);
            put = new Put(row3);
            put.add(cf_essential, col_normal, filtered_val);
            put.add(cf_joined, col_normal, filtered_val);
            this.region.put(put);
            Scan scan = new Scan();
            SingleColumnValueExcludeFilter filter = new SingleColumnValueExcludeFilter(cf_essential, col_normal, CompareFilter.CompareOp.NOT_EQUAL, filtered_val);
            scan.setFilter((Filter)filter);
            scan.setLoadColumnFamiliesOnDemand(true);
            RegionScanner s = this.region.getScanner(scan);
            ArrayList results = new ArrayList();
            Assert.assertTrue((boolean)s.next(results));
            Assert.assertEquals((long)results.size(), (long)1L);
            results.clear();
            Assert.assertTrue((boolean)s.next(results));
            Assert.assertEquals((long)results.size(), (long)3L);
            Assert.assertTrue((String)"orderCheck", (boolean)CellUtil.matchingFamily((Cell)((Cell)results.get(0)), (byte[])cf_alpha));
            Assert.assertTrue((String)"orderCheck", (boolean)CellUtil.matchingFamily((Cell)((Cell)results.get(1)), (byte[])cf_essential));
            Assert.assertTrue((String)"orderCheck", (boolean)CellUtil.matchingFamily((Cell)((Cell)results.get(2)), (byte[])cf_joined));
            results.clear();
            Assert.assertFalse((boolean)s.next(results));
            Assert.assertEquals((long)results.size(), (long)0L);
        }
        finally {
            HRegion.closeHRegion((HRegion)this.region);
            this.region = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testScanner_JoinedScannersWithLimits() throws IOException {
        final byte[] cf_first = Bytes.toBytes((String)"first");
        byte[] cf_second = Bytes.toBytes((String)"second");
        this.region = TestHRegion.initHRegion(this.tableName, this.getName(), conf, (byte[][])new byte[][]{cf_first, cf_second});
        try {
            boolean more;
            byte[] col_a = Bytes.toBytes((String)"a");
            byte[] col_b = Bytes.toBytes((String)"b");
            for (int i = 0; i < 10; ++i) {
                Put put = new Put(Bytes.toBytes((String)("r" + Integer.toString(i))));
                put.add(cf_first, col_a, Bytes.toBytes((int)i));
                if (i < 5) {
                    put.add(cf_first, col_b, Bytes.toBytes((int)i));
                    put.add(cf_second, col_a, Bytes.toBytes((int)i));
                    put.add(cf_second, col_b, Bytes.toBytes((int)i));
                }
                this.region.put(put);
            }
            Scan scan = new Scan();
            scan.setLoadColumnFamiliesOnDemand(true);
            FilterBase bogusFilter = new FilterBase(){

                public boolean isFamilyEssential(byte[] name) {
                    return Bytes.equals((byte[])name, (byte[])cf_first);
                }
            };
            scan.setFilter((Filter)bogusFilter);
            RegionScanner s = this.region.getScanner(scan);
            ArrayList results = new ArrayList();
            int index = 0;
            do {
                more = s.next(results, 3);
                if (index >> 1 < 5) {
                    if (index % 2 == 0) {
                        Assert.assertEquals((long)results.size(), (long)3L);
                    } else {
                        Assert.assertEquals((long)results.size(), (long)1L);
                    }
                } else {
                    Assert.assertEquals((long)results.size(), (long)1L);
                }
                results.clear();
                ++index;
            } while (more);
        }
        finally {
            HRegion.closeHRegion((HRegion)this.region);
            this.region = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBasicSplit() throws Exception {
        byte[][] families = new byte[][]{HBaseTestingUtility.fam1, HBaseTestingUtility.fam2, HBaseTestingUtility.fam3};
        Configuration hc = this.initSplit();
        String method = this.getName();
        this.region = TestHRegion.initHRegion(this.tableName, method, hc, (byte[][])families);
        try {
            LOG.info((Object)("" + HBaseTestCase.addContent(this.region, HBaseTestingUtility.fam3)));
            this.region.flushcache();
            this.region.compactStores();
            byte[] splitRow = this.region.checkSplit();
            Assert.assertNotNull((Object)splitRow);
            LOG.info((Object)("SplitRow: " + Bytes.toString((byte[])splitRow)));
            HRegion[] regions = this.splitRegion(this.region, splitRow);
            try {
                int i;
                for (i = 0; i < regions.length; ++i) {
                    regions[i] = HRegion.openHRegion((HRegion)regions[i], null);
                }
                this.assertGet(regions[0], HBaseTestingUtility.fam3, Bytes.toBytes((String)HBaseTestingUtility.START_KEY));
                this.assertGet(regions[1], HBaseTestingUtility.fam3, splitRow);
                this.assertScan(regions[0], HBaseTestingUtility.fam3, Bytes.toBytes((String)HBaseTestingUtility.START_KEY));
                this.assertScan(regions[1], HBaseTestingUtility.fam3, splitRow);
                for (i = 0; i < regions.length; ++i) {
                    for (int j = 0; j < 2; ++j) {
                        HBaseTestCase.addContent(regions[i], HBaseTestingUtility.fam3);
                    }
                    HBaseTestCase.addContent(regions[i], HBaseTestingUtility.fam2);
                    HBaseTestCase.addContent(regions[i], HBaseTestingUtility.fam1);
                    regions[i].flushcache();
                }
                byte[][] midkeys = new byte[regions.length][];
                for (int i2 = 0; i2 < regions.length; ++i2) {
                    regions[i2].compactStores();
                    midkeys[i2] = regions[i2].checkSplit();
                }
                TreeMap<String, HRegion> sortedMap = new TreeMap<String, HRegion>();
                for (int i3 = 0; i3 < regions.length; ++i3) {
                    HRegion[] rs = null;
                    if (midkeys[i3] == null) continue;
                    rs = this.splitRegion(regions[i3], midkeys[i3]);
                    for (int j = 0; j < rs.length; ++j) {
                        sortedMap.put(Bytes.toString((byte[])rs[j].getRegionName()), HRegion.openHRegion((HRegion)rs[j], null));
                    }
                }
                LOG.info((Object)"Made 4 regions");
                int interval = 8;
                byte[] b = Bytes.toBytes((String)HBaseTestingUtility.START_KEY);
                for (HRegion r : sortedMap.values()) {
                    this.assertGet(r, HBaseTestingUtility.fam3, b);
                    b[0] = (byte)(b[0] + interval);
                }
            }
            finally {
                for (int i = 0; i < regions.length; ++i) {
                    try {
                        regions[i].close();
                        continue;
                    }
                    catch (IOException e) {}
                }
            }
        }
        finally {
            HRegion.closeHRegion((HRegion)this.region);
            this.region = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSplitRegion() throws IOException {
        byte[] qualifier = Bytes.toBytes((String)"qualifier");
        Configuration hc = this.initSplit();
        int numRows = 10;
        byte[][] families = new byte[][]{HBaseTestingUtility.fam1, HBaseTestingUtility.fam3};
        String method = this.getName();
        this.region = TestHRegion.initHRegion(this.tableName, method, hc, (byte[][])families);
        int startRow = 100;
        this.putData(startRow, numRows, qualifier, families);
        int splitRow = startRow + numRows;
        this.putData(splitRow, numRows, qualifier, families);
        this.region.flushcache();
        HRegion[] regions = null;
        try {
            regions = this.splitRegion(this.region, Bytes.toBytes((String)("" + splitRow)));
            for (int i = 0; i < regions.length; ++i) {
                regions[i] = HRegion.openHRegion((HRegion)regions[i], null);
            }
            Assert.assertEquals((long)2L, (long)regions.length);
            this.verifyData(regions[0], startRow, numRows, qualifier, families);
            this.verifyData(regions[1], splitRow, numRows, qualifier, families);
        }
        finally {
            HRegion.closeHRegion((HRegion)this.region);
            this.region = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFlushCacheWhileScanning() throws IOException, InterruptedException {
        byte[] family = Bytes.toBytes((String)"family");
        int numRows = 1000;
        int flushAndScanInterval = 10;
        int compactInterval = 10 * flushAndScanInterval;
        String method = "testFlushCacheWhileScanning";
        this.region = TestHRegion.initHRegion(this.tableName, method, conf, (byte[][])new byte[][]{family});
        try {
            FlushThread flushThread = new FlushThread();
            flushThread.start();
            Scan scan = new Scan();
            scan.addFamily(family);
            scan.setFilter((Filter)new SingleColumnValueFilter(family, this.qual1, CompareFilter.CompareOp.EQUAL, (ByteArrayComparable)new BinaryComparator(Bytes.toBytes((long)5L))));
            int expectedCount = 0;
            ArrayList res = new ArrayList();
            boolean toggle = true;
            for (long i = 0L; i < (long)numRows; ++i) {
                Put put = new Put(Bytes.toBytes((long)i));
                put.setDurability(Durability.SKIP_WAL);
                put.add(family, this.qual1, Bytes.toBytes((long)(i % 10L)));
                this.region.put(put);
                if (i != 0L && i % (long)compactInterval == 0L) {
                    this.region.compactStores(true);
                }
                if (i % 10L == 5L) {
                    ++expectedCount;
                }
                if (i == 0L || i % (long)flushAndScanInterval != 0L) continue;
                res.clear();
                RegionScanner scanner = this.region.getScanner(scan);
                if (toggle) {
                    flushThread.flush();
                }
                while (scanner.next(res)) {
                }
                if (!toggle) {
                    flushThread.flush();
                }
                Assert.assertEquals((String)("i=" + i), (long)expectedCount, (long)res.size());
                toggle = !toggle;
            }
            flushThread.done();
            flushThread.join();
            flushThread.checkNoError();
        }
        finally {
            HRegion.closeHRegion((HRegion)this.region);
            this.region = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWritesWhileScanning() throws IOException, InterruptedException {
        int testCount = 100;
        int numRows = 1;
        int numFamilies = 10;
        int numQualifiers = 100;
        int flushInterval = 7;
        int compactInterval = 5 * flushInterval;
        byte[][] families = new byte[numFamilies][];
        for (int i = 0; i < numFamilies; ++i) {
            families[i] = Bytes.toBytes((String)("family" + i));
        }
        byte[][] qualifiers = new byte[numQualifiers][];
        for (int i = 0; i < numQualifiers; ++i) {
            qualifiers[i] = Bytes.toBytes((String)("qual" + i));
        }
        String method = "testWritesWhileScanning";
        this.region = TestHRegion.initHRegion(this.tableName, method, conf, (byte[][])families);
        try {
            PutThread putThread = new PutThread(numRows, families, qualifiers);
            putThread.start();
            putThread.waitForFirstPut();
            FlushThread flushThread = new FlushThread();
            flushThread.start();
            Scan scan = new Scan(Bytes.toBytes((String)"row0"), Bytes.toBytes((String)"row1"));
            int expectedCount = numFamilies * numQualifiers;
            ArrayList res = new ArrayList();
            long prevTimestamp = 0L;
            for (int i = 0; i < testCount; ++i) {
                if (i != 0 && i % compactInterval == 0) {
                    this.region.compactStores(true);
                }
                if (i != 0 && i % flushInterval == 0) {
                    flushThread.flush();
                }
                boolean previousEmpty = res.isEmpty();
                res.clear();
                RegionScanner scanner = this.region.getScanner(scan);
                while (scanner.next(res)) {
                }
                if (res.isEmpty() && previousEmpty && i <= compactInterval) continue;
                Assert.assertEquals((String)("i=" + i), (long)expectedCount, (long)res.size());
                long timestamp = ((Cell)res.get(0)).getTimestamp();
                Assert.assertTrue((String)("Timestamps were broke: " + timestamp + " prev: " + prevTimestamp), (timestamp >= prevTimestamp ? 1 : 0) != 0);
                prevTimestamp = timestamp;
            }
            putThread.done();
            this.region.flushcache();
            putThread.join();
            putThread.checkNoError();
            flushThread.done();
            flushThread.join();
            flushThread.checkNoError();
        }
        finally {
            HRegion.closeHRegion((HRegion)this.region);
            this.region = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWritesWhileGetting() throws Exception {
        int testCount = 100;
        int numRows = 1;
        int numFamilies = 10;
        int numQualifiers = 100;
        int compactInterval = 100;
        byte[][] families = new byte[numFamilies][];
        for (int i = 0; i < numFamilies; ++i) {
            families[i] = Bytes.toBytes((String)("family" + i));
        }
        byte[][] qualifiers = new byte[numQualifiers][];
        for (int i = 0; i < numQualifiers; ++i) {
            qualifiers[i] = Bytes.toBytes((String)("qual" + i));
        }
        String method = "testWritesWhileGetting";
        conf.setInt("hbase.hstore.compaction.min", 1);
        conf.setInt("hbase.hstore.compaction.max", 1000);
        this.region = TestHRegion.initHRegion(this.tableName, method, conf, (byte[][])families);
        PutThread putThread = null;
        MultithreadedTestUtil.TestContext ctx = new MultithreadedTestUtil.TestContext(conf);
        try {
            putThread = new PutThread(numRows, families, qualifiers);
            putThread.start();
            putThread.waitForFirstPut();
            ctx.addThread(new MultithreadedTestUtil.RepeatingTestThread(ctx){
                private int flushesSinceCompact;
                private final int maxFlushesSinceCompact = 20;
                {
                    this.flushesSinceCompact = 0;
                    this.maxFlushesSinceCompact = 20;
                }

                @Override
                public void doAnAction() throws Exception {
                    if (TestHRegion.this.region.flushcache()) {
                        ++this.flushesSinceCompact;
                    }
                    if (this.flushesSinceCompact == 20) {
                        TestHRegion.this.region.compactStores(false);
                        this.flushesSinceCompact = 0;
                    }
                }
            });
            ctx.startThreads();
            Get get = new Get(Bytes.toBytes((String)"row0"));
            Result result = null;
            int expectedCount = numFamilies * numQualifiers;
            long prevTimestamp = 0L;
            for (int i = 0; i < testCount; ++i) {
                boolean previousEmpty = result == null || result.isEmpty();
                result = this.region.get(get);
                if (result.isEmpty() && previousEmpty && i <= compactInterval) continue;
                Assert.assertEquals((String)("i=" + i), (long)expectedCount, (long)result.size());
                long timestamp = 0L;
                for (Cell kv : result.rawCells()) {
                    if (!CellUtil.matchingFamily((Cell)kv, (byte[])families[0]) || !CellUtil.matchingQualifier((Cell)kv, (byte[])qualifiers[0])) continue;
                    timestamp = kv.getTimestamp();
                }
                Assert.assertTrue((timestamp >= prevTimestamp ? 1 : 0) != 0);
                prevTimestamp = timestamp;
                Cell previousKV = null;
                for (Cell kv : result.rawCells()) {
                    byte[] thisValue = CellUtil.cloneValue((Cell)kv);
                    if (previousKV != null && Bytes.compareTo((byte[])CellUtil.cloneValue(previousKV), (byte[])thisValue) != 0) {
                        LOG.warn((Object)("These two KV should have the same value. Previous KV:" + previousKV + "(memStoreTS:" + previousKV.getMvccVersion() + ")" + ", New KV: " + kv + "(memStoreTS:" + kv.getMvccVersion() + ")"));
                        Assert.assertEquals((long)0L, (long)Bytes.compareTo((byte[])CellUtil.cloneValue((Cell)previousKV), (byte[])thisValue));
                    }
                    previousKV = kv;
                }
            }
        }
        finally {
            if (putThread != null) {
                putThread.done();
            }
            this.region.flushcache();
            if (putThread != null) {
                putThread.join();
                putThread.checkNoError();
            }
            ctx.stop();
            HRegion.closeHRegion((HRegion)this.region);
            this.region = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHolesInMeta() throws Exception {
        byte[] family = Bytes.toBytes((String)"family");
        this.region = TestHRegion.initHRegion(this.tableName, Bytes.toBytes((String)"x"), Bytes.toBytes((String)"z"), this.method, conf, false, (byte[][])new byte[][]{family});
        try {
            byte[] rowNotServed = Bytes.toBytes((String)"a");
            Get g = new Get(rowNotServed);
            try {
                this.region.get(g);
                Assert.fail();
            }
            catch (WrongRegionException x) {
                // empty catch block
            }
            byte[] row = Bytes.toBytes((String)"y");
            g = new Get(row);
            this.region.get(g);
        }
        finally {
            HRegion.closeHRegion((HRegion)this.region);
            this.region = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testIndexesScanWithOneDeletedRow() throws IOException {
        byte[] family = Bytes.toBytes((String)"family");
        String method = "testIndexesScanWithOneDeletedRow";
        this.region = TestHRegion.initHRegion(this.tableName, method, conf, (byte[][])new byte[][]{family});
        try {
            Put put = new Put(Bytes.toBytes((long)1L));
            put.add(family, this.qual1, 1L, Bytes.toBytes((long)1L));
            this.region.put(put);
            this.region.flushcache();
            Delete delete = new Delete(Bytes.toBytes((long)1L), 1L);
            this.region.delete(delete);
            put = new Put(Bytes.toBytes((long)2L));
            put.add(family, this.qual1, 2L, Bytes.toBytes((long)2L));
            this.region.put(put);
            Scan idxScan = new Scan();
            idxScan.addFamily(family);
            idxScan.setFilter((Filter)new FilterList(FilterList.Operator.MUST_PASS_ALL, Arrays.asList(new SingleColumnValueFilter(family, this.qual1, CompareFilter.CompareOp.GREATER_OR_EQUAL, (ByteArrayComparable)new BinaryComparator(Bytes.toBytes((long)0L))), new SingleColumnValueFilter(family, this.qual1, CompareFilter.CompareOp.LESS_OR_EQUAL, (ByteArrayComparable)new BinaryComparator(Bytes.toBytes((long)3L))))));
            RegionScanner scanner = this.region.getScanner(idxScan);
            ArrayList res = new ArrayList();
            while (scanner.next(res)) {
            }
            Assert.assertEquals((long)1L, (long)res.size());
        }
        finally {
            HRegion.closeHRegion((HRegion)this.region);
            this.region = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBloomFilterSize() throws IOException {
        byte[] row1 = Bytes.toBytes((String)"row1");
        byte[] fam1 = Bytes.toBytes((String)"fam1");
        byte[] qf1 = Bytes.toBytes((String)"col");
        byte[] val1 = Bytes.toBytes((String)"value1");
        HColumnDescriptor hcd = new HColumnDescriptor(fam1).setMaxVersions(Integer.MAX_VALUE).setBloomFilterType(BloomType.ROWCOL);
        HTableDescriptor htd = new HTableDescriptor(TableName.valueOf((byte[])this.tableName));
        htd.addFamily(hcd);
        HRegionInfo info = new HRegionInfo(htd.getTableName(), null, null, false);
        this.region = TEST_UTIL.createLocalHRegion(info, htd);
        try {
            StoreFile.Reader reader;
            int num_unique_rows = 10;
            int duplicate_multiplier = 2;
            int num_storefiles = 4;
            int version = 0;
            for (int f = 0; f < num_storefiles; ++f) {
                for (int i = 0; i < duplicate_multiplier; ++i) {
                    for (int j = 0; j < num_unique_rows; ++j) {
                        Put put = new Put(Bytes.toBytes((String)("row" + j)));
                        put.setDurability(Durability.SKIP_WAL);
                        put.add(fam1, qf1, (long)version++, val1);
                        this.region.put(put);
                    }
                }
                this.region.flushcache();
            }
            HStore store = (HStore)this.region.getStore(fam1);
            Collection storeFiles = store.getStorefiles();
            for (StoreFile storefile : storeFiles) {
                reader = storefile.getReader();
                reader.loadFileInfo();
                reader.loadBloomfilter();
                Assert.assertEquals((long)(num_unique_rows * duplicate_multiplier), (long)reader.getEntries());
                Assert.assertEquals((long)num_unique_rows, (long)reader.getFilterEntries());
            }
            this.region.compactStores(true);
            storeFiles = store.getStorefiles();
            for (StoreFile storefile : storeFiles) {
                reader = storefile.getReader();
                reader.loadFileInfo();
                reader.loadBloomfilter();
                Assert.assertEquals((long)(num_unique_rows * duplicate_multiplier * num_storefiles), (long)reader.getEntries());
                Assert.assertEquals((long)num_unique_rows, (long)reader.getFilterEntries());
            }
        }
        finally {
            HRegion.closeHRegion((HRegion)this.region);
            this.region = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAllColumnsWithBloomFilter() throws IOException {
        byte[] TABLE = Bytes.toBytes((String)"testAllColumnsWithBloomFilter");
        byte[] FAMILY = Bytes.toBytes((String)"family");
        HColumnDescriptor hcd = new HColumnDescriptor(FAMILY).setMaxVersions(Integer.MAX_VALUE).setBloomFilterType(BloomType.ROWCOL);
        HTableDescriptor htd = new HTableDescriptor(TableName.valueOf((byte[])TABLE));
        htd.addFamily(hcd);
        HRegionInfo info = new HRegionInfo(htd.getTableName(), null, null, false);
        this.region = TEST_UTIL.createLocalHRegion(info, htd);
        try {
            byte[] row = Bytes.toBytes((String)"row:0");
            byte[] column = Bytes.toBytes((String)"column:0");
            Put put = new Put(row);
            put.setDurability(Durability.SKIP_WAL);
            for (long idx = 1L; idx <= 4L; ++idx) {
                put.add(FAMILY, column, idx, Bytes.toBytes((String)("value-version-" + idx)));
            }
            this.region.put(put);
            this.region.flushcache();
            Get get = new Get(row);
            get.setMaxVersions();
            Cell[] kvs = this.region.get(get).rawCells();
            Assert.assertEquals((long)4L, (long)kvs.length);
            this.checkOneCell(kvs[0], FAMILY, 0, 0, 4L);
            this.checkOneCell(kvs[1], FAMILY, 0, 0, 3L);
            this.checkOneCell(kvs[2], FAMILY, 0, 0, 2L);
            this.checkOneCell(kvs[3], FAMILY, 0, 0, 1L);
        }
        finally {
            HRegion.closeHRegion((HRegion)this.region);
            this.region = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDeleteRowWithBloomFilter() throws IOException {
        byte[] familyName = Bytes.toBytes((String)"familyName");
        HColumnDescriptor hcd = new HColumnDescriptor(familyName).setMaxVersions(Integer.MAX_VALUE).setBloomFilterType(BloomType.ROWCOL);
        HTableDescriptor htd = new HTableDescriptor(TableName.valueOf((byte[])this.tableName));
        htd.addFamily(hcd);
        HRegionInfo info = new HRegionInfo(htd.getTableName(), null, null, false);
        this.region = TEST_UTIL.createLocalHRegion(info, htd);
        try {
            byte[] row = Bytes.toBytes((String)"row1");
            byte[] col = Bytes.toBytes((String)"col1");
            Put put = new Put(row);
            put.add(familyName, col, 1L, Bytes.toBytes((String)"SomeRandomValue"));
            this.region.put(put);
            this.region.flushcache();
            Delete del = new Delete(row);
            this.region.delete(del);
            this.region.flushcache();
            Get get = new Get(row);
            get.addColumn(familyName, col);
            Cell[] keyValues = this.region.get(get).rawCells();
            Assert.assertTrue((keyValues.length == 0 ? 1 : 0) != 0);
        }
        finally {
            HRegion.closeHRegion((HRegion)this.region);
            this.region = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testgetHDFSBlocksDistribution() throws Exception {
        HBaseTestingUtility htu = new HBaseTestingUtility();
        int DEFAULT_BLOCK_SIZE = 1024;
        htu.getConfiguration().setLong("dfs.block.size", 1024L);
        htu.getConfiguration().setInt("dfs.replication", 2);
        MiniHBaseCluster cluster = null;
        String[] dataNodeHosts = new String[]{"host1", "host2", "host3"};
        int regionServersCount = 3;
        try {
            cluster = htu.startMiniCluster(1, regionServersCount, dataNodeHosts);
            byte[][] families = new byte[][]{HBaseTestingUtility.fam1, HBaseTestingUtility.fam2};
            HTable ht = htu.createTable(Bytes.toBytes((String)this.getName()), (byte[][])families);
            byte[] row = Bytes.toBytes((String)"row1");
            byte[] col = Bytes.toBytes((String)"col1");
            Put put = new Put(row);
            put.add(HBaseTestingUtility.fam1, col, 1L, Bytes.toBytes((String)"test1"));
            put.add(HBaseTestingUtility.fam2, col, 1L, Bytes.toBytes((String)"test2"));
            ht.put(put);
            HRegion firstRegion = htu.getHBaseCluster().getRegions(TableName.valueOf((String)this.getName())).get(0);
            firstRegion.flushcache();
            HDFSBlocksDistribution blocksDistribution1 = firstRegion.getHDFSBlocksDistribution();
            long uniqueBlocksWeight1 = blocksDistribution1.getUniqueBlocksTotalWeight();
            String topHost = (String)blocksDistribution1.getTopHosts().get(0);
            long topHostWeight = blocksDistribution1.getWeight(topHost);
            Assert.assertTrue((uniqueBlocksWeight1 == topHostWeight ? 1 : 0) != 0);
            HDFSBlocksDistribution blocksDistribution2 = HRegion.computeHDFSBlocksDistribution((Configuration)htu.getConfiguration(), (HTableDescriptor)firstRegion.getTableDesc(), (HRegionInfo)firstRegion.getRegionInfo());
            long uniqueBlocksWeight2 = blocksDistribution2.getUniqueBlocksTotalWeight();
            Assert.assertTrue((uniqueBlocksWeight1 == uniqueBlocksWeight2 ? 1 : 0) != 0);
            ht.close();
        }
        finally {
            if (cluster != null) {
                htu.shutdownMiniCluster();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStatusSettingToAbortIfAnyExceptionDuringRegionInitilization() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        HRegionInfo info = null;
        try {
            FileSystem fs = (FileSystem)Mockito.mock(FileSystem.class);
            Mockito.when((Object)fs.exists((Path)Mockito.anyObject())).thenThrow(new Throwable[]{new IOException()});
            HTableDescriptor htd = new HTableDescriptor(tableName);
            htd.addFamily(new HColumnDescriptor("cf"));
            info = new HRegionInfo(htd.getTableName(), HConstants.EMPTY_BYTE_ARRAY, HConstants.EMPTY_BYTE_ARRAY, false);
            Path path = new Path(this.DIR + "testStatusSettingToAbortIfAnyExceptionDuringRegionInitilization");
            this.region = HRegion.newHRegion((Path)path, null, (FileSystem)fs, (Configuration)conf, (HRegionInfo)info, (HTableDescriptor)htd, null);
            this.region.initialize();
            Assert.fail((String)"Region initialization should fail due to IOException");
        }
        catch (IOException io) {
            List tasks = TaskMonitor.get().getTasks();
            for (MonitoredTask monitoredTask : tasks) {
                if (monitoredTask instanceof MonitoredRPCHandler || !monitoredTask.getDescription().contains(this.region.toString())) continue;
                Assert.assertTrue((String)"Region state should be ABORTED.", (boolean)monitoredTask.getState().equals((Object)MonitoredTask.State.ABORTED));
                break;
            }
        }
        finally {
            HRegion.closeHRegion((HRegion)this.region);
        }
    }

    @Test
    public void testRegionInfoFileCreation() throws IOException {
        Path rootDir = new Path(this.DIR + "testRegionInfoFileCreation");
        HTableDescriptor htd = new HTableDescriptor(TableName.valueOf((String)"testtb"));
        htd.addFamily(new HColumnDescriptor("cf"));
        HRegionInfo hri = new HRegionInfo(htd.getTableName());
        HRegion region = HRegion.createHRegion((HRegionInfo)hri, (Path)rootDir, (Configuration)conf, (HTableDescriptor)htd, null, (boolean)false, (boolean)true);
        Path regionDir = region.getRegionFileSystem().getRegionDir();
        FileSystem fs = region.getRegionFileSystem().getFileSystem();
        HRegion.closeHRegion((HRegion)region);
        Path regionInfoFile = new Path(regionDir, ".regioninfo");
        Assert.assertTrue((String)".regioninfo should be present in the region dir", (boolean)fs.exists(regionInfoFile));
        region = HRegion.openHRegion((Path)rootDir, (HRegionInfo)hri, (HTableDescriptor)htd, null, (Configuration)conf);
        Assert.assertEquals((Object)regionDir, (Object)region.getRegionFileSystem().getRegionDir());
        HRegion.closeHRegion((HRegion)region);
        Assert.assertTrue((String)".regioninfo should be present in the region dir", (boolean)fs.exists(regionInfoFile));
        fs.delete(regionInfoFile);
        Assert.assertFalse((String)".regioninfo should be removed from the region dir", (boolean)fs.exists(regionInfoFile));
        region = HRegion.openHRegion((Path)rootDir, (HRegionInfo)hri, (HTableDescriptor)htd, null, (Configuration)conf);
        Assert.assertEquals((Object)regionDir, (Object)region.getRegionFileSystem().getRegionDir());
        HRegion.closeHRegion((HRegion)region);
        Assert.assertTrue((String)".regioninfo should be present in the region dir", (boolean)fs.exists(new Path(regionDir, ".regioninfo")));
    }

    @Test
    public void testParallelIncrementWithMemStoreFlush() throws Exception {
        int i;
        byte[] family = Incrementer.family;
        final HRegion region = this.region = TestHRegion.initHRegion(this.tableName, this.method, conf, (byte[][])new byte[][]{family});
        final AtomicBoolean incrementDone = new AtomicBoolean(false);
        Runnable flusher = new Runnable(){

            @Override
            public void run() {
                while (!incrementDone.get()) {
                    try {
                        region.flushcache();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        };
        int threadNum = 20;
        int incCounter = 100;
        long expected = threadNum * incCounter;
        Thread[] incrementers = new Thread[threadNum];
        Thread flushThread = new Thread(flusher);
        for (i = 0; i < threadNum; ++i) {
            incrementers[i] = new Thread(new Incrementer(this.region, incCounter));
            incrementers[i].start();
        }
        flushThread.start();
        for (i = 0; i < threadNum; ++i) {
            incrementers[i].join();
        }
        incrementDone.set(true);
        flushThread.join();
        Get get = new Get(Incrementer.incRow);
        get.addColumn(Incrementer.family, Incrementer.qualifier);
        get.setMaxVersions(1);
        Result res = this.region.get(get);
        List kvs = res.getColumnCells(Incrementer.family, Incrementer.qualifier);
        Assert.assertEquals((long)kvs.size(), (long)1L);
        Cell kv = (Cell)kvs.get(0);
        Assert.assertEquals((long)expected, (long)Bytes.toLong((byte[])kv.getValueArray(), (int)kv.getValueOffset()));
        this.region = null;
    }

    @Test
    public void testParallelAppendWithMemStoreFlush() throws Exception {
        int i;
        byte[] family = Appender.family;
        final HRegion region = this.region = TestHRegion.initHRegion(this.tableName, this.method, conf, (byte[][])new byte[][]{family});
        final AtomicBoolean appendDone = new AtomicBoolean(false);
        Runnable flusher = new Runnable(){

            @Override
            public void run() {
                while (!appendDone.get()) {
                    try {
                        region.flushcache();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        };
        int threadNum = 20;
        int appendCounter = 100;
        byte[] expected = new byte[threadNum * appendCounter];
        for (int i2 = 0; i2 < threadNum * appendCounter; ++i2) {
            System.arraycopy(Appender.CHAR, 0, expected, i2, 1);
        }
        Thread[] appenders = new Thread[threadNum];
        Thread flushThread = new Thread(flusher);
        for (i = 0; i < threadNum; ++i) {
            appenders[i] = new Thread(new Appender(this.region, appendCounter));
            appenders[i].start();
        }
        flushThread.start();
        for (i = 0; i < threadNum; ++i) {
            appenders[i].join();
        }
        appendDone.set(true);
        flushThread.join();
        Get get = new Get(Appender.appendRow);
        get.addColumn(Appender.family, Appender.qualifier);
        get.setMaxVersions(1);
        Result res = this.region.get(get);
        List kvs = res.getColumnCells(Appender.family, Appender.qualifier);
        Assert.assertEquals((long)kvs.size(), (long)1L);
        Cell kv = (Cell)kvs.get(0);
        byte[] appendResult = new byte[kv.getValueLength()];
        System.arraycopy(kv.getValueArray(), kv.getValueOffset(), appendResult, 0, kv.getValueLength());
        Assert.assertArrayEquals((byte[])expected, (byte[])appendResult);
        this.region = null;
    }

    @Test
    public void testPutWithMemStoreFlush() throws Exception {
        byte[] family = Bytes.toBytes((String)"family");
        byte[] qualifier = Bytes.toBytes((String)"qualifier");
        byte[] row = Bytes.toBytes((String)"putRow");
        byte[] value = null;
        this.region = TestHRegion.initHRegion(this.tableName, this.method, conf, (byte[][])new byte[][]{family});
        Put put = null;
        Get get = null;
        List kvs = null;
        Result res = null;
        put = new Put(row);
        value = Bytes.toBytes((String)"value0");
        put.add(family, qualifier, 1234567L, value);
        this.region.put(put);
        get = new Get(row);
        get.addColumn(family, qualifier);
        get.setMaxVersions();
        res = this.region.get(get);
        kvs = res.getColumnCells(family, qualifier);
        Assert.assertEquals((long)1L, (long)kvs.size());
        Assert.assertArrayEquals((byte[])Bytes.toBytes((String)"value0"), (byte[])CellUtil.cloneValue((Cell)((Cell)kvs.get(0))));
        this.region.flushcache();
        get = new Get(row);
        get.addColumn(family, qualifier);
        get.setMaxVersions();
        res = this.region.get(get);
        kvs = res.getColumnCells(family, qualifier);
        Assert.assertEquals((long)1L, (long)kvs.size());
        Assert.assertArrayEquals((byte[])Bytes.toBytes((String)"value0"), (byte[])CellUtil.cloneValue((Cell)((Cell)kvs.get(0))));
        put = new Put(row);
        value = Bytes.toBytes((String)"value1");
        put.add(family, qualifier, 1234567L, value);
        this.region.put(put);
        get = new Get(row);
        get.addColumn(family, qualifier);
        get.setMaxVersions();
        res = this.region.get(get);
        kvs = res.getColumnCells(family, qualifier);
        Assert.assertEquals((long)1L, (long)kvs.size());
        Assert.assertArrayEquals((byte[])Bytes.toBytes((String)"value1"), (byte[])CellUtil.cloneValue((Cell)((Cell)kvs.get(0))));
        this.region.flushcache();
        get = new Get(row);
        get.addColumn(family, qualifier);
        get.setMaxVersions();
        res = this.region.get(get);
        kvs = res.getColumnCells(family, qualifier);
        Assert.assertEquals((long)1L, (long)kvs.size());
        Assert.assertArrayEquals((byte[])Bytes.toBytes((String)"value1"), (byte[])CellUtil.cloneValue((Cell)((Cell)kvs.get(0))));
    }

    @Test
    public void testDurability() throws Exception {
        String method = "testDurability";
        this.durabilityTest(method, Durability.SYNC_WAL, Durability.SYNC_WAL, 0L, true, true, false);
        this.durabilityTest(method, Durability.SYNC_WAL, Durability.FSYNC_WAL, 0L, true, true, false);
        this.durabilityTest(method, Durability.SYNC_WAL, Durability.USE_DEFAULT, 0L, true, true, false);
        this.durabilityTest(method, Durability.FSYNC_WAL, Durability.SYNC_WAL, 0L, true, true, false);
        this.durabilityTest(method, Durability.FSYNC_WAL, Durability.FSYNC_WAL, 0L, true, true, false);
        this.durabilityTest(method, Durability.FSYNC_WAL, Durability.USE_DEFAULT, 0L, true, true, false);
        this.durabilityTest(method, Durability.ASYNC_WAL, Durability.SYNC_WAL, 0L, true, true, false);
        this.durabilityTest(method, Durability.ASYNC_WAL, Durability.FSYNC_WAL, 0L, true, true, false);
        this.durabilityTest(method, Durability.SKIP_WAL, Durability.SYNC_WAL, 0L, true, true, false);
        this.durabilityTest(method, Durability.SKIP_WAL, Durability.FSYNC_WAL, 0L, true, true, false);
        this.durabilityTest(method, Durability.USE_DEFAULT, Durability.SYNC_WAL, 0L, true, true, false);
        this.durabilityTest(method, Durability.USE_DEFAULT, Durability.FSYNC_WAL, 0L, true, true, false);
        this.durabilityTest(method, Durability.USE_DEFAULT, Durability.USE_DEFAULT, 0L, true, true, false);
        conf.setLong("hbase.regionserver.optionallogflushinterval", Integer.MAX_VALUE);
        this.durabilityTest(method, Durability.SYNC_WAL, Durability.ASYNC_WAL, 0L, true, false, false);
        this.durabilityTest(method, Durability.FSYNC_WAL, Durability.ASYNC_WAL, 0L, true, false, false);
        this.durabilityTest(method, Durability.ASYNC_WAL, Durability.ASYNC_WAL, 0L, true, false, false);
        this.durabilityTest(method, Durability.SKIP_WAL, Durability.ASYNC_WAL, 0L, true, false, false);
        this.durabilityTest(method, Durability.USE_DEFAULT, Durability.ASYNC_WAL, 0L, true, false, false);
        this.durabilityTest(method, Durability.ASYNC_WAL, Durability.USE_DEFAULT, 0L, true, false, false);
        conf.setLong("hbase.regionserver.optionallogflushinterval", 5L);
        this.durabilityTest(method, Durability.SYNC_WAL, Durability.ASYNC_WAL, 5000L, true, false, true);
        this.durabilityTest(method, Durability.FSYNC_WAL, Durability.ASYNC_WAL, 5000L, true, false, true);
        this.durabilityTest(method, Durability.ASYNC_WAL, Durability.ASYNC_WAL, 5000L, true, false, true);
        this.durabilityTest(method, Durability.SKIP_WAL, Durability.ASYNC_WAL, 5000L, true, false, true);
        this.durabilityTest(method, Durability.USE_DEFAULT, Durability.ASYNC_WAL, 5000L, true, false, true);
        this.durabilityTest(method, Durability.ASYNC_WAL, Durability.USE_DEFAULT, 5000L, true, false, true);
        this.durabilityTest(method, Durability.SYNC_WAL, Durability.SKIP_WAL, 0L, false, false, false);
        this.durabilityTest(method, Durability.FSYNC_WAL, Durability.SKIP_WAL, 0L, false, false, false);
        this.durabilityTest(method, Durability.ASYNC_WAL, Durability.SKIP_WAL, 0L, false, false, false);
        this.durabilityTest(method, Durability.SKIP_WAL, Durability.SKIP_WAL, 0L, false, false, false);
        this.durabilityTest(method, Durability.USE_DEFAULT, Durability.SKIP_WAL, 0L, false, false, false);
        this.durabilityTest(method, Durability.SKIP_WAL, Durability.USE_DEFAULT, 0L, false, false, false);
    }

    private void durabilityTest(String method, Durability tableDurability, Durability mutationDurability, long timeout, boolean expectAppend, final boolean expectSync, final boolean expectSyncFromLogSyncer) throws Exception {
        method = method + "_" + tableDurability.name() + "_" + mutationDurability.name();
        TableName tableName = TableName.valueOf((String)method);
        byte[] family = Bytes.toBytes((String)"family");
        Path logDir = new Path(new Path(this.DIR + method), "log");
        HLog hlog = HLogFactory.createHLog((FileSystem)fs, (Path)logDir, (String)UUID.randomUUID().toString(), (Configuration)conf);
        final HLog log = (HLog)Mockito.spy((Object)hlog);
        this.region = TestHRegion.initHRegion(tableName.getName(), HConstants.EMPTY_START_ROW, HConstants.EMPTY_END_ROW, method, conf, false, tableDurability, log, (byte[][])new byte[][]{family});
        Put put = new Put(Bytes.toBytes((String)"r1"));
        put.add(family, Bytes.toBytes((String)"q1"), Bytes.toBytes((String)"v1"));
        put.setDurability(mutationDurability);
        this.region.put(put);
        ((HLog)Mockito.verify((Object)log, (VerificationMode)(expectAppend ? Mockito.times((int)1) : Mockito.never()))).appendNoSync((HRegionInfo)Matchers.any(), (TableName)Matchers.eq((Object)tableName), (WALEdit)Matchers.any(), (List)Matchers.any(), Matchers.anyLong(), (HTableDescriptor)Matchers.any());
        if (expectSync || expectSyncFromLogSyncer) {
            TEST_UTIL.waitFor(timeout, new Waiter.Predicate<Exception>(){

                public boolean evaluate() throws Exception {
                    try {
                        if (expectSync) {
                            ((HLog)Mockito.verify((Object)log, (VerificationMode)Mockito.times((int)1))).sync(Matchers.anyLong());
                        } else if (expectSyncFromLogSyncer) {
                            ((HLog)Mockito.verify((Object)log, (VerificationMode)Mockito.times((int)1))).sync();
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    return true;
                }
            });
        } else {
            ((HLog)Mockito.verify((Object)log, (VerificationMode)Mockito.never())).sync(Matchers.anyLong());
            ((HLog)Mockito.verify((Object)log, (VerificationMode)Mockito.never())).sync();
        }
        hlog.close();
        this.region.close();
    }

    private void putData(int startRow, int numRows, byte[] qf, byte[] ... families) throws IOException {
        for (int i = startRow; i < startRow + numRows; ++i) {
            Put put = new Put(Bytes.toBytes((String)("" + i)));
            put.setDurability(Durability.SKIP_WAL);
            for (byte[] family : families) {
                put.add(family, qf, null);
            }
            this.region.put(put);
        }
    }

    private void verifyData(HRegion newReg, int startRow, int numRows, byte[] qf, byte[] ... families) throws IOException {
        for (int i = startRow; i < startRow + numRows; ++i) {
            byte[] row = Bytes.toBytes((String)("" + i));
            Get get = new Get(row);
            for (byte[] family : families) {
                get.addColumn(family, qf);
            }
            Result result = newReg.get(get);
            Cell[] raw = result.rawCells();
            Assert.assertEquals((long)families.length, (long)result.size());
            for (int j = 0; j < families.length; ++j) {
                Assert.assertTrue((boolean)CellUtil.matchingRow((Cell)raw[j], (byte[])row));
                Assert.assertTrue((boolean)CellUtil.matchingFamily((Cell)raw[j], (byte[])families[j]));
                Assert.assertTrue((boolean)CellUtil.matchingQualifier((Cell)raw[j], (byte[])qf));
            }
        }
    }

    private void assertGet(HRegion r, byte[] family, byte[] k) throws IOException {
        Get get = new Get(k).addFamily(family).setMaxVersions();
        Cell[] results = r.get(get).rawCells();
        for (int j = 0; j < results.length; ++j) {
            byte[] tmp = CellUtil.cloneValue((Cell)results[j]);
            Assert.assertTrue((boolean)Bytes.equals((byte[])k, (byte[])tmp));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assertScan(HRegion r, byte[] fs, byte[] firstValue) throws IOException {
        block7: {
            byte[][] families = new byte[][]{fs};
            Scan scan = new Scan();
            for (int i = 0; i < families.length; ++i) {
                scan.addFamily(families[i]);
            }
            RegionScanner s = r.getScanner(scan);
            try {
                ArrayList curVals = new ArrayList();
                boolean first = true;
                while (s.next(curVals)) {
                    for (Cell kv : curVals) {
                        byte[] val;
                        byte[] curval = val = CellUtil.cloneValue((Cell)kv);
                        if (first) {
                            first = false;
                            Assert.assertTrue((Bytes.compareTo((byte[])curval, (byte[])firstValue) == 0 ? 1 : 0) != 0);
                            continue;
                        }
                        break block7;
                    }
                }
            }
            finally {
                s.close();
            }
        }
    }

    private Configuration initSplit() {
        conf.setInt("hbase.hstore.compactionThreshold", 2);
        conf.setInt("hbase.master.lease.thread.wakefrequency", 5000);
        conf.setInt(HConstants.HBASE_CLIENT_SCANNER_TIMEOUT_PERIOD, 10000);
        conf.setLong("hbase.client.pause", 15000L);
        conf.setLong("hbase.hregion.max.filesize", 131072L);
        return conf;
    }

    public static HRegion initHRegion(TableName tableName, String callingMethod, Configuration conf, byte[] ... families) throws IOException {
        return TestHRegion.initHRegion(tableName.getName(), null, null, callingMethod, conf, false, families);
    }

    public static HRegion initHRegion(byte[] tableName, String callingMethod, Configuration conf, byte[] ... families) throws IOException {
        return TestHRegion.initHRegion(tableName, null, null, callingMethod, conf, false, families);
    }

    public static HRegion initHRegion(byte[] tableName, String callingMethod, Configuration conf, boolean isReadOnly, byte[] ... families) throws IOException {
        return TestHRegion.initHRegion(tableName, null, null, callingMethod, conf, isReadOnly, families);
    }

    private static HRegion initHRegion(byte[] tableName, byte[] startKey, byte[] stopKey, String callingMethod, Configuration conf, boolean isReadOnly, byte[] ... families) throws IOException {
        return TestHRegion.initHRegion(tableName, startKey, stopKey, callingMethod, conf, isReadOnly, Durability.SYNC_WAL, null, families);
    }

    private static HRegion initHRegion(byte[] tableName, byte[] startKey, byte[] stopKey, String callingMethod, Configuration conf, boolean isReadOnly, Durability durability, HLog hlog, byte[] ... families) throws IOException {
        return TEST_UTIL.createLocalHRegion(tableName, startKey, stopKey, callingMethod, conf, isReadOnly, durability, hlog, families);
    }

    private void checkOneCell(Cell kv, byte[] cf, int rowIdx, int colIdx, long ts) {
        String ctx = "rowIdx=" + rowIdx + "; colIdx=" + colIdx + "; ts=" + ts;
        Assert.assertEquals((String)("Row mismatch which checking: " + ctx), (Object)("row:" + rowIdx), (Object)Bytes.toString((byte[])CellUtil.cloneRow((Cell)kv)));
        Assert.assertEquals((String)("ColumnFamily mismatch while checking: " + ctx), (Object)Bytes.toString((byte[])cf), (Object)Bytes.toString((byte[])CellUtil.cloneFamily((Cell)kv)));
        Assert.assertEquals((String)("Column qualifier mismatch while checking: " + ctx), (Object)("column:" + colIdx), (Object)Bytes.toString((byte[])CellUtil.cloneQualifier((Cell)kv)));
        Assert.assertEquals((String)("Timestamp mismatch while checking: " + ctx), (long)ts, (long)kv.getTimestamp());
        Assert.assertEquals((String)("Value mismatch while checking: " + ctx), (Object)("value-version-" + ts), (Object)Bytes.toString((byte[])CellUtil.cloneValue((Cell)kv)));
    }

    private static class Appender
    implements Runnable {
        private HRegion region;
        private static final byte[] appendRow = Bytes.toBytes((String)"appendRow");
        private static final byte[] family = Bytes.toBytes((String)"family");
        private static final byte[] qualifier = Bytes.toBytes((String)"qualifier");
        private static final byte[] CHAR = Bytes.toBytes((String)"a");
        private int appendCounter;

        public Appender(HRegion region, int appendCounter) {
            this.region = region;
            this.appendCounter = appendCounter;
        }

        @Override
        public void run() {
            for (int count = 0; count < this.appendCounter; ++count) {
                Append app = new Append(appendRow);
                app.add(family, qualifier, CHAR);
                try {
                    this.region.append(app);
                    continue;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    break;
                }
            }
        }
    }

    private static class Incrementer
    implements Runnable {
        private HRegion region;
        private static final byte[] incRow = Bytes.toBytes((String)"incRow");
        private static final byte[] family = Bytes.toBytes((String)"family");
        private static final byte[] qualifier = Bytes.toBytes((String)"qualifier");
        private static final long ONE = 1L;
        private int incCounter;

        public Incrementer(HRegion region, int incCounter) {
            this.region = region;
            this.incCounter = incCounter;
        }

        @Override
        public void run() {
            for (int count = 0; count < this.incCounter; ++count) {
                Increment inc = new Increment(incRow);
                inc.addColumn(family, qualifier, 1L);
                try {
                    this.region.increment(inc);
                    continue;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    break;
                }
            }
        }
    }

    protected class PutThread
    extends Thread {
        private volatile boolean done;
        private volatile int numPutsFinished = 0;
        private Throwable error = null;
        private int numRows;
        private byte[][] families;
        private byte[][] qualifiers;

        private PutThread(int numRows, byte[][] families, byte[][] qualifiers) {
            this.numRows = numRows;
            this.families = families;
            this.qualifiers = qualifiers;
        }

        public void waitForFirstPut() throws InterruptedException {
            while (this.numPutsFinished == 0) {
                this.checkNoError();
                Thread.sleep(50L);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void done() {
            this.done = true;
            PutThread putThread = this;
            synchronized (putThread) {
                this.interrupt();
            }
        }

        public void checkNoError() {
            if (this.error != null) {
                Assert.assertNull((Object)this.error);
            }
        }

        @Override
        public void run() {
            this.done = false;
            while (!this.done) {
                try {
                    for (int r = 0; r < this.numRows; ++r) {
                        byte[] row = Bytes.toBytes((String)("row" + r));
                        Put put = new Put(row);
                        put.setDurability(Durability.SKIP_WAL);
                        byte[] value = Bytes.toBytes((String)String.valueOf(this.numPutsFinished));
                        for (byte[] family : this.families) {
                            for (byte[] qualifier : this.qualifiers) {
                                put.add(family, qualifier, (long)this.numPutsFinished, value);
                            }
                        }
                        TestHRegion.this.region.put(put);
                        ++this.numPutsFinished;
                        if (this.numPutsFinished > 0 && this.numPutsFinished % 47 == 0) {
                            System.out.println("put iteration = " + this.numPutsFinished);
                            Delete delete = new Delete(row, (long)this.numPutsFinished - 30L);
                            TestHRegion.this.region.delete(delete);
                        }
                        ++this.numPutsFinished;
                    }
                }
                catch (InterruptedIOException e) {
                }
                catch (IOException e) {
                    LOG.error((Object)"error while putting records", (Throwable)e);
                    this.error = e;
                    break;
                }
            }
        }
    }

    protected class FlushThread
    extends Thread {
        private volatile boolean done;
        private Throwable error = null;

        protected FlushThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void done() {
            this.done = true;
            FlushThread flushThread = this;
            synchronized (flushThread) {
                this.interrupt();
            }
        }

        public void checkNoError() {
            if (this.error != null) {
                Assert.assertNull((Object)this.error);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.done = false;
            while (!this.done) {
                FlushThread flushThread = this;
                synchronized (flushThread) {
                    block8: {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException ignored) {
                            if (!this.done) break block8;
                            break;
                        }
                    }
                }
                try {
                    TestHRegion.this.region.flushcache();
                }
                catch (IOException e) {
                    if (this.done) break;
                    LOG.error((Object)"Error while flusing cache", (Throwable)e);
                    this.error = e;
                    break;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void flush() {
            FlushThread flushThread = this;
            synchronized (flushThread) {
                this.notify();
            }
        }
    }

    class GetTillDoneOrException
    extends Thread {
        private final Get g;
        private final AtomicBoolean done;
        private final AtomicInteger count;
        private Exception e;

        GetTillDoneOrException(int i, byte[] r, AtomicBoolean d, AtomicInteger c) {
            super("getter." + i);
            this.g = new Get(r);
            this.done = d;
            this.count = c;
        }

        @Override
        public void run() {
            while (!this.done.get()) {
                try {
                    Assert.assertTrue((TestHRegion.this.region.get(this.g).size() > 0 ? 1 : 0) != 0);
                    this.count.incrementAndGet();
                }
                catch (Exception e) {
                    this.e = e;
                    break;
                }
            }
        }
    }
}

