/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.RegionTransition;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.executor.EventType;
import org.apache.hadoop.hbase.master.AssignmentManager;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.RegionState;
import org.apache.hadoop.hbase.zookeeper.ZKAssign;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.zookeeper.KeeperException;
import org.junit.Assert;

public class Mocking {
    static void waitForRegionFailedToCloseAndSetToPendingClose(AssignmentManager am, HRegionInfo hri) throws InterruptedException {
        boolean wait = true;
        while (wait) {
            RegionState state = am.getRegionStates().getRegionState(hri);
            if (state != null && state.isFailedClose()) {
                am.getRegionStates().updateRegionState(hri, RegionState.State.PENDING_CLOSE);
                wait = false;
                continue;
            }
            Thread.sleep(1L);
        }
    }

    static void waitForRegionPendingOpenInRIT(AssignmentManager am, String encodedName) throws InterruptedException {
        boolean wait = true;
        while (wait) {
            RegionState state = (RegionState)am.getRegionStates().getRegionsInTransition().get(encodedName);
            if (state != null && state.isPendingOpen()) {
                wait = false;
                continue;
            }
            Thread.sleep(1L);
        }
    }

    static void fakeRegionServerRegionOpenInZK(HMaster master, ZooKeeperWatcher w, ServerName sn, HRegionInfo hri) throws KeeperException, DeserializationException, InterruptedException {
        Mocking.waitForRegionPendingOpenInRIT(master.getAssignmentManager(), hri.getEncodedName());
        int versionid = ZKAssign.getVersion((ZooKeeperWatcher)w, (HRegionInfo)hri);
        Assert.assertNotSame((Object)-1, (Object)versionid);
        versionid = ZKAssign.transitionNode((ZooKeeperWatcher)w, (HRegionInfo)hri, (ServerName)sn, (EventType)EventType.M_ZK_REGION_OFFLINE, (EventType)EventType.RS_ZK_REGION_OPENING, (int)versionid);
        Assert.assertNotSame((Object)-1, (Object)versionid);
        versionid = ZKAssign.transitionNodeOpened((ZooKeeperWatcher)w, (HRegionInfo)hri, (ServerName)sn, (int)versionid);
        Assert.assertNotSame((Object)-1, (Object)versionid);
    }

    static boolean verifyRegionState(ZooKeeperWatcher zkw, HRegionInfo region, EventType expectedState) throws KeeperException, DeserializationException {
        String encoded = region.getEncodedName();
        String node = ZKAssign.getNodeName((ZooKeeperWatcher)zkw, (String)encoded);
        zkw.sync(node);
        byte[] existingBytes = null;
        try {
            existingBytes = ZKUtil.getDataAndWatch((ZooKeeperWatcher)zkw, (String)node);
        }
        catch (KeeperException.NoNodeException nne) {
            return false;
        }
        catch (KeeperException e) {
            throw e;
        }
        if (existingBytes == null) {
            return false;
        }
        RegionTransition rt = RegionTransition.parseFrom((byte[])existingBytes);
        return rt.getEventType().equals((Object)expectedState);
    }
}

