/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import com.google.protobuf.BlockingRpcChannel;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import com.google.protobuf.RpcController;
import com.google.protobuf.ServiceException;
import java.net.SocketTimeoutException;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.MasterNotRunningException;
import org.apache.hadoop.hbase.MediumTests;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HConnection;
import org.apache.hadoop.hbase.client.HConnectionManager;
import org.apache.hadoop.hbase.ipc.RpcClient;
import org.apache.hadoop.hbase.security.User;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestClientTimeouts {
    final Log LOG = LogFactory.getLog(this.getClass());
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    protected static int SLAVES = 1;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.startMiniCluster(SLAVES);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAdminTimeout() throws Exception {
        long lastLimit = HConstants.DEFAULT_HBASE_CLIENT_PREFETCH_LIMIT;
        HConnection lastConnection = null;
        boolean lastFailed = false;
        int initialInvocations = RandomTimeoutBlockingRpcChannel.invokations.get();
        RpcClient rpcClient = new RpcClient(TEST_UTIL.getConfiguration(), TEST_UTIL.getClusterKey()){

            public BlockingRpcChannel createBlockingRpcChannel(ServerName sn, User ticket, int rpcTimeout) {
                return new RandomTimeoutBlockingRpcChannel(this, sn, ticket, rpcTimeout);
            }
        };
        try {
            for (int i = 0; i < 5 || lastFailed && i < 100; ++i) {
                lastFailed = false;
                Configuration conf = HBaseConfiguration.create((Configuration)TEST_UTIL.getConfiguration());
                conf.setLong(HConstants.HBASE_CLIENT_PREFETCH_LIMIT, ++lastLimit);
                HBaseAdmin admin = null;
                try {
                    admin = new HBaseAdmin(conf);
                    HConnection connection = admin.getConnection();
                    Assert.assertFalse((connection == lastConnection ? 1 : 0) != 0);
                    lastConnection = connection;
                    ((HConnectionManager.HConnectionImplementation)connection).setRpcClient(rpcClient);
                    HBaseAdmin.checkHBaseAvailable((Configuration)conf);
                    admin.setBalancerRunning(false, false);
                    continue;
                }
                catch (MasterNotRunningException ex) {
                    lastFailed = true;
                    continue;
                }
                finally {
                    admin.close();
                }
            }
            Assert.assertFalse((boolean)lastFailed);
            Assert.assertTrue((RandomTimeoutBlockingRpcChannel.invokations.get() > initialInvocations ? 1 : 0) != 0);
        }
        finally {
            rpcClient.stop();
        }
    }

    static class RandomTimeoutBlockingRpcChannel
    extends RpcClient.BlockingRpcChannelImplementation {
        private static final Random RANDOM = new Random(System.currentTimeMillis());
        public static final double CHANCE_OF_TIMEOUT = 0.3;
        private static AtomicInteger invokations = new AtomicInteger();

        RandomTimeoutBlockingRpcChannel(RpcClient rpcClient, ServerName sn, User ticket, int rpcTimeout) {
            super(rpcClient, sn, ticket, rpcTimeout);
        }

        public Message callBlockingMethod(Descriptors.MethodDescriptor md, RpcController controller, Message param, Message returnType) throws ServiceException {
            invokations.getAndIncrement();
            if ((double)RANDOM.nextFloat() < 0.3) {
                throw new ServiceException((Throwable)new SocketTimeoutException("fake timeout"));
            }
            return super.callBlockingMethod(md, controller, param, returnType);
        }
    }
}

