/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.zookeeper;

import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.zookeeper.ZKConfig;
import org.apache.zookeeper.ZooKeeperMain;

public class ZooKeeperMainServer {
    public String parse(Configuration c) {
        Properties zkProps = ZKConfig.makeZKProps((Configuration)c);
        String clientPort = null;
        ArrayList<String> hosts = new ArrayList<String>();
        for (Map.Entry<Object, Object> entry : zkProps.entrySet()) {
            String key = entry.getKey().toString().trim();
            String value = entry.getValue().toString().trim();
            if (key.startsWith("server.")) {
                String[] parts = value.split(":");
                hosts.add(parts[0]);
                continue;
            }
            if (!key.endsWith("clientPort")) continue;
            clientPort = value;
        }
        if (hosts.isEmpty() || clientPort == null) {
            return null;
        }
        StringBuilder host = new StringBuilder();
        for (int i = 0; i < hosts.size(); ++i) {
            if (i > 0) {
                host.append("," + (String)hosts.get(i));
            } else {
                host.append((String)hosts.get(i));
            }
            host.append(":");
            host.append(clientPort);
        }
        return host.toString();
    }

    public static void main(String[] args) throws Exception {
        Configuration conf = HBaseConfiguration.create();
        String hostport = new ZooKeeperMainServer().parse(conf);
        String[] newArgs = args;
        if (hostport != null && hostport.length() > 0) {
            newArgs = new String[args.length + 2];
            System.arraycopy(args, 0, newArgs, 2, args.length);
            newArgs[0] = "-server";
            newArgs[1] = hostport;
        }
        ZooKeeperMain.main((String[])newArgs);
    }
}

