/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.snapshot;

import java.util.List;
import java.util.concurrent.Callable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hbase.errorhandling.ForeignException;
import org.apache.hadoop.hbase.errorhandling.ForeignExceptionDispatcher;
import org.apache.hadoop.hbase.procedure.ProcedureMember;
import org.apache.hadoop.hbase.procedure.Subprocedure;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.snapshot.RegionServerSnapshotManager;
import org.apache.hadoop.hbase.snapshot.ClientSnapshotDescriptionUtils;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class FlushSnapshotSubprocedure
extends Subprocedure {
    private static final Log LOG = LogFactory.getLog(FlushSnapshotSubprocedure.class);
    private final List<HRegion> regions;
    private final HBaseProtos.SnapshotDescription snapshot;
    private final RegionServerSnapshotManager.SnapshotSubprocedurePool taskManager;

    public FlushSnapshotSubprocedure(ProcedureMember member, ForeignExceptionDispatcher errorListener, long wakeFrequency, long timeout, List<HRegion> regions, HBaseProtos.SnapshotDescription snapshot, RegionServerSnapshotManager.SnapshotSubprocedurePool taskManager) {
        super(member, snapshot.getName(), errorListener, wakeFrequency, timeout);
        this.snapshot = snapshot;
        this.regions = regions;
        this.taskManager = taskManager;
    }

    private void flushSnapshot() throws ForeignException {
        if (this.regions.isEmpty()) {
            return;
        }
        this.monitor.rethrowException();
        if (this.taskManager.hasTasks()) {
            throw new IllegalStateException("Attempting to take snapshot " + ClientSnapshotDescriptionUtils.toString((HBaseProtos.SnapshotDescription)this.snapshot) + " but we currently have outstanding tasks");
        }
        for (HRegion region : this.regions) {
            this.taskManager.submitTask(new RegionSnapshotTask(region));
            this.monitor.rethrowException();
        }
        LOG.debug((Object)("Flush Snapshot Tasks submitted for " + this.regions.size() + " regions"));
        try {
            this.taskManager.waitForOutstandingTasks();
        }
        catch (InterruptedException e) {
            throw new ForeignException(this.getMemberName(), e);
        }
    }

    @Override
    public void acquireBarrier() throws ForeignException {
    }

    @Override
    public void insideBarrier() throws ForeignException {
        this.flushSnapshot();
    }

    @Override
    public void cleanup(Exception e) {
        LOG.info((Object)("Aborting all online FLUSH snapshot subprocedure task threads for '" + this.snapshot.getName() + "' due to error"), (Throwable)e);
        try {
            this.taskManager.cancelTasks();
        }
        catch (InterruptedException e1) {
            Thread.currentThread().interrupt();
        }
    }

    public void releaseBarrier() {
    }

    private class RegionSnapshotTask
    implements Callable<Void> {
        HRegion region;

        RegionSnapshotTask(HRegion region) {
            this.region = region;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void call() throws Exception {
            LOG.debug((Object)("Starting region operation on " + this.region));
            this.region.startRegionOperation();
            try {
                LOG.debug((Object)("Flush Snapshotting region " + this.region.toString() + " started..."));
                this.region.flushcache();
                this.region.addRegionToSnapshot(FlushSnapshotSubprocedure.this.snapshot, FlushSnapshotSubprocedure.this.monitor);
                LOG.debug((Object)("... Flush Snapshotting region " + this.region.toString() + " completed."));
            }
            finally {
                LOG.debug((Object)("Closing region operation on " + this.region));
                this.region.closeRegionOperation();
            }
            return null;
        }
    }
}

