/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.migration;

import com.google.common.collect.Lists;
import com.google.common.primitives.Ints;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.catalog.MetaEditor;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionFileSystem;
import org.apache.hadoop.hbase.regionserver.wal.HLog;
import org.apache.hadoop.hbase.regionserver.wal.HLogFactory;
import org.apache.hadoop.hbase.regionserver.wal.HLogUtil;
import org.apache.hadoop.hbase.security.access.AccessControlLists;
import org.apache.hadoop.hbase.snapshot.SnapshotDescriptionUtils;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.FSTableDescriptors;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.util.Tool;

public class NamespaceUpgrade
implements Tool {
    private static final Log LOG = LogFactory.getLog(NamespaceUpgrade.class);
    private Configuration conf;
    private FileSystem fs;
    private Path rootDir;
    private Path sysNsDir;
    private Path defNsDir;
    private Path[] baseDirs;
    private Path backupDir;
    private static final String TMP_DATA_DIR = ".data";
    private static final String DOT_LOGS = ".logs";
    private static final String DOT_OLD_LOGS = ".oldlogs";
    private static final String DOT_CORRUPT = ".corrupt";
    private static final String DOT_SPLITLOG = "splitlog";
    private static final String DOT_ARCHIVE = ".archive";
    private static final String DOT_LIB_DIR = ".lib";
    private static final String OLD_ACL = "_acl_";
    static final List<String> NON_USER_TABLE_DIRS = Arrays.asList(".logs", ".oldlogs", ".corrupt", "splitlog", ".hbck", ".archive", ".hbase-snapshot", ".tmp", ".data", "_acl_", ".lib");
    private static final PathFilter TABLEINFO_PATHFILTER = new PathFilter(){

        public boolean accept(Path p) {
            return p.getName().startsWith(".tableinfo");
        }
    };
    static final Comparator<FileStatus> TABLEINFO_FILESTATUS_COMPARATOR = new Comparator<FileStatus>(){

        @Override
        public int compare(FileStatus left, FileStatus right) {
            return -left.compareTo((Object)right);
        }
    };

    public void init() throws IOException {
        this.rootDir = FSUtils.getRootDir(this.conf);
        FSUtils.setFsDefault(this.getConf(), this.rootDir);
        this.fs = FileSystem.get((Configuration)this.conf);
        Path tmpDataDir = new Path(this.rootDir, TMP_DATA_DIR);
        this.sysNsDir = new Path(tmpDataDir, NamespaceDescriptor.SYSTEM_NAMESPACE_NAME_STR);
        this.defNsDir = new Path(tmpDataDir, NamespaceDescriptor.DEFAULT_NAMESPACE_NAME_STR);
        this.baseDirs = new Path[]{this.rootDir, new Path(this.rootDir, "archive"), new Path(this.rootDir, ".tmp")};
        this.backupDir = new Path(this.rootDir, ".migration");
    }

    public void upgradeTableDirs() throws IOException, DeserializationException {
        if (NamespaceUpgrade.verifyNSUpgrade(this.fs, this.rootDir)) {
            return;
        }
        this.makeNamespaceDirs();
        this.migrateTables();
        this.migrateSnapshots();
        this.migrateDotDirs();
        this.migrateMeta();
        this.migrateACL();
        this.deleteRoot();
        FSUtils.setVersion(this.fs, this.rootDir);
    }

    public void deleteRoot() throws IOException {
        Path rootDir = new Path(this.rootDir, "-ROOT-");
        if (this.fs.exists(rootDir)) {
            if (!this.fs.delete(rootDir, true)) {
                LOG.info((Object)("Failed remove of " + rootDir));
            }
            LOG.info((Object)("Deleted " + rootDir));
        }
    }

    public void migrateDotDirs() throws IOException {
        Path[][] dirs;
        Path archiveDir = new Path(this.rootDir, "archive");
        for (Path[] dir : dirs = new Path[][]{{new Path(this.rootDir, DOT_CORRUPT), new Path(this.rootDir, "corrupt")}, {new Path(this.rootDir, DOT_LOGS), new Path(this.rootDir, "WALs")}, {new Path(this.rootDir, DOT_OLD_LOGS), new Path(this.rootDir, "oldWALs")}, {new Path(this.rootDir, TMP_DATA_DIR), new Path(this.rootDir, "data")}, {new Path(this.rootDir, DOT_LIB_DIR), new Path(this.rootDir, "lib")}}) {
            Path src = dir[0];
            Path tgt = dir[1];
            if (!this.fs.exists(src)) {
                LOG.info((Object)("Does not exist: " + src));
                continue;
            }
            this.rename(src, tgt);
        }
        Path oldArchiveDir = new Path(this.rootDir, DOT_ARCHIVE);
        if (this.fs.exists(oldArchiveDir)) {
            this.mkdirs(archiveDir);
            Path archiveDataDir = new Path(archiveDir, "data");
            this.mkdirs(archiveDataDir);
            this.rename(oldArchiveDir, new Path(archiveDataDir, NamespaceDescriptor.DEFAULT_NAMESPACE_NAME_STR));
        }
        Path dataDir = new Path(this.rootDir, "data");
        this.sysNsDir = new Path(dataDir, NamespaceDescriptor.SYSTEM_NAMESPACE_NAME_STR);
        this.defNsDir = new Path(dataDir, NamespaceDescriptor.DEFAULT_NAMESPACE_NAME_STR);
    }

    private void mkdirs(Path p) throws IOException {
        if (!this.fs.mkdirs(p)) {
            throw new IOException("Failed make of " + p);
        }
    }

    private void rename(Path src, Path tgt) throws IOException {
        if (!this.fs.rename(src, tgt)) {
            throw new IOException("Failed move " + src + " to " + tgt);
        }
    }

    public void makeNamespaceDirs() throws IOException {
        if (!this.fs.exists(this.sysNsDir) && !this.fs.mkdirs(this.sysNsDir)) {
            throw new IOException("Failed to create system namespace dir: " + this.sysNsDir);
        }
        if (!this.fs.exists(this.defNsDir) && !this.fs.mkdirs(this.defNsDir)) {
            throw new IOException("Failed to create default namespace dir: " + this.defNsDir);
        }
    }

    public void migrateTables() throws IOException {
        ArrayList sysTables = Lists.newArrayList((Object[])new String[]{"-ROOT-", ".META."});
        for (Path baseDir : this.baseDirs) {
            if (!this.fs.exists(baseDir)) continue;
            List<Path> oldTableDirs = FSUtils.getLocalTableDirs(this.fs, baseDir);
            for (Path oldTableDir : oldTableDirs) {
                if (NON_USER_TABLE_DIRS.contains(oldTableDir.getName()) || sysTables.contains(oldTableDir.getName())) continue;
                Path nsDir = new Path(this.defNsDir, TableName.valueOf((String)oldTableDir.getName()).getQualifierAsString());
                if (!this.fs.exists(nsDir.getParent()) && !this.fs.mkdirs(nsDir.getParent())) {
                    throw new IOException("Failed to create namespace dir " + nsDir.getParent());
                }
                if (sysTables.indexOf(oldTableDir.getName()) >= 0) continue;
                LOG.info((Object)("Migrating table " + oldTableDir.getName() + " to " + nsDir));
                if (this.fs.rename(oldTableDir, nsDir)) continue;
                throw new IOException("Failed to move " + oldTableDir + " to namespace dir " + nsDir);
            }
        }
    }

    public void migrateSnapshots() throws IOException {
        Path oldSnapshotDir = new Path(this.rootDir, ".snapshot");
        Path newSnapshotDir = new Path(this.rootDir, ".hbase-snapshot");
        if (this.fs.exists(oldSnapshotDir)) {
            FileStatus[] snapshots;
            boolean foundOldSnapshotDir = false;
            for (FileStatus snapshot : snapshots = this.fs.listStatus(oldSnapshotDir, (PathFilter)new SnapshotDescriptionUtils.CompletedSnaphotDirectoriesFilter(this.fs))) {
                Path info = new Path(snapshot.getPath(), ".snapshotinfo");
                if (!this.fs.exists(info)) continue;
                foundOldSnapshotDir = true;
                break;
            }
            if (foundOldSnapshotDir) {
                LOG.info((Object)"Migrating snapshot dir");
                if (!this.fs.rename(oldSnapshotDir, newSnapshotDir)) {
                    throw new IOException("Failed to move old snapshot dir " + oldSnapshotDir + " to new " + newSnapshotDir);
                }
            }
        }
    }

    public void migrateMeta() throws IOException {
        Path oldMetaRegionDir;
        Path newMetaDir = new Path(this.sysNsDir, TableName.META_TABLE_NAME.getQualifierAsString());
        Path newMetaRegionDir = new Path(newMetaDir, HRegionInfo.FIRST_META_REGIONINFO.getEncodedName());
        Path oldMetaDir = new Path(this.rootDir, ".META.");
        if (this.fs.exists(oldMetaDir)) {
            LOG.info((Object)("Migrating meta table " + oldMetaDir.getName() + " to " + newMetaDir));
            if (!this.fs.rename(oldMetaDir, newMetaDir)) {
                throw new IOException("Failed to migrate meta table " + oldMetaDir.getName() + " to " + newMetaDir);
            }
        }
        if (this.fs.exists(oldMetaRegionDir = HRegion.getRegionDir(this.rootDir, new Path(newMetaDir, "1028785192").toString()))) {
            LOG.info((Object)("Migrating meta region " + oldMetaRegionDir + " to " + newMetaRegionDir));
            if (!this.fs.rename(oldMetaRegionDir, newMetaRegionDir)) {
                throw new IOException("Failed to migrate meta region " + oldMetaRegionDir + " to " + newMetaRegionDir);
            }
        }
        this.removeTableInfoInPre96Format(TableName.META_TABLE_NAME);
        Path oldRootDir = new Path(this.rootDir, "-ROOT-");
        if (!this.fs.rename(oldRootDir, this.backupDir)) {
            throw new IllegalStateException("Failed to old data: " + oldRootDir + " to " + this.backupDir);
        }
    }

    private void removeTableInfoInPre96Format(TableName tableName) throws IOException {
        Path tableDir = FSUtils.getTableDir(this.rootDir, tableName);
        FileStatus[] status = FSUtils.listStatus(this.fs, tableDir, TABLEINFO_PATHFILTER);
        if (status == null) {
            return;
        }
        for (FileStatus fStatus : status) {
            FSUtils.delete(this.fs, fStatus.getPath(), false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void migrateACL() throws IOException {
        TableName oldTableName = TableName.valueOf((String)OLD_ACL);
        Path oldTablePath = new Path(this.rootDir, oldTableName.getNameAsString());
        if (!this.fs.exists(oldTablePath)) {
            return;
        }
        LOG.info((Object)"Migrating ACL table");
        TableName newTableName = AccessControlLists.ACL_TABLE_NAME;
        Path newTablePath = FSUtils.getTableDir(this.rootDir, newTableName);
        HTableDescriptor oldDesc = NamespaceUpgrade.readTableDescriptor(this.fs, NamespaceUpgrade.getCurrentTableInfoStatus(this.fs, oldTablePath));
        if (FSTableDescriptors.getTableInfoPath(this.fs, newTablePath) == null) {
            LOG.info((Object)"Creating new tableDesc for ACL");
            HTableDescriptor newDesc = new HTableDescriptor(oldDesc);
            newDesc.setName(newTableName);
            new FSTableDescriptors(this.conf).createTableDescriptorForTableDirectory(newTablePath, newDesc, true);
        }
        ServerName fakeServer = new ServerName("nsupgrade", 96, 123L);
        String metaLogName = HLogUtil.getHLogDirectoryName(fakeServer.toString());
        HLog metaHLog = HLogFactory.createMetaHLog(this.fs, this.rootDir, metaLogName, this.conf, null, fakeServer.toString());
        HRegion meta = HRegion.openHRegion(this.rootDir, HRegionInfo.FIRST_META_REGIONINFO, HTableDescriptor.META_TABLEDESC, metaHLog, this.conf);
        HRegion region = null;
        try {
            for (Path regionDir : FSUtils.getRegionDirs(this.fs, oldTablePath)) {
                LOG.info((Object)("Migrating ACL region " + regionDir.getName()));
                HRegionInfo oldRegionInfo = HRegionFileSystem.loadRegionInfoFileContent(this.fs, regionDir);
                HRegionInfo newRegionInfo = new HRegionInfo(newTableName, oldRegionInfo.getStartKey(), oldRegionInfo.getEndKey(), oldRegionInfo.isSplit(), oldRegionInfo.getRegionId());
                newRegionInfo.setOffline(oldRegionInfo.isOffline());
                region = new HRegion(HRegionFileSystem.openRegionFromFileSystem(this.conf, this.fs, oldTablePath, oldRegionInfo, false), metaHLog, this.conf, oldDesc, null);
                region.initialize();
                region.compactStores(true);
                region.waitForFlushesAndCompactions();
                region.close();
                Path newRegionDir = new Path(newTablePath, newRegionInfo.getEncodedName());
                if (!this.fs.exists(newRegionDir) && !this.fs.mkdirs(newRegionDir)) {
                    throw new IllegalStateException("Failed to create new region dir: " + newRegionDir);
                }
                HRegionFileSystem.openRegionFromFileSystem(this.conf, this.fs, newTablePath, newRegionInfo, false);
                for (FileStatus file : this.fs.listStatus(regionDir, (PathFilter)new FSUtils.UserTableDirFilter(this.fs))) {
                    if (file.getPath().getName().equals(".regioninfo") || this.fs.rename(file.getPath(), newRegionDir)) continue;
                    throw new IllegalStateException("Failed to move file " + file.getPath() + " to " + newRegionDir);
                }
                meta.put(MetaEditor.makePutFromRegionInfo(newRegionInfo));
                meta.delete(MetaEditor.makeDeleteFromRegionInfo(oldRegionInfo));
            }
        }
        finally {
            meta.flushcache();
            meta.waitForFlushesAndCompactions();
            meta.close();
            metaHLog.closeAndDelete();
            if (region != null) {
                region.close();
            }
        }
        if (!this.fs.rename(oldTablePath, this.backupDir)) {
            throw new IllegalStateException("Failed to old data: " + oldTablePath + " to " + this.backupDir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static HTableDescriptor readTableDescriptor(FileSystem fs, FileStatus status) throws IOException {
        int len = Ints.checkedCast((long)status.getLen());
        byte[] content = new byte[len];
        FSDataInputStream fsDataInputStream = fs.open(status.getPath());
        try {
            fsDataInputStream.readFully(content);
        }
        finally {
            fsDataInputStream.close();
        }
        HTableDescriptor htd = null;
        try {
            htd = HTableDescriptor.parseFrom((byte[])content);
        }
        catch (DeserializationException e) {
            throw new IOException("content=" + Bytes.toShort((byte[])content), e);
        }
        return htd;
    }

    static FileStatus getCurrentTableInfoStatus(FileSystem fs, Path dir) throws IOException {
        FileStatus[] status = FSUtils.listStatus(fs, dir, TABLEINFO_PATHFILTER);
        if (status == null || status.length < 1) {
            return null;
        }
        FileStatus mostCurrent = null;
        for (FileStatus file : status) {
            if (mostCurrent != null && TABLEINFO_FILESTATUS_COMPARATOR.compare(file, mostCurrent) >= 0) continue;
            mostCurrent = file;
        }
        return mostCurrent;
    }

    public static boolean verifyNSUpgrade(FileSystem fs, Path rootDir) throws IOException {
        try {
            return FSUtils.getVersion(fs, rootDir).equals("8");
        }
        catch (DeserializationException e) {
            throw new IOException("Failed to verify namespace upgrade", e);
        }
    }

    public int run(String[] args) throws Exception {
        if (args.length < 1 || !args[0].equals("--upgrade")) {
            System.out.println("Usage: <CMD> --upgrade");
            return 0;
        }
        this.init();
        this.upgradeTableDirs();
        return 0;
    }

    public void setConf(Configuration conf) {
        this.conf = conf;
    }

    public Configuration getConf() {
        return this.conf;
    }
}

