/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.MultiThreadedWriterBase;
import org.apache.hadoop.hbase.util.test.LoadTestDataGenerator;

public class MultiThreadedWriter
extends MultiThreadedWriterBase {
    private static final Log LOG = LogFactory.getLog(MultiThreadedWriter.class);
    private Set<HBaseWriterThread> writers = new HashSet<HBaseWriterThread>();
    private boolean isMultiPut = false;

    public MultiThreadedWriter(LoadTestDataGenerator dataGen, Configuration conf, TableName tableName) {
        super(dataGen, conf, tableName, "W");
    }

    public void setMultiPut(boolean isMultiPut) {
        this.isMultiPut = isMultiPut;
    }

    @Override
    public void start(long startKey, long endKey, int numThreads) throws IOException {
        super.start(startKey, endKey, numThreads);
        if (this.verbose) {
            LOG.debug((Object)("Inserting keys [" + startKey + ", " + endKey + ")"));
        }
        for (int i = 0; i < numThreads; ++i) {
            HBaseWriterThread writer = new HBaseWriterThread(i);
            this.writers.add(writer);
        }
        this.startThreads(this.writers);
    }

    @Override
    public void waitForFinish() {
        super.waitForFinish();
        System.out.println("Failed to write keys: " + this.failedKeySet.size());
        for (Long key : this.failedKeySet) {
            System.out.println("Failed to write key: " + key);
        }
    }

    private class HBaseWriterThread
    extends Thread {
        private final HTable table;

        public HBaseWriterThread(int writerId) throws IOException {
            this.setName(this.getClass().getSimpleName() + "_" + writerId);
            this.table = new HTable(MultiThreadedWriter.this.conf, MultiThreadedWriter.this.tableName);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                long rowKeyBase;
                byte[][] columnFamilies = MultiThreadedWriter.this.dataGenerator.getColumnFamilies();
                while ((rowKeyBase = MultiThreadedWriter.this.nextKeyToWrite.getAndIncrement()) < MultiThreadedWriter.this.endKey) {
                    byte[] rowKey = MultiThreadedWriter.this.dataGenerator.getDeterministicUniqueKey(rowKeyBase);
                    Put put = new Put(rowKey);
                    MultiThreadedWriter.this.numKeys.addAndGet(1L);
                    int columnCount = 0;
                    for (byte[] cf : columnFamilies) {
                        byte[][] columns;
                        for (byte[] column : columns = MultiThreadedWriter.this.dataGenerator.generateColumnsForCf(rowKey, cf)) {
                            byte[] value = MultiThreadedWriter.this.dataGenerator.generateValue(rowKey, cf, column);
                            put.add(cf, column, value);
                            ++columnCount;
                            if (MultiThreadedWriter.this.isMultiPut) continue;
                            MultiThreadedWriter.this.insert(this.table, put, rowKeyBase);
                            MultiThreadedWriter.this.numCols.addAndGet(1L);
                            put = new Put(rowKey);
                        }
                        long rowKeyHash = Arrays.hashCode(rowKey);
                        put.add(cf, LoadTestDataGenerator.MUTATE_INFO, HConstants.EMPTY_BYTE_ARRAY);
                        put.add(cf, LoadTestDataGenerator.INCREMENT, Bytes.toBytes((long)rowKeyHash));
                        if (MultiThreadedWriter.this.isMultiPut) continue;
                        MultiThreadedWriter.this.insert(this.table, put, rowKeyBase);
                        MultiThreadedWriter.this.numCols.addAndGet(1L);
                        put = new Put(rowKey);
                    }
                    if (MultiThreadedWriter.this.isMultiPut) {
                        if (MultiThreadedWriter.this.verbose) {
                            LOG.debug((Object)("Preparing put for key = [" + rowKey + "], " + columnCount + " columns"));
                        }
                        MultiThreadedWriter.this.insert(this.table, put, rowKeyBase);
                        MultiThreadedWriter.this.numCols.addAndGet(columnCount);
                    }
                    if (!MultiThreadedWriter.this.trackWroteKeys) continue;
                    MultiThreadedWriter.this.wroteKeys.add(rowKeyBase);
                }
            }
            finally {
                try {
                    this.table.close();
                }
                catch (IOException e) {
                    LOG.error((Object)"Error closing table", (Throwable)e);
                }
                MultiThreadedWriter.this.numThreadsWorking.decrementAndGet();
            }
        }
    }
}

