/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.util.concurrent.Semaphore;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.MediumTests;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.zookeeper.MasterAddressTracker;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperListener;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestMasterAddressManager {
    private static final Log LOG = LogFactory.getLog(TestMasterAddressManager.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.startMiniZKCluster();
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniZKCluster();
    }

    @Test
    public void testMasterAddressManagerFromZK() throws Exception {
        ZooKeeperWatcher zk = new ZooKeeperWatcher(TEST_UTIL.getConfiguration(), "testMasterAddressManagerFromZK", null);
        ZKUtil.createAndFailSilent((ZooKeeperWatcher)zk, (String)zk.baseZNode);
        MasterAddressTracker addressManager = new MasterAddressTracker(zk, null);
        addressManager.start();
        Assert.assertFalse((boolean)addressManager.hasMaster());
        zk.registerListener((ZooKeeperListener)addressManager);
        NodeCreationListener listener = new NodeCreationListener(zk, zk.getMasterAddressZNode());
        zk.registerListener((ZooKeeperListener)listener);
        String host = "localhost";
        int port = 1234;
        ServerName sn = new ServerName(host, port, System.currentTimeMillis());
        LOG.info((Object)"Creating master node");
        MasterAddressTracker.setMasterAddress((ZooKeeperWatcher)zk, (String)zk.getMasterAddressZNode(), (ServerName)sn);
        LOG.info((Object)"Waiting for master address manager to be notified");
        listener.waitForCreation();
        LOG.info((Object)"Master node created");
        Assert.assertTrue((boolean)addressManager.hasMaster());
        ServerName pulledAddress = addressManager.getMasterAddress();
        Assert.assertTrue((boolean)pulledAddress.equals((Object)sn));
    }

    public static class NodeCreationListener
    extends ZooKeeperListener {
        private static final Log LOG = LogFactory.getLog(NodeCreationListener.class);
        private Semaphore lock = new Semaphore(0);
        private String node;

        public NodeCreationListener(ZooKeeperWatcher watcher, String node) {
            super(watcher);
            this.node = node;
        }

        public void nodeCreated(String path) {
            if (path.equals(this.node)) {
                LOG.debug((Object)("nodeCreated(" + path + ")"));
                this.lock.release();
            }
        }

        public void waitForCreation() throws InterruptedException {
            this.lock.acquire();
        }
    }
}

