/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.encoding;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.LargeTests;
import org.apache.hadoop.hbase.io.compress.Compression;
import org.apache.hadoop.hbase.io.encoding.DataBlockEncoder;
import org.apache.hadoop.hbase.io.encoding.DataBlockEncoding;
import org.apache.hadoop.hbase.io.encoding.HFileBlockDefaultEncodingContext;
import org.apache.hadoop.hbase.io.encoding.HFileBlockEncodingContext;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.test.RedundantKVGenerator;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@Category(value={LargeTests.class})
@RunWith(value=Parameterized.class)
public class TestDataBlockEncoders {
    static int NUMBER_OF_KV = 10000;
    static int NUM_RANDOM_SEEKS = 10000;
    private static int ENCODED_DATA_OFFSET = 35;
    private RedundantKVGenerator generator = new RedundantKVGenerator();
    private Random randomizer = new Random(42L);
    private final boolean includesMemstoreTS;

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return HBaseTestingUtility.BOOLEAN_PARAMETERIZED;
    }

    public TestDataBlockEncoders(boolean includesMemstoreTS) {
        this.includesMemstoreTS = includesMemstoreTS;
    }

    private HFileBlockEncodingContext getEncodingContext(Compression.Algorithm algo, DataBlockEncoding encoding) {
        DataBlockEncoder encoder = encoding.getEncoder();
        if (encoder != null) {
            return encoder.newDataBlockEncodingContext(algo, encoding, HConstants.HFILEBLOCK_DUMMY_HEADER);
        }
        return new HFileBlockDefaultEncodingContext(algo, encoding, HConstants.HFILEBLOCK_DUMMY_HEADER);
    }

    private byte[] encodeBytes(DataBlockEncoding encoding, ByteBuffer dataset) throws IOException {
        DataBlockEncoder encoder = encoding.getEncoder();
        HFileBlockEncodingContext encodingCtx = this.getEncodingContext(Compression.Algorithm.NONE, encoding);
        encoder.encodeKeyValues(dataset, this.includesMemstoreTS, encodingCtx);
        byte[] encodedBytesWithHeader = encodingCtx.getUncompressedBytesWithHeader();
        byte[] encodedData = new byte[encodedBytesWithHeader.length - ENCODED_DATA_OFFSET];
        System.arraycopy(encodedBytesWithHeader, ENCODED_DATA_OFFSET, encodedData, 0, encodedData.length);
        return encodedData;
    }

    private void testAlgorithm(ByteBuffer dataset, DataBlockEncoding encoding) throws IOException {
        byte[] encodedBytes = this.encodeBytes(encoding, dataset);
        ByteArrayInputStream bais = new ByteArrayInputStream(encodedBytes);
        DataInputStream dis = new DataInputStream(bais);
        DataBlockEncoder encoder = encoding.getEncoder();
        ByteBuffer actualDataset = encoder.decodeKeyValues(dis, this.includesMemstoreTS);
        dataset.rewind();
        actualDataset.rewind();
        Assert.assertEquals((String)("Encoding -> decoding gives different results for " + encoder), (Object)Bytes.toStringBinary((ByteBuffer)dataset), (Object)Bytes.toStringBinary((ByteBuffer)actualDataset));
    }

    @Test
    public void testEmptyKeyValues() throws IOException {
        ArrayList<KeyValue> kvList = new ArrayList<KeyValue>();
        byte[] row = new byte[]{};
        byte[] family = new byte[]{};
        byte[] qualifier = new byte[]{};
        byte[] value = new byte[]{};
        kvList.add(new KeyValue(row, family, qualifier, 0L, KeyValue.Type.Put, value));
        kvList.add(new KeyValue(row, family, qualifier, 0L, KeyValue.Type.Put, value));
        this.testEncodersOnDataset(RedundantKVGenerator.convertKvToByteBuffer(kvList, (boolean)this.includesMemstoreTS));
    }

    @Test
    public void testNegativeTimestamps() throws IOException {
        ArrayList<KeyValue> kvList = new ArrayList<KeyValue>();
        byte[] row = new byte[]{};
        byte[] family = new byte[]{};
        byte[] qualifier = new byte[]{};
        byte[] value = new byte[]{};
        kvList.add(new KeyValue(row, family, qualifier, -1L, KeyValue.Type.Put, value));
        kvList.add(new KeyValue(row, family, qualifier, -2L, KeyValue.Type.Put, value));
        this.testEncodersOnDataset(RedundantKVGenerator.convertKvToByteBuffer(kvList, (boolean)this.includesMemstoreTS));
    }

    @Test
    public void testExecutionOnSample() throws IOException {
        this.testEncodersOnDataset(RedundantKVGenerator.convertKvToByteBuffer((List)this.generator.generateTestKeyValues(NUMBER_OF_KV), (boolean)this.includesMemstoreTS));
    }

    @Test
    public void testSeekingOnSample() throws IOException {
        List sampleKv = this.generator.generateTestKeyValues(NUMBER_OF_KV);
        ByteBuffer originalBuffer = RedundantKVGenerator.convertKvToByteBuffer((List)sampleKv, (boolean)this.includesMemstoreTS);
        ArrayList<DataBlockEncoder.EncodedSeeker> encodedSeekers = new ArrayList<DataBlockEncoder.EncodedSeeker>();
        for (DataBlockEncoding encoding : DataBlockEncoding.values()) {
            if (encoding.getEncoder() == null) continue;
            ByteBuffer encodedBuffer = ByteBuffer.wrap(this.encodeBytes(encoding, originalBuffer));
            DataBlockEncoder encoder = encoding.getEncoder();
            DataBlockEncoder.EncodedSeeker seeker = encoder.createSeeker(KeyValue.COMPARATOR, this.includesMemstoreTS);
            seeker.setCurrentBuffer(encodedBuffer);
            encodedSeekers.add(seeker);
        }
        for (boolean seekBefore : new boolean[]{false, true}) {
            for (int i = 0; i < NUM_RANDOM_SEEKS; ++i) {
                int keyValueId = !seekBefore ? this.randomizer.nextInt(sampleKv.size()) : this.randomizer.nextInt(sampleKv.size() - 1) + 1;
                KeyValue keyValue = (KeyValue)sampleKv.get(keyValueId);
                this.checkSeekingConsistency(encodedSeekers, seekBefore, keyValue);
            }
        }
        this.checkSeekingConsistency(encodedSeekers, false, (KeyValue)sampleKv.get(0));
        for (boolean seekBefore : new boolean[]{false, true}) {
            this.checkSeekingConsistency(encodedSeekers, seekBefore, (KeyValue)sampleKv.get(sampleKv.size() - 1));
            KeyValue midKv = (KeyValue)sampleKv.get(sampleKv.size() / 2);
            KeyValue lastMidKv = midKv.createLastOnRowCol();
            this.checkSeekingConsistency(encodedSeekers, seekBefore, lastMidKv);
        }
    }

    @Test
    public void testNextOnSample() {
        List sampleKv = this.generator.generateTestKeyValues(NUMBER_OF_KV);
        ByteBuffer originalBuffer = RedundantKVGenerator.convertKvToByteBuffer((List)sampleKv, (boolean)this.includesMemstoreTS);
        for (DataBlockEncoding encoding : DataBlockEncoding.values()) {
            if (encoding.getEncoder() == null) continue;
            DataBlockEncoder encoder = encoding.getEncoder();
            ByteBuffer encodedBuffer = null;
            try {
                encodedBuffer = ByteBuffer.wrap(this.encodeBytes(encoding, originalBuffer));
            }
            catch (IOException e) {
                throw new RuntimeException(String.format("Bug while encoding using '%s'", encoder.toString()), e);
            }
            DataBlockEncoder.EncodedSeeker seeker = encoder.createSeeker(KeyValue.COMPARATOR, this.includesMemstoreTS);
            seeker.setCurrentBuffer(encodedBuffer);
            int i = 0;
            do {
                KeyValue expectedKeyValue = (KeyValue)sampleKv.get(i);
                ByteBuffer keyValue = seeker.getKeyValueBuffer();
                if (0 != Bytes.compareTo((byte[])keyValue.array(), (int)keyValue.arrayOffset(), (int)keyValue.limit(), (byte[])expectedKeyValue.getBuffer(), (int)expectedKeyValue.getOffset(), (int)expectedKeyValue.getLength())) {
                    int commonPrefix;
                    byte[] left = keyValue.array();
                    byte[] right = expectedKeyValue.getBuffer();
                    int leftOff = keyValue.arrayOffset();
                    int rightOff = expectedKeyValue.getOffset();
                    int length = Math.min(keyValue.limit(), expectedKeyValue.getLength());
                    for (commonPrefix = 0; commonPrefix < length && left[commonPrefix + leftOff] == right[commonPrefix + rightOff]; ++commonPrefix) {
                    }
                    Assert.fail((String)String.format("next() produces wrong results encoder: %s i: %d commonPrefix: %d\n expected %s\n actual      %s", encoder.toString(), i, commonPrefix, Bytes.toStringBinary((byte[])expectedKeyValue.getBuffer(), (int)expectedKeyValue.getOffset(), (int)expectedKeyValue.getLength()), Bytes.toStringBinary((ByteBuffer)keyValue)));
                }
                ++i;
            } while (seeker.next());
        }
    }

    @Test
    public void testFirstKeyInBlockOnSample() {
        List sampleKv = this.generator.generateTestKeyValues(NUMBER_OF_KV);
        ByteBuffer originalBuffer = RedundantKVGenerator.convertKvToByteBuffer((List)sampleKv, (boolean)this.includesMemstoreTS);
        for (DataBlockEncoding encoding : DataBlockEncoding.values()) {
            int commonPrefix;
            if (encoding.getEncoder() == null) continue;
            DataBlockEncoder encoder = encoding.getEncoder();
            ByteBuffer encodedBuffer = null;
            try {
                encodedBuffer = ByteBuffer.wrap(this.encodeBytes(encoding, originalBuffer));
            }
            catch (IOException e) {
                throw new RuntimeException(String.format("Bug while encoding using '%s'", encoder.toString()), e);
            }
            ByteBuffer keyBuffer = encoder.getFirstKeyInBlock(encodedBuffer);
            KeyValue firstKv = (KeyValue)sampleKv.get(0);
            if (0 == Bytes.compareTo((byte[])keyBuffer.array(), (int)keyBuffer.arrayOffset(), (int)keyBuffer.limit(), (byte[])firstKv.getBuffer(), (int)firstKv.getKeyOffset(), (int)firstKv.getKeyLength())) continue;
            int length = Math.min(keyBuffer.limit(), firstKv.getKeyLength());
            for (commonPrefix = 0; commonPrefix < length && keyBuffer.array()[keyBuffer.arrayOffset() + commonPrefix] == firstKv.getBuffer()[firstKv.getKeyOffset() + commonPrefix]; ++commonPrefix) {
            }
            Assert.fail((String)String.format("Bug in '%s' commonPrefix %d", encoder.toString(), commonPrefix));
        }
    }

    private void checkSeekingConsistency(List<DataBlockEncoder.EncodedSeeker> encodedSeekers, boolean seekBefore, KeyValue keyValue) {
        ByteBuffer expectedKeyValue = null;
        ByteBuffer expectedKey = null;
        ByteBuffer expectedValue = null;
        for (DataBlockEncoder.EncodedSeeker seeker : encodedSeekers) {
            seeker.seekToKeyInBlock(keyValue.getBuffer(), keyValue.getKeyOffset(), keyValue.getKeyLength(), seekBefore);
            seeker.rewind();
            ByteBuffer actualKeyValue = seeker.getKeyValueBuffer();
            ByteBuffer actualKey = seeker.getKeyDeepCopy();
            ByteBuffer actualValue = seeker.getValueShallowCopy();
            if (expectedKeyValue != null) {
                Assert.assertEquals((Object)expectedKeyValue, (Object)actualKeyValue);
            } else {
                expectedKeyValue = actualKeyValue;
            }
            if (expectedKey != null) {
                Assert.assertEquals((Object)expectedKey, (Object)actualKey);
            } else {
                expectedKey = actualKey;
            }
            if (expectedValue != null) {
                Assert.assertEquals((Object)expectedValue, (Object)actualValue);
                continue;
            }
            expectedValue = actualValue;
        }
    }

    private void testEncodersOnDataset(ByteBuffer onDataset) throws IOException {
        ByteBuffer dataset = ByteBuffer.allocate(onDataset.capacity());
        onDataset.rewind();
        dataset.put(onDataset);
        onDataset.rewind();
        dataset.flip();
        for (DataBlockEncoding encoding : DataBlockEncoding.values()) {
            if (encoding.getEncoder() == null) continue;
            this.testAlgorithm(dataset, encoding);
            dataset.rewind();
            Assert.assertEquals((String)"Input of two methods is changed", (Object)onDataset, (Object)dataset);
        }
    }
}

