/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.coprocessor;

import java.io.IOException;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.MediumTests;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.HTableInterface;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.coprocessor.BaseRegionObserver;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.regionserver.wal.WALEdit;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestOpenTableInCoprocessor {
    private static final TableName otherTable = TableName.valueOf((String)"otherTable");
    private static final byte[] family = new byte[]{102};
    private static boolean completed = false;
    private static final HBaseTestingUtility UTIL = new HBaseTestingUtility();

    @AfterClass
    public static void cleanup() throws Exception {
        UTIL.getHBaseAdmin().close();
    }

    @Test
    public void testCoprocessorCanCreateConnectionToRemoteTable() throws Throwable {
        HTableDescriptor primary = new HTableDescriptor(TableName.valueOf((String)"primary"));
        primary.addFamily(new HColumnDescriptor(family));
        primary.addCoprocessor(SendToOtherTableCoprocessor.class.getName());
        HTableDescriptor other = new HTableDescriptor(otherTable);
        other.addFamily(new HColumnDescriptor(family));
        UTIL.startMiniCluster();
        HBaseAdmin admin = UTIL.getHBaseAdmin();
        admin.createTable(primary);
        admin.createTable(other);
        admin.close();
        HTable table = new HTable(UTIL.getConfiguration(), "primary");
        Put p = new Put(new byte[]{97});
        p.add(family, null, new byte[]{97});
        table.put(p);
        table.flushCommits();
        table.close();
        HTable target = new HTable(UTIL.getConfiguration(), otherTable);
        Assert.assertTrue((String)"Didn't complete update to target table!", (boolean)completed);
        Assert.assertEquals((String)"Didn't find inserted row", (long)1L, (long)this.getKeyValueCount(target));
        target.close();
        UTIL.shutdownMiniCluster();
    }

    private int getKeyValueCount(HTable table) throws IOException {
        Scan scan = new Scan();
        scan.setMaxVersions(0x7FFFFFFE);
        ResultScanner results = table.getScanner(scan);
        int count = 0;
        for (Result res : results) {
            System.out.println((count += res.listCells().size()) + ") " + res);
        }
        results.close();
        return count;
    }

    public static class SendToOtherTableCoprocessor
    extends BaseRegionObserver {
        public void prePut(ObserverContext<RegionCoprocessorEnvironment> e, Put put, WALEdit edit, Durability durability) throws IOException {
            HTableInterface table = ((RegionCoprocessorEnvironment)e.getEnvironment()).getTable(otherTable);
            Put p = new Put(new byte[]{97});
            p.add(family, null, new byte[]{97});
            table.put(put);
            table.flushCommits();
            completed = true;
            table.close();
        }
    }
}

