/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.codec.prefixtree;

import java.nio.ByteBuffer;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.codec.prefixtree.decode.DecoderFactory;
import org.apache.hadoop.hbase.codec.prefixtree.decode.PrefixTreeArraySearcher;
import org.apache.hadoop.hbase.codec.prefixtree.scanner.CellScannerPosition;
import org.apache.hadoop.hbase.io.encoding.DataBlockEncoder;

@InterfaceAudience.Private
public class PrefixTreeSeeker
implements DataBlockEncoder.EncodedSeeker {
    protected ByteBuffer block;
    protected boolean includeMvccVersion;
    protected PrefixTreeArraySearcher ptSearcher;
    private static final boolean USE_POSITION_BEFORE = false;

    public PrefixTreeSeeker(boolean includeMvccVersion) {
        this.includeMvccVersion = includeMvccVersion;
    }

    public void setCurrentBuffer(ByteBuffer fullBlockBuffer) {
        this.block = fullBlockBuffer;
        this.ptSearcher = DecoderFactory.checkOut(this.block, this.includeMvccVersion);
        this.rewind();
    }

    public void releaseCurrentSearcher() {
        DecoderFactory.checkIn(this.ptSearcher);
    }

    public ByteBuffer getKeyDeepCopy() {
        return KeyValueUtil.copyKeyToNewByteBuffer((Cell)this.ptSearcher.current());
    }

    public ByteBuffer getValueShallowCopy() {
        return CellUtil.getValueBufferShallowCopy((Cell)this.ptSearcher.current());
    }

    public ByteBuffer getKeyValueBuffer() {
        return KeyValueUtil.copyToNewByteBuffer((Cell)this.ptSearcher.current());
    }

    public KeyValue getKeyValue() {
        if (this.ptSearcher.current() == null) {
            return null;
        }
        return KeyValueUtil.copyToNewKeyValue((Cell)this.ptSearcher.current());
    }

    public Cell get() {
        return this.ptSearcher.current();
    }

    public void rewind() {
        this.ptSearcher.positionAtFirstCell();
    }

    public boolean next() {
        return this.ptSearcher.advance();
    }

    public boolean advance() {
        return this.ptSearcher.advance();
    }

    public int seekToKeyInBlock(byte[] keyOnlyBytes, int offset, int length, boolean forceBeforeOnExactMatch) {
        return this.seekToOrBeforeUsingPositionAtOrAfter(keyOnlyBytes, offset, length, forceBeforeOnExactMatch);
    }

    protected int seekToOrBeforeUsingPositionAtOrBefore(byte[] keyOnlyBytes, int offset, int length, boolean seekBefore) {
        KeyValue kv = KeyValue.createKeyValueFromKey((byte[])keyOnlyBytes, (int)offset, (int)length);
        CellScannerPosition position = this.ptSearcher.seekForwardToOrBefore((Cell)kv);
        if (CellScannerPosition.AT == position) {
            if (seekBefore) {
                this.ptSearcher.previous();
                return 1;
            }
            return 0;
        }
        return 1;
    }

    protected int seekToOrBeforeUsingPositionAtOrAfter(byte[] keyOnlyBytes, int offset, int length, boolean seekBefore) {
        KeyValue kv = KeyValue.createKeyValueFromKey((byte[])keyOnlyBytes, (int)offset, (int)length);
        CellScannerPosition position = this.ptSearcher.seekForwardToOrAfter((Cell)kv);
        if (CellScannerPosition.AT == position) {
            if (seekBefore) {
                this.ptSearcher.previous();
                return 1;
            }
            return 0;
        }
        if (CellScannerPosition.AFTER == position) {
            if (!this.ptSearcher.isBeforeFirst()) {
                this.ptSearcher.previous();
            }
            return 1;
        }
        if (position == CellScannerPosition.AFTER_LAST) {
            if (seekBefore) {
                this.ptSearcher.previous();
            }
            return 1;
        }
        throw new RuntimeException("unexpected CellScannerPosition:" + (Object)((Object)position));
    }
}

