/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.util.HashSet;
import java.util.Random;
import org.apache.hadoop.hbase.SmallTests;
import org.apache.hadoop.hbase.util.test.LoadTestKVGenerator;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestLoadTestKVGenerator {
    private static final int MIN_LEN = 10;
    private static final int MAX_LEN = 20;
    private Random rand = new Random(28937293L);
    private LoadTestKVGenerator gen = new LoadTestKVGenerator(10, 20);

    @Test
    public void testValueLength() {
        for (int i = 0; i < 1000; ++i) {
            byte[] v = this.gen.generateRandomSizeValue((byte[][])new byte[][]{Integer.toString(i).getBytes(), String.valueOf(this.rand.nextInt()).getBytes()});
            Assert.assertTrue((10 <= v.length ? 1 : 0) != 0);
            Assert.assertTrue((v.length <= 20 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testVerification() {
        for (int i = 0; i < 1000; ++i) {
            for (int qualIndex = 0; qualIndex < 20; ++qualIndex) {
                byte[] qual = String.valueOf(qualIndex).getBytes();
                byte[] rowKey = LoadTestKVGenerator.md5PrefixedKey((long)i).getBytes();
                byte[] v = this.gen.generateRandomSizeValue((byte[][])new byte[][]{rowKey, qual});
                Assert.assertTrue((boolean)LoadTestKVGenerator.verify((byte[])v, (byte[][])new byte[][]{rowKey, qual}));
                v[0] = (byte)(v[0] + 1);
                Assert.assertFalse((boolean)LoadTestKVGenerator.verify((byte[])v, (byte[][])new byte[][]{rowKey, qual}));
            }
        }
    }

    @Test
    public void testCorrectAndUniqueKeys() {
        HashSet<String> keys = new HashSet<String>();
        for (int i = 0; i < 1000; ++i) {
            String k = LoadTestKVGenerator.md5PrefixedKey((long)i);
            Assert.assertFalse((boolean)keys.contains(k));
            Assert.assertTrue((boolean)k.endsWith("-" + i));
            keys.add(k);
        }
    }
}

