/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.io.File;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseCommonTestingUtility;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.SmallTests;
import org.apache.hadoop.hbase.util.ClassLoaderTestHelper;
import org.apache.hadoop.hbase.util.DynamicClassLoader;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestDynamicClassLoader {
    private static final Log LOG = LogFactory.getLog(TestDynamicClassLoader.class);
    private static final Configuration conf = HBaseConfiguration.create();
    private static final HBaseCommonTestingUtility TEST_UTIL = new HBaseCommonTestingUtility();

    @Test
    public void testLoadClassFromLocalPath() throws Exception {
        ClassLoader parent = TestDynamicClassLoader.class.getClassLoader();
        DynamicClassLoader classLoader = new DynamicClassLoader(conf, parent);
        String className = "TestLoadClassFromLocalPath";
        this.deleteClass(className);
        try {
            classLoader.loadClass(className);
            Assert.fail((String)("Should not be able to load class " + className));
        }
        catch (ClassNotFoundException cnfe) {
            // empty catch block
        }
        try {
            String folder = TEST_UTIL.getDataTestDir().toString();
            ClassLoaderTestHelper.buildJar(folder, className, null, ClassLoaderTestHelper.localDirPath(conf));
            classLoader.loadClass(className);
        }
        catch (ClassNotFoundException cnfe) {
            LOG.error((Object)("Should be able to load class " + className), (Throwable)cnfe);
            Assert.fail((String)cnfe.getMessage());
        }
    }

    @Test
    public void testLoadClassFromAnotherPath() throws Exception {
        ClassLoader parent = TestDynamicClassLoader.class.getClassLoader();
        DynamicClassLoader classLoader = new DynamicClassLoader(conf, parent);
        String className = "TestLoadClassFromAnotherPath";
        this.deleteClass(className);
        try {
            classLoader.loadClass(className);
            Assert.fail((String)("Should not be able to load class " + className));
        }
        catch (ClassNotFoundException cnfe) {
            // empty catch block
        }
        try {
            String folder = TEST_UTIL.getDataTestDir().toString();
            ClassLoaderTestHelper.buildJar(folder, className, null);
            classLoader.loadClass(className);
        }
        catch (ClassNotFoundException cnfe) {
            LOG.error((Object)("Should be able to load class " + className), (Throwable)cnfe);
            Assert.fail((String)cnfe.getMessage());
        }
    }

    private void deleteClass(String className) throws Exception {
        String jarFileName = className + ".jar";
        File file = new File(TEST_UTIL.getDataTestDir().toString(), jarFileName);
        file.delete();
        Assert.assertFalse((String)("Should be deleted: " + file.getPath()), (boolean)file.exists());
        file = new File(conf.get("hbase.dynamic.jars.dir"), jarFileName);
        file.delete();
        Assert.assertFalse((String)("Should be deleted: " + file.getPath()), (boolean)file.exists());
        file = new File(ClassLoaderTestHelper.localDirPath(conf), jarFileName);
        file.delete();
        Assert.assertFalse((String)("Should be deleted: " + file.getPath()), (boolean)file.exists());
    }

    static {
        conf.set("hbase.dynamic.jars.dir", TEST_UTIL.getDataTestDir().toString());
    }
}

