/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.zookeeper;

import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.zookeeper.HQuorumPeer;
import org.apache.hadoop.util.StringUtils;

@InterfaceAudience.Private
public class ZKConfig {
    private static final Log LOG = LogFactory.getLog(ZKConfig.class);
    private static final String VARIABLE_START = "${";
    private static final int VARIABLE_START_LENGTH = "${".length();
    private static final String VARIABLE_END = "}";
    private static final int VARIABLE_END_LENGTH = "}".length();

    public static Properties makeZKProps(Configuration conf) {
        if (conf.getBoolean("hbase.config.read.zookeeper.config", false)) {
            LOG.warn((Object)"Parsing ZooKeeper's zoo.cfg file for ZK properties has been deprecated. Please instead place all ZK related HBase configuration under the hbase-site.xml, using prefixes of the form 'hbase.zookeeper.property.', and set property 'hbase.config.read.zookeeper.config' to false");
            ClassLoader cl = HQuorumPeer.class.getClassLoader();
            InputStream inputStream = cl.getResourceAsStream("zoo.cfg");
            if (inputStream != null) {
                try {
                    return ZKConfig.parseZooCfg(conf, inputStream);
                }
                catch (IOException e) {
                    LOG.warn((Object)"Cannot read zoo.cfg, loading from XML files", (Throwable)e);
                }
            }
        } else if (LOG.isTraceEnabled()) {
            LOG.trace((Object)"Skipped reading ZK properties file 'zoo.cfg' since 'hbase.config.read.zookeeper.config' was not set to true");
        }
        Properties zkProperties = new Properties();
        for (Map.Entry entry : new Configuration(conf)) {
            String key = (String)entry.getKey();
            if (!key.startsWith("hbase.zookeeper.property.")) continue;
            String zkKey = key.substring(HConstants.ZK_CFG_PROPERTY_PREFIX_LEN);
            String value = (String)entry.getValue();
            if (value.contains(VARIABLE_START)) {
                value = conf.get(key);
            }
            zkProperties.put(zkKey, value);
        }
        if (zkProperties.getProperty("clientPort") == null) {
            zkProperties.put("clientPort", (Object)2181);
        }
        int peerPort = conf.getInt("hbase.zookeeper.peerport", 2888);
        int leaderPort = conf.getInt("hbase.zookeeper.leaderport", 3888);
        String[] serverHosts = conf.getStrings("hbase.zookeeper.quorum", new String[]{"localhost"});
        for (int i = 0; i < serverHosts.length; ++i) {
            String serverHost = serverHosts[i];
            String address = serverHost + ":" + peerPort + ":" + leaderPort;
            String key = "server." + i;
            zkProperties.put(key, address);
        }
        return zkProperties;
    }

    @Deprecated
    public static Properties parseZooCfg(Configuration conf, InputStream inputStream) throws IOException {
        Properties properties = new Properties();
        try {
            properties.load(inputStream);
        }
        catch (IOException e) {
            String msg = "fail to read properties from zoo.cfg";
            LOG.fatal((Object)"fail to read properties from zoo.cfg");
            throw new IOException("fail to read properties from zoo.cfg", e);
        }
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            boolean mode;
            String value = entry.getValue().toString().trim();
            String key = entry.getKey().toString().trim();
            StringBuilder newValue = new StringBuilder();
            int varStart = value.indexOf(VARIABLE_START);
            int varEnd = 0;
            while (varStart != -1) {
                varEnd = value.indexOf(VARIABLE_END, varStart);
                if (varEnd == -1) {
                    String msg = "variable at " + varStart + " has no end marker";
                    LOG.fatal((Object)msg);
                    throw new IOException(msg);
                }
                String variable = value.substring(varStart + VARIABLE_START_LENGTH, varEnd);
                String substituteValue = System.getProperty(variable);
                if (substituteValue == null) {
                    substituteValue = conf.get(variable);
                }
                if (substituteValue == null) {
                    String msg = "variable " + variable + " not set in system property " + "or hbase configs";
                    LOG.fatal((Object)msg);
                    throw new IOException(msg);
                }
                newValue.append(substituteValue);
                varStart = value.indexOf(VARIABLE_START, varEnd += VARIABLE_END_LENGTH);
            }
            if (key.startsWith("server.") && (mode = conf.getBoolean("hbase.cluster.distributed", false)) && value.startsWith("localhost")) {
                String msg = "The server in zoo.cfg cannot be set to localhost in a fully-distributed setup because it won't be reachable. See \"Getting Started\" for more information.";
                LOG.fatal((Object)msg);
                throw new IOException(msg);
            }
            newValue.append(value.substring(varEnd));
            properties.setProperty(key, newValue.toString());
        }
        return properties;
    }

    public static String getZKQuorumServersString(Properties properties) {
        String clientPort = null;
        ArrayList<String> servers = new ArrayList<String>();
        boolean anyValid = false;
        for (Map.Entry<Object, Object> property : properties.entrySet()) {
            String key = property.getKey().toString().trim();
            String value = property.getValue().toString().trim();
            if (key.equals("clientPort")) {
                clientPort = value;
                continue;
            }
            if (!key.startsWith("server.")) continue;
            String host = value.substring(0, value.indexOf(58));
            servers.add(host);
            try {
                InetAddress.getByName(host);
                anyValid = true;
            }
            catch (UnknownHostException e) {
                LOG.warn((Object)StringUtils.stringifyException((Throwable)e));
            }
        }
        if (!anyValid) {
            LOG.error((Object)"no valid quorum servers found in zoo.cfg");
            return null;
        }
        if (clientPort == null) {
            LOG.error((Object)"no clientPort found in zoo.cfg");
            return null;
        }
        if (servers.isEmpty()) {
            LOG.fatal((Object)"No servers were found in provided ZooKeeper configuration. HBase must have a ZooKeeper cluster configured for its operation. Ensure that you've configured 'hbase.zookeeper.quorum' properly.");
            return null;
        }
        StringBuilder hostPortBuilder = new StringBuilder();
        for (int i = 0; i < servers.size(); ++i) {
            String host = (String)servers.get(i);
            if (i > 0) {
                hostPortBuilder.append(',');
            }
            hostPortBuilder.append(host);
            hostPortBuilder.append(':');
            hostPortBuilder.append(clientPort);
        }
        return hostPortBuilder.toString();
    }

    public static String getZKQuorumServersString(Configuration conf) {
        return ZKConfig.getZKQuorumServersString(ZKConfig.makeZKProps(conf));
    }
}

