/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security.visibility;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hbase.security.visibility.VisibilityLabelsValidator;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class Authorizations {
    private List<String> labels;

    public Authorizations(String ... labels) {
        this.labels = new ArrayList<String>(labels.length);
        for (String label : labels) {
            this.validateLabel(label);
            this.labels.add(label);
        }
    }

    private void validateLabel(String label) {
        if (!VisibilityLabelsValidator.isValidLabel(label)) {
            throw new IllegalArgumentException("Invalid authorization label : " + label + ". Authorizations cannot contain '(', ')' ,'&' ,'|', '!'" + " and cannot be empty");
        }
    }

    public Authorizations(List<String> labels) {
        for (String label : labels) {
            this.validateLabel(label);
        }
        this.labels = labels;
    }

    public List<String> getLabels() {
        return Collections.unmodifiableList(this.labels);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[ ");
        for (String label : this.labels) {
            sb.append(label);
            sb.append(' ');
        }
        sb.append(']');
        return sb.toString();
    }
}

