/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.filter;

import com.google.common.base.Preconditions;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterBase;
import org.apache.hadoop.hbase.filter.ParseFilter;
import org.apache.hadoop.hbase.protobuf.generated.FilterProtos;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class TimestampsFilter
extends FilterBase {
    TreeSet<Long> timestamps;
    private static final int MAX_LOG_TIMESTAMPS = 5;
    long minTimeStamp = Long.MAX_VALUE;

    public TimestampsFilter(List<Long> timestamps) {
        for (Long timestamp : timestamps) {
            Preconditions.checkArgument((timestamp >= 0L ? 1 : 0) != 0, (String)"must be positive %s", (Object[])new Object[]{timestamp});
        }
        this.timestamps = new TreeSet<Long>(timestamps);
        this.init();
    }

    public List<Long> getTimestamps() {
        ArrayList<Long> list = new ArrayList<Long>(this.timestamps.size());
        list.addAll(this.timestamps);
        return list;
    }

    private void init() {
        if (this.timestamps.size() > 0) {
            this.minTimeStamp = this.timestamps.first();
        }
    }

    public long getMin() {
        return this.minTimeStamp;
    }

    @Override
    public Filter.ReturnCode filterKeyValue(Cell v) {
        if (this.timestamps.contains(v.getTimestamp())) {
            return Filter.ReturnCode.INCLUDE;
        }
        if (v.getTimestamp() < this.minTimeStamp) {
            return Filter.ReturnCode.NEXT_COL;
        }
        return Filter.ReturnCode.SKIP;
    }

    public static Filter createFilterFromArguments(ArrayList<byte[]> filterArguments) {
        ArrayList<Long> timestamps = new ArrayList<Long>();
        for (int i = 0; i < filterArguments.size(); ++i) {
            long timestamp = ParseFilter.convertByteArrayToLong(filterArguments.get(i));
            timestamps.add(timestamp);
        }
        return new TimestampsFilter(timestamps);
    }

    @Override
    public byte[] toByteArray() {
        FilterProtos.TimestampsFilter.Builder builder = FilterProtos.TimestampsFilter.newBuilder();
        builder.addAllTimestamps(this.timestamps);
        return builder.build().toByteArray();
    }

    public static TimestampsFilter parseFrom(byte[] pbBytes) throws DeserializationException {
        FilterProtos.TimestampsFilter proto;
        try {
            proto = FilterProtos.TimestampsFilter.parseFrom((byte[])pbBytes);
        }
        catch (InvalidProtocolBufferException e) {
            throw new DeserializationException(e);
        }
        return new TimestampsFilter(proto.getTimestampsList());
    }

    @Override
    boolean areSerializedFieldsEqual(Filter o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TimestampsFilter)) {
            return false;
        }
        TimestampsFilter other = (TimestampsFilter)o;
        return this.getTimestamps().equals(other.getTimestamps());
    }

    @Override
    public String toString() {
        return this.toString(5);
    }

    protected String toString(int maxTimestamps) {
        StringBuilder tsList = new StringBuilder();
        int count = 0;
        for (Long ts : this.timestamps) {
            if (count >= maxTimestamps) break;
            tsList.append(ts.toString());
            if (++count >= this.timestamps.size() || count >= maxTimestamps) continue;
            tsList.append(", ");
        }
        return String.format("%s (%d/%d): [%s]", this.getClass().getSimpleName(), count, this.timestamps.size(), tsList.toString());
    }
}

