/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.QueueACL;
import org.apache.hadoop.yarn.api.records.QueueUserACLInfo;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerAppUtils;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.AllocationConfigurationException;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.AppSchedulable;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSParentQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSSchedulerApp;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSSchedulerNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FairScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.Schedulable;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.SchedulingPolicy;
import org.apache.hadoop.yarn.util.resource.Resources;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class FSLeafQueue
extends FSQueue {
    private static final Log LOG = LogFactory.getLog((String)FSLeafQueue.class.getName());
    private final List<AppSchedulable> runnableAppScheds = new ArrayList<AppSchedulable>();
    private final List<AppSchedulable> nonRunnableAppScheds = new ArrayList<AppSchedulable>();
    private Resource demand = Resources.createResource((int)0);
    private long lastTimeAtMinShare;
    private long lastTimeAtHalfFairShare;

    public FSLeafQueue(String name, FairScheduler scheduler, FSParentQueue parent) {
        super(name, scheduler, parent);
        this.lastTimeAtMinShare = scheduler.getClock().getTime();
        this.lastTimeAtHalfFairShare = scheduler.getClock().getTime();
    }

    public void addApp(FSSchedulerApp app, boolean runnable) {
        AppSchedulable appSchedulable = new AppSchedulable(this.scheduler, app, this);
        app.setAppSchedulable(appSchedulable);
        if (runnable) {
            this.runnableAppScheds.add(appSchedulable);
        } else {
            this.nonRunnableAppScheds.add(appSchedulable);
        }
    }

    void addAppSchedulable(AppSchedulable appSched) {
        this.runnableAppScheds.add(appSched);
    }

    public boolean removeApp(FSSchedulerApp app) {
        if (this.runnableAppScheds.remove(app.getAppSchedulable())) {
            return true;
        }
        if (this.nonRunnableAppScheds.remove(app.getAppSchedulable())) {
            return false;
        }
        throw new IllegalStateException("Given app to remove " + app + " does not exist in queue " + this);
    }

    public Collection<AppSchedulable> getRunnableAppSchedulables() {
        return this.runnableAppScheds;
    }

    public List<AppSchedulable> getNonRunnableAppSchedulables() {
        return this.nonRunnableAppScheds;
    }

    @Override
    public void collectSchedulerApplications(Collection<ApplicationAttemptId> apps) {
        for (AppSchedulable appSched : this.runnableAppScheds) {
            apps.add(appSched.getApp().getApplicationAttemptId());
        }
        for (AppSchedulable appSched : this.nonRunnableAppScheds) {
            apps.add(appSched.getApp().getApplicationAttemptId());
        }
    }

    @Override
    public void setPolicy(SchedulingPolicy policy) throws AllocationConfigurationException {
        if (!SchedulingPolicy.isApplicableTo(policy, (byte)1)) {
            this.throwPolicyDoesnotApplyException(policy);
        }
        this.policy = policy;
    }

    @Override
    public void recomputeShares() {
        this.policy.computeShares(this.getRunnableAppSchedulables(), this.getFairShare());
    }

    @Override
    public Resource getDemand() {
        return this.demand;
    }

    @Override
    public Resource getResourceUsage() {
        Resource usage = Resources.createResource((int)0);
        for (AppSchedulable app : this.runnableAppScheds) {
            Resources.addTo((Resource)usage, (Resource)app.getResourceUsage());
        }
        for (AppSchedulable app : this.nonRunnableAppScheds) {
            Resources.addTo((Resource)usage, (Resource)app.getResourceUsage());
        }
        return usage;
    }

    @Override
    public void updateDemand() {
        Resource maxRes = this.scheduler.getAllocationConfiguration().getMaxResources(this.getName());
        this.demand = Resources.createResource((int)0);
        for (AppSchedulable sched : this.runnableAppScheds) {
            if (Resources.equals((Resource)this.demand, (Resource)maxRes)) break;
            this.updateDemandForApp(sched, maxRes);
        }
        for (AppSchedulable sched : this.nonRunnableAppScheds) {
            if (Resources.equals((Resource)this.demand, (Resource)maxRes)) break;
            this.updateDemandForApp(sched, maxRes);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("The updated demand for " + this.getName() + " is " + this.demand + "; the max is " + maxRes));
        }
    }

    private void updateDemandForApp(AppSchedulable sched, Resource maxRes) {
        sched.updateDemand();
        Resource toAdd = sched.getDemand();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Counting resource from " + sched.getName() + " " + toAdd + "; Total resource consumption for " + this.getName() + " now " + this.demand));
        }
        this.demand = Resources.add((Resource)this.demand, (Resource)toAdd);
        this.demand = Resources.componentwiseMin((Resource)this.demand, (Resource)maxRes);
    }

    @Override
    public Resource assignContainer(FSSchedulerNode node) {
        Resource assigned = Resources.none();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Node " + node.getNodeName() + " offered to queue: " + this.getName()));
        }
        if (!this.assignContainerPreCheck(node)) {
            return assigned;
        }
        Comparator<Schedulable> comparator = this.policy.getComparator();
        Collections.sort(this.runnableAppScheds, comparator);
        for (AppSchedulable sched : this.runnableAppScheds) {
            if (!SchedulerAppUtils.isBlacklisted(sched.getApp(), node, LOG) && !(assigned = sched.assignContainer(node)).equals((Object)Resources.none())) break;
        }
        return assigned;
    }

    @Override
    public List<FSQueue> getChildQueues() {
        return new ArrayList<FSQueue>(1);
    }

    @Override
    public List<QueueUserACLInfo> getQueueUserAclInfo(UserGroupInformation user) {
        QueueUserACLInfo userAclInfo = (QueueUserACLInfo)this.recordFactory.newRecordInstance(QueueUserACLInfo.class);
        ArrayList<QueueACL> operations = new ArrayList<QueueACL>();
        for (QueueACL operation : QueueACL.values()) {
            if (!this.hasAccess(operation, user)) continue;
            operations.add(operation);
        }
        userAclInfo.setQueueName(this.getQueueName());
        userAclInfo.setUserAcls(operations);
        return Collections.singletonList(userAclInfo);
    }

    public long getLastTimeAtMinShare() {
        return this.lastTimeAtMinShare;
    }

    public void setLastTimeAtMinShare(long lastTimeAtMinShare) {
        this.lastTimeAtMinShare = lastTimeAtMinShare;
    }

    public long getLastTimeAtHalfFairShare() {
        return this.lastTimeAtHalfFairShare;
    }

    public void setLastTimeAtHalfFairShare(long lastTimeAtHalfFairShare) {
        this.lastTimeAtHalfFairShare = lastTimeAtHalfFairShare;
    }

    @Override
    public int getNumRunnableApps() {
        return this.runnableAppScheds.size();
    }
}

