/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.QueueACL;
import org.apache.hadoop.yarn.api.records.QueueState;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainer;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerEventType;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ActiveUsersManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.Queue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSAssignment;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.fica.FiCaSchedulerApp;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.fica.FiCaSchedulerNode;

@InterfaceStability.Stable
@InterfaceAudience.Private
public interface CSQueue
extends Queue {
    public CSQueue getParent();

    public void setParent(CSQueue var1);

    @Override
    public String getQueueName();

    public String getQueuePath();

    public float getCapacity();

    public float getAbsoluteCapacity();

    public float getMaximumCapacity();

    public float getAbsoluteMaximumCapacity();

    public float getAbsoluteUsedCapacity();

    public float getUsedCapacity();

    public void setUsedCapacity(float var1);

    public void setAbsoluteUsedCapacity(float var1);

    public Resource getUsedResources();

    public QueueState getState();

    public List<CSQueue> getChildQueues();

    @Override
    public boolean hasAccess(QueueACL var1, UserGroupInformation var2);

    public void submitApplication(FiCaSchedulerApp var1, String var2, String var3) throws AccessControlException;

    public void finishApplication(FiCaSchedulerApp var1, String var2);

    public CSAssignment assignContainers(Resource var1, FiCaSchedulerNode var2);

    public void completedContainer(Resource var1, FiCaSchedulerApp var2, FiCaSchedulerNode var3, RMContainer var4, ContainerStatus var5, RMContainerEventType var6, CSQueue var7);

    public int getNumApplications();

    public void reinitialize(CSQueue var1, Resource var2) throws IOException;

    public void updateClusterResource(Resource var1);

    public ActiveUsersManager getActiveUsersManager();

    public void recoverContainer(Resource var1, FiCaSchedulerApp var2, Container var3);

    public void collectSchedulerApplications(Collection<ApplicationAttemptId> var1);
}

