/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager;

import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.util.ShutdownHookManager;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.YarnException;
import org.apache.hadoop.yarn.YarnUncaughtExceptionHandler;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.NodeHealthStatus;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.event.AsyncDispatcher;
import org.apache.hadoop.yarn.event.Dispatcher;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.server.nodemanager.ContainerExecutor;
import org.apache.hadoop.yarn.server.nodemanager.ContainerManagerEventType;
import org.apache.hadoop.yarn.server.nodemanager.Context;
import org.apache.hadoop.yarn.server.nodemanager.DefaultContainerExecutor;
import org.apache.hadoop.yarn.server.nodemanager.DeletionService;
import org.apache.hadoop.yarn.server.nodemanager.LocalDirsHandlerService;
import org.apache.hadoop.yarn.server.nodemanager.NodeHealthCheckerService;
import org.apache.hadoop.yarn.server.nodemanager.NodeResourceMonitor;
import org.apache.hadoop.yarn.server.nodemanager.NodeResourceMonitorImpl;
import org.apache.hadoop.yarn.server.nodemanager.NodeStatusUpdater;
import org.apache.hadoop.yarn.server.nodemanager.NodeStatusUpdaterImpl;
import org.apache.hadoop.yarn.server.nodemanager.ResourceView;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.ContainerManagerImpl;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.application.Application;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.Container;
import org.apache.hadoop.yarn.server.nodemanager.metrics.NodeManagerMetrics;
import org.apache.hadoop.yarn.server.nodemanager.security.NMContainerTokenSecretManager;
import org.apache.hadoop.yarn.server.nodemanager.webapp.WebServer;
import org.apache.hadoop.yarn.server.security.ApplicationACLsManager;
import org.apache.hadoop.yarn.service.CompositeService;
import org.apache.hadoop.yarn.service.Service;
import org.apache.hadoop.yarn.service.ServiceStateChangeListener;
import org.apache.hadoop.yarn.util.Records;

public class NodeManager
extends CompositeService
implements ServiceStateChangeListener {
    public static final int SHUTDOWN_HOOK_PRIORITY = 30;
    private static final Log LOG = LogFactory.getLog(NodeManager.class);
    protected final NodeManagerMetrics metrics = NodeManagerMetrics.create();
    private ApplicationACLsManager aclsManager;
    private NodeHealthCheckerService nodeHealthChecker;
    private LocalDirsHandlerService dirsHandler;
    private static CompositeService.CompositeServiceShutdownHook nodeManagerShutdownHook;

    public NodeManager() {
        super(NodeManager.class.getName());
    }

    protected NodeStatusUpdater createNodeStatusUpdater(Context context, Dispatcher dispatcher, NodeHealthCheckerService healthChecker) {
        return new NodeStatusUpdaterImpl(context, dispatcher, healthChecker, this.metrics);
    }

    protected NodeResourceMonitor createNodeResourceMonitor() {
        return new NodeResourceMonitorImpl();
    }

    protected ContainerManagerImpl createContainerManager(Context context, ContainerExecutor exec, DeletionService del, NodeStatusUpdater nodeStatusUpdater, ApplicationACLsManager aclsManager, LocalDirsHandlerService dirsHandler) {
        return new ContainerManagerImpl(context, exec, del, nodeStatusUpdater, this.metrics, aclsManager, dirsHandler);
    }

    protected WebServer createWebServer(Context nmContext, ResourceView resourceView, ApplicationACLsManager aclsManager, LocalDirsHandlerService dirsHandler) {
        return new WebServer(nmContext, resourceView, aclsManager, dirsHandler);
    }

    protected void doSecureLogin() throws IOException {
        SecurityUtil.login((Configuration)this.getConfig(), (String)"yarn.nodemanager.keytab", (String)"yarn.nodemanager.principal");
    }

    public void init(Configuration conf) {
        conf.setBoolean("yarn.dispatcher.exit-on-error", true);
        NMContainerTokenSecretManager containerTokenSecretManager = null;
        if (UserGroupInformation.isSecurityEnabled()) {
            LOG.info((Object)"Security is enabled on NodeManager. Creating ContainerTokenSecretManager");
            containerTokenSecretManager = new NMContainerTokenSecretManager(conf);
        }
        NMContext context = new NMContext(containerTokenSecretManager);
        this.aclsManager = new ApplicationACLsManager(conf);
        ContainerExecutor exec = (ContainerExecutor)ReflectionUtils.newInstance((Class)conf.getClass("yarn.nodemanager.container-executor.class", DefaultContainerExecutor.class, ContainerExecutor.class), (Configuration)conf);
        try {
            exec.init();
        }
        catch (IOException e) {
            throw new YarnException("Failed to initialize container executor", (Throwable)e);
        }
        DeletionService del = new DeletionService(exec);
        this.addService((Service)del);
        AsyncDispatcher dispatcher = new AsyncDispatcher();
        this.nodeHealthChecker = new NodeHealthCheckerService();
        this.addService((Service)this.nodeHealthChecker);
        this.dirsHandler = this.nodeHealthChecker.getDiskHandler();
        NodeStatusUpdater nodeStatusUpdater = this.createNodeStatusUpdater(context, (Dispatcher)dispatcher, this.nodeHealthChecker);
        nodeStatusUpdater.register(this);
        NodeResourceMonitor nodeResourceMonitor = this.createNodeResourceMonitor();
        this.addService(nodeResourceMonitor);
        ContainerManagerImpl containerManager = this.createContainerManager(context, exec, del, nodeStatusUpdater, this.aclsManager, this.dirsHandler);
        this.addService((Service)containerManager);
        WebServer webServer = this.createWebServer(context, containerManager.getContainersMonitor(), this.aclsManager, this.dirsHandler);
        this.addService((Service)webServer);
        dispatcher.register(ContainerManagerEventType.class, (EventHandler)containerManager);
        this.addService((Service)dispatcher);
        DefaultMetricsSystem.initialize((String)"NodeManager");
        this.addService(nodeStatusUpdater);
        super.init(conf);
    }

    public void start() {
        try {
            this.doSecureLogin();
        }
        catch (IOException e) {
            throw new YarnException("Failed NodeManager login", (Throwable)e);
        }
        super.start();
    }

    public void stop() {
        super.stop();
        DefaultMetricsSystem.shutdown();
    }

    public NodeHealthCheckerService getNodeHealthChecker() {
        return this.nodeHealthChecker;
    }

    public void stateChanged(Service service) {
        if (NodeStatusUpdaterImpl.class.getName().equals(service.getName()) && Service.STATE.STOPPED.equals((Object)service.getServiceState())) {
            boolean hasToReboot = ((NodeStatusUpdaterImpl)service).hasToRebootNode();
            this.stop();
            if (hasToReboot) {
                LOG.info((Object)"Rebooting the node manager.");
                NodeManager nodeManager = this.createNewNodeManager();
                nodeManager.initAndStartNodeManager(this.getConfig(), hasToReboot);
            }
        }
    }

    private void initAndStartNodeManager(Configuration conf, boolean hasToReboot) {
        try {
            if (hasToReboot && null != nodeManagerShutdownHook) {
                ShutdownHookManager.get().removeShutdownHook((Runnable)nodeManagerShutdownHook);
            }
            nodeManagerShutdownHook = new CompositeService.CompositeServiceShutdownHook((CompositeService)this);
            ShutdownHookManager.get().addShutdownHook((Runnable)nodeManagerShutdownHook, 30);
            this.init(conf);
            this.start();
        }
        catch (Throwable t) {
            LOG.fatal((Object)"Error starting NodeManager", t);
            System.exit(-1);
        }
    }

    NodeManager createNewNodeManager() {
        return new NodeManager();
    }

    public static void main(String[] args) {
        Thread.setDefaultUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new YarnUncaughtExceptionHandler());
        StringUtils.startupShutdownMessage(NodeManager.class, (String[])args, (Log)LOG);
        NodeManager nodeManager = new NodeManager();
        YarnConfiguration conf = new YarnConfiguration();
        nodeManager.initAndStartNodeManager((Configuration)conf, false);
    }

    public static class NMContext
    implements Context {
        private final NodeId nodeId = (NodeId)Records.newRecord(NodeId.class);
        private final ConcurrentMap<ApplicationId, Application> applications = new ConcurrentHashMap<ApplicationId, Application>();
        private final ConcurrentMap<ContainerId, Container> containers = new ConcurrentSkipListMap<ContainerId, Container>();
        private final NMContainerTokenSecretManager containerTokenSecretManager;
        private final NodeHealthStatus nodeHealthStatus = (NodeHealthStatus)RecordFactoryProvider.getRecordFactory(null).newRecordInstance(NodeHealthStatus.class);

        public NMContext(NMContainerTokenSecretManager containerTokenSecretManager) {
            this.containerTokenSecretManager = containerTokenSecretManager;
            this.nodeHealthStatus.setIsNodeHealthy(true);
            this.nodeHealthStatus.setHealthReport("Healthy");
            this.nodeHealthStatus.setLastHealthReportTime(System.currentTimeMillis());
        }

        @Override
        public NodeId getNodeId() {
            return this.nodeId;
        }

        @Override
        public ConcurrentMap<ApplicationId, Application> getApplications() {
            return this.applications;
        }

        @Override
        public ConcurrentMap<ContainerId, Container> getContainers() {
            return this.containers;
        }

        @Override
        public NMContainerTokenSecretManager getContainerTokenSecretManager() {
            return this.containerTokenSecretManager;
        }

        @Override
        public NodeHealthStatus getNodeHealthStatus() {
            return this.nodeHealthStatus;
        }
    }
}

