/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.HarFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.Mapper;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reducer;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.SequenceFileRecordReader;
import org.apache.hadoop.mapred.lib.NullOutputFormat;
import org.apache.hadoop.tools.DistCp;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

public class HadoopArchives
implements Tool {
    private static final Log LOG = LogFactory.getLog(HadoopArchives.class);
    private static final String NAME = "har";
    static final String SRC_LIST_LABEL = "har.src.list";
    static final String DST_DIR_LABEL = "har.dest.path";
    static final String TMP_DIR_LABEL = "har.tmp.dir";
    static final String JOB_DIR_LABEL = "har.job.dir";
    static final String SRC_COUNT_LABEL = "har.src.count";
    static final String TOTAL_SIZE_LABEL = "har.total.size";
    static final String DST_HAR_LABEL = "har.archive.name";
    static final long partSize = 0x80000000L;
    private static final String usage = "archive -archiveName NAME <src>* <dest>\n";
    private JobConf conf;

    public void setConf(Configuration conf) {
        this.conf = conf instanceof JobConf ? (JobConf)conf : new JobConf(conf, HadoopArchives.class);
    }

    public Configuration getConf() {
        return this.conf;
    }

    public HadoopArchives(Configuration conf) {
        this.setConf(conf);
    }

    private static void checkPaths(Configuration conf, List<Path> paths) throws IOException {
        for (Path p : paths) {
            FileSystem fs = p.getFileSystem(conf);
            if (fs.exists(p)) continue;
            throw new FileNotFoundException("Source " + p + " does not exist.");
        }
    }

    private void recursivels(FileSystem fs, Path p, List<FileStatus> out) throws IOException {
        FileStatus[] listStatus;
        FileStatus fstatus = fs.getFileStatus(p);
        if (!fstatus.isDir()) {
            out.add(fstatus);
            return;
        }
        out.add(fstatus);
        for (FileStatus stat : listStatus = fs.listStatus(p)) {
            this.recursivels(fs, stat.getPath(), out);
        }
    }

    private boolean checkValidName(String name) {
        Path tmp = new Path(name);
        if (tmp.depth() != 1) {
            return false;
        }
        return name.endsWith(".har");
    }

    private Path largestDepth(List<Path> paths) {
        Path deepest = paths.get(0);
        for (Path p : paths) {
            if (p.depth() <= deepest.depth()) continue;
            deepest = p;
        }
        return deepest;
    }

    private void writeTopLevelDirs(SequenceFile.Writer srcWriter, List<Path> paths) throws IOException {
        ArrayList<Path> justDirs = new ArrayList<Path>();
        for (Path p : paths) {
            if (!p.getFileSystem(this.getConf()).isFile(p)) {
                justDirs.add(new Path(p.toUri().getPath()));
                continue;
            }
            justDirs.add(new Path(p.getParent().toUri().getPath()));
        }
        TreeMap<String, HashSet> allpaths = new TreeMap<String, HashSet>();
        Path deepest = this.largestDepth(paths);
        Path root = new Path("/");
        for (int i = 0; i < deepest.depth(); ++i) {
            ArrayList<Path> parents = new ArrayList<Path>();
            for (Path p : justDirs) {
                HashSet children;
                if (p.compareTo((Object)root) == 0) continue;
                Path parent = p.getParent();
                if (allpaths.containsKey(parent.toString())) {
                    children = (HashSet)allpaths.get(parent.toString());
                    children.add(p.getName());
                } else {
                    children = new HashSet();
                    children.add(p.getName());
                    allpaths.put(parent.toString(), children);
                }
                parents.add(parent);
            }
            justDirs = parents;
        }
        Set keyVals = allpaths.entrySet();
        for (Map.Entry entry : keyVals) {
            HashSet children = (HashSet)entry.getValue();
            String toWrite = (String)entry.getKey() + " dir ";
            StringBuffer sbuff = new StringBuffer();
            sbuff.append(toWrite);
            for (String child : children) {
                sbuff.append(child + " ");
            }
            toWrite = sbuff.toString();
            srcWriter.append((Writable)new LongWritable(0L), (Writable)new Text(toWrite));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void archive(List<Path> srcPaths, String archiveName, Path dest) throws IOException {
        HadoopArchives.checkPaths((Configuration)this.conf, srcPaths);
        int numFiles = 0;
        long totalSize = 0L;
        this.conf.set(DST_HAR_LABEL, archiveName);
        Path outputPath = new Path(dest, archiveName);
        FileOutputFormat.setOutputPath((JobConf)this.conf, (Path)outputPath);
        FileSystem outFs = outputPath.getFileSystem((Configuration)this.conf);
        if (outFs.exists(outputPath) || outFs.isFile(dest)) {
            throw new IOException("Invalid Output.");
        }
        this.conf.set(DST_DIR_LABEL, outputPath.toString());
        String randomId = DistCp.getRandomId();
        Path jobDirectory = new Path(new JobClient(this.conf).getSystemDir(), "har_" + randomId);
        this.conf.set(JOB_DIR_LABEL, jobDirectory.toString());
        FileSystem jobfs = jobDirectory.getFileSystem((Configuration)this.conf);
        jobfs.mkdirs(jobDirectory);
        Path srcFiles = new Path(jobDirectory, "_har_src_files");
        this.conf.set(SRC_LIST_LABEL, srcFiles.toString());
        SequenceFile.Writer srcWriter = SequenceFile.createWriter((FileSystem)jobfs, (Configuration)this.conf, (Path)srcFiles, LongWritable.class, Text.class, (SequenceFile.CompressionType)SequenceFile.CompressionType.NONE);
        try {
            this.writeTopLevelDirs(srcWriter, srcPaths);
            srcWriter.sync();
            for (Path src : srcPaths) {
                FileSystem fs = src.getFileSystem((Configuration)this.conf);
                ArrayList<FileStatus> allFiles = new ArrayList<FileStatus>();
                this.recursivels(fs, src, allFiles);
                for (FileStatus stat : allFiles) {
                    long len;
                    String toWrite = "";
                    long l = len = stat.isDir() ? 0L : stat.getLen();
                    if (stat.isDir()) {
                        toWrite = "" + fs.makeQualified(stat.getPath()) + " dir ";
                        FileStatus[] list = fs.listStatus(stat.getPath());
                        StringBuffer sbuff = new StringBuffer();
                        sbuff.append(toWrite);
                        for (FileStatus stats : list) {
                            sbuff.append(stats.getPath().getName() + " ");
                        }
                        toWrite = sbuff.toString();
                    } else {
                        toWrite = toWrite + fs.makeQualified(stat.getPath()) + " file ";
                    }
                    srcWriter.append((Writable)new LongWritable(len), (Writable)new Text(toWrite));
                    srcWriter.sync();
                    ++numFiles;
                    totalSize += len;
                }
            }
        }
        finally {
            srcWriter.close();
        }
        jobfs.setReplication(srcFiles, (short)10);
        this.conf.setInt(SRC_COUNT_LABEL, numFiles);
        this.conf.setLong(TOTAL_SIZE_LABEL, totalSize);
        int numMaps = (int)(totalSize / 0x80000000L);
        this.conf.setNumMapTasks(numMaps == 0 ? 1 : numMaps);
        this.conf.setNumReduceTasks(1);
        this.conf.setInputFormat(HArchiveInputFormat.class);
        this.conf.setOutputFormat(NullOutputFormat.class);
        this.conf.setMapperClass(HArchivesMapper.class);
        this.conf.setReducerClass(HArchivesReducer.class);
        this.conf.setMapOutputKeyClass(IntWritable.class);
        this.conf.setMapOutputValueClass(Text.class);
        this.conf.set("hadoop.job.history.user.location", "none");
        FileInputFormat.addInputPath((JobConf)this.conf, (Path)jobDirectory);
        this.conf.setSpeculativeExecution(false);
        JobClient.runJob((JobConf)this.conf);
        try {
            jobfs.delete(jobDirectory, true);
        }
        catch (IOException ie) {
            LOG.info((Object)("Unable to clean tmp directory " + jobDirectory));
        }
    }

    public int run(String[] args) throws Exception {
        try {
            ArrayList<Path> srcPaths = new ArrayList<Path>();
            Path destPath = null;
            String archiveName = null;
            if (args.length < 4) {
                System.out.println(usage);
                throw new IOException("Invalid usage.");
            }
            if (!"-archiveName".equals(args[0])) {
                System.out.println(usage);
                throw new IOException("Archive Name not specified.");
            }
            archiveName = args[1];
            if (!this.checkValidName(archiveName)) {
                System.out.println(usage);
                throw new IOException("Invalid name for archives. " + archiveName);
            }
            for (int i = 2; i < args.length; ++i) {
                if (i == args.length - 1) {
                    destPath = new Path(args[i]);
                    continue;
                }
                srcPaths.add(new Path(args[i]));
            }
            if (srcPaths.size() == 0) {
                System.out.println(usage);
                throw new IOException("Invalid Usage: No input sources specified.");
            }
            ArrayList<Path> globPaths = new ArrayList<Path>();
            for (Path p : srcPaths) {
                FileStatus[] statuses;
                FileSystem fs = p.getFileSystem(this.getConf());
                for (FileStatus status : statuses = fs.globStatus(p)) {
                    globPaths.add(fs.makeQualified(status.getPath()));
                }
            }
            this.archive(globPaths, archiveName, destPath);
        }
        catch (IOException ie) {
            System.err.println(ie.getLocalizedMessage());
            return -1;
        }
        return 0;
    }

    public static void main(String[] args) {
        JobConf job = new JobConf(HadoopArchives.class);
        HadoopArchives harchives = new HadoopArchives((Configuration)job);
        int ret = 0;
        try {
            ret = ToolRunner.run((Tool)harchives, (String[])args);
        }
        catch (Exception e) {
            LOG.debug((Object)"Exception in archives  ", (Throwable)e);
            System.err.println("Exception in archives");
            System.err.println(e.getLocalizedMessage());
            System.exit(1);
        }
        System.exit(ret);
    }

    static class HArchivesReducer
    implements Reducer<IntWritable, Text, Text, Text> {
        private JobConf conf = null;
        private long startIndex = 0L;
        private long endIndex = 0L;
        private long startPos = 0L;
        private Path masterIndex = null;
        private Path index = null;
        private FileSystem fs = null;
        private FSDataOutputStream outStream = null;
        private FSDataOutputStream indexStream = null;
        private int numIndexes = 1000;
        private Path tmpOutputDir = null;
        private int written = 0;
        private int keyVal = 0;

        HArchivesReducer() {
        }

        public void configure(JobConf conf) {
            this.conf = conf;
            this.tmpOutputDir = FileOutputFormat.getWorkOutputPath((JobConf)this.conf);
            this.masterIndex = new Path(this.tmpOutputDir, "_masterindex");
            this.index = new Path(this.tmpOutputDir, "_index");
            try {
                this.fs = this.masterIndex.getFileSystem((Configuration)conf);
                if (this.fs.exists(this.masterIndex)) {
                    this.fs.delete(this.masterIndex, false);
                }
                if (this.fs.exists(this.index)) {
                    this.fs.delete(this.index, false);
                }
                this.indexStream = this.fs.create(this.index);
                this.outStream = this.fs.create(this.masterIndex);
                String version = "1 \n";
                this.outStream.write(version.getBytes());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public void reduce(IntWritable key, Iterator<Text> values, OutputCollector<Text, Text> out, Reporter reporter) throws IOException {
            this.keyVal = key.get();
            while (values.hasNext()) {
                Text value = values.next();
                String towrite = value.toString() + "\n";
                this.indexStream.write(towrite.getBytes());
                ++this.written;
                if (this.written <= this.numIndexes - 1) continue;
                reporter.setStatus("Creating index for archives");
                reporter.progress();
                this.endIndex = this.keyVal;
                String masterWrite = this.startIndex + " " + this.endIndex + " " + this.startPos + " " + this.indexStream.getPos() + " \n";
                this.outStream.write(masterWrite.getBytes());
                this.startPos = this.indexStream.getPos();
                this.startIndex = this.endIndex;
                this.written = 0;
            }
        }

        public void close() throws IOException {
            if (this.written > 0) {
                String masterWrite = this.startIndex + " " + this.keyVal + " " + this.startPos + " " + this.indexStream.getPos() + " \n";
                this.outStream.write(masterWrite.getBytes());
            }
            this.outStream.close();
            this.indexStream.close();
            this.fs.setReplication(this.index, (short)10);
            this.fs.setReplication(this.masterIndex, (short)10);
        }
    }

    static class HArchivesMapper
    implements Mapper<LongWritable, Text, IntWritable, Text> {
        private JobConf conf = null;
        int partId = -1;
        Path tmpOutputDir = null;
        Path tmpOutput = null;
        String partname = null;
        FSDataOutputStream partStream = null;
        FileSystem destFs = null;
        byte[] buffer;
        int buf_size = 131072;

        HArchivesMapper() {
        }

        public void configure(JobConf conf) {
            this.conf = conf;
            this.partId = conf.getInt("mapred.task.partition", -1);
            this.tmpOutputDir = FileOutputFormat.getWorkOutputPath((JobConf)conf);
            this.partname = "part-" + this.partId;
            this.tmpOutput = new Path(this.tmpOutputDir, this.partname);
            try {
                this.destFs = this.tmpOutput.getFileSystem((Configuration)conf);
                if (this.destFs.exists(this.tmpOutput)) {
                    this.destFs.delete(this.tmpOutput, false);
                }
                this.partStream = this.destFs.create(this.tmpOutput);
            }
            catch (IOException ie) {
                throw new RuntimeException("Unable to open output file " + this.tmpOutput);
            }
            this.buffer = new byte[this.buf_size];
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void copyData(Path input, FSDataInputStream fsin, FSDataOutputStream fout, Reporter reporter) throws IOException {
            try {
                int cbread = 0;
                while ((cbread = fsin.read(this.buffer)) >= 0) {
                    fout.write(this.buffer, 0, cbread);
                    reporter.progress();
                }
            }
            finally {
                fsin.close();
            }
        }

        private Path makeRelative(Path p) {
            Path retPath = new Path(p.toUri().getPath());
            return retPath;
        }

        public void map(LongWritable key, Text value, OutputCollector<IntWritable, Text> out, Reporter reporter) throws IOException {
            String line = value.toString();
            MapStat mstat = new MapStat(line);
            Path srcPath = new Path(mstat.pathname);
            String towrite = null;
            Path relPath = this.makeRelative(srcPath);
            int hash = HarFileSystem.getHarHash((Path)relPath);
            long startPos = this.partStream.getPos();
            if (mstat.isDir) {
                towrite = relPath.toString() + " " + "dir none " + 0 + " " + 0 + " ";
                StringBuffer sbuff = new StringBuffer();
                sbuff.append(towrite);
                for (String child : mstat.children) {
                    sbuff.append(child + " ");
                }
                towrite = sbuff.toString();
                reporter.progress();
            } else {
                FileSystem srcFs = srcPath.getFileSystem((Configuration)this.conf);
                FileStatus srcStatus = srcFs.getFileStatus(srcPath);
                FSDataInputStream input = srcFs.open(srcStatus.getPath());
                reporter.setStatus("Copying file " + srcStatus.getPath() + " to archive.");
                this.copyData(srcStatus.getPath(), input, this.partStream, reporter);
                towrite = relPath.toString() + " file " + this.partname + " " + startPos + " " + srcStatus.getLen() + " ";
            }
            out.collect((Object)new IntWritable(hash), (Object)new Text(towrite));
        }

        public void close() throws IOException {
            this.partStream.close();
        }

        static class MapStat {
            private String pathname;
            private boolean isDir;
            private List<String> children;

            public MapStat(String line) {
                String[] splits = line.split(" ");
                this.pathname = splits[0];
                this.isDir = "dir".equals(splits[1]);
                if (this.isDir) {
                    this.children = new ArrayList<String>();
                    for (int i = 2; i < splits.length; ++i) {
                        this.children.add(splits[i]);
                    }
                }
            }
        }
    }

    static class HArchiveInputFormat
    implements InputFormat<LongWritable, Text> {
        HArchiveInputFormat() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public InputSplit[] getSplits(JobConf jconf, int numSplits) throws IOException {
            String srcfilelist = jconf.get(HadoopArchives.SRC_LIST_LABEL, "");
            if ("".equals(srcfilelist)) {
                throw new IOException("Unable to get the src file for archive generation.");
            }
            long totalSize = jconf.getLong(HadoopArchives.TOTAL_SIZE_LABEL, -1L);
            if (totalSize == -1L) {
                throw new IOException("Invalid size of files to archive");
            }
            Path src = new Path(srcfilelist);
            FileSystem fs = src.getFileSystem((Configuration)jconf);
            FileStatus fstatus = fs.getFileStatus(src);
            ArrayList<FileSplit> splits = new ArrayList<FileSplit>(numSplits);
            LongWritable key = new LongWritable();
            Text value = new Text();
            SequenceFile.Reader reader = null;
            long remaining = fstatus.getLen();
            long currentCount = 0L;
            long lastPos = 0L;
            long startPos = 0L;
            long targetSize = totalSize / (long)numSplits;
            try {
                reader = new SequenceFile.Reader(fs, src, (Configuration)jconf);
                while (reader.next((Writable)key, (Writable)value)) {
                    if (currentCount + key.get() > targetSize && currentCount != 0L) {
                        long size = lastPos - startPos;
                        splits.add(new FileSplit(src, startPos, size, (String[])null));
                        remaining -= size;
                        startPos = lastPos;
                        currentCount = 0L;
                    }
                    currentCount += key.get();
                    lastPos = reader.getPosition();
                }
                if (remaining != 0L) {
                    splits.add(new FileSplit(src, startPos, remaining, (String[])null));
                }
            }
            finally {
                reader.close();
            }
            return (InputSplit[])splits.toArray(new FileSplit[splits.size()]);
        }

        public RecordReader<LongWritable, Text> getRecordReader(InputSplit split, JobConf job, Reporter reporter) throws IOException {
            return new SequenceFileRecordReader((Configuration)job, (FileSplit)split);
        }
    }
}

