/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util;

import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.util.QueueProcessingStatistics;
import org.junit.Before;
import org.junit.Test;

public class TestQueueProcessingStatistics
extends TestCase {
    public static final Log testLog = LogFactory.getLog((String)(TestQueueProcessingStatistics.class.getName() + ".testLog"));
    private UnitQueueProcessingStats qStats = new UnitQueueProcessingStats();
    private static final long DEFAULT_CYCLE_DURATION = 25L;
    private static final long DEFAULT_CYCLE_DELAY = 10L;
    private long cycleDuration = 25L;
    private long cycleDelay = 10L;

    @Before
    public void initialize() {
        this.qStats.initialize();
        this.cycleDuration = 25L;
        this.cycleDelay = 10L;
        this.assertExpectedValues(false, QueueProcessingStatistics.State.BEGIN_COLLECTING, 0, 0);
    }

    public void assertExpectedValues(boolean inCycle, QueueProcessingStatistics.State state, Integer workItemCount, Integer cycleCount) {
        TestQueueProcessingStatistics.assertTrue((this.cycleDuration >= 0L ? 1 : 0) != 0);
        TestQueueProcessingStatistics.assertTrue((this.cycleDelay >= 0L ? 1 : 0) != 0);
        if (state != null) {
            TestQueueProcessingStatistics.assertEquals((String)this.failMsg(), (Object)state, (Object)this.qStats.state);
        }
        if (workItemCount != null) {
            TestQueueProcessingStatistics.assertEquals((String)this.failMsg(), (long)workItemCount.intValue(), (long)this.qStats.workItemCount);
        }
        if (cycleCount != null) {
            TestQueueProcessingStatistics.assertEquals((String)this.failMsg(), (int)cycleCount, (int)this.qStats.cycleCount);
        }
        TestQueueProcessingStatistics.assertTrue((String)this.failMsg(), (this.qStats.startTime >= 0L ? 1 : 0) != 0);
        if (this.qStats.state != QueueProcessingStatistics.State.BEGIN_COLLECTING) {
            // empty if block
        }
        TestQueueProcessingStatistics.assertTrue((String)this.failMsg(), (this.qStats.workItemCount >= 0L ? 1 : 0) != 0);
        TestQueueProcessingStatistics.assertTrue((String)this.failMsg(), (this.qStats.cycleCount >= 0 ? 1 : 0) != 0);
        switch (this.qStats.state) {
            case BEGIN_COLLECTING: {
                TestQueueProcessingStatistics.assertFalse((String)this.failMsg(), (boolean)inCycle);
                TestQueueProcessingStatistics.assertEquals((String)this.failMsg(), (long)0L, (long)this.qStats.startTime);
                TestQueueProcessingStatistics.assertEquals((String)this.failMsg(), (long)0L, (long)this.qStats.startTimeCurrentCycle);
                TestQueueProcessingStatistics.assertEquals((String)this.failMsg(), (long)0L, (long)this.qStats.processDuration);
                TestQueueProcessingStatistics.assertEquals((String)this.failMsg(), (long)0L, (long)this.qStats.clockDuration);
                TestQueueProcessingStatistics.assertEquals((String)this.failMsg(), (long)0L, (long)this.qStats.workItemCount);
                TestQueueProcessingStatistics.assertEquals((String)this.failMsg(), (int)0, (int)this.qStats.cycleCount);
                break;
            }
            case IN_FIRST_CYCLE: 
            case IN_SOLE_CYCLE: {
                TestQueueProcessingStatistics.assertTrue((String)this.failMsg(), (boolean)inCycle);
                TestQueueProcessingStatistics.assertTrue((String)this.failMsg(), (this.qStats.startTime > 0L ? 1 : 0) != 0);
                TestQueueProcessingStatistics.assertEquals((String)this.failMsg(), (long)this.qStats.startTime, (long)this.qStats.startTimeCurrentCycle);
                TestQueueProcessingStatistics.assertEquals((String)this.failMsg(), (long)0L, (long)this.qStats.processDuration);
                TestQueueProcessingStatistics.assertEquals((String)this.failMsg(), (long)0L, (long)this.qStats.clockDuration);
                TestQueueProcessingStatistics.assertEquals((String)this.failMsg(), (long)0L, (long)this.qStats.workItemCount);
                TestQueueProcessingStatistics.assertEquals((String)this.failMsg(), (int)0, (int)this.qStats.cycleCount);
                break;
            }
            case DONE_FIRST_CYCLE: {
                TestQueueProcessingStatistics.assertTrue((String)this.failMsg(), (this.qStats.startTime > 0L ? 1 : 0) != 0);
                TestQueueProcessingStatistics.assertTrue((String)this.failMsg(), (this.qStats.cycleCount > 0 ? 1 : 0) != 0);
                break;
            }
            case IN_LAST_CYCLE: {
                TestQueueProcessingStatistics.assertTrue((String)this.failMsg(), (boolean)inCycle);
                TestQueueProcessingStatistics.assertTrue((String)this.failMsg(), (this.qStats.startTime > 0L ? 1 : 0) != 0);
                TestQueueProcessingStatistics.assertTrue((String)this.failMsg(), (this.qStats.cycleCount > 0 ? 1 : 0) != 0);
                break;
            }
            case DONE_COLLECTING: {
                TestQueueProcessingStatistics.assertFalse((String)this.failMsg(), (boolean)inCycle);
                TestQueueProcessingStatistics.assertTrue((String)this.failMsg(), (this.qStats.startTime > 0L ? 1 : 0) != 0);
                TestQueueProcessingStatistics.assertTrue((String)this.failMsg(), (this.qStats.cycleCount > 0 ? 1 : 0) != 0);
                break;
            }
            default: {
                TestQueueProcessingStatistics.fail((String)(this.failMsg() + " Reached unallowed state"));
            }
        }
    }

    private String failMsg() {
        return "State=" + this.qStats.state + " cycleCount=" + this.qStats.cycleCount;
    }

    private boolean almostEquals(long a, long b) {
        long diff = a - b;
        if (diff < 0L) {
            diff = -diff;
        }
        return diff < (long)(2 * (this.qStats.cycleCount + 1));
    }

    private void assertAlmostEquals(long a, long b) {
        if (!this.almostEquals(a, b)) {
            TestQueueProcessingStatistics.fail((String)("Failed almostEquals test: " + a + ", " + b));
        }
    }

    private void assertAlmostEquals(String msg, long a, long b) {
        if (!this.almostEquals(a, b)) {
            TestQueueProcessingStatistics.fail((String)(msg + "; Failed almostEquals test: " + a + ", " + b));
        }
    }

    private int simulateWork(int work) throws InterruptedException {
        Thread.sleep(25L);
        return work;
    }

    private void simulateIntercycleDelay() throws InterruptedException {
        Thread.sleep(10L);
    }

    @Test
    public void testSingleCyclePreDetect() throws InterruptedException {
        int workToDo = 8;
        int maxWorkPerCycle = 10;
        int workDone = 0;
        this.qStats.checkRestart();
        this.assertExpectedValues(false, QueueProcessingStatistics.State.BEGIN_COLLECTING, 0, 0);
        this.qStats.triggerPreDetectLastCycle = true;
        this.qStats.startCycle(workToDo);
        this.assertExpectedValues(true, QueueProcessingStatistics.State.IN_SOLE_CYCLE, 0, 0);
        workDone = this.simulateWork(workToDo);
        this.qStats.expectedLogResult = ExpectedLogResult.EXPECT_END_SOLE_CYCLE;
        this.qStats.endCycle(workDone);
        this.assertExpectedValues(false, QueueProcessingStatistics.State.DONE_COLLECTING, 8, 1);
    }

    @Test
    public void testSingleCyclePostDetect() throws InterruptedException {
        int workToDo = 8;
        int maxWorkPerCycle = 10;
        int workDone = 0;
        this.qStats.checkRestart();
        this.assertExpectedValues(false, QueueProcessingStatistics.State.BEGIN_COLLECTING, 0, 0);
        this.qStats.startCycle(maxWorkPerCycle);
        this.assertExpectedValues(true, QueueProcessingStatistics.State.IN_FIRST_CYCLE, 0, 0);
        workDone = this.simulateWork(workToDo);
        this.qStats.triggerPostDetectLastCycle = true;
        this.qStats.expectedLogResult = ExpectedLogResult.EXPECT_END_SOLE_CYCLE;
        this.qStats.endCycle(workDone);
        this.assertExpectedValues(false, QueueProcessingStatistics.State.DONE_COLLECTING, 8, 1);
    }

    @Test
    public void testMultiCyclePreDetect() throws InterruptedException {
        int workToDo = 28;
        int maxWorkPerCycle = 10;
        int workFound = 0;
        int workDone = 0;
        this.qStats.checkRestart();
        this.assertExpectedValues(false, QueueProcessingStatistics.State.BEGIN_COLLECTING, 0, 0);
        this.qStats.startCycle(maxWorkPerCycle);
        this.assertExpectedValues(true, QueueProcessingStatistics.State.IN_FIRST_CYCLE, workDone, 0);
        workFound = this.simulateWork(maxWorkPerCycle);
        workDone += workFound;
        workToDo -= workFound;
        this.qStats.expectedLogResult = ExpectedLogResult.EXPECT_END_FIRST_CYCLE;
        this.qStats.endCycle(workFound);
        this.assertExpectedValues(false, QueueProcessingStatistics.State.DONE_FIRST_CYCLE, 10, 1);
        this.qStats.expectedLogResult = ExpectedLogResult.NONE;
        this.simulateIntercycleDelay();
        this.qStats.startCycle(maxWorkPerCycle);
        this.assertExpectedValues(true, QueueProcessingStatistics.State.DONE_FIRST_CYCLE, workDone, 1);
        workFound = this.simulateWork(maxWorkPerCycle);
        workDone += workFound;
        workToDo -= workFound;
        this.qStats.endCycle(workFound);
        this.assertExpectedValues(false, QueueProcessingStatistics.State.DONE_FIRST_CYCLE, 20, 2);
        this.simulateIntercycleDelay();
        this.qStats.triggerPreDetectLastCycle = true;
        this.qStats.startCycle(maxWorkPerCycle);
        this.assertExpectedValues(true, QueueProcessingStatistics.State.IN_LAST_CYCLE, workDone, 2);
        workFound = this.simulateWork(workToDo);
        workDone += workFound;
        workToDo -= workFound;
        this.qStats.expectedLogResult = ExpectedLogResult.EXPECT_END_LAST_CYCLE;
        this.qStats.endCycle(workFound);
        this.assertExpectedValues(false, QueueProcessingStatistics.State.DONE_COLLECTING, 28, 3);
    }

    @Test
    public void testMultiCyclePostDetect() throws InterruptedException {
        int workToDo = 28;
        int maxWorkPerCycle = 10;
        int workFound = 0;
        int workDone = 0;
        this.qStats.checkRestart();
        this.assertExpectedValues(false, QueueProcessingStatistics.State.BEGIN_COLLECTING, 0, 0);
        this.qStats.startCycle(maxWorkPerCycle);
        this.assertExpectedValues(true, QueueProcessingStatistics.State.IN_FIRST_CYCLE, workDone, 0);
        workFound = this.simulateWork(maxWorkPerCycle);
        workDone += workFound;
        workToDo -= workFound;
        this.qStats.expectedLogResult = ExpectedLogResult.EXPECT_END_FIRST_CYCLE;
        this.qStats.endCycle(workFound);
        this.assertExpectedValues(false, QueueProcessingStatistics.State.DONE_FIRST_CYCLE, 10, 1);
        this.qStats.expectedLogResult = ExpectedLogResult.NONE;
        this.simulateIntercycleDelay();
        this.qStats.startCycle(maxWorkPerCycle);
        this.assertExpectedValues(true, QueueProcessingStatistics.State.DONE_FIRST_CYCLE, workDone, 1);
        workFound = this.simulateWork(maxWorkPerCycle);
        workDone += workFound;
        workToDo -= workFound;
        this.qStats.endCycle(workFound);
        this.assertExpectedValues(false, QueueProcessingStatistics.State.DONE_FIRST_CYCLE, 20, 2);
        this.simulateIntercycleDelay();
        this.qStats.startCycle(maxWorkPerCycle);
        this.assertExpectedValues(true, QueueProcessingStatistics.State.DONE_FIRST_CYCLE, workDone, 2);
        workFound = this.simulateWork(workToDo);
        workDone += workFound;
        workToDo -= workFound;
        this.qStats.triggerPostDetectLastCycle = true;
        this.qStats.expectedLogResult = ExpectedLogResult.EXPECT_END_LAST_CYCLE;
        this.qStats.endCycle(workFound);
        this.assertExpectedValues(false, QueueProcessingStatistics.State.DONE_COLLECTING, 28, 3);
    }

    @Test
    public void testRestartIncycle() throws InterruptedException {
        int workToDo = 28;
        int maxWorkPerCycle = 10;
        int workFound = 0;
        int workDone = 0;
        this.qStats.checkRestart();
        this.assertExpectedValues(false, QueueProcessingStatistics.State.BEGIN_COLLECTING, 0, 0);
        this.qStats.startCycle(maxWorkPerCycle);
        this.assertExpectedValues(true, QueueProcessingStatistics.State.IN_FIRST_CYCLE, workDone, 0);
        workFound = this.simulateWork(maxWorkPerCycle);
        workDone += workFound;
        workToDo -= workFound;
        this.qStats.expectedLogResult = ExpectedLogResult.EXPECT_END_FIRST_CYCLE;
        this.qStats.endCycle(workFound);
        this.assertExpectedValues(false, QueueProcessingStatistics.State.DONE_FIRST_CYCLE, 10, 1);
        this.qStats.expectedLogResult = ExpectedLogResult.EXPECT_ERROR_WITH_STATUS;
        this.qStats.checkRestart();
        this.assertExpectedValues(false, QueueProcessingStatistics.State.BEGIN_COLLECTING, 0, 0);
    }

    @Test
    public void testRestartAfter() throws InterruptedException {
        this.testSingleCyclePostDetect();
        this.qStats.expectedLogResult = ExpectedLogResult.EXPECT_ERROR;
        this.qStats.checkRestart();
        this.assertExpectedValues(false, QueueProcessingStatistics.State.BEGIN_COLLECTING, 0, 0);
    }

    private class UnitQueueProcessingStats
    extends QueueProcessingStatistics {
        public boolean triggerPreDetectLastCycle;
        public boolean triggerPostDetectLastCycle;
        public ExpectedLogResult expectedLogResult;

        UnitQueueProcessingStats() {
            super("UnitTestQueue", "blocks", testLog);
            this.triggerPreDetectLastCycle = false;
            this.triggerPostDetectLastCycle = false;
            this.expectedLogResult = ExpectedLogResult.NONE;
        }

        void initialize() {
            super.initialize();
            this.triggerPreDetectLastCycle = false;
            this.triggerPostDetectLastCycle = false;
            this.expectedLogResult = ExpectedLogResult.NONE;
        }

        public boolean preCheckIsLastCycle(int maxWorkToProcess) {
            return this.triggerPreDetectLastCycle;
        }

        public boolean postCheckIsLastCycle(int workFound) {
            return this.triggerPostDetectLastCycle;
        }

        void logEndFirstCycle() {
            Assert.assertTrue((this.expectedLogResult == ExpectedLogResult.EXPECT_END_FIRST_CYCLE || this.expectedLogResult == ExpectedLogResult.EXPECT_END_SOLE_CYCLE ? 1 : 0) != 0);
            super.logEndFirstCycle();
        }

        void logEndLastCycle() {
            Assert.assertTrue((this.expectedLogResult == ExpectedLogResult.EXPECT_END_LAST_CYCLE || this.expectedLogResult == ExpectedLogResult.EXPECT_END_SOLE_CYCLE ? 1 : 0) != 0);
            super.logEndLastCycle();
        }

        void logError(String msg) {
            Assert.assertEquals((Object)((Object)ExpectedLogResult.EXPECT_ERROR), (Object)((Object)this.expectedLogResult));
            super.logError(msg);
        }

        void logErrorWithStats(String msg) {
            Assert.assertEquals((Object)((Object)ExpectedLogResult.EXPECT_ERROR_WITH_STATUS), (Object)((Object)this.expectedLogResult));
            super.logErrorWithStats(msg);
        }
    }

    public static enum ExpectedLogResult {
        NONE,
        EXPECT_END_FIRST_CYCLE,
        EXPECT_END_SOLE_CYCLE,
        EXPECT_END_LAST_CYCLE,
        EXPECT_ERROR,
        EXPECT_ERROR_WITH_STATUS;

    }
}

