/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.LinkedHashMap;
import java.util.TreeMap;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.filecache.TrackerDistributedCacheManager;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.LocalDirAllocator;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.CleanupQueue;
import org.apache.hadoop.mapred.DefaultTaskController;
import org.apache.hadoop.mapred.IndexCache;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobID;
import org.apache.hadoop.mapred.JvmManager;
import org.apache.hadoop.mapred.KillJobAction;
import org.apache.hadoop.mapred.MapTask;
import org.apache.hadoop.mapred.QueueManager;
import org.apache.hadoop.mapred.Task;
import org.apache.hadoop.mapred.TaskAttemptID;
import org.apache.hadoop.mapred.TaskController;
import org.apache.hadoop.mapred.TaskLog;
import org.apache.hadoop.mapred.TaskLogServlet;
import org.apache.hadoop.mapred.TaskRunner;
import org.apache.hadoop.mapred.TaskTracker;
import org.apache.hadoop.mapred.UtilsForTests;
import org.apache.hadoop.mapreduce.server.tasktracker.Localizer;
import org.apache.hadoop.mapreduce.server.tasktracker.userlogs.UserLogManager;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.Shell;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

@Ignore
public class TestTaskTrackerLocalization {
    private File TEST_ROOT_DIR;
    private File ROOT_MAPRED_LOCAL_DIR;
    private File HADOOP_LOG_DIR;
    private int numLocalDirs = 6;
    private static final Log LOG = LogFactory.getLog(TestTaskTrackerLocalization.class);
    protected TaskTracker tracker;
    protected UserGroupInformation taskTrackerUGI;
    protected TaskController taskController;
    protected JobConf trackerFConf;
    private JobConf localizedJobConf;
    protected JobID jobId;
    protected TaskAttemptID taskId;
    protected Task task;
    protected String[] localDirs;
    protected static LocalDirAllocator lDirAlloc = new LocalDirAllocator("mapred.local.dir");
    protected Path attemptWorkDir;
    protected File[] attemptLogFiles;
    protected JobConf localizedTaskConf;
    private TaskTracker.TaskInProgress tip;
    private JobConf jobConf;
    private File jobConfFile;

    protected boolean canRun() {
        return true;
    }

    @Before
    public void setUp() throws Exception {
        if (!this.canRun()) {
            return;
        }
        this.TEST_ROOT_DIR = new File(System.getProperty("test.build.data", "/tmp"), this.getClass().getSimpleName());
        if (!this.TEST_ROOT_DIR.exists()) {
            this.TEST_ROOT_DIR.mkdirs();
        }
        this.ROOT_MAPRED_LOCAL_DIR = new File(this.TEST_ROOT_DIR, "mapred/local");
        this.ROOT_MAPRED_LOCAL_DIR.mkdirs();
        this.HADOOP_LOG_DIR = new File(this.TEST_ROOT_DIR, "logs");
        this.HADOOP_LOG_DIR.mkdir();
        System.setProperty("hadoop.log.dir", this.HADOOP_LOG_DIR.getAbsolutePath());
        this.trackerFConf = new JobConf();
        this.trackerFConf.set("fs.default.name", "file:///");
        this.localDirs = new String[this.numLocalDirs];
        for (int i = 0; i < this.numLocalDirs; ++i) {
            this.localDirs[i] = new File(this.ROOT_MAPRED_LOCAL_DIR, "0_" + i).getPath();
        }
        this.trackerFConf.setStrings("mapred.local.dir", this.localDirs);
        this.trackerFConf.setBoolean("mapred.acls.enabled", true);
        this.jobConf = new JobConf((Configuration)this.trackerFConf);
        String jobViewACLs = "user1,user2, group1,group2";
        this.jobConf.set("mapreduce.job.acl-view-job", jobViewACLs);
        this.jobConf.setInt("mapred.userlog.retain.hours", 0);
        this.jobConf.setUser(this.getJobOwner().getShortUserName());
        String queue = "default";
        this.jobConf.setQueueName(queue);
        this.jobConf.set(QueueManager.toFullPropertyName((String)queue, (String)QueueManager.QueueACL.ADMINISTER_JOBS.getAclName()), "qAdmin1,qAdmin2 qAdminsGroup1,qAdminsGroup2");
        String jtIdentifier = "200907202331";
        this.jobId = new JobID(jtIdentifier, 1);
        this.uploadJobJar(this.jobConf);
        this.jobConfFile = this.uploadJobConf(this.jobConf);
        this.uploadJobTokensFile();
        this.taskTrackerUGI = UserGroupInformation.getCurrentUser();
        this.startTracker();
        this.taskId = new TaskAttemptID(jtIdentifier, this.jobId.getId(), true, 1, 0);
        this.createTask();
        TaskTracker taskTracker = this.tracker;
        taskTracker.getClass();
        this.tip = new TaskTracker.TaskInProgress(taskTracker, this.task, this.trackerFConf);
    }

    private void startTracker() throws IOException {
        this.tracker = new TaskTracker();
        this.tracker.setConf(this.trackerFConf);
        this.tracker.setUserLogManager((UserLogManager)new UtilsForTests.InLineUserLogManager((Configuration)this.trackerFConf));
        this.initializeTracker();
    }

    private void initializeTracker() throws IOException {
        this.tracker.setIndexCache(new IndexCache(this.trackerFConf));
        this.tracker.setTaskMemoryManagerEnabledFlag();
        this.tracker.systemFS = FileSystem.getLocal((Configuration)this.trackerFConf);
        this.tracker.systemDirectory = new Path(this.TEST_ROOT_DIR.getAbsolutePath());
        this.tracker.setLocalFileSystem(this.tracker.systemFS);
        this.tracker.runningTasks = new LinkedHashMap();
        this.tracker.runningJobs = new TreeMap();
        this.trackerFConf.deleteLocalFiles("taskTracker");
        this.taskController = this.getTaskController();
        this.taskController.setConf((Configuration)this.trackerFConf);
        this.taskController.setup(lDirAlloc, new TaskTracker.LocalStorage(this.trackerFConf.getLocalDirs()));
        this.tracker.setTaskController(this.taskController);
        this.tracker.setLocalizer(new Localizer(this.tracker.getLocalFileSystem(), this.localDirs));
    }

    protected TaskController getTaskController() {
        return new DefaultTaskController();
    }

    private void createTask() throws IOException {
        this.task = new MapTask(this.jobConfFile.toURI().toString(), this.taskId, 1, null, 1);
        this.task.setConf((Configuration)this.jobConf);
        this.task.setUser(this.jobConf.getUser());
    }

    protected UserGroupInformation getJobOwner() throws IOException {
        return UserGroupInformation.getCurrentUser();
    }

    private void uploadJobJar(JobConf jobConf) throws IOException, FileNotFoundException {
        File jobJarFile = new File(this.TEST_ROOT_DIR, "jobjar-on-dfs.jar");
        JarOutputStream jstream = new JarOutputStream(new FileOutputStream(jobJarFile));
        ZipEntry ze = new ZipEntry("lib/lib1.jar");
        jstream.putNextEntry(ze);
        jstream.closeEntry();
        ze = new ZipEntry("lib/lib2.jar");
        jstream.putNextEntry(ze);
        jstream.closeEntry();
        jstream.finish();
        jstream.close();
        jobConf.setJar(jobJarFile.toURI().toString());
    }

    protected File uploadJobConf(JobConf jobConf) throws FileNotFoundException, IOException {
        File jobConfFile = new File(this.TEST_ROOT_DIR, "jobconf-on-dfs.xml");
        FileOutputStream out = new FileOutputStream(jobConfFile);
        jobConf.writeXml((OutputStream)out);
        out.close();
        return jobConfFile;
    }

    protected void uploadJobTokensFile() throws IOException {
        File dir = new File(this.TEST_ROOT_DIR, this.jobId.toString());
        if (!dir.exists()) {
            Assert.assertTrue((String)("faild to create dir=" + dir.getAbsolutePath()), (boolean)dir.mkdirs());
        }
        new Credentials().writeTokenStorageFile(new Path("file:///" + dir, "jobToken"), new Configuration());
    }

    @After
    public void tearDown() throws Exception {
        if (!this.canRun()) {
            return;
        }
        FileUtil.fullyDelete((File)this.TEST_ROOT_DIR);
    }

    protected static String[] getFilePermissionAttrs(String path) throws IOException {
        String output = Shell.execCommand((String[])new String[]{"stat", path, "-c", "%A:%U:%G"});
        return output.split(":|\n");
    }

    static void checkFilePermissions(String path, String expectedPermissions, String expectedOwnerUser, String expectedOwnerGroup) throws IOException {
        String[] attrs = TestTaskTrackerLocalization.getFilePermissionAttrs(path);
        Assert.assertTrue((String)("File attrs length is not 3 but " + attrs.length), (attrs.length == 3 ? 1 : 0) != 0);
        Assert.assertTrue((String)("Path " + path + " has the permissions " + attrs[0] + " instead of the expected " + expectedPermissions), (boolean)attrs[0].equals(expectedPermissions));
        Assert.assertTrue((String)("Path " + path + " is user owned not by " + expectedOwnerUser + " but by " + attrs[1]), (boolean)attrs[1].equals(expectedOwnerUser));
        Assert.assertTrue((String)("Path " + path + " is group owned not by " + expectedOwnerGroup + " but by " + attrs[2]), (boolean)attrs[2].equals(expectedOwnerGroup));
    }

    @Test
    public void testTaskControllerSetup() throws IOException {
        if (!this.canRun()) {
            return;
        }
        for (String localDir : this.localDirs) {
            File lDir = new File(localDir);
            Assert.assertTrue((String)("localDir " + lDir + " doesn't exists!"), (boolean)lDir.exists());
            TestTaskTrackerLocalization.checkFilePermissions(lDir.getAbsolutePath(), "drwxr-xr-x", this.task.getUser(), this.taskTrackerUGI.getGroupNames()[0]);
        }
        File taskLog = TaskLog.getUserLogDir();
        TestTaskTrackerLocalization.checkFilePermissions(taskLog.getAbsolutePath(), "drwxr-xr-x", this.task.getUser(), this.taskTrackerUGI.getGroupNames()[0]);
    }

    @Test
    public void testUserLocalization() throws IOException {
        File userDir;
        if (!this.canRun()) {
            return;
        }
        this.tracker.getLocalizer().initializeUserDirs(this.task.getUser());
        this.checkUserLocalization();
        for (String dir : this.localDirs) {
            userDir = new File(dir, TaskTracker.getUserDir((String)this.task.getUser()));
            if (FileUtil.fullyDelete((File)userDir)) continue;
            throw new IOException("Uanble to delete " + userDir);
        }
        this.tracker.getLocalizer().initializeUserDirs(this.task.getUser());
        for (String dir : this.localDirs) {
            userDir = new File(dir, TaskTracker.getUserDir((String)this.task.getUser()));
            Assert.assertFalse((String)("Unexpectedly, user-dir " + userDir.getAbsolutePath() + " exists!"), (boolean)userDir.exists());
        }
    }

    protected void checkUserLocalization() throws IOException {
        for (String dir : this.localDirs) {
            File localDir = new File(dir);
            Assert.assertTrue((String)("mapred.local.dir " + localDir + " isn'task created!"), (boolean)localDir.exists());
            File taskTrackerSubDir = new File(localDir, "taskTracker");
            Assert.assertTrue((String)("taskTracker sub-dir in the local-dir " + localDir + "is not created!"), (boolean)taskTrackerSubDir.exists());
            File userDir = new File(taskTrackerSubDir, this.task.getUser());
            Assert.assertTrue((String)("user-dir in taskTrackerSubdir " + taskTrackerSubDir + "is not created!"), (boolean)userDir.exists());
            TestTaskTrackerLocalization.checkFilePermissions(userDir.getAbsolutePath(), "drwx------", this.task.getUser(), this.taskTrackerUGI.getGroupNames()[0]);
            File jobCache = new File(userDir, "jobcache");
            Assert.assertTrue((String)("jobcache in the userDir " + userDir + " isn't created!"), (boolean)jobCache.exists());
            TestTaskTrackerLocalization.checkFilePermissions(jobCache.getAbsolutePath(), "drwx------", this.task.getUser(), this.taskTrackerUGI.getGroupNames()[0]);
            File distributedCacheDir = new File(localDir, TaskTracker.getPrivateDistributedCacheDir((String)this.task.getUser()));
            Assert.assertTrue((String)("distributed cache dir " + distributedCacheDir + " doesn't exists!"), (boolean)distributedCacheDir.exists());
            TestTaskTrackerLocalization.checkFilePermissions(distributedCacheDir.getAbsolutePath(), "drwx------", this.task.getUser(), this.taskTrackerUGI.getGroupNames()[0]);
        }
    }

    @Test
    public void testJobLocalization() throws Exception {
        if (!this.canRun()) {
            return;
        }
        TaskTracker.RunningJob rjob = this.tracker.localizeJob(this.tip);
        this.localizedJobConf = rjob.getJobConf();
        this.checkJobLocalization();
    }

    protected void checkJobLocalization() throws IOException {
        for (String dir : this.localDirs) {
            File localDir = new File(dir);
            File taskTrackerSubDir = new File(localDir, "taskTracker");
            File userDir = new File(taskTrackerSubDir, this.task.getUser());
            File jobCache = new File(userDir, "jobcache");
            File jobDir = new File(jobCache, this.jobId.toString());
            Assert.assertTrue((String)("job-dir in " + jobCache + " isn't created!"), (boolean)jobDir.exists());
            TestTaskTrackerLocalization.checkFilePermissions(jobDir.getAbsolutePath(), "drwx------", this.task.getUser(), this.taskTrackerUGI.getGroupNames()[0]);
        }
        Assert.assertTrue((String)"job.xml is not localized on this TaskTracker!!", (lDirAlloc.getLocalPathToRead(TaskTracker.getLocalJobConfFile((String)this.task.getUser(), (String)this.jobId.toString()), (Configuration)this.trackerFConf) != null ? 1 : 0) != 0);
        Path jarFileLocalized = lDirAlloc.getLocalPathToRead(TaskTracker.getJobJarFile((String)this.task.getUser(), (String)this.jobId.toString()), (Configuration)this.trackerFConf);
        Assert.assertTrue((String)"job.jar is not localized on this TaskTracker!!", (jarFileLocalized != null ? 1 : 0) != 0);
        Assert.assertTrue((String)"lib/lib1.jar is not unjarred on this TaskTracker!!", (boolean)new File(jarFileLocalized.getParent() + "/" + "lib/lib1.jar").exists());
        Assert.assertTrue((String)"lib/lib2.jar is not unjarred on this TaskTracker!!", (boolean)new File(jarFileLocalized.getParent() + "/" + "lib/lib2.jar").exists());
        Assert.assertTrue((String)"job-work dir is not created on this TaskTracker!!", (lDirAlloc.getLocalPathToRead(TaskTracker.getJobWorkDir((String)this.task.getUser(), (String)this.jobId.toString()), (Configuration)this.trackerFConf) != null ? 1 : 0) != 0);
        boolean jobLocalDirFlag = false;
        boolean mapredJarFlag = false;
        String localizedJobLocalDir = this.localizedJobConf.get("job.local.dir");
        String localizedJobJar = this.localizedJobConf.getJar();
        for (String localDir : this.localizedJobConf.getStrings("mapred.local.dir")) {
            if (localizedJobLocalDir.equals(localDir + "/" + TaskTracker.getJobWorkDir((String)this.task.getUser(), (String)this.jobId.toString()))) {
                jobLocalDirFlag = true;
            }
            if (!localizedJobJar.equals(localDir + "/" + TaskTracker.getJobJarFile((String)this.task.getUser(), (String)this.jobId.toString()))) continue;
            mapredJarFlag = true;
        }
        Assert.assertTrue((String)("job.local.dir is not set properly to the target users directory : " + localizedJobLocalDir), (boolean)jobLocalDirFlag);
        Assert.assertTrue((String)("mapred.jar is not set properly to the target users directory : " + localizedJobJar), (boolean)mapredJarFlag);
        File jobLogDir = TaskLog.getJobDir((org.apache.hadoop.mapreduce.JobID)this.jobId);
        Assert.assertTrue((String)("job log directory " + jobLogDir + " does not exist!"), (boolean)jobLogDir.exists());
        TestTaskTrackerLocalization.checkFilePermissions(jobLogDir.toString(), "drwx------", this.task.getUser(), this.taskTrackerUGI.getGroupNames()[0]);
        File jobACLsFile = new File(jobLogDir, TaskTracker.jobACLsFile);
        Assert.assertTrue((String)("JobACLsFile is missing in the job userlog dir " + jobLogDir), (boolean)jobACLsFile.exists());
        TestTaskTrackerLocalization.checkFilePermissions(jobACLsFile.getAbsolutePath(), "-rwx------", this.taskTrackerUGI.getShortUserName(), this.taskTrackerUGI.getGroupNames()[0]);
        this.validateJobACLsFileContent();
    }

    protected void validateJobACLsFileContent() {
        JobConf jobACLsConf = TaskLogServlet.getConfFromJobACLsFile((JobID)this.jobId);
        Assert.assertTrue((boolean)jobACLsConf.get("user.name").equals(this.localizedJobConf.getUser()));
        Assert.assertTrue((boolean)jobACLsConf.get("mapreduce.job.acl-view-job").equals(this.localizedJobConf.get("mapreduce.job.acl-view-job")));
        String queue = this.localizedJobConf.getQueueName();
        Assert.assertTrue((boolean)queue.equalsIgnoreCase(jobACLsConf.getQueueName()));
        String qACLName = QueueManager.toFullPropertyName((String)queue, (String)QueueManager.QueueACL.ADMINISTER_JOBS.getAclName());
        Assert.assertTrue((boolean)jobACLsConf.get(qACLName).equals(this.localizedJobConf.get(qACLName)));
    }

    @Test
    public void testTaskLocalization() throws Exception {
        if (!this.canRun()) {
            return;
        }
        TaskTracker.RunningJob rjob = this.tracker.localizeJob(this.tip);
        this.localizedJobConf = rjob.getJobConf();
        this.initializeTask();
        this.checkTaskLocalization();
    }

    protected void checkTaskLocalization() throws IOException {
        for (String childMapredLocalDir : this.localizedTaskConf.getStrings("mapred.local.dir")) {
            Assert.assertTrue((String)("Local dir " + childMapredLocalDir + " is not sandboxed !!"), (boolean)childMapredLocalDir.endsWith(TaskTracker.getLocalTaskDir((String)this.task.getUser(), (String)this.jobId.toString(), (String)this.taskId.toString(), (boolean)this.task.isTaskCleanupTask())));
        }
        Assert.assertTrue((boolean)this.task.getJobFile().endsWith(TaskTracker.getTaskConfFile((String)this.task.getUser(), (String)this.jobId.toString(), (String)this.taskId.toString(), (boolean)this.task.isTaskCleanupTask())));
        Assert.assertTrue((String)("tmp dir is not created in workDir " + this.attemptWorkDir.toUri().getPath()), (boolean)new File(this.attemptWorkDir.toUri().getPath(), "tmp").exists());
        File logDir = TaskLog.getAttemptDir((TaskAttemptID)this.taskId, (boolean)this.task.isTaskCleanupTask());
        Assert.assertTrue((String)("task's log dir " + logDir.toString() + " doesn't exist!"), (boolean)logDir.exists());
        TestTaskTrackerLocalization.checkFilePermissions(logDir.getAbsolutePath(), "drwx------", this.task.getUser(), this.taskTrackerUGI.getGroupNames()[0]);
        File expectedStdout = new File(logDir, TaskLog.LogName.STDOUT.toString());
        Assert.assertTrue((String)("stdout log file is improper. Expected : " + expectedStdout.toString() + " Observed : " + this.attemptLogFiles[0].toString()), (boolean)expectedStdout.toString().equals(this.attemptLogFiles[0].toString()));
        File expectedStderr = new File(logDir, "/" + TaskLog.LogName.STDERR.toString());
        Assert.assertTrue((String)("stderr log file is improper. Expected : " + expectedStderr.toString() + " Observed : " + this.attemptLogFiles[1].toString()), (boolean)expectedStderr.toString().equals(this.attemptLogFiles[1].toString()));
    }

    static void createFileAndSetPermissions(JobConf jobConf, Path dir) throws IOException {
        Path subDir = new Path(dir, "subDir");
        LocalFileSystem fs = FileSystem.getLocal((Configuration)jobConf);
        fs.mkdirs(subDir);
        Path p = new Path(subDir, "file");
        FSDataOutputStream out = fs.create(p);
        out.writeBytes("dummy input");
        out.close();
        int ret = 0;
        ret = FileUtil.chmod((String)subDir.toUri().getPath(), (String)"a=rx", (boolean)true);
        if (ret != 0) {
            LOG.warn((Object)("chmod failed for " + subDir + ";retVal=" + ret));
        }
    }

    void validateRemoveTaskFiles(boolean needCleanup, boolean jvmReuse, TaskTracker.TaskInProgress tip) throws IOException {
        String dir = !needCleanup || jvmReuse ? TaskTracker.getTaskWorkDir((String)this.task.getUser(), (String)this.task.getJobID().toString(), (String)this.taskId.toString(), (boolean)this.task.isTaskCleanupTask()) : TaskTracker.getLocalTaskDir((String)this.task.getUser(), (String)this.task.getJobID().toString(), (String)this.taskId.toString(), (boolean)this.task.isTaskCleanupTask());
        Path[] paths = this.tracker.getLocalFiles(this.localizedJobConf, dir);
        Assert.assertTrue((String)"No paths found", (paths.length > 0 ? 1 : 0) != 0);
        for (Path p : paths) {
            if (!this.tracker.getLocalFileSystem().exists(p)) continue;
            TestTaskTrackerLocalization.createFileAndSetPermissions(this.localizedJobConf, p);
        }
        UtilsForTests.InlineCleanupQueue cleanupQueue = new UtilsForTests.InlineCleanupQueue();
        this.tracker.setCleanupThread((CleanupQueue)cleanupQueue);
        tip.removeTaskFiles(needCleanup);
        if (jvmReuse) {
            Assert.assertTrue((String)"cleanup queue is not empty after removeTaskFiles() in case of jvm reuse.", (boolean)cleanupQueue.isQueueEmpty());
            boolean workDirExists = false;
            for (Path p : paths) {
                if (!this.tracker.getLocalFileSystem().exists(p)) continue;
                workDirExists = true;
            }
            Assert.assertTrue((String)"work dir does not exist in case of jvm reuse", (boolean)workDirExists);
            JvmManager.deleteWorkDir((TaskTracker)this.tracker, (Task)this.task);
        }
        Assert.assertTrue((String)("Some task files are not deleted!! Number of stale paths is " + cleanupQueue.stalePaths.size()), (cleanupQueue.stalePaths.size() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testTaskFilesRemoval() throws Exception {
        if (!this.canRun()) {
            return;
        }
        this.testTaskFilesRemoval(false, false);
    }

    @Test
    public void testFailedTaskFilesRemoval() throws Exception {
        if (!this.canRun()) {
            return;
        }
        this.testTaskFilesRemoval(true, false);
        this.task.setTaskCleanupTask();
        this.initializeTask();
        this.checkTaskLocalization();
        this.testTaskFilesRemoval(true, false);
    }

    @Test
    public void testTaskFilesRemovalWithJvmUse() throws Exception {
        if (!this.canRun()) {
            return;
        }
        this.testTaskFilesRemoval(false, true);
    }

    private void initializeTask() throws IOException {
        this.tip.setJobConf(this.localizedJobConf);
        this.tip.localizeTask(this.task);
        for (String dir : this.trackerFConf.getStrings("mapred.local.dir")) {
            File attemptDir = new File(dir, TaskTracker.getLocalTaskDir((String)this.task.getUser(), (String)this.jobId.toString(), (String)this.taskId.toString(), (boolean)this.task.isTaskCleanupTask()));
            Assert.assertTrue((String)("attempt-dir " + attemptDir + " in localDir " + dir + " is not created!!"), (boolean)attemptDir.exists());
        }
        this.attemptWorkDir = lDirAlloc.getLocalPathToRead(TaskTracker.getTaskWorkDir((String)this.task.getUser(), (String)this.task.getJobID().toString(), (String)this.task.getTaskID().toString(), (boolean)this.task.isTaskCleanupTask()), (Configuration)this.trackerFConf);
        Assert.assertTrue((String)("atttempt work dir for " + this.taskId.toString() + " is not created in any of the configured dirs!!"), (this.attemptWorkDir != null ? 1 : 0) != 0);
        TaskTracker.RunningJob rjob = new TaskTracker.RunningJob(this.jobId);
        DefaultTaskController taskController = new DefaultTaskController();
        taskController.setConf((Configuration)this.trackerFConf);
        rjob.distCacheMgr = new TrackerDistributedCacheManager((Configuration)this.trackerFConf, (TaskController)taskController).newTaskDistributedCacheManager((org.apache.hadoop.mapreduce.JobID)this.jobId, (Configuration)this.trackerFConf);
        TaskRunner runner = this.task.createRunner(this.tracker, this.tip, rjob);
        this.tip.setTaskRunner(runner);
        runner.setupChildTaskConfiguration(lDirAlloc);
        TaskRunner.createChildTmpDir((File)new File(this.attemptWorkDir.toUri().getPath()), (JobConf)this.localizedJobConf, (boolean)true);
        this.attemptLogFiles = runner.prepareLogFiles(this.task.getTaskID(), this.task.isTaskCleanupTask());
        Path localTaskFile = lDirAlloc.getLocalPathToRead(TaskTracker.getTaskConfFile((String)this.task.getUser(), (String)this.task.getJobID().toString(), (String)this.task.getTaskID().toString(), (boolean)this.task.isTaskCleanupTask()), (Configuration)this.trackerFConf);
        Assert.assertTrue((String)("Task conf file " + localTaskFile.toString() + " is not created!!"), (boolean)new File(localTaskFile.toUri().getPath()).exists());
        this.localizedTaskConf = new JobConf(localTaskFile);
        TaskRunner.setupChildMapredLocalDirs((Task)this.task, (JobConf)this.localizedTaskConf);
    }

    private void testTaskFilesRemoval(boolean needCleanup, boolean jvmReuse) throws Exception {
        TaskTracker.RunningJob rjob = this.tracker.localizeJob(this.tip);
        this.localizedJobConf = rjob.getJobConf();
        if (jvmReuse) {
            this.localizedJobConf.setNumTasksToExecutePerJvm(2);
        }
        this.initializeTask();
        this.validateRemoveTaskFiles(needCleanup, jvmReuse, this.tip);
    }

    private void verifyUserLogsRemoval() throws IOException {
        File jobUserLogDir = TaskLog.getJobDir((org.apache.hadoop.mapreduce.JobID)this.jobId);
        Assert.assertTrue((String)("Userlogs dir " + jobUserLogDir + " is not present as expected!!"), (boolean)jobUserLogDir.exists());
        this.tracker.purgeJob(new KillJobAction(this.jobId));
        this.tracker.getUserLogManager().getUserLogCleaner().processCompletedJobs();
        Assert.assertFalse((String)("Userlogs dir " + jobUserLogDir + " is not deleted as expected!!"), (boolean)jobUserLogDir.exists());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testJobFilesRemoval() throws IOException, InterruptedException {
        void var9_16;
        if (!this.canRun()) {
            return;
        }
        LOG.info((Object)"Running testJobCleanup()");
        UtilsForTests.InlineCleanupQueue cleanupQueue = new UtilsForTests.InlineCleanupQueue();
        this.tracker.setCleanupThread((CleanupQueue)cleanupQueue);
        TaskTracker.RunningJob rjob = this.tracker.localizeJob(this.tip);
        this.localizedJobConf = rjob.getJobConf();
        String jobWorkDir = TaskTracker.getJobWorkDir((String)this.task.getUser(), (String)this.task.getJobID().toString());
        Path[] jPaths = this.tracker.getLocalFiles(this.localizedJobConf, jobWorkDir);
        Assert.assertTrue((String)"No paths found for job", (jPaths.length > 0 ? 1 : 0) != 0);
        for (Path p : jPaths) {
            if (!this.tracker.getLocalFileSystem().exists(p)) continue;
            TestTaskTrackerLocalization.createFileAndSetPermissions(this.localizedJobConf, p);
        }
        this.tip.setJobConf(this.localizedJobConf);
        this.tip.localizeTask(this.task);
        String taskLocalDir = TaskTracker.getLocalTaskDir((String)this.task.getUser(), (String)this.task.getJobID().toString(), (String)this.task.getTaskID().toString(), (boolean)false);
        Path[] tPaths = this.tracker.getLocalFiles(this.localizedJobConf, taskLocalDir);
        Assert.assertTrue((String)"No paths found for task", (tPaths.length > 0 ? 1 : 0) != 0);
        Path[] arr$ = tPaths;
        int len$ = arr$.length;
        boolean bl = false;
        while (var9_16 < len$) {
            Path p = arr$[var9_16];
            if (this.tracker.getLocalFileSystem().exists(p)) {
                TestTaskTrackerLocalization.createFileAndSetPermissions(this.localizedJobConf, p);
            }
            ++var9_16;
        }
        this.tracker.removeJobFiles(this.task.getUser(), this.task.getJobID());
        boolean tLocalDirExists = false;
        for (Path p : tPaths) {
            if (!this.tracker.getLocalFileSystem().exists(p)) continue;
            tLocalDirExists = true;
        }
        Assert.assertFalse((String)("Task " + this.task.getTaskID() + " local dir exists after cleanup"), (boolean)tLocalDirExists);
        boolean jWorkDirExists = false;
        for (Path path : jPaths) {
            if (!this.tracker.getLocalFileSystem().exists(path)) continue;
            jWorkDirExists = true;
        }
        Assert.assertFalse((String)("Job " + this.task.getJobID() + " work dir exists after cleanup"), (boolean)jWorkDirExists);
        this.verifyUserLogsRemoval();
        for (String string : this.localDirs) {
            Path userDir = new Path(string, TaskTracker.getUserDir((String)this.task.getUser()));
            Assert.assertTrue((String)("User directory " + userDir + " is not present!!"), (boolean)this.tracker.getLocalFileSystem().exists(userDir));
        }
    }

    @Test
    public void testTrackerRestart() throws IOException, InterruptedException {
        if (!this.canRun()) {
            return;
        }
        TaskTracker.RunningJob rjob = this.tracker.localizeJob(this.tip);
        this.localizedJobConf = rjob.getJobConf();
        this.initializeTask();
        this.startTracker();
        this.createTask();
        this.task.setTaskCleanupTask();
        TaskTracker taskTracker = this.tracker;
        taskTracker.getClass();
        this.tip = new TaskTracker.TaskInProgress(taskTracker, this.task, this.trackerFConf);
        rjob = this.tracker.localizeJob(this.tip);
        this.localizedJobConf = rjob.getJobConf();
        this.checkJobLocalization();
        this.initializeTask();
        this.checkTaskLocalization();
    }

    @Test
    public void testTrackerReinit() throws IOException, InterruptedException {
        if (!this.canRun()) {
            return;
        }
        TaskTracker.RunningJob rjob = this.tracker.localizeJob(this.tip);
        this.localizedJobConf = rjob.getJobConf();
        this.initializeTask();
        this.initializeTracker();
        this.createTask();
        this.task.setTaskCleanupTask();
        TaskTracker taskTracker = this.tracker;
        taskTracker.getClass();
        this.tip = new TaskTracker.TaskInProgress(taskTracker, this.task, this.trackerFConf);
        rjob = this.tracker.localizeJob(this.tip);
        this.localizedJobConf = rjob.getJobConf();
        this.checkJobLocalization();
        this.initializeTask();
        this.checkTaskLocalization();
    }

    @Test
    public void testCleanupTaskLocalization() throws IOException, InterruptedException {
        if (!this.canRun()) {
            return;
        }
        this.task.setTaskCleanupTask();
        TaskTracker taskTracker = this.tracker;
        taskTracker.getClass();
        this.tip = new TaskTracker.TaskInProgress(taskTracker, this.task, this.trackerFConf);
        TaskTracker.RunningJob rjob = this.tracker.localizeJob(this.tip);
        this.localizedJobConf = rjob.getJobConf();
        this.checkJobLocalization();
        this.initializeTask();
        this.checkTaskLocalization();
    }
}

