/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.MiniDFSClusterWithNodeGroup;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.mapred.Counters;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobInProgress;
import org.apache.hadoop.mapred.MiniMRCluster;
import org.apache.hadoop.mapred.MiniMRClusterWithNodeGroup;
import org.apache.hadoop.mapred.RunningJob;
import org.apache.hadoop.mapred.SequenceFileOutputFormat;
import org.apache.hadoop.mapred.SortValidator;
import org.apache.hadoop.mapred.UtilsForTests;
import org.apache.hadoop.mapred.lib.IdentityMapper;
import org.apache.hadoop.mapred.lib.IdentityReducer;
import org.apache.hadoop.net.StaticMapping;
import org.junit.BeforeClass;

public class TestNodeGroupAwareTaskPlacement
extends TestCase {
    private static final String[] rack1 = new String[]{"/r1"};
    private static final String[] nodeGroup1 = new String[]{"/nodegroup1"};
    private static final String[] hosts1 = new String[]{"host1.nodegroup1.rack1"};
    private static final String[] rack2 = new String[]{"/r1", "/r2"};
    private static final String[] nodeGroup2 = new String[]{"/nodegroup2", "/nodegroup3"};
    private static final String[] hosts2 = new String[]{"host2.nodegroup2.rack1", "host2.nodegroup3.rack2"};
    private static final String[] hosts3 = new String[]{"host2.nodegroup3.rack2"};
    private static final String[] nodeGroup3 = new String[]{"/nodegroup3"};
    private static final String[] rack3 = new String[]{"/r2"};
    private static final String[] hosts4 = new String[]{"host3.nodegroup1.rack1"};
    private static final String[] nodeGroup4 = new String[]{"/nodegroup1"};
    private static final String[] rack4 = new String[]{"/r1"};
    final Path inDir = new Path("/nodegrouptesting");
    final Path outputPath = new Path("/output");

    static void launchJobAndTestCounters(String jobName, MiniMRCluster mr, FileSystem fileSys, Path in, Path out, int numMaps, int otherLocalMaps, int rackLocalMaps, int nodeGroupLocalMaps, int dataLocalMaps, JobConf jobConfig) throws IOException {
        JobConf jobConf = mr.createJobConf(jobConfig);
        if (fileSys.exists(out)) {
            fileSys.delete(out, true);
        }
        RunningJob job = TestNodeGroupAwareTaskPlacement.launchJob(jobConf, in, out, numMaps, jobName);
        Counters counters = job.getCounters();
        TestNodeGroupAwareTaskPlacement.assertEquals((String)"Number of local maps", (long)counters.getCounter((Enum)JobInProgress.Counter.OTHER_LOCAL_MAPS), (long)otherLocalMaps);
        TestNodeGroupAwareTaskPlacement.assertEquals((String)"Number of Data-local maps", (long)counters.getCounter((Enum)JobInProgress.Counter.DATA_LOCAL_MAPS), (long)dataLocalMaps);
        TestNodeGroupAwareTaskPlacement.assertEquals((String)"Number of NodeGroup-local maps", (long)counters.getCounter((Enum)JobInProgress.Counter.NODEGROUP_LOCAL_MAPS), (long)nodeGroupLocalMaps);
        TestNodeGroupAwareTaskPlacement.assertEquals((String)"Number of Rack-local maps", (long)counters.getCounter((Enum)JobInProgress.Counter.RACK_LOCAL_MAPS), (long)rackLocalMaps);
        mr.waitUntilIdle();
        mr.shutdown();
    }

    @BeforeClass
    public void setUp() {
        StaticMapping.addNodeToRack(hosts1[0], rack1[0] + nodeGroup1[0]);
        StaticMapping.addNodeToRack(hosts2[0], rack2[0] + nodeGroup2[0]);
        StaticMapping.addNodeToRack(hosts2[1], rack2[1] + nodeGroup2[1]);
        StaticMapping.addNodeToRack(hosts4[0], rack4[0] + nodeGroup4[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTaskPlacement() throws IOException {
        String namenode = null;
        MiniDFSCluster dfs = null;
        MiniMRCluster mr = null;
        FileSystem fileSys = null;
        String testName = "TestForNodeGroupAwareness";
        try {
            boolean taskTrackers = true;
            Configuration conf = new Configuration();
            conf.setBoolean("dfs.replication.considerLoad", false);
            conf.set("dfs.block.replicator.classname", "org.apache.hadoop.hdfs.server.namenode.BlockPlacementPolicyWithNodeGroup");
            conf.set("net.topology.impl", "org.apache.hadoop.net.NetworkTopologyWithNodeGroup");
            conf.setBoolean("net.topology.nodegroup.aware", true);
            conf.setBoolean("mapred.jobtracker.nodegroup.aware", true);
            conf.setInt("mapred.task.cache.levels", 3);
            conf.set("mapred.jobtracker.jobSchedulable", "org.apache.hadoop.mapred.JobSchedulableWithNodeGroup");
            JobConf jobConf = new JobConf(conf);
            MiniDFSClusterWithNodeGroup.setNodeGroups(nodeGroup1);
            dfs = new MiniDFSClusterWithNodeGroup(0, conf, 1, true, true, null, rack1, hosts1, null);
            dfs.waitActive();
            fileSys = dfs.getFileSystem();
            if (!fileSys.mkdirs(this.inDir)) {
                throw new IOException("Mkdirs failed to create " + this.inDir.toString());
            }
            UtilsForTests.writeFile(dfs.getNameNode(), conf, new Path(this.inDir + "/file1"), (short)1);
            ((MiniDFSClusterWithNodeGroup)dfs).startDataNodes(conf, 2, true, null, rack2, nodeGroup2, hosts2, null);
            dfs.waitActive();
            UtilsForTests.writeFile(dfs.getNameNode(), conf, new Path(this.inDir + "/file2"), (short)3);
            UtilsForTests.writeFile(dfs.getNameNode(), conf, new Path(this.inDir + "/file3"), (short)3);
            namenode = dfs.getFileSystem().getUri().getHost() + ":" + dfs.getFileSystem().getUri().getPort();
            mr = new MiniMRClusterWithNodeGroup(1, namenode, 1, rack3, nodeGroup3, hosts3, jobConf);
            TestNodeGroupAwareTaskPlacement.launchJobAndTestCounters(testName, mr, fileSys, this.inDir, this.outputPath, 3, 0, 0, 0, 2, jobConf);
            mr.shutdown();
            mr = new MiniMRClusterWithNodeGroup(1, namenode, 1, rack4, nodeGroup4, hosts4, jobConf);
            TestNodeGroupAwareTaskPlacement.launchJobAndTestCounters(testName, mr, fileSys, this.inDir, this.outputPath, 3, 0, 0, 3, 0, jobConf);
            mr.shutdown();
        }
        finally {
            if (dfs != null) {
                dfs.shutdown();
            }
            if (mr != null) {
                mr.shutdown();
            }
        }
    }

    static RunningJob launchJob(JobConf jobConf, Path inDir, Path outputPath, int numMaps, String jobName) throws IOException {
        jobConf.setJobName(jobName);
        jobConf.setInputFormat(SortValidator.RecordStatsChecker.NonSplitableSequenceFileInputFormat.class);
        jobConf.setOutputFormat(SequenceFileOutputFormat.class);
        FileInputFormat.setInputPaths((JobConf)jobConf, (Path[])new Path[]{inDir});
        FileOutputFormat.setOutputPath((JobConf)jobConf, (Path)outputPath);
        jobConf.setMapperClass(IdentityMapper.class);
        jobConf.setReducerClass(IdentityReducer.class);
        jobConf.setOutputKeyClass(BytesWritable.class);
        jobConf.setOutputValueClass(BytesWritable.class);
        jobConf.setNumMapTasks(numMaps);
        jobConf.setNumReduceTasks(0);
        jobConf.setJar("build/test/testjar/testjob.jar");
        return JobClient.runJob((JobConf)jobConf);
    }
}

