/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import junit.framework.TestCase;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobTracker;
import org.apache.hadoop.util.ServicePlugin;
import org.junit.Test;

public class TestJobTrackerPlugins
extends TestCase {
    @Test
    public void test() throws Exception {
        JobConf conf = new JobConf();
        conf.set("mapred.job.tracker", "localhost:0");
        conf.set("mapred.job.tracker.http.address", "0.0.0.0:0");
        conf.setClass("mapreduce.jobtracker.plugins", FakeServicePlugin.class, ServicePlugin.class);
        TestJobTrackerPlugins.assertNull((String)"Plugin not created", (Object)FakeServicePlugin.getInstance());
        JobTracker jobTracker = JobTracker.startTracker((JobConf)conf);
        TestJobTrackerPlugins.assertNotNull((String)"Plugin created", (Object)FakeServicePlugin.getInstance());
        TestJobTrackerPlugins.assertSame((String)"Service is jobTracker", (Object)FakeServicePlugin.getInstance().getService(), (Object)jobTracker);
        TestJobTrackerPlugins.assertFalse((String)"Plugin not stopped", (boolean)FakeServicePlugin.getInstance().isStopped());
        jobTracker.close();
        TestJobTrackerPlugins.assertTrue((String)"Plugin stopped", (boolean)FakeServicePlugin.getInstance().isStopped());
    }

    static class FakeServicePlugin
    implements ServicePlugin {
        private static FakeServicePlugin instance;
        private Object service;
        private boolean stopped;

        public static FakeServicePlugin getInstance() {
            return instance;
        }

        public Object getService() {
            return this.service;
        }

        public boolean isStopped() {
            return this.stopped;
        }

        public FakeServicePlugin() {
            instance = this;
        }

        public void start(Object service) {
            this.service = service;
        }

        public void stop() {
            this.stopped = true;
        }

        public void close() throws IOException {
        }
    }
}

