/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.File;
import java.io.IOException;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.mapred.ClusterMapReduceTestCase;
import org.apache.hadoop.mapred.MiniMRCluster;
import org.apache.hadoop.mapred.TaskTracker;
import org.apache.hadoop.mapred.TaskTrackerMetricsSource;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.metrics2.MetricsSource;
import org.apache.hadoop.test.MetricsAsserts;
import org.apache.hadoop.util.StringUtils;

public class TestDiskFailures
extends ClusterMapReduceTestCase {
    private static final Log LOG = LogFactory.getLog(TestDiskFailures.class);
    private static String localPathRoot = System.getProperty("test.build.data", "/tmp").replace(' ', '+');
    private String DISK_HEALTH_CHECK_INTERVAL = "1000";

    @Override
    protected void setUp() throws Exception {
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
        FileUtil.fullyDelete((File)new File(localPathRoot));
    }

    public void testDiskFailures() throws Exception {
        FileSystem fs = FileSystem.get((Configuration)new Configuration());
        Path dir = new Path(localPathRoot, "mapred_local_dirs_base");
        FileSystem.mkdirs((FileSystem)fs, (Path)dir, (FsPermission)new FsPermission(511));
        Properties props = new Properties();
        props.setProperty("mapred.local.dir", dir.toUri().getPath());
        props.setProperty("mapred.disk.healthChecker.interval", this.DISK_HEALTH_CHECK_INTERVAL);
        int numMapredLocalDirs = 4;
        this.startCluster(true, props, 4);
        MiniMRCluster cluster = this.getMRCluster();
        TaskTracker tt = cluster.getTaskTrackerRunner(0).getTaskTracker();
        MetricsRecordBuilder rb = MetricsAsserts.getMetrics((MetricsSource)new TaskTrackerMetricsSource(tt));
        String[] localDirs = cluster.getTaskTrackerLocalDirs(0);
        MetricsAsserts.assertGauge("failedDirs", 0, rb);
        this.prepareDirToFail(localDirs[2]);
        String expectedMapredLocalDirs = localDirs[0] + "," + localDirs[1] + "," + localDirs[3];
        this.verifyReinitTaskTrackerAfterDiskFailure(expectedMapredLocalDirs, cluster);
        rb = MetricsAsserts.getMetrics((MetricsSource)new TaskTrackerMetricsSource(tt));
        MetricsAsserts.assertGauge("failedDirs", 1, rb);
        this.prepareDirToFail(localDirs[0]);
        this.prepareDirToFail(localDirs[3]);
        expectedMapredLocalDirs = localDirs[1];
        this.verifyReinitTaskTrackerAfterDiskFailure(expectedMapredLocalDirs, cluster);
        rb = MetricsAsserts.getMetrics((MetricsSource)new TaskTrackerMetricsSource(tt));
        MetricsAsserts.assertGauge("failedDirs", 3, rb);
        this.prepareDirToFail(localDirs[1]);
        this.waitForDiskHealthCheck();
        TestDiskFailures.assertTrue((String)"Tasktracker is not dead even though all mapred local dirs became bad.", (boolean)cluster.getTaskTrackerRunner((int)0).exited);
        rb = MetricsAsserts.getMetrics((MetricsSource)new TaskTrackerMetricsSource(tt));
        MetricsAsserts.assertGauge("failedDirs", 4, rb);
    }

    private void waitForDiskHealthCheck() {
        try {
            Thread.sleep(4000L);
        }
        catch (InterruptedException e) {
            LOG.error((Object)"Interrupted while waiting for TaskTracker reinit.");
        }
    }

    private void verifyReinitTaskTrackerAfterDiskFailure(String expectedMapredLocalDirs, MiniMRCluster cluster) throws IOException {
        this.waitForDiskHealthCheck();
        String[] updatedLocalDirs = cluster.getTaskTrackerRunner(0).getTaskTracker().getJobConf().getLocalDirs();
        String seenMapredLocalDirs = StringUtils.arrayToString((String[])updatedLocalDirs);
        LOG.info((Object)("ExpectedMapredLocalDirs=" + expectedMapredLocalDirs));
        TestDiskFailures.assertTrue((String)"TaskTracker could not reinit properly after disk failure.", (boolean)expectedMapredLocalDirs.equals(seenMapredLocalDirs));
    }

    private void prepareDirToFail(String dir) throws IOException {
        File file = new File(dir);
        FileUtil.fullyDelete((File)file);
        file.createNewFile();
    }
}

