/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MiniMRCluster;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.net.StaticMapping;

public class MiniMRClusterWithNodeGroup
extends MiniMRCluster {
    private String[] nodeGroups;

    public MiniMRClusterWithNodeGroup(int numTaskTrackers, String namenode, int numDir, String[] racks, String[] nodeGroups, String[] hosts, JobConf conf) throws IOException {
        super(numTaskTrackers, namenode, numDir, racks, hosts, conf);
        this.nodeGroups = nodeGroups;
    }

    @Override
    public void startTaskTracker(String host, String rack, int idx, int numDir) throws IOException {
        if (rack != null && this.nodeGroups != null) {
            StaticMapping.addNodeToRack(host, rack + this.nodeGroups);
        }
        if (host != null) {
            NetUtils.addStaticResolution((String)host, (String)"localhost");
        }
        MiniMRCluster.TaskTrackerRunner taskTracker = new MiniMRCluster.TaskTrackerRunner(idx, numDir, host, this.conf);
        this.addTaskTracker(taskTracker);
    }
}

