/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.net.URL;
import java.util.Collection;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.ChecksumException;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.TestDatanodeBlockScanner;
import org.junit.Assert;
import org.junit.Test;

public class TestCorruptFilesJsp {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCorruptFilesJsp() throws Exception {
        MiniDFSCluster cluster = null;
        try {
            int FILE_SIZE = 512;
            Path[] filepaths = new Path[]{new Path("/audiobook"), new Path("/audio/audio1"), new Path("/audio/audio2"), new Path("/audio/audio")};
            Configuration conf = new Configuration();
            conf.setInt("dfs.datanode.directoryscan.interval", 1);
            conf.setInt("dfs.blockreport.intervalMsec", 3000);
            cluster = new MiniDFSCluster(conf, 1, true, null);
            cluster.waitActive();
            FileSystem fs = cluster.getFileSystem();
            for (Path filepath : filepaths) {
                DFSTestUtil.createFile(fs, filepath, 512L, (short)1, 0L);
                DFSTestUtil.waitReplication(fs, filepath, (short)1);
            }
            Collection badFiles = cluster.getNameNode().getNamesystem().listCorruptFileBlocks();
            Assert.assertTrue((String)("There are " + badFiles.size() + " corrupt files, but expecting none"), (badFiles.size() == 0 ? 1 : 0) != 0);
            String nnUrl = cluster.getNameNode().getHttpAddress().getHostName() + ":" + cluster.getNameNode().getHttpAddress().getPort();
            URL url = new URL("http://" + nnUrl + "/corrupt_files.jsp");
            String corruptFilesPage = DFSTestUtil.urlGet(url);
            Assert.assertTrue((String)"Corrupt files page is not showing a healthy filesystem", (boolean)corruptFilesPage.contains("No missing blocks found at the moment."));
            for (int idx = 0; idx < filepaths.length - 1; ++idx) {
                String blockName = DFSTestUtil.getFirstBlock(fs, filepaths[idx]).getBlockName();
                TestDatanodeBlockScanner.corruptReplica(blockName, 0);
                FSDataInputStream in = fs.open(filepaths[idx]);
                try {
                    in.readFully(new byte[512]);
                }
                catch (ChecksumException ignored) {
                    // empty catch block
                }
                in.close();
            }
            badFiles = cluster.getNameNode().getNamesystem().listCorruptFileBlocks();
            Assert.assertTrue((String)("Expecting 3 corrupt files, but got " + badFiles.size()), (badFiles.size() == 3 ? 1 : 0) != 0);
            corruptFilesPage = DFSTestUtil.urlGet(url);
            Assert.assertTrue((String)"'/audiobook' should be corrupt", (boolean)corruptFilesPage.contains("/audiobook"));
            Assert.assertTrue((String)"'/audio/audio1' should be corrupt", (boolean)corruptFilesPage.contains("/audio/audio1"));
            Assert.assertTrue((String)"'/audio/audio2' should be corrupt", (boolean)corruptFilesPage.contains("/audio/audio2"));
            Assert.assertTrue((String)"Summary message shall report 3 corrupt files", (boolean)corruptFilesPage.contains("At least 3 corrupt file(s)"));
            for (Path filepath : filepaths) {
                fs.delete(filepath, false);
            }
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }
}

