/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.OutputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.junit.Test;

public class TestWriteConfigurationToDFS {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testWriteConf() throws Exception {
        Configuration conf = new Configuration();
        conf.setInt("dfs.block.size", 4096);
        System.out.println("Setting conf in: " + System.identityHashCode(conf));
        MiniDFSCluster cluster = new MiniDFSCluster(conf, 1, true, null, null);
        cluster.waitActive();
        try {
            FileSystem fs = cluster.getFileSystem();
            Path filePath = new Path("/testWriteConf.xml");
            FSDataOutputStream os = fs.create(filePath);
            StringBuilder longString = new StringBuilder();
            for (int i = 0; i < 100000; ++i) {
                longString.append("hello");
            }
            conf.set("foobar", longString.toString());
            conf.writeXml((OutputStream)os);
            os.close();
        }
        finally {
            cluster.shutdown();
        }
    }
}

