/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.util.ArrayList;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.ChecksumException;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.server.datanode.DataNode;

public class TestFileCorruption
extends TestCase {
    public TestFileCorruption(String testName) {
        super(testName);
    }

    protected void setUp() throws Exception {
    }

    protected void tearDown() throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testFileCorruption() throws Exception {
        MiniDFSCluster cluster = null;
        DFSTestUtil util = new DFSTestUtil("TestFileCorruption", 20, 3, 8192);
        try {
            Configuration conf = new Configuration();
            cluster = new MiniDFSCluster(conf, 3, true, null);
            FileSystem fs = cluster.getFileSystem();
            util.createFiles(fs, "/srcdat");
            File data_dir = new File(System.getProperty("test.build.data"), "dfs/data/data5/current");
            TestFileCorruption.assertTrue((String)"data directory does not exist", (boolean)data_dir.exists());
            File[] blocks = data_dir.listFiles();
            TestFileCorruption.assertTrue((String)"Blocks do not exist in data-dir", (blocks != null && blocks.length > 0 ? 1 : 0) != 0);
            for (int idx = 0; idx < blocks.length; ++idx) {
                if (!blocks[idx].getName().startsWith("blk_")) continue;
                System.out.println("Deliberately removing file " + blocks[idx].getName());
                TestFileCorruption.assertTrue((String)"Cannot remove file.", (boolean)blocks[idx].delete());
            }
            TestFileCorruption.assertTrue((String)"Corrupted replicas not handled properly.", (boolean)util.checkFiles(fs, "/srcdat"));
            util.cleanup(fs, "/srcdat");
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    public void testLocalFileCorruption() throws Exception {
        Configuration conf = new Configuration();
        Path file = new Path(System.getProperty("test.build.data"), "corruptFile");
        LocalFileSystem fs = FileSystem.getLocal((Configuration)conf);
        Object dos = fs.create(file);
        ((DataOutputStream)dos).writeBytes("original bytes");
        ((FilterOutputStream)dos).close();
        dos = new DataOutputStream(new FileOutputStream(file.toString()));
        ((DataOutputStream)dos).writeBytes("corruption");
        ((FilterOutputStream)dos).close();
        FSDataInputStream dis = fs.open(file, 512);
        try {
            System.out.println("A ChecksumException is expected to be logged.");
            dis.readByte();
        }
        catch (ChecksumException ignore) {
            // empty catch block
        }
        fs.delete(file, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testArrayOutOfBoundsException() throws Exception {
        MiniDFSCluster cluster = null;
        try {
            Configuration conf = new Configuration();
            cluster = new MiniDFSCluster(conf, 2, true, null);
            cluster.waitActive();
            FileSystem fs = cluster.getFileSystem();
            Path FILE_PATH = new Path("/tmp.txt");
            long FILE_LEN = 1L;
            DFSTestUtil.createFile(fs, FILE_PATH, 1L, (short)2, 1L);
            File dataDir = new File(cluster.getDataDirectory(), "data1/current");
            Block blk = this.getBlock(dataDir);
            if (blk == null) {
                blk = this.getBlock(new File(cluster.getDataDirectory(), "dfs/data/data2/current"));
            }
            TestFileCorruption.assertFalse((blk == null ? 1 : 0) != 0);
            cluster.startDataNodes(conf, 1, true, null, null);
            ArrayList<DataNode> datanodes = cluster.getDataNodes();
            TestFileCorruption.assertEquals((int)datanodes.size(), (int)3);
            DataNode dataNode = datanodes.get(2);
            cluster.getNameNode().getNamesystem().markBlockAsCorrupt(blk, new DatanodeInfo((DatanodeID)dataNode.dnRegistration));
            fs.open(FILE_PATH);
            fs.delete(FILE_PATH, false);
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    private Block getBlock(File dataDir) {
        int idx;
        TestFileCorruption.assertTrue((String)"data directory does not exist", (boolean)dataDir.exists());
        File[] blocks = dataDir.listFiles();
        TestFileCorruption.assertTrue((String)"Blocks do not exist in dataDir", (blocks != null && blocks.length > 0 ? 1 : 0) != 0);
        String blockFileName = null;
        for (idx = 0; idx < blocks.length && (!(blockFileName = blocks[idx].getName()).startsWith("blk_") || blockFileName.endsWith(".meta")); ++idx) {
        }
        if (blockFileName == null) {
            return null;
        }
        long blockId = Long.parseLong(blockFileName.substring("blk_".length()));
        long blockTimeStamp = 1L;
        for (idx = 0; idx < blocks.length; ++idx) {
            String fileName = blocks[idx].getName();
            if (!fileName.startsWith(blockFileName) || !fileName.endsWith(".meta")) continue;
            int startIndex = blockFileName.length() + 1;
            int endIndex = fileName.length() - ".meta".length();
            blockTimeStamp = Long.parseLong(fileName.substring(startIndex, endIndex));
            break;
        }
        return new Block(blockId, blocks[idx].length(), blockTimeStamp);
    }
}

