/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.IOException;
import java.util.ArrayList;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.server.namenode.DatanodeDescriptor;

public class TestBlocksScheduledCounter
extends TestCase {
    public void testBlocksScheduledCounter() throws IOException {
        MiniDFSCluster cluster = new MiniDFSCluster(new Configuration(), 1, true, null);
        cluster.waitActive();
        FileSystem fs = cluster.getFileSystem();
        FSDataOutputStream out = fs.create(new Path("/testBlockScheduledCounter"));
        for (int i = 0; i < 1024; ++i) {
            out.write(i);
        }
        ((DFSClient.DFSOutputStream)out.getWrappedStream()).sync();
        ArrayList dnList = new ArrayList();
        cluster.getNameNode().getNamesystem().DFSNodesStatus(dnList, dnList);
        DatanodeDescriptor dn = (DatanodeDescriptor)dnList.get(0);
        TestBlocksScheduledCounter.assertEquals((int)1, (int)dn.getBlocksScheduled());
        out.close();
        TestBlocksScheduledCounter.assertEquals((int)0, (int)dn.getBlocksScheduled());
    }
}

