/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.Groups;
import org.apache.hadoop.security.ShellBasedUnixGroupsMapping;
import org.junit.Assert;
import org.junit.Test;

public class TestGroupsCaching {
    public static final Log LOG = LogFactory.getLog(TestGroupsCaching.class);
    private static Configuration conf = new Configuration();
    private static String[] myGroups = new String[]{"grp1", "grp2"};

    @Test
    public void TestGroupsCachingDefault() throws Exception {
        Groups groups;
        block2: {
            groups = new Groups(conf);
            groups.cacheGroupsAdd(Arrays.asList(myGroups));
            groups.refresh();
            FakeGroupMapping.clearBlackList();
            FakeGroupMapping.addToBlackList("user1");
            Assert.assertTrue((groups.getGroups("me").size() == 2 ? 1 : 0) != 0);
            FakeGroupMapping.addToBlackList("me");
            Assert.assertTrue((groups.getGroups("me").size() == 2 ? 1 : 0) != 0);
            try {
                LOG.error((Object)("We are not supposed to get here." + groups.getGroups("user1").toString()));
                Assert.fail();
            }
            catch (IOException ioe) {
                if (ioe.getMessage().startsWith("No groups found")) break block2;
                LOG.error((Object)("Got unexpected exception: " + ioe.getMessage()));
                Assert.fail();
            }
        }
        FakeGroupMapping.clearBlackList();
        Assert.assertTrue((groups.getGroups("user1").size() == 2 ? 1 : 0) != 0);
    }

    static {
        conf.setClass("hadoop.security.group.mapping", FakeGroupMapping.class, ShellBasedUnixGroupsMapping.class);
    }

    public static class FakeGroupMapping
    extends ShellBasedUnixGroupsMapping {
        private static Set<String> allGroups = new HashSet<String>();
        private static Set<String> blackList = new HashSet<String>();

        public List<String> getGroups(String user) throws IOException {
            LOG.info((Object)("Getting groups for " + user));
            if (blackList.contains(user)) {
                return new LinkedList<String>();
            }
            return new LinkedList<String>(allGroups);
        }

        public void cacheGroupsRefresh() throws IOException {
            LOG.info((Object)"Cache is being refreshed.");
            FakeGroupMapping.clearBlackList();
        }

        public static void clearBlackList() throws IOException {
            LOG.info((Object)"Clearing the blacklist");
            blackList.clear();
        }

        public void cacheGroupsAdd(List<String> groups) throws IOException {
            LOG.info((Object)("Adding " + groups + " to groups."));
            allGroups.addAll(groups);
        }

        public static void addToBlackList(String user) throws IOException {
            LOG.info((Object)("Adding " + user + " to the blacklist"));
            blackList.add(user);
        }
    }
}

